/*
 * Decompiled with CFR 0.152.
 */
package dbatool.TreeNode;

import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.ForeignKey.ForeignKeyList;
import dbatool.IVFTextIndex.IVFTextIndexList;
import dbatool.Index.IndexList;
import dbatool.NoInfo;
import dbatool.Popupmenu.List_Popupmenu;
import dbatool.Replication.ReplicationList;
import dbatool.TextIndex.TextIndexList;
import dbatool.TreeNode.DBATreeNode;
import dbatool.TreeNode.TableTreeNode;
import dbatool.Trigger.TriggerList;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

public class TableSubTreeNode
extends DBATreeNode {
    public static final int INDEX = 0;
    public static final int TEXT_INDEX = 1;
    public static final int FOREIGN_KEY = 2;
    public static final int TRIGGER = 3;
    public static final int REPLICATION = 4;
    public static final int IVF_TEXT_INDEX = 5;
    private static String[] resources = new String[]{"Index", "Text_Index", "Foreign_Key", "Trigger", "Replication", "Ivf_Text_Index"};
    private static String[] helpids = new String[]{"index.list", "textindex.list", "foreignkey.list", "trigger.list", "replication.list", "ivftextindex.list"};
    private static ImageIcon[] icons = null;
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private String table_owner;
    private String table_name;
    private int type = 0;
    private String toString = null;

    public TableSubTreeNode(int type, TableTreeNode parent_node) {
        this.table_name = parent_node.getTableName();
        this.table_owner = parent_node.getTableOwner();
        this.type = type;
        this.toString = this.res.getString(resources[type]);
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    @Override
    public String getHelpID() {
        if (this.type >= 0 && this.type < helpids.length) {
            return helpids[this.type];
        }
        return "home";
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = DbFrame.frame.getResourceBundle();
        this.toString = this.res.getString(resources[this.type]);
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icons == null) {
            icons = new ImageIcon[]{DBAImageResource.getResource(this.getClass(), "/jdbaimages/index.gif"), DBAImageResource.getResource(this.getClass(), "/jdbaimages/text_index.gif"), DBAImageResource.getResource(this.getClass(), "/jdbaimages/foreign_key.gif"), DBAImageResource.getResource(this.getClass(), "/jdbaimages/trigger.gif"), DBAImageResource.getResource(this.getClass(), "/jdbaimages/replication.gif"), DBAImageResource.getResource(this.getClass(), "/jdbaimages/ivf_text_index.gif")};
        }
        return icons[this.type];
    }

    @Override
    public void displayObject() {
        DbaTabbedPane info = null;
        switch (this.type) {
            case 0: {
                info = new IndexList(this.table_owner, this.table_name);
                break;
            }
            case 1: {
                info = new TextIndexList(this.table_owner, this.table_name);
                break;
            }
            case 2: {
                info = new ForeignKeyList(this.table_owner, this.table_name);
                break;
            }
            case 3: {
                info = new TriggerList((TableTreeNode)this.getParent());
                break;
            }
            case 4: {
                info = new ReplicationList((TableTreeNode)this.getParent(), this.table_owner, this.table_name);
                break;
            }
            case 5: {
                info = new IVFTextIndexList(this.table_owner, this.table_name);
                break;
            }
            default: {
                info = new NoInfo();
            }
        }
        DbFrame.frame.setContentPanel(info);
    }

    @Override
    public void displayMenu(MouseEvent e) {
        List_Popupmenu popup = new List_Popupmenu(this);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void refresh() {
        if (this.type == 3) {
            DbFrame.frame.treePanel.refreshTriggerTree((TableTreeNode)this.getParent());
        } else if (this.type == 4) {
            DbFrame.frame.treePanel.refreshReplicationTree((TableTreeNode)this.getParent());
        }
        this.displayObject();
    }

    public int getType() {
        return this.type;
    }

    public String getTableOwner() {
        return this.table_owner;
    }

    public String getTableName() {
        return this.table_name;
    }

    @Override
    public boolean isFound(String s1, String s2, String s3) {
        int i = Integer.parseInt(s1);
        return i == this.type;
    }
}

