/*
 * Decompiled with CFR 0.152.
 */
package dbatool.TreeNode;

import dbatool.DbFrame;
import dbatool.Popupmenu.List_Popupmenu;
import dbatool.Replication.ReplicationInfo;
import dbatool.TreeNode.DBATreeNode;
import dbaut.GuiUt;
import dbaut.locale.LocaleChangeEvent;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class ReplicationTreeNode
extends DBATreeNode {
    private String repl_name = null;
    private String table_owner = null;
    private String table_name = null;
    private String type = null;
    private String project_column = "";
    public DefaultMutableTreeNode parent_node = null;
    private static ImageIcon icon = null;
    private String toString = null;

    public ReplicationTreeNode(String repl_name, String table_owner, String table_name, String type, String project_column, DefaultMutableTreeNode parent_node) {
        this.parent_node = parent_node;
        this.repl_name = GuiUt.rightTrim(repl_name);
        this.table_owner = GuiUt.rightTrim(table_owner);
        this.table_name = GuiUt.rightTrim(table_name);
        String str = GuiUt.rightTrim(project_column);
        while (true) {
            int index = str.lastIndexOf(0);
            this.project_column = this.project_column.length() == 0 ? str.substring(index + 1) : str.substring(index + 1) + "," + this.project_column;
            if (index < 0) break;
            str = str.substring(0, index).trim();
        }
        this.type = type;
        this.toString = this.repl_name + " (" + this.table_owner + "." + this.table_name + ")";
    }

    @Override
    public String getHelpID() {
        return "replication.info";
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/single_replication.gif");
        }
        return icon;
    }

    @Override
    public void displayObject() {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(res.getString("Information_about"), this.repl_name));
        DbFrame.frame.setContentPanel(new ReplicationInfo(this.repl_name, this.table_owner, this.table_name, this.project_column, this.type));
    }

    @Override
    public void displayMenu(MouseEvent e) {
        List_Popupmenu popup = new List_Popupmenu(this);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
    }

    @Override
    public boolean isFound(String s1, String s2, String s3) {
        return this.table_owner.equalsIgnoreCase(s1) && this.table_name.equalsIgnoreCase(s2) && this.repl_name.equalsIgnoreCase(s3);
    }

    public String getTableOwner() {
        return this.table_owner;
    }

    public String getTableName() {
        return this.table_name;
    }

    public String getReplicationName() {
        return this.repl_name;
    }

    @Override
    public void refresh() {
        this.displayObject();
    }
}

