/*
 * Decompiled with CFR 0.152.
 */
package dbatool.TreeNode;

import dbatool.DbFrame;
import dbatool.Popupmenu.List_Popupmenu;
import dbatool.StoredProcedure.StoredProcedureInfo;
import dbatool.TreeNode.DBATreeNode;
import dbaut.GuiUt;
import dbaut.locale.LocaleChangeEvent;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

public class ProcedureTreeNode
extends DBATreeNode {
    private String modulename;
    private String proc_owner;
    private String proc_name;
    private String toString;
    private static ImageIcon icon = null;

    public ProcedureTreeNode(String modulename, String proc_owner, String proc_name) {
        this.modulename = modulename.trim();
        this.proc_owner = GuiUt.rightTrim(proc_owner);
        this.proc_name = GuiUt.rightTrim(proc_name);
        this.toString = this.proc_owner + "." + this.proc_name;
    }

    @Override
    public String getHelpID() {
        return "storedprocedure.info";
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/single_stored_procedure.gif");
        }
        return icon;
    }

    @Override
    public void displayObject() {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(res.getString("Information_about"), this.modulename + "." + this.proc_owner + "." + this.proc_name));
        DbFrame.frame.setContentPanel(new StoredProcedureInfo(this.modulename, this.proc_owner, this.proc_name));
    }

    @Override
    public void displayMenu(MouseEvent e) {
        List_Popupmenu popup = new List_Popupmenu(this);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
    }

    @Override
    public boolean isFound(String s1, String s2, String s3) {
        return this.modulename.equalsIgnoreCase(s1) && this.proc_owner.equalsIgnoreCase(s2) && this.proc_name.equalsIgnoreCase(s3);
    }

    @Override
    public void refresh() {
        this.displayObject();
    }

    public String getProcOwner() {
        return this.proc_owner;
    }

    public String getProcName() {
        return this.proc_name;
    }

    public String getModuleName() {
        return this.modulename;
    }
}

