/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.Table.DataPanel;
import dbatool.Table.DefTablePanel;
import dbatool.Table.TableDependency;
import dbatool.Table.TableDependencyGraph;
import dbatool.Table.TablePermission;
import dbatool.Table.TableProperties;
import dbatool.Table.TableSchema;
import dbatool.Table.TableStatistics;
import dbatool.TreeNode.TableTreeNode;
import dbaut.comp.DbaPanel;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.help.CSH;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import queryAnalyzer.QueryFrame;

public class TableInfo
extends DbaTabbedPane
implements ComponentPrivilege {
    public DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.TableRes", LocaleManager.getLocale());
    public TableSchema schemaPanel = null;
    public TableProperties propertiesPanel = null;
    public TablePermission permissionPanel = null;
    public TableStatistics statisticsPanel = null;
    public TableDependency dependencyPanel = null;
    public DataPanel dataPanel = null;
    public TableDependencyGraph dependGraphPanel = null;
    private String table_type = "";
    public String table_owner = "";
    public String table_name = "";
    public boolean isExistSerial = false;

    public TableInfo(TableTreeNode tableNode) {
        try {
            this.table_owner = tableNode.getTableOwner();
            this.table_name = tableNode.getTableName();
            this.table_type = tableNode.getTableType();
            this.jbInit();
        }
        catch (Exception e) {
            System.out.println("TableInfo failed: " + e.getMessage());
        }
    }

    private void jbInit() throws Exception {
        this.schemaPanel = new TableSchema("table.info.schema", this);
        this.propertiesPanel = new TableProperties("table.info.properties", this);
        this.permissionPanel = new TablePermission("table.info.permission", this);
        this.statisticsPanel = new TableStatistics("table.info.statistics", this);
        this.dependencyPanel = new TableDependency("table.info.dependecy", this);
        this.dataPanel = new DataPanel("table.info.editdata", this);
        this.dependGraphPanel = new TableDependencyGraph("table.info.dependecy", this);
        this.setName("TableTabbedPane");
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TableInfo.this.this_stateChanged(e);
            }
        });
        this.add((Component)this.schemaPanel, "");
        this.add((Component)this.propertiesPanel, "");
        if (!DbFrame.conn_DatabaseConnection.isSecure) {
            JPanel panel = new JPanel();
            JLabel label = new JLabel();
            label.setText("Not available");
            panel.add((Component)label, null);
            this.add((Component)panel, "");
        } else {
            this.add((Component)this.permissionPanel, "");
        }
        this.add((Component)this.dependencyPanel, "");
        this.add((Component)this.dependGraphPanel, "");
        this.add((Component)new JScrollPane(this.statisticsPanel), "");
        this.add((Component)this.dataPanel, "");
        this.setTitleAt(0, this.res.getTitle("Schema"));
        this.setTitleAt(1, this.res.getTitle("Properties"));
        this.setTitleAt(2, this.res.getTitle("Permissions"));
        this.setTitleAt(3, this.res.getTitle("Dependencies"));
        this.setTitleAt(4, this.res.getTitle("Dependency_Graph"));
        this.setTitleAt(5, this.res.getTitle("Statistics"));
        this.setTitleAt(6, this.res.getTitle("Edit_Data"));
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce(this.table_owner, this.table_name);
    }

    @Override
    public int getComponentType() {
        return 101;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.setEnabledAt(5, enabled);
    }

    @Override
    public void grant(boolean enabled) {
    }

    @Override
    public void this_stateChanged(ChangeEvent e) {
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getComponentCount()) {
            return;
        }
        Component panel = this.getComponentAt(index);
        if (panel instanceof DbaPanel) {
            String helpid2 = ((DbaPanel)panel).getHelpIDString();
            DbFrame.frame.setHelpMenuitem(helpid2);
            CSH.setHelpIDString((Component)this, (String)helpid2);
        } else if (panel instanceof QueryFrame) {
            String helpid3 = ((QueryFrame)panel).getHelpIDString();
            DbFrame.frame.setHelpMenuitem(helpid3);
            CSH.setHelpIDString((Component)this, (String)helpid3);
        }
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        switch (index) {
            case 0: {
                break;
            }
            case 1: {
                this.propertiesPanel.initPanel();
                break;
            }
            case 2: {
                if (!DbFrame.conn_DatabaseConnection.isSecure || !this.permissionPanel.initPanel()) break;
                this.permissionPanel.refreshData();
                break;
            }
            case 3: {
                if (!this.dependencyPanel.initPanel()) break;
                this.dependencyPanel.getDependencies(this.table_owner, this.table_name);
                break;
            }
            case 4: {
                if (this.dependGraphPanel.getComponentCount() != 0) break;
                this.dependGraphPanel.getDependencies(this.table_owner, this.table_name);
                this.dependGraphPanel.initPanel();
                break;
            }
            case 5: {
                if (!this.statisticsPanel.initPanel()) break;
                this.statisticsPanel.getTableStatistics();
                break;
            }
            case 6: {
                if (this.dataPanel.getComponentCount() != 0 || !this.isEnabledAt(5)) break;
                this.dataPanel.initPanel();
            }
        }
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void clean() {
        this.dataPanel.clean();
    }

    public void rename(ActionEvent e) {
        this.schemaPanel.Rename_Button_actionPerformed(e);
    }

    public void defTable(ActionEvent e) {
        this.add(DbFrame.frame.res.getString("DefTable"), this.getDefTablePanel());
        this.setSelectedIndex(this.getComponentCount() - 1);
    }

    private DefTablePanel getDefTablePanel() {
        DefTablePanel panel = null;
        Component comp = null;
        int count = this.getTabCount();
        for (int i = count - 1; i >= 0; --i) {
            comp = this.getComponentAt(i);
            if (!(comp instanceof DefTablePanel)) continue;
            panel = (DefTablePanel)comp;
            break;
        }
        if (panel == null) {
            panel = new DefTablePanel("table.info.deftable", this.table_owner, this.table_name);
        }
        return panel;
    }
}

