/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import javax.swing.JPanel;

public class LinePanel
extends JPanel {
    private int lineDirection;

    public void setLineDirection(int lineDirection) {
        this.lineDirection = lineDirection;
    }

    @Override
    public void paint(Graphics g) {
        Point p1 = null;
        Point p2 = null;
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        switch (this.lineDirection) {
            case 1: {
                g2D.drawLine(3, this.getHeight() - 3, this.getWidth() - 3, 3);
                p2 = new Point(3, this.getHeight() - 3);
                p1 = new Point(this.getWidth() - 3, 3);
                break;
            }
            case 2: {
                g2D.drawLine(3, 3, this.getWidth() - 3, this.getHeight() - 3);
                p1 = new Point(3, 3);
                p2 = new Point(this.getWidth() - 3, this.getHeight() - 3);
                break;
            }
            case 3: {
                g2D.drawLine(3, this.getHeight() - 3, this.getWidth() - 3, 3);
                p1 = new Point(3, this.getHeight() - 3);
                p2 = new Point(this.getWidth() - 3, 3);
                break;
            }
            case 4: {
                g2D.drawLine(3, 3, this.getWidth() - 3, this.getHeight() - 3);
                p2 = new Point(3, 3);
                p1 = new Point(this.getWidth() - 3, this.getHeight() - 3);
            }
        }
        g.fillOval(p1.x - 3, p1.y - 3, 6, 6);
        double angle = this.calcAngel(p1, p2);
        this.drawArrowhead(g, p2, angle);
        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public void drawArrowhead(Graphics g, Point p, double angle) {
        int bottomWidth = 6;
        int height = 16;
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int[] x = new int[]{p.x, p.x - bottomWidth / 2, p.x + bottomWidth / 2};
        int[] y = new int[]{p.y, p.y + height, p.y + height};
        int nPoints = 3;
        g2D.rotate(angle, p.x, p.y);
        g2D.fillPolygon(x, y, nPoints);
        g2D.rotate(-angle, p.x, p.y);
    }

    public double calcAngel(Point2D point2d, Point2D point2d2) {
        double x = (point2d.getX() - point2d2.getX()) / (point2d2.getY() - point2d.getY());
        double angle = Math.atan(x);
        if (point2d.getY() <= point2d2.getY()) {
            angle = Math.PI + angle;
        }
        return angle;
    }
}

