/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DbFrame;
import dbatool.Table.DataFilterDlg;
import dbatool.Table.DataTableModel;
import dbatool.Table.PrimaryKeyVector;
import dbatool.Table.SchemaTableModel;
import dbatool.Table.SchemaType;
import dbatool.Table.TableInfo;
import dbatool.tableCell.BlobCellObject;
import dbatool.tableCell.BlobEditor;
import dbatool.tableCell.BlobEditorButton;
import dbatool.tableCell.BlobEditorButtonInterface;
import dbatool.tableCell.BlobEditorNoJAIButton;
import dbatool.tableCell.OidEditor;
import dbatool.tableCell.OidRenderer;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.DbaTable;
import dbaut.comp.ReflectionAction;
import dbaut.comp.TableColumnSelectionListener;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.DecimalField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DataPanel
extends DbaPanel
implements ComponentPrivilege {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private DataTableModel dataModel = null;
    private DBAToolAbstractTableModel absDataModel = null;
    private DbaTable Table_Data = null;
    private JLabel infoLabel = new JLabel();
    private DbaTableModel schemaModel = null;
    private String table_owner = "";
    private String table_name = "";
    private int data_start = 0;
    private int data_end = 0;
    private boolean hasNext = false;
    private String where_text = "";
    private int data_offset;
    private Statement stmt;
    private ResultSet rs;
    private TableInfo tableInfo;
    private int previous_row;
    private int current_row;
    private MethodTypes[] retriveMethods;
    private String[] types;
    private DbaButton Data_Down_Button;
    private DbaButton Data_Up_Button;
    private DbaButton Confirm_Button;
    private DbaButton Cancel_Button;
    private DbaButton Modify_Button;
    private DbaButton Delete_Button;
    private DbaButton Filter_Button;
    private DbaButton Data_First_Button;
    private DbaButton Data_Last_Button;
    private boolean[] button_status;

    public DataPanel(String helpid2, TableInfo tableInfo) {
        super(DbFrame.helpres, helpid2);
        this.data_offset = DbFrame.frame.px.getNumRecord();
        this.stmt = null;
        this.rs = null;
        this.tableInfo = null;
        this.previous_row = -1;
        this.current_row = -1;
        this.retriveMethods = null;
        this.types = null;
        this.Data_Down_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Page_Down"), 'W', DBAImageResource.getResource(this.getClass(), "/jdbaimages/pagedown.gif"), new ReflectionAction(this, "Data_Down_Button_actionPerformed"));
        this.Data_Up_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Page_Up"), 'U', DBAImageResource.getResource(this.getClass(), "/jdbaimages/pageup.gif"), new ReflectionAction(this, "Data_Up_Button_actionPerformed"));
        this.Confirm_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Confirm_Button_actionPerformed"));
        this.Cancel_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancel.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        this.Modify_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Modify_Button_actionPerformed"));
        this.Delete_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Delete"), 'E', DBAImageResource.getResource(this.getClass(), "/jdbaimages/delete.gif"), new ReflectionAction(this, "Delete_Button_actionPerformed"));
        this.Filter_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Filter"), 'F', DBAImageResource.getResource(this.getClass(), "/jdbaimages/filter.gif"), new ReflectionAction(this, "Filter_Button_actionPerformed"));
        this.Data_First_Button = new DbaButton(new Dimension(100, 24), this.res.getString("First"), 'F', DBAImageResource.getResource(this.getClass(), "/jdbaimages/datafirst.gif"), new ReflectionAction(this, "Data_First_Button_actionPerformed"));
        this.Data_Last_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Last"), 'L', DBAImageResource.getResource(this.getClass(), "/jdbaimages/datalast.gif"), new ReflectionAction(this, "Data_Last_Button_actionPerformed"));
        this.button_status = new boolean[]{false, true, false, true};
        this.tableInfo = tableInfo;
        this.table_owner = tableInfo.table_owner;
        this.table_name = tableInfo.table_name;
        this.res = tableInfo.res;
    }

    private void initRetrieveMethods() {
        int count = this.absDataModel.getColumnCount();
        this.retriveMethods = new MethodTypes[count];
        this.types = new String[count];
        this.types[0] = "oid";
        this.retriveMethods[0] = MethodTypes.STRING;
        for (int i = 1; i < count; ++i) {
            this.types[i] = (String)this.schemaModel.getValueAt(i - 1, SchemaTableModel.TYPE);
            if (SchemaType.isBlobType(this.types[i])) {
                if (SchemaType.isDomainType(this.types[i])) {
                    this.types[i] = this.dataModel.types.elementAt(i - 1).toString();
                }
                if (this.types[i].equalsIgnoreCase("long varchar") || this.types[i].equalsIgnoreCase("clob")) {
                    this.retriveMethods[i] = MethodTypes.CLOB;
                    continue;
                }
                this.retriveMethods[i] = MethodTypes.BLOB;
                continue;
            }
            this.retriveMethods[i] = this.types[i].equals("binary") || this.types[i].equals("oid") ? MethodTypes.STRING : (this.types[i].equals("char") || this.types[i].equals("varchar") || this.types[i].equals("nchar") || this.types[i].equals("nvarchar") || this.types[i].equals("integer") || this.types[i].equals("smallint") || this.types[i].equals("bigint") ? MethodTypes.OBJECT : MethodTypes.STRING);
        }
    }

    public void initPanel() {
        this.setName("TableDataPanel");
        this.Modify_Button.setName("ModifyButton");
        this.Confirm_Button.setName("ConfirmButton");
        this.Delete_Button.setName("DeleteButton");
        if (this.getComponentCount() > 0) {
            return;
        }
        this.schemaModel = this.tableInfo.schemaPanel.schemaTableModel;
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        JPanel jPanel1 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.infoLabel.setText("");
        jPanel1.add((Component)jPanel6, null);
        jPanel6.setName("TableDataButtonPanel");
        jPanel6.add((Component)this.Modify_Button, null);
        jPanel6.add((Component)this.Confirm_Button, null);
        jPanel6.add((Component)this.Cancel_Button, null);
        jPanel6.add((Component)this.Delete_Button, null);
        jPanel1.add((Component)jPanel7, null);
        jPanel7.add((Component)this.Filter_Button, null);
        jPanel7.add((Component)this.Data_Up_Button, null);
        jPanel7.add((Component)this.Data_Down_Button, null);
        jPanel7.add((Component)this.Data_First_Button, null);
        jPanel7.add((Component)this.Data_Last_Button, null);
        jPanel1.add((Component)jPanel2, null);
        jPanel2.add((Component)this.infoLabel, "Center");
        this.dataModel = new DataTableModel(this.schemaModel, this.table_owner, this.table_name);
        this.absDataModel = new DBAToolAbstractTableModel(this.dataModel);
        this.Table_Data = new DbaTable(this.absDataModel);
        this.Table_Data.setName("TableDataTable");
        this.dataModel.setTable(this.Table_Data);
        this.absDataModel.setTable(this.Table_Data, true);
        this.Table_Data.setSelectionMode(0);
        this.Table_Data.addColumnSelectionListener(new TableColumnSelectionListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DataPanel.this.TableColumnSelectionChanged(e);
                }
            }
        });
        this.Table_Data.addRowSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Component c = DataPanel.this.Table_Data.getEditorComponent();
                if (e == null || !e.getValueIsAdjusting() || c != null && c instanceof BlobEditorButton) {
                    DataPanel.this.TableRowSelectionChanged(e);
                    DataPanel.this.setDeleteButton();
                }
            }
        });
        this.setUpCellEditor(this.Table_Data);
        this.setEditable(false);
        this.initRetrieveMethods();
        this.getTableData();
        this.absDataModel.addMouseListenerToHeaderInTable(this.Table_Data);
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce(this.table_owner, this.table_name);
        JScrollPane jScrollPane9 = new JScrollPane(this.Table_Data);
        jScrollPane9.setPreferredSize(new Dimension(200, 200));
        jPanel4.add((Component)jScrollPane9, "Center");
        this.Table_Data.setAutoResizeMode(0);
        TableColumnModel tcm = this.Table_Data.getColumnModel();
        TableColumn firstcolumn = tcm.getColumn(0);
        firstcolumn.setPreferredWidth(0);
        firstcolumn.setResizable(false);
        firstcolumn.setCellEditor(new OidEditor(this.Table_Data));
        firstcolumn.setCellRenderer(new OidRenderer());
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel4, "Center");
        this.add((Component)jPanel1, "North");
        this.Table_Data.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DataPanel.this.Table_Data_mouseClicked(e);
            }
        });
    }

    @Override
    public int getComponentType() {
        return 701;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Modify_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Delete_Button.setEnabled(enabled);
    }

    private void setEditable(boolean editable) {
        if (editable) {
            this.Modify_Button.setEnabled(false);
            this.Cancel_Button.setEnabled(true);
            this.Confirm_Button.setEnabled(true);
            this.Filter_Button.setEnabled(false);
            this.button_status[0] = this.Data_Up_Button.isEnabled();
            this.button_status[1] = this.Data_Down_Button.isEnabled();
            this.button_status[2] = this.Data_First_Button.isEnabled();
            this.button_status[3] = this.Data_Last_Button.isEnabled();
            this.Data_Up_Button.setEnabled(false);
            this.Data_Down_Button.setEnabled(false);
            this.Data_First_Button.setEnabled(false);
            this.Data_Last_Button.setEnabled(false);
        } else {
            this.Modify_Button.setEnabled(true);
            this.Cancel_Button.setEnabled(false);
            this.Confirm_Button.setEnabled(false);
            this.Filter_Button.setEnabled(true);
            this.setButtonStatus(this.button_status);
        }
        this.setDeleteButton();
    }

    private void setDeleteButton() {
        int row = this.Table_Data.getSelectedRow();
        int rowcount = this.Table_Data.getRowCount();
        if (!this.Modify_Button.isEnabled() && !this.Table_Data.getSelectionModel().isSelectionEmpty() && row >= 0 && row < rowcount) {
            this.authority.authorise(this.table_owner, this.table_name);
        } else {
            this.grant(false);
        }
    }

    public void Data_First_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.data_end = 0;
            this.data_start = 0;
            this.hasNext = this.rs.first();
            if (this.hasNext) {
                ++this.data_start;
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        this.getTableData();
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void Data_Last_Button_actionPerformed(ActionEvent e) {
        block10: {
            DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
            int data_max = 0;
            Statement stmt0 = null;
            ResultSet rs0 = null;
            try {
                stmt0 = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
                String query0 = "SELECT COUNT(*) FROM \"" + this.table_owner + "\".\"" + this.table_name + "\" ";
                if (this.where_text.length() > 0) {
                    String temp = this.where_text.toUpperCase();
                    if ((temp = temp.trim()).indexOf("WHERE") == 0) {
                        query0 = query0 + this.where_text;
                    } else if (temp.indexOf("ORDER") != 0) {
                        query0 = query0 + "WHERE " + this.where_text;
                    }
                }
                if ((rs0 = stmt0.executeQuery(query0)).next()) {
                    data_max = rs0.getInt(1);
                }
                rs0.close();
                stmt0.close();
                rs0 = null;
                stmt0 = null;
                int i = data_max / this.data_offset;
                int j = data_max % this.data_offset;
                if (j == 0 && i > 0) {
                    --i;
                }
                this.data_start = i * this.data_offset;
                int move = this.data_start - this.data_end;
                this.data_end = this.data_start++;
                this.hasNext = this.rs.relative(move);
                if (this.hasNext) {
                    // empty if block
                }
            }
            catch (SQLException e0) {
                if (rs0 != null) {
                    DbaObject.close(rs0);
                }
                if (stmt0 == null) break block10;
                DbaObject.close(stmt0);
            }
        }
        this.getTableData();
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void Data_Down_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (this.hasNext) {
            this.data_start = this.data_end + 1;
        }
        this.getTableData();
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void Data_Up_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int move = this.data_end - this.data_start + 1 + this.data_offset;
            this.data_start -= this.data_offset;
            this.data_end = this.data_start - 1;
            this.hasNext = this.rs.relative(-move);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        this.getTableData();
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    private void setUpBlobEditor(JTable table, int index) {
        Class<?> jaicls = null;
        try {
            jaicls = Class.forName("javax.media.jai.widget.ScrollingImagePanel");
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe.getMessage());
        }
        JButton field = jaicls == null ? new BlobEditorNoJAIButton() : new BlobEditorButton();
        BlobEditor editor = new BlobEditor((BlobEditorButtonInterface)((Object)field), table, this.dataModel);
        TableColumn column = table.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
    }

    private void setUpCellEditor(JTable table) {
        int col_count = this.dataModel.getColumnCount();
        String type = null;
        String precision = null;
        String scale = null;
        for (int i = 1; i < col_count; ++i) {
            type = (String)this.schemaModel.getValueAt(i - 1, SchemaTableModel.TYPE);
            if (type.equals("integer") || type.equals("serial")) {
                this.Table_Data.setUpCharEditor(i);
                continue;
            }
            if (type.equals("bigint")) {
                this.Table_Data.setUpCharEditor(i);
                continue;
            }
            if (type.equals("bigserial")) {
                this.Table_Data.setUpCharEditor(i);
                continue;
            }
            if (type.equals("smallint")) {
                this.Table_Data.setUpCharEditor(i);
                continue;
            }
            if (type.equals("double")) {
                this.Table_Data.setUpDoubleEditor(i);
                continue;
            }
            if (type.equals("decimal")) {
                precision = (String)this.schemaModel.getValueAt(i - 1, SchemaTableModel.SIZE);
                scale = (String)this.schemaModel.getValueAt(i - 1, SchemaTableModel.SCALE);
                this.Table_Data.setUpDecimalEditorStr(i, new DecimalField(Integer.parseInt(precision), Integer.parseInt(scale)));
                continue;
            }
            if (type.equals("real")) {
                this.Table_Data.setUpFloatEditor(i);
                continue;
            }
            if (type.equals("binary") || type.equals("oid")) {
                this.Table_Data.setUpBinaryEditor(i);
                continue;
            }
            if (type.equals("char") || type.equals("varchar") || type.equals("nchar") || type.equals("nvarchar")) {
                this.Table_Data.setUpCharEditor(i);
                continue;
            }
            if (!SchemaType.isBlobType(type)) continue;
            this.setUpBlobEditor(table, i);
        }
    }

    private ResultSet initResultSet() throws SQLException {
        this.data_end = 0;
        this.data_start = 0;
        this.hasNext = false;
        this.stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement(1005, 1008);
        String query = "SELECT OID";
        int count = this.absDataModel.getColumnCount();
        String colName = null;
        for (int i = 1; i < count; ++i) {
            colName = (String)this.schemaModel.getValueAt(i - 1, SchemaTableModel.NAME);
            query = this.retriveMethods[i] == MethodTypes.CLOB || this.retriveMethods[i] == MethodTypes.BLOB ? query + ", bloblen(" + GuiUt.getIDString(colName) + ")" : query + ", " + GuiUt.getIDString(colName);
        }
        query = query + " FROM \"" + this.table_owner + "\".\"" + this.table_name + "\" ";
        if (this.where_text.length() > 0) {
            String temp = this.where_text.toUpperCase();
            query = (temp = temp.trim()).indexOf("WHERE") == 0 ? query + this.where_text : (temp.indexOf("ORDER") == 0 ? query + this.where_text : query + "WHERE " + this.where_text);
        }
        PrimaryKeyVector primarykey = this.tableInfo.schemaPanel.primarykey;
        if (this.where_text.toUpperCase().indexOf("ORDER") < 0 && primarykey != null && primarykey.toSQLString().length() > 0) {
            query = query + " ORDER BY " + primarykey.toSQLString();
        }
        return this.stmt.executeQuery(query);
    }

    private void getTableData() {
        try {
            if (this.rs == null) {
                this.rs = this.initResultSet();
            }
            int count = this.absDataModel.getColumnCount();
            if (!this.hasNext) {
                this.hasNext = this.rs.next();
                if (this.hasNext) {
                    this.data_start = this.data_end + 1;
                }
            }
            this.dataModel.removeAll();
            ArrayList<Object> one_row = null;
            BlobCellObject obj = null;
            Object temp = null;
            String oid = null;
            int k = 1;
            Object c = null;
            Object b = null;
            while (this.hasNext) {
                ++this.data_end;
                one_row = new ArrayList<Object>(count);
                oid = this.rs.getString(1);
                one_row.add(oid);
                block9: for (int i = 1; i < count; ++i) {
                    switch (this.retriveMethods[i]) {
                        case CLOB: {
                            long length = this.rs.getLong(i + 1);
                            obj = new BlobCellObject(oid, this.table_owner, this.table_name, this.absDataModel.getColumnName(i), this.types[i], length, this.rs.wasNull());
                            one_row.add(obj);
                            continue block9;
                        }
                        case BLOB: {
                            long length = this.rs.getLong(i + 1);
                            obj = new BlobCellObject(oid, this.table_owner, this.table_name, this.absDataModel.getColumnName(i), this.types[i], length, this.rs.wasNull());
                            one_row.add(obj);
                            continue block9;
                        }
                        case OBJECT: {
                            temp = this.rs.getObject(i + 1);
                            one_row.add(this.rs.wasNull() ? null : GuiUt.rightTrim(temp.toString()));
                            continue block9;
                        }
                        default: {
                            temp = this.rs.getString(i + 1);
                            one_row.add(this.rs.wasNull() ? null : temp);
                        }
                    }
                }
                this.dataModel.addValue(one_row);
                this.hasNext = this.rs.next();
                if (++k <= this.data_offset) continue;
            }
            if (k > this.data_offset && this.hasNext) {
                this.Data_Down_Button.setEnabled(true);
                this.Data_Last_Button.setEnabled(true);
            } else {
                this.Data_Down_Button.setEnabled(false);
                this.Data_Last_Button.setEnabled(false);
            }
            if (this.data_start > this.data_offset) {
                this.Data_Up_Button.setEnabled(true);
                this.Data_First_Button.setEnabled(true);
            } else {
                this.Data_Up_Button.setEnabled(false);
                this.Data_First_Button.setEnabled(false);
            }
            String s = GuiUt.mapStringForProperty(this.res.getString("records_selected"), Integer.toString(this.dataModel.getRowCount()));
            if (this.dataModel.getRowCount() > 0) {
                s = s + " (" + this.data_start + " - " + this.data_end + ")";
            }
            this.infoLabel.setText(s);
            DbFrame.frame.setStatusDisc(s);
            this.absDataModel.fireTableChanged(new TableModelEvent(this.absDataModel));
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            DbaObject.close(this.rs);
            DbaObject.close(this.stmt);
            this.rs = null;
            this.stmt = null;
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUt.showErrorDlg(DbFrame.frame, ex.getClass().toString() + ":" + ex.getMessage(), null);
        }
        if (this.dataModel.getRowCount() > 0) {
            this.Table_Data.setselectedCell(0, 0);
        }
    }

    private void setButtonStatus(boolean[] status) {
        this.Data_Up_Button.setEnabled(status[0]);
        this.Data_Down_Button.setEnabled(status[1]);
        this.Data_First_Button.setEnabled(status[2]);
        this.Data_Last_Button.setEnabled(status[3]);
    }

    public void Confirm_Button_actionPerformed(ActionEvent e) {
        try {
            int result;
            int row;
            if (this.Table_Data.isEditing()) {
                int edit_row = this.Table_Data.getEditingRow();
                this.Table_Data.editingStopped(null);
                this.Table_Data.setSelectedRow(edit_row);
            }
            if ((row = this.Table_Data.getSelectedRow()) >= 0 && row < this.dataModel.getRowCount() && this.dataModel.withNewData(row) && (result = this.dataModel.insertNewRecord(row)) < 0) {
                this.Table_Data.setSelectedRow(row);
                return;
            }
            DbFrame.conn_DatabaseConnection.getDbConnection().commit();
            this.Cancel_Button_actionPerformed(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("exception=" + ex.getMessage());
        }
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.Table_Data.editingCanceled(null);
        this.setEditable(false);
        this.setButtonStatus(this.button_status);
        this.dataModel.isEditable = false;
        if (this.rs != null) {
            try {
                this.rs.close();
                this.rs = null;
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        try {
            DbFrame.conn_DatabaseConnection.getDbConnection().rollback();
            DbFrame.conn_DatabaseConnection.getDbConnection().setAutoCommit(true);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        try {
            int original = this.data_start;
            this.rs = this.initResultSet();
            if (original > 0) {
                this.rs.relative(original - 1);
                this.data_end = original - 1;
                this.hasNext = this.rs.next();
                if (this.hasNext) {
                    this.data_start = this.data_end + 1;
                } else if (original > this.data_offset) {
                    this.hasNext = this.rs.relative(-this.data_offset);
                    this.data_start = this.data_end - this.data_offset + 1;
                    this.data_end = this.data_start - 1;
                }
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        this.getTableData();
        this.previous_row = -1;
        this.current_row = -1;
        this.absDataModel.addMouseListenerToHeaderInTable(this.Table_Data);
        this.Table_Data.clearSelection();
        this.tableInfo.releaseTabbedPanel();
    }

    public void Modify_Button_actionPerformed(ActionEvent e) {
        try {
            this.dataModel.isEditable = true;
            this.dataModel.addEmptyRow();
            if (this.dataModel.getColumnCount() == 2) {
                this.dataModel.addEmptyRow();
            }
            DbFrame.conn_DatabaseConnection.getDbConnection().setAutoCommit(false);
            this.absDataModel.removeMouseListenerToHeaderInTable(this.Table_Data);
            this.setEditable(true);
            this.Table_Data.setselectedCell(this.dataModel.getFirstNewData(), 1);
            this.previous_row = this.dataModel.getFirstNewData();
            this.current_row = -1;
            this.tableInfo.fixTabbedPanelAt(5);
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        catch (Exception ex) {
            GuiUt.showErrorDlg(DbFrame.frame, "ex=" + ex.getMessage(), null);
        }
    }

    public void Delete_Button_actionPerformed(ActionEvent e) {
        int row = -1;
        if (this.Table_Data.isEditing()) {
            row = this.Table_Data.getEditingRow();
            this.Table_Data.editingStopped(null);
        } else {
            row = this.Table_Data.getSelectedRow();
        }
        if (row < 0 || row >= this.Table_Data.getRowCount()) {
            return;
        }
        this.Table_Data.clearSelection();
        this.previous_row = -1;
        this.dataModel.deleteRow(row);
        this.absDataModel.fireTableChanged(new TableModelEvent(this.absDataModel));
        int row_count = this.Table_Data.getRowCount();
        if (row >= row_count && row_count > 0) {
            row = row_count - 1;
        }
        if (row < row_count) {
            this.Table_Data.setSelectedRow(row);
        }
        this.setDeleteButton();
    }

    public void Filter_Button_actionPerformed(ActionEvent e) {
        DataFilterDlg dlg = DbFrame.isWindows ? new DataFilterDlg(DbFrame.frame) : new DataFilterDlg(DbFrame.frame, "", true);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.setTitle(this.res.getString("Data_Filter"));
        dlg.setText(this.where_text);
        dlg.show();
        if (dlg.getResult() != 0) {
            dlg.dispose();
            return;
        }
        this.where_text = dlg.getText().trim();
        if (dlg.getResult() == 0 && this.rs != null) {
            try {
                this.rs.close();
                this.stmt.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            this.rs = null;
            this.stmt = null;
        }
        dlg.dispose();
        System.gc();
        if (this.where_text.length() > 0) {
            this.Filter_Button.setToolTipText(this.where_text);
        } else {
            this.Filter_Button.setToolTipText(null);
        }
        this.getTableData();
    }

    private void TableRowSelectionChanged(ListSelectionEvent e) {
        if (this.Modify_Button.isEnabled()) {
            return;
        }
        int row = this.Table_Data.getSelectedRow();
        if (this.current_row == row && e != null) {
            return;
        }
        this.current_row = row;
        int col = this.Table_Data.getSelectedColumn();
        if (row < 0 || col < 0) {
            return;
        }
        if (row >= this.dataModel.getRowCount() || col >= this.dataModel.getColumnCount()) {
            return;
        }
        if (this.previous_row == row) {
            return;
        }
        if ((e == null || this.previous_row >= 0 && this.previous_row != row) && this.dataModel.withNewData(this.previous_row) && this.dataModel.insertNewRecord(this.previous_row) < 0) {
            this.Table_Data.setSelectedRow(this.previous_row);
            this.Table_Data.editCellAt(this.previous_row, col, e);
            return;
        }
        if (row == this.dataModel.getRowCount() - 1 && this.dataModel.withNewData(row)) {
            this.dataModel.addEmptyRow();
            this.absDataModel.fireTableChanged(new TableModelEvent(this.absDataModel));
        }
        this.previous_row = row;
        this.Table_Data.editCellAt(row, col);
    }

    private void TableColumnSelectionChanged(ListSelectionEvent e) {
        int col = this.Table_Data.getSelectedColumn();
        int row = this.Table_Data.getSelectedRow();
        if (col < 0 || col >= this.Table_Data.getColumnCount()) {
            return;
        }
        if (row < 0 || row >= this.Table_Data.getRowCount()) {
            return;
        }
        this.Table_Data.editCellAt(row, col);
    }

    public void clean() {
        if (this.rs != null) {
            try {
                this.rs.close();
                this.stmt.close();
                this.rs = null;
                this.stmt = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void Table_Data_mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            int row = this.Table_Data.getSelectedRow();
            if (row < 0 || row >= this.dataModel.getRowCount()) {
                return;
            }
            int columnCount = this.Table_Data.getColumnCount();
            Object[][] newTableData = new Object[columnCount - 1][2];
            for (int i = 1; i < columnCount; ++i) {
                newTableData[i - 1][0] = this.Table_Data.getColumnName(i);
                newTableData[i - 1][1] = this.dataModel.getValueAt(row, i);
            }
            DefaultTableModel newModel = new DefaultTableModel(newTableData, new String[]{"Columns", "Row #" + (row + 1)}){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            JTable newTable = new JTable(newModel);
            JScrollPane scrollPane = new JScrollPane(newTable);
            newTable.getColumnModel().getColumn(0).setPreferredWidth(100);
            newTable.getColumnModel().getColumn(1).setPreferredWidth(400);
            JFrame newFrame = new JFrame("Row Data");
            newFrame.setDefaultCloseOperation(2);
            newFrame.getContentPane().add((Component)scrollPane, "Center");
            newFrame.pack();
            newFrame.setLocationRelativeTo(null);
            newFrame.setAlwaysOnTop(true);
            newFrame.setVisible(true);
        }
    }

    static enum MethodTypes {
        CLOB,
        BLOB,
        STRING,
        OBJECT;

    }
}

