/*
 * Decompiled with CFR 0.152.
 */
package dbatool.StoredCommand;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.StoredCommand.ExecuteCommand;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class StoredCommandList
extends DbaTabbedPane
implements ComponentPrivilege {
    private int MODULE = 0;
    private int OWNER = 1;
    private int NAME = 2;
    private DbaButton Create_Button;
    private DbaButton Execute_Button;
    private DbaButton Drop_Button;
    private DbaButton rebuildButton;
    private DbaTableModel model;
    private DBAToolAbstractTableModel absModel;
    private JTable table;

    public StoredCommandList() {
        this.Create_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.Execute_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Execute"), 'E', DBAImageResource.getResource(this.getClass(), "/jdbaimages/execute.gif"), new ReflectionAction(this, "Execute_Button_actionPerformed"));
        this.Drop_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
        this.rebuildButton = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Rebuild"), 'R', DBAImageResource.getResource(this.getClass(), "/jdbaimages/edit.gif"), new ReflectionAction(this, "rebuildButtonActionPerformed"));
        this.model = null;
        this.absModel = null;
        this.table = null;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("StoredCommandsTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "storedcommand.list");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JScrollPane jScrollPane1 = new JScrollPane();
        String[] columnNames = new String[]{DbFrame.frame.res.getString("Module"), DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Status")};
        this.model = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.table = new JTable(this.absModel);
        this.table.setName("StoredCommandListTable");
        jPanel1.setLayout(new BorderLayout());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StoredCommandList.this.table_mouseClicked(e);
            }
        });
        this.add((Component)jPanel1, DbFrame.frame.res.getTitle("Stored_Command"));
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.Create_Button, null);
        jPanel2.add((Component)this.Drop_Button, null);
        jPanel2.add((Component)this.Execute_Button, null);
        jPanel2.add((Component)this.rebuildButton, null);
        jPanel2.setName("StoredCommandButtonPanel");
        this.Create_Button.setName("CreateButton");
        this.Drop_Button.setName("DropButton");
        this.Execute_Button.setName("ExecuteButton");
        this.rebuildButton.setName("RebuildButton");
        jPanel1.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.table, null);
        this.initColumnSizes();
        this.getStoredCommandList();
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
        this.Execute_Button.setEnabled(false);
        this.rebuildButton.setEnabled(false);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
        this.absModel.addMouseListenerToHeaderInTable(this.table);
    }

    @Override
    public int getComponentType() {
        return 16;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Drop_Button.setEnabled(enabled);
        this.rebuildButton.setEnabled(enabled);
    }

    public void table_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
            this.Execute_Button.setEnabled(false);
        } else {
            int r = this.table.getSelectedRow();
            Object value = this.table.getValueAt(r, 1);
            String owner = (String)value;
            this.authority.authorise(owner);
            String s = (String)this.table.getValueAt(this.table.getSelectedRow(), 3);
            if (s.equals(DbFrame.frame.res.getString("Valid"))) {
                this.Execute_Button.setEnabled(true);
            } else {
                this.Execute_Button.setEnabled(false);
            }
        }
    }

    private void initColumnSizes() {
        TableColumn column = null;
        Object renderer = null;
        column = this.table.getColumnModel().getColumn(this.MODULE);
        column.setPreferredWidth(100);
        column = this.table.getColumnModel().getColumn(this.OWNER);
        column.setPreferredWidth(100);
        column = this.table.getColumnModel().getColumn(this.NAME);
        column.setPreferredWidth(100);
    }

    private void getStoredCommandList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select MODULENAME, CMDOWNER, CMDNAME, NUM_PARM, STATUS from SYSTEM.SYSCMDINFO where CMDTYPE = 0 order by MODULENAME, CMDOWNER, CMDNAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.model.addValue(new DBARowInfo(this.getRowInfo(rs.getString(1), rs.getString(2), rs.getString(3), rs.getInt(4), rs.getShort(5))));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(DbFrame.frame.res.getString("The_number_of_stored_commands_is"), Integer.toString(this.model.getRowCount())));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
    }

    private Object[] getRowInfo(String module, String owner, String name, int num_parm, short status) {
        Object[] data = new Object[5];
        data[this.MODULE] = module.trim();
        data[this.OWNER] = GuiUt.rightTrim(owner);
        data[this.NAME] = GuiUt.rightTrim(name);
        data[3] = status == 0 ? DbFrame.frame.res.getString("Invalid") : DbFrame.frame.res.getString("Valid");
        data[4] = new Integer(num_parm);
        return data;
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(14);
        DbFrame.frame.treePanel.refreshCommandTree();
        this.getStoredCommandList();
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        String owner = (String)this.model.getValueAt(row, this.OWNER);
        String name = (String)this.model.getValueAt(row, this.NAME);
        if (DbFrame.conn_DatabaseConnection.dropCommand(owner, name)) {
            DbFrame.frame.treePanel.afterDropObject(16);
        }
    }

    public void Execute_Button_actionPerformed(ActionEvent e) {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        String owner = (String)this.model.getValueAt(row, this.OWNER);
        String name = (String)this.model.getValueAt(row, this.NAME);
        int num_parm = (Integer)this.model.getValueAt(row, 4);
        StringBuffer query_sb = new StringBuffer("EXEC COMMAND \"");
        if (owner.length() > 0) {
            query_sb.append(owner).append("\".\"");
        }
        query_sb.append(name).append("\" ");
        if (num_parm > 0) {
            query_sb.append("(?");
            for (int i = 1; i < num_parm; ++i) {
                query_sb.append(",?");
            }
            query_sb.append(")");
        }
        ExecuteCommand ec = new ExecuteCommand(query_sb.toString(), num_parm);
        ec.execute();
    }

    public void rebuildButtonActionPerformed(ActionEvent e) {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        String owner = (String)this.model.getValueAt(row, this.OWNER);
        String name = (String)this.model.getValueAt(row, this.NAME);
        String sql = "rebuild command \"" + owner + "\".\"" + name + "\"";
        boolean isOK = DatabaseConnection.executeSQL(DbFrame.frame, sql);
        if (isOK) {
            GuiUt.showSuccessDlg(DbFrame.frame, DbFrame.frame.res.getString("Rebuild_command_successfully"), null);
        }
        this.model.removeAll();
        this.getStoredCommandList();
        this.model.fireTableChanged(null);
    }

    private void table_mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            int row = this.table.getSelectedRow();
            if (row < 0 || row >= this.absModel.getRowCount()) {
                return;
            }
            String owner = (String)this.absModel.getValueAt(row, this.OWNER);
            String name = (String)this.absModel.getValueAt(row, this.NAME);
            DbFrame.frame.treePanel.openCommandTree(owner, name);
        }
    }
}

