/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Schedule;

import com.borland.jbcl.layout.VerticalFlowLayout;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.Schedule.SynchronizeDlg;
import dbatool.tableModel.BasicInfoTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.text.TextField;
import dbaut.textField.CharField;
import dbaut.textField.CharPasswordField;
import dbaut.textField.DateTimeField;
import dbaut.textField.IntegerRangeField;
import dbaut.textField.IntervalField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ScheduleInfo
extends DbaTabbedPane {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.ScheduleRes", LocaleManager.getLocale());
    private DbaButton Suspend_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Suspend"), 'U', DBAImageResource.getResource(this.getClass(), "/jdbaimages/lock.gif"), new ReflectionAction(this, "Suspend_Button_actionPerformed"));
    private DbaButton Cancel_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancel.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
    private DbaButton Confirm_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Confirm_Button_actionPerformed"));
    private DbaButton Modify_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Modify_Button_actionPerformed"));
    private BasicInfoTableModel model = new BasicInfoTableModel();
    private String remote_db = null;
    private JComboBox Stop_On_Error = new JComboBox();
    private IntegerRangeField Seconds_Btwn_Retries = new IntegerRangeField(Integer.MAX_VALUE, 0);
    private IntegerRangeField Retry = new IntegerRangeField(Integer.MAX_VALUE, 0);
    private IntervalField Interval = new IntervalField(365, 0);
    private DateTimeField Begin_Time = new DateTimeField();
    private JTextField Status = new TextField();
    private CharField User_Name = new CharField();
    private CharField DB_Name = new CharField();
    private JTextField DB_Type = new TextField();
    private JTextField Is_Express = new TextField();
    private JComboBox With_No_Check = new JComboBox();
    private String begin_time;
    private String user_name;
    private int retry;
    private int seconds_btwn_retry;
    private String interval;
    private String isExpress;
    private String stop_on_error;
    private String with_no_check;
    private CharPasswordField Password = new CharPasswordField(16, true);

    public ScheduleInfo(String remote_db) {
        this.remote_db = remote_db;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("RepScheduleTabbedPane");
        this.Status.setName("StatusField");
        this.Retry.setName("RetryField");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "schedule.info");
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JPanel jPanel2 = new JPanel(new GridLayout(12, 2, 5, 5));
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        JLabel jLabel11 = new JLabel();
        JLabel jLabel12 = new JLabel();
        jPanel1.setLayout((LayoutManager)new VerticalFlowLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        DbaButton Synchronize_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Synchronize"), 'S', DBAImageResource.getResource(this.getClass(), "/jdbaimages/schedule.gif"), new ReflectionAction(this, "Synchronize_Button_actionPerformed"));
        jLabel1.setText(this.res.getString("With_no_Check"));
        jLabel2.setText(this.res.getString("Stop_on_Error"));
        jLabel3.setText(this.res.getString("Seconds_between"));
        jLabel4.setText(this.res.getString("Retry"));
        jLabel5.setText(this.res.getString("Interval"));
        jLabel6.setText(this.res.getString("Begin_Time"));
        jLabel7.setText(this.res.getString("Status"));
        jLabel8.setText(this.res.getString("User_Name"));
        jLabel9.setText(this.res.getString("Database_Type"));
        jLabel10.setText(this.res.getString("Target_Database_Name"));
        jLabel11.setText(this.res.getString("Password"));
        jLabel12.setText(this.res.getString("Is_Express"));
        this.add((Component)jPanel1, this.res.getString("Replication_Schedule"));
        jPanel1.add(jPanel4);
        jPanel4.setName("RepScheduleButtonPanel");
        jPanel4.add((Component)this.Modify_Button, null);
        jPanel4.add((Component)this.Confirm_Button, null);
        jPanel4.add((Component)this.Cancel_Button, null);
        jPanel4.add((Component)this.Suspend_Button, null);
        jPanel4.add((Component)Synchronize_Button, null);
        this.Modify_Button.setName("ModifyButton");
        this.Confirm_Button.setName("ConfirmButton");
        this.Cancel_Button.setName("CancelButton");
        this.Suspend_Button.setName("SuspendButton");
        Synchronize_Button.setName("SynchronizeButton");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)jPanel2, "West");
        jPanel1.add(panel2);
        jPanel2.setName("RepScheduleContentsPanel");
        jPanel2.add(jLabel10);
        jPanel2.add(this.DB_Name);
        jPanel2.add(jLabel9);
        jPanel2.add(this.DB_Type);
        jPanel2.add(jLabel8);
        jPanel2.add(this.User_Name);
        jPanel2.add(jLabel11);
        jPanel2.add(this.Password);
        jPanel2.add(jLabel7);
        jPanel2.add(this.Status);
        jPanel2.add(jLabel6);
        jPanel2.add(this.Begin_Time);
        jPanel2.add(jLabel5);
        jPanel2.add(this.Interval);
        jPanel2.add(jLabel4);
        jPanel2.add(this.Retry);
        jPanel2.add(jLabel3);
        jPanel2.add(this.Seconds_Btwn_Retries);
        jPanel2.add(jLabel12);
        jPanel2.add(this.Is_Express);
        jPanel2.add(jLabel2);
        jPanel2.add(this.Stop_On_Error);
        jPanel2.add(jLabel1);
        jPanel2.add(this.With_No_Check);
        this.With_No_Check.addItem(this.res.getString("Check"));
        this.With_No_Check.addItem(this.res.getString("No"));
        this.Stop_On_Error.addItem(this.res.getString("Yes"));
        this.Stop_On_Error.addItem(this.res.getString("No"));
        this.setEditable(false);
        this.getScheduleInfo();
    }

    private void setEditable(boolean editable) {
        if (editable) {
            this.Begin_Time.setEnabled(true);
            this.User_Name.setEnabled(true);
            this.Retry.setEnabled(true);
            this.Interval.setEnabled(true);
            this.Seconds_Btwn_Retries.setEnabled(true);
            if (this.isExpress.equals(this.res.getString("No"))) {
                this.Stop_On_Error.setEnabled(true);
            }
            this.Password.setEnabled(true);
            this.Cancel_Button.setEnabled(true);
            this.Confirm_Button.setEnabled(true);
            this.Modify_Button.setEnabled(false);
        } else {
            this.DB_Name.setEnabled(false);
            this.DB_Type.setEnabled(false);
            this.User_Name.setEnabled(false);
            this.Password.setEnabled(false);
            this.Status.setEnabled(false);
            this.Begin_Time.setEnabled(false);
            this.Interval.setEnabled(false);
            this.Retry.setEnabled(false);
            this.Seconds_Btwn_Retries.setEnabled(false);
            this.Stop_On_Error.setEnabled(false);
            this.With_No_Check.setEnabled(false);
            this.Is_Express.setEnabled(false);
            this.Cancel_Button.setEnabled(false);
            this.Confirm_Button.setEnabled(false);
            this.Modify_Button.setEnabled(true);
        }
    }

    private void getScheduleInfo() {
        int i = 0;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select SVRNAME, SVRTYPE, USER_NAME, STATUS, BEGTIME, \"INTERVAL\", RETRY, TIME_SLEEP, ASCII(STOP_ON_ERR), NOCHECK, RESERVE1  from SYSTEM.SYSTRPDEST where SVRNAME = '" + this.remote_db + "' order by SVRNAME";
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                this.DB_Name.setText(rs.getString(1).trim());
                String dbbrand = "DBMaker";
                if (!LocaleManager.getIsDBMaker()) {
                    dbbrand = "DBMaster";
                }
                switch (rs.getInt(2)) {
                    case 0: {
                        this.DB_Type.setText(dbbrand);
                        break;
                    }
                    case 1: {
                        this.DB_Type.setText("Informix");
                        break;
                    }
                    case 2: {
                        this.DB_Type.setText("Microsoft");
                        break;
                    }
                    case 3: {
                        this.DB_Type.setText("Oracle");
                        break;
                    }
                    case 4: {
                        this.DB_Type.setText("Sybase");
                        break;
                    }
                    case 5: {
                        this.DB_Type.setText(dbbrand + "X");
                        break;
                    }
                    case 6: {
                        this.DB_Type.setText("DB2");
                        break;
                    }
                    case 7: {
                        this.DB_Type.setText("MySQL");
                        break;
                    }
                    case 8: {
                        this.DB_Type.setText("PostgreSQL");
                        break;
                    }
                    case 9: {
                        this.DB_Type.setText("ODBCX");
                        break;
                    }
                    default: {
                        this.DB_Type.setText("Unknown");
                    }
                }
                this.user_name = rs.getString(3);
                if (this.user_name != null) {
                    this.user_name = this.user_name.trim();
                }
                this.User_Name.setText(this.user_name);
                this.Status.setText(rs.getString(4).equals("0") ? "OK" : "SUSPEND");
                if (this.Status.getText().equals("OK")) {
                    this.Suspend_Button.setText(this.res.getString("Suspend"));
                } else {
                    this.Suspend_Button.setText(this.res.getString("Resume"));
                }
                i = rs.getInt(5);
                if (i < 0) {
                    this.begin_time = GuiUt.convertTimeToStr(0);
                    this.Begin_Time.setInitValue(this.begin_time);
                } else {
                    this.begin_time = GuiUt.convertTimeToStr(i);
                    this.Begin_Time.setInitValue(this.begin_time);
                }
                this.interval = GuiUt.convertIntervalToStr(rs.getInt(6));
                this.Interval.setDayTime(this.interval);
                this.retry = rs.getInt(7);
                this.Retry.setValue(this.retry);
                this.seconds_btwn_retry = rs.getInt(8);
                this.Seconds_Btwn_Retries.setValue(this.seconds_btwn_retry);
                this.stop_on_error = rs.getInt(9) == 0 ? new String(this.res.getString("No")) : new String(this.res.getString("Yes"));
                this.Stop_On_Error.setSelectedItem(this.stop_on_error);
                this.with_no_check = rs.getInt(10) == 0 ? new String(this.res.getString("Check")) : new String(this.res.getString("No"));
                this.With_No_Check.setSelectedItem(this.with_no_check);
                this.isExpress = rs.getInt(11) == 0 ? new String(this.res.getString("No")) : new String(this.res.getString("Yes"));
                this.Is_Express.setText(this.isExpress);
                this.Password.setText("");
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public void Modify_Button_actionPerformed(ActionEvent e) {
        this.fixTabbedPanelAt(this.getSelectedIndex());
        this.setEditable(true);
    }

    public void Confirm_Button_actionPerformed(ActionEvent e) {
        boolean result;
        String query = "";
        String password = new String(this.Password.getPassword());
        if (password.length() > 0 || !this.User_Name.getText().equals(this.user_name)) {
            query = query + "ALTER SCHEDULE FOR REPLICATION TO " + this.DB_Name.getText() + " IDENTIFIED BY " + this.User_Name.getText();
            if (password.length() > 0) {
                query = query + " '" + password + "'";
            }
            query = query + ";\n";
        }
        if (this.Begin_Time.getDateTime() == null) {
            GuiUt.showErrorDlg(DbFrame.frame, GuiUt.mapStringForProperty(this.res.getString("Invalid_date_time_format"), (String)this.Begin_Time.getValue(), false), null);
            return;
        }
        if (this.Interval.getDay() == null) {
            GuiUt.showErrorDlg(DbFrame.frame, GuiUt.mapStringForProperty(this.res.getString("Invalid_interval_format"), (String)this.Interval.getValue(), false), null);
            return;
        }
        if (this.Retry.getValue() == null) {
            GuiUt.showErrorDlg(DbFrame.frame, GuiUt.mapStringForProperty(this.res.getString("Invalid_retry"), String.valueOf(this.Retry.getInt()), false), null);
            return;
        }
        if (this.Seconds_Btwn_Retries.getValue() == null) {
            GuiUt.showErrorDlg(DbFrame.frame, GuiUt.mapStringForProperty(this.res.getString("Invalid_seconds_between_retries"), String.valueOf(this.Seconds_Btwn_Retries.getInt()), false), null);
            return;
        }
        if (!this.Begin_Time.getDateTime().equals(this.begin_time) || !((String)this.Interval.getValue()).equals(this.interval)) {
            query = query + "ALTER SCHEDULE FOR REPLICATION TO " + this.DB_Name.getText() + " BEGIN AT " + this.Begin_Time.getValue().toString() + " EVERY " + this.Interval.getDay() + " DAYS AND " + this.Interval.getTime() + ";\n";
        }
        if (this.Seconds_Btwn_Retries.getInt() != this.seconds_btwn_retry || this.Retry.getInt() != this.retry) {
            query = query + "ALTER SCHEDULE FOR REPLICATION TO " + this.DB_Name.getText() + " RETRY " + this.Retry.getInt() + " TIMES " + " AFTER " + this.Seconds_Btwn_Retries.getInt() + " SECONDS;\n";
        }
        if (!this.Stop_On_Error.getSelectedItem().equals(this.stop_on_error)) {
            query = this.stop_on_error.equals(this.res.getString("Yes")) ? query + "ALTER SCHEDULE FOR REPLICATION TO " + this.DB_Name.getText() + "  IGNORE ON ERROR;\n" : query + "ALTER SCHEDULE FOR REPLICATION TO " + this.DB_Name.getText() + "  STOP ON ERROR;\n";
        }
        if (query.length() > 0 && !(result = DatabaseConnection.executeMultiSQL(query))) {
            return;
        }
        this.Cancel_Button_actionPerformed(null);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.getScheduleInfo();
        this.setEditable(false);
        this.releaseTabbedPanel();
    }

    public void Suspend_Button_actionPerformed(ActionEvent e) {
        String query = this.Suspend_Button.getRealText().equals(this.res.getString("Suspend")) ? "SUSPEND SCHEDULE FOR REPLICATION TO \"" + this.DB_Name.getText() + "\"" : "RESUME SCHEDULE FOR REPLICATION TO \"" + this.DB_Name.getText() + "\"";
        boolean result = DatabaseConnection.executeMultiSQL(query);
        if (!result) {
            return;
        }
        this.Cancel_Button_actionPerformed(null);
    }

    public void Synchronize_Button_actionPerformed(ActionEvent e) {
        SynchronizeDlg dlg = DbFrame.isWindows ? new SynchronizeDlg((Frame)DbFrame.frame, this.DB_Name.getText()) : new SynchronizeDlg((Frame)DbFrame.frame, "", true, this.DB_Name.getText());
        dlg.setTitle(this.res.getString("Synchronize"));
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.show();
        this.Cancel_Button_actionPerformed(null);
    }
}

