/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Replication;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import dbaut.text.TextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import wizard.async.ASyncRowInfo;
import wizard.async.Wizard_asyncdest;
import wizard.sync.SyncRowInfo;
import wizard.sync.Wizard_syncdest;

public class ReplicationInfo
extends DbaTabbedPane
implements ComponentPrivilege {
    private int DB_LINK = 0;
    private int TABLE_OWNER = 1;
    private int TABLE_NAME = 2;
    private int COLUMNS = 3;
    private int FLUSH = 4;
    private int CLEAR = 5;
    private DbaButton Drop_Button;
    private DbaButton Add_Button;
    private DbaTableModel model;
    private DBAToolAbstractTableModel absModel;
    private JTable table;
    private String repl_name;
    private String table_owner;
    private String table_name;
    private String project_column;
    private String type;
    private JTextField Base_Table;
    private JTextField Project_Column;
    private JTextField Replication_Name;

    public ReplicationInfo(String repl_name, String table_owner, String table_name, String project_column, String type) {
        this.Drop_Button = new DbaButton(new Dimension(160, 24), DbFrame.frame.res.getString("Remove_Subscriber"), 'R', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
        this.Add_Button = new DbaButton(new Dimension(160, 24), DbFrame.frame.res.getString("Add_Subscriber"), 'A', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Add_Button_actionPerformed"));
        this.model = null;
        this.absModel = null;
        this.table = null;
        this.repl_name = null;
        this.table_owner = null;
        this.table_name = null;
        this.project_column = null;
        this.type = null;
        this.Base_Table = new TextField();
        this.Project_Column = new TextField();
        this.Replication_Name = new TextField();
        this.repl_name = repl_name;
        this.table_owner = table_owner;
        this.table_name = table_name;
        this.project_column = project_column;
        this.type = type.trim().equalsIgnoreCase("A") ? DbFrame.frame.res.getString("Asynchronous") : DbFrame.frame.res.getString("Synchronous");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("RepTabbedPane");
        String[] columnNames = new String[]{DbFrame.frame.res.getString("Database_Link"), DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Table_Name"), DbFrame.frame.res.getString("Columns"), DbFrame.frame.res.getString("Flush"), DbFrame.frame.res.getString("Clear")};
        this.model = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.table = new JTable(this.absModel);
        this.table.setName("RepSubscribersTable");
        this.Add_Button.setName("AddButton");
        this.Drop_Button.setName("DropButton");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "replication.info");
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel Replication_Type = new JLabel();
        jPanel1.setLayout(new BorderLayout(5, 5));
        jPanel2.setLayout((LayoutManager)new VerticalFlowLayout());
        jLabel1.setText(DbFrame.frame.res.getString("Base_table_"));
        jLabel2.setText(DbFrame.frame.res.getString("Project_columns_"));
        Replication_Type.setText(this.type + DbFrame.frame.res.getString("Replication_"));
        this.Replication_Name.setEnabled(false);
        this.Replication_Name.setEditable(false);
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        jScrollPane1.setPreferredSize(new Dimension(454, 20));
        this.Base_Table.setEnabled(false);
        this.Project_Column.setEnabled(false);
        this.add((Component)jPanel1, DbFrame.frame.res.getString("Replication"));
        jPanel1.add((Component)jScrollPane1, "Center");
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.add((Component)jPanel5, null);
        jPanel5.setName("RepButtonPanel");
        jPanel5.add((Component)this.Add_Button, null);
        jPanel5.add((Component)this.Drop_Button, null);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        jPanel4.add((Component)Replication_Type, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 10;
        gbc.weightx = 1.0;
        jPanel4.add((Component)this.Replication_Name, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        jPanel4.add((Component)jLabel1, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 10;
        jPanel4.add((Component)this.Base_Table, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        jPanel4.add((Component)jLabel2, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 10;
        jPanel4.add((Component)this.Project_Column, gbc);
        JPanel jPanel40 = new JPanel(new BorderLayout());
        jPanel40.add((Component)jPanel4, "West");
        jPanel2.add((Component)jPanel40, null);
        this.Replication_Name.setText(this.repl_name);
        this.Base_Table.setText(GuiUt.rightTrim(this.table_owner) + "." + GuiUt.rightTrim(this.table_name));
        this.Project_Column.setText(this.project_column);
        jScrollPane1.getViewport().add((Component)this.table, null);
        this.initColumnSizes();
        this.getReplicationInfo();
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
        this.table.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
        this.table.setAutoResizeMode(4);
    }

    @Override
    public int getComponentType() {
        return 20;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Add_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Drop_Button.setEnabled(enabled);
    }

    public void table_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            this.authority.authorise();
        }
    }

    private void initColumnSizes() {
        TableColumn column = null;
        Object renderer = null;
        int[] sizes = new int[]{100, 100, 100, 160, 60, 60};
        for (int i = 0; i < sizes.length; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(sizes[i]);
        }
    }

    private void getReplicationInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select DB_LINK, TABLE_OWNER, TABLE_NAME, PROJECT, FLUSH, CLEAR from SYSTEM.SYSSUBSCRIBE where BASE_TABLE_OWNER = '" + this.table_owner + "' " + "and BASE_TABLE_NAME = '" + this.table_name + "' " + "and REPLICATION_NAME = '" + this.repl_name + "' " + "order by REPLICATION_NAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String proj = rs.getString(4);
                String newStr = "";
                if (proj != null && proj.length() > 0) {
                    int len = proj.length();
                    int i = 0;
                    while (i < len) {
                        String sub = proj.substring(i, 128 + i).trim();
                        String mark = "";
                        mark = (i += 128) == len / 128 * 128 ? "" : ", ";
                        newStr = newStr + sub + mark;
                    }
                }
                this.model.addValue(new DBARowInfo(this.getRowInfo(rs.getString(1), rs.getString(2), rs.getString(3), newStr, rs.getString(5), rs.getString(6))));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private Object[] getRowInfo(String db_link, String tb_owner, String tb_name, String columns, String flush, String clear) {
        Object[] data = new Object[6];
        data[this.DB_LINK] = GuiUt.rightTrim(db_link);
        data[this.TABLE_OWNER] = GuiUt.rightTrim(tb_owner);
        data[this.TABLE_NAME] = GuiUt.rightTrim(tb_name);
        String str = columns.trim();
        String resultStr = "";
        while (true) {
            int index = str.lastIndexOf(0);
            resultStr = resultStr.length() == 0 ? str.substring(index + 1) : str.substring(index + 1) + "," + resultStr;
            if (index < 0) break;
            str = str.substring(0, index).trim();
        }
        data[this.COLUMNS] = resultStr;
        data[this.FLUSH] = flush;
        data[this.CLEAR] = clear;
        return data;
    }

    public void Add_Button_actionPerformed(ActionEvent e) {
        boolean result = false;
        if (this.type.equals(DbFrame.frame.res.getString("Asynchronous"))) {
            Vector v = new Vector();
            Wizard_asyncdest dlg = new Wizard_asyncdest((Frame)DbFrame.frame, this.table_owner, this.table_name, v);
            GuiUt.setCenterLocation(DbFrame.frame, dlg);
            dlg.show();
            if (v.size() == 0) {
                return;
            }
            ASyncRowInfo data = (ASyncRowInfo)v.elementAt(0);
            String query = "ALTER REPLICATION " + this.repl_name + " ON \"" + this.table_owner + "\".\"" + this.table_name + "\" " + "ADD REPLICATE TO " + data.toSQLString();
            result = DatabaseConnection.executeSQL(query);
        } else {
            Vector v = new Vector();
            Wizard_syncdest dlg = new Wizard_syncdest((Frame)DbFrame.frame, this.table_owner, this.table_name, v);
            GuiUt.setCenterLocation(DbFrame.frame, dlg);
            dlg.show();
            if (v.size() == 0) {
                return;
            }
            SyncRowInfo data = (SyncRowInfo)v.elementAt(0);
            String query = "ALTER REPLICATION " + this.repl_name + " ON \"" + this.table_owner + "\".\"" + this.table_name + "\" " + "ADD REPLICATE TO " + data.toSQLString();
            result = DatabaseConnection.executeSQL(query);
        }
        if (result) {
            this.getReplicationInfo();
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        }
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        String dblink = (String)this.model.getValueAt(row, this.DB_LINK);
        String tbowner = (String)this.model.getValueAt(row, this.TABLE_OWNER);
        String tbname = (String)this.model.getValueAt(row, this.TABLE_NAME);
        String str1 = DbFrame.frame.res.getString("Do_you_want_to_drop_replication_to");
        String str2 = GuiUt.mapStringForProperty(str1, dblink);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, DbFrame.frame.res.getString("Drop_Replication"), str2 + " ?");
        if (reply != 0) {
            return;
        }
        String query = "ALTER REPLICATION " + this.repl_name + " ON \"" + this.table_owner + "\".\"" + this.table_name + "\" " + "DROP REPLICATE TO " + dblink + ":\"" + tbowner + "\".\"" + tbname + "\"";
        boolean result = DatabaseConnection.executeSQL(query);
        if (result) {
            this.getReplicationInfo();
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            if (row >= this.table.getRowCount()) {
                this.table.clearSelection();
            }
        }
    }
}

