/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Qbe;

import dbatool.DbFrame;
import dbatool.Qbe.PkFkInfo;
import dbatool.Qbe.treetable.AbstractDmMutableTreeNode;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.resource.DBAImageResource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ImageIcon;

public class TableInfo
extends AbstractDmMutableTreeNode {
    private String tableName = null;
    private String schemaName = null;
    private String tableAliasName = null;
    private Vector columnsVector = new Vector();
    private boolean isView = false;
    private static ImageIcon icon = null;
    private static String[] imagefilename = new String[]{"/jdbaimages/qbe/table.gif", "/jdbaimages/qbe/view.gif"};
    private short table_type = 0;
    private boolean isExpand = false;
    private int aliasCount = 0;
    Vector fkInfos = new Vector();

    public TableInfo(String schemaName, String tableName, String tableAliasName, boolean isView) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.tableAliasName = tableAliasName == null ? tableName : tableAliasName;
        this.isView = isView;
        this.table_type = isView ? (short)1 : 0;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableAliasName() {
        return this.tableAliasName;
    }

    public Vector getColumnsVector() {
        return this.columnsVector;
    }

    @Override
    public String toString() {
        if (!this.isView) {
            return "(TABLE)" + this.schemaName + "." + this.tableAliasName;
        }
        return "(VIEW)" + this.schemaName + "." + this.tableAliasName;
    }

    public boolean isHaveTableAliasName() {
        return !this.tableName.equalsIgnoreCase(this.tableAliasName);
    }

    public void setTableAliasName(int aliasCount) {
        this.tableAliasName = this.tableName + "_" + Integer.toString(aliasCount);
    }

    public void setTableAliasName(String aliasName) {
        this.tableAliasName = aliasName;
    }

    public boolean isView() {
        return this.isView;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), imagefilename[this.table_type]);
        }
        return icon;
    }

    @Override
    public String getText() {
        return this.toString();
    }

    public boolean isExpand() {
        return this.isExpand;
    }

    public void setExpand(boolean b) {
        this.isExpand = b;
    }

    public void setAliasCount(int count) {
        this.aliasCount = count;
    }

    public boolean isEqualLoginName() {
        return this.schemaName.equals(DbFrame.frame.px.getLoginIdName());
    }

    public int getAliasCount() {
        return this.aliasCount;
    }

    public void getBeDependedOn() {
        Statement stmt = null;
        ResultSet rs = null;
        String queryStr = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            queryStr = "select FK_NAME, FK_TBL_OWNER, FK_TBL_NAME, FK_COL_ORDER, PK_TBL_OWNER, PK_TBL_NAME, PK_COL_ORDER from SYSTEM.SYSFOREIGNKEY where PK_TBL_OWNER = '" + GuiUt.singleQuoteHandle(this.getSchemaName()) + "' and PK_TBL_NAME = '" + GuiUt.singleQuoteHandle(this.getTableName()) + "'order by FK_TBL_OWNER, FK_TBL_NAME ";
            rs = stmt.executeQuery(queryStr);
            byte[] fk_col_order_bytes = null;
            byte[] pk_col_order_bytes = null;
            String fk_name = "";
            String fk_tbl_owner = "";
            String fk_tbl_name = "";
            String pk_tbl_owner = "";
            String pk_tbl_name = "";
            while (rs.next()) {
                fk_name = rs.getString(1).trim();
                fk_tbl_owner = rs.getString(2).trim();
                fk_tbl_name = rs.getString(3).trim();
                pk_tbl_owner = rs.getString(5).trim();
                pk_tbl_name = rs.getString(6).trim();
                fk_col_order_bytes = rs.getBytes(4);
                pk_col_order_bytes = rs.getBytes(7);
                PkFkInfo pkFkInfo = new PkFkInfo(fk_name, fk_tbl_owner, fk_tbl_name, fk_col_order_bytes, pk_tbl_owner, pk_tbl_name, pk_col_order_bytes);
                this.fkInfos.add(pkFkInfo);
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }
}

