/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Qbe;

import com.borland.jbcl.layout.VerticalFlowLayout;
import dbatool.DbFrame;
import dbatool.Table.DataTableModel;
import dbatool.Table.SchemaTableModel;
import dbatool.Table.SchemaType;
import dbatool.tableCell.BlobCellObject;
import dbatool.tableCell.BlobEditor;
import dbatool.tableCell.BlobEditorButton;
import dbatool.tableCell.BlobEditorButtonInterface;
import dbatool.tableCell.BlobEditorNoJAIButton;
import dbatool.tableCell.OidEditor;
import dbatool.tableCell.OidRenderer;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.DbaTable;
import dbaut.comp.ReflectionAction;
import dbaut.comp.TableColumnSelectionListener;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.DecimalField;
import dbaut.util.JdbcUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PreviewQbeResultPanel
extends DbaPanel {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private DataTableModel dataModel = null;
    private DBAToolAbstractTableModel absDataModel = null;
    private DbaTable Table_Data = null;
    private JLabel infoLabel = new JLabel();
    private DbaTableModel schemaModel = null;
    private int data_start = 0;
    private int data_end = 0;
    private int next_data_start = 0;
    private int data_max = 0;
    private int data_offset = 0;
    private int data_counter = 0;
    private int previous_row = -1;
    private int current_row = -1;
    private DbaButton Data_Down_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Page_Down"), 'W', DBAImageResource.getResource(this.getClass(), "/jdbaimages/pagedown.gif"), new ReflectionAction(this, "Data_Down_Button_actionPerformed"));
    private DbaButton Data_Up_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Page_Up"), 'U', DBAImageResource.getResource(this.getClass(), "/jdbaimages/pageup.gif"), new ReflectionAction(this, "Data_Up_Button_actionPerformed"));
    private DbaButton Data_First_Button = new DbaButton(new Dimension(100, 24), this.res.getString("First"), 'F', DBAImageResource.getResource(this.getClass(), "/jdbaimages/datafirst.gif"), new ReflectionAction(this, "Data_First_Button_actionPerformed"));
    private DbaButton Data_Last_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Last"), 'L', DBAImageResource.getResource(this.getClass(), "/jdbaimages/datalast.gif"), new ReflectionAction(this, "Data_Last_Button_actionPerformed"));
    private static final int BLOB = 0;
    private static final int STRING = 1;
    private static final int BOOLEAN = 2;
    private static final int INTEGER = 3;
    private static final int REAL = 4;
    private static final int DOUBLE = 5;
    private static final int SHORT = 6;
    private static final int DATE = 7;
    private static final int TIME = 8;
    private static final int TIMESTAMP = 9;
    public ResultSet viewRS = null;
    private int[] button_info = new int[]{this.data_start, this.data_end, this.data_max, this.data_offset, this.data_counter};
    private boolean[] button_status = new boolean[]{false, this.data_max > this.data_offset, false, this.data_max > this.data_offset};
    private static final int PAGEUP = 0;
    private static final int PAGEDOWN = 1;
    private static final int PAGEFIRST = 2;
    private static final int PAGELAST = 3;
    String qbeStr = null;
    Component comp = null;
    private Statement stmt = null;

    public PreviewQbeResultPanel(String helpid2, String inStr, DbaTableModel schemaModel, Component comp) {
        super(DbFrame.helpres, helpid2);
        this.qbeStr = inStr;
        this.schemaModel = schemaModel;
        this.comp = comp;
        this.initPanel();
    }

    public void initPanel() {
        this.setName("PreviewQBEResultPanel");
        if (this.getComponentCount() > 0) {
            return;
        }
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        JPanel jPanel1 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.infoLabel.setText("");
        jPanel1.add((Component)jPanel7, null);
        jPanel7.add((Component)this.Data_Up_Button, null);
        jPanel7.add((Component)this.Data_Down_Button, null);
        jPanel7.add((Component)this.Data_First_Button, null);
        jPanel7.add((Component)this.Data_Last_Button, null);
        jPanel1.add((Component)jPanel2, null);
        jPanel2.add((Component)this.infoLabel, "Center");
        this.dataModel = new DataTableModel(this.schemaModel, null, null);
        this.absDataModel = new DBAToolAbstractTableModel(this.dataModel);
        this.Table_Data = new DbaTable(this.absDataModel);
        this.Table_Data.setName("ResultTable");
        this.dataModel.setTable(this.Table_Data);
        this.absDataModel.setTable(this.Table_Data, true);
        this.Table_Data.getTableHeader().setReorderingAllowed(false);
        this.Table_Data.setSelectionMode(0);
        this.Table_Data.setAutoResizeMode(0);
        this.Table_Data.addColumnSelectionListener(new TableColumnSelectionListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PreviewQbeResultPanel.this.TableColumnSelectionChanged(e);
                }
            }
        });
        this.Table_Data.addRowSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Component c = PreviewQbeResultPanel.this.Table_Data.getEditorComponent();
                if (e == null || !e.getValueIsAdjusting() || c != null && c instanceof BlobEditorButton) {
                    PreviewQbeResultPanel.this.TableRowSelectionChanged(e);
                }
            }
        });
        this.setUpCellEditor(this.Table_Data);
        this.getTableData();
        this.setEditable(false);
        this.absDataModel.addMouseListenerToHeaderInTable(this.Table_Data);
        JScrollPane jScrollPane9 = new JScrollPane(this.Table_Data);
        jScrollPane9.setPreferredSize(new Dimension(200, 200));
        jPanel4.add((Component)jScrollPane9, "Center");
        TableColumnModel tcm = this.Table_Data.getColumnModel();
        TableColumn firstcolumn = tcm.getColumn(0);
        firstcolumn.setPreferredWidth(0);
        firstcolumn.setResizable(false);
        firstcolumn.setCellEditor(new OidEditor(this.Table_Data));
        firstcolumn.setCellRenderer(new OidRenderer());
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel4, "Center");
        this.add((Component)jPanel1, "North");
    }

    private void setEditable(boolean editable) {
        if (editable) {
            this.Data_Down_Button.setEnabled(false);
            this.Data_Up_Button.setEnabled(false);
        }
    }

    public void Data_First_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.ButtonAction(2);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void Data_Last_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.ButtonAction(3);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void Data_Down_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.ButtonAction(1);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void Data_Up_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.ButtonAction(0);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    private void setUpBlobEditor(JTable table, int index) {
        Class<?> jaicls = null;
        try {
            jaicls = Class.forName("javax.media.jai.widget.ScrollingImagePanel");
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe.getMessage());
        }
        JButton field = jaicls == null ? new BlobEditorNoJAIButton() : new BlobEditorButton();
        BlobEditor editor = new BlobEditor((BlobEditorButtonInterface)((Object)field), table, this.dataModel);
        TableColumn column = table.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
    }

    private void setUpCellEditor(JTable table) {
        int col_count = table.getColumnCount();
        String type = null;
        String precision = null;
        String scale = null;
        for (int i = 1; i < col_count; ++i) {
            type = (String)this.schemaModel.getValueAt(i - 1, SchemaTableModel.TYPE);
            if (type.equals("integer") || type.equals("serial")) {
                this.Table_Data.setUpIntegerEditorStr(i);
                continue;
            }
            if (type.equals("bigint")) {
                this.Table_Data.setUpBigIntEditor(i);
                continue;
            }
            if (type.equals("bigserial")) {
                this.Table_Data.setUpBigSerialEditor(i);
                continue;
            }
            if (type.equals("smallint")) {
                this.Table_Data.setUpShortEditor(i);
                continue;
            }
            if (type.equals("double")) {
                this.Table_Data.setUpDoubleEditor(i);
                continue;
            }
            if (type.equals("decimal")) {
                precision = (String)this.schemaModel.getValueAt(i - 1, SchemaTableModel.SIZE);
                scale = (String)this.schemaModel.getValueAt(i - 1, SchemaTableModel.SCALE);
                this.Table_Data.setUpDecimalEditorStr(i, new DecimalField(Integer.parseInt(precision), Integer.parseInt(scale)));
                continue;
            }
            if (type.equals("real")) {
                this.Table_Data.setUpFloatEditor(i);
                continue;
            }
            if (type.equals("binary") || type.equals("oid")) {
                this.Table_Data.setUpBinaryEditor(i);
                continue;
            }
            if (type.equals("char") || type.equals("varchar") || type.equals("nchar") || type.equals("nvarchar")) {
                this.Table_Data.setUpCharEditor(i);
                continue;
            }
            if (!SchemaType.isBlobType(type)) continue;
            this.setUpBlobEditor(table, i);
        }
    }

    private void setData(ResultSet rs) {
        int count = this.absDataModel.getColumnCount();
        this.dataModel.removeAll();
        ArrayList<Object> one_row = null;
        BlobCellObject obj = null;
        String temp = null;
        String type = null;
        String oid = "VIEW";
        boolean k = false;
        long length = -1L;
        Object c = null;
        Blob b = null;
        this.dataModel.removeAll();
        for (int i = this.data_start; i < this.data_end; ++i) {
            one_row = new ArrayList<Object>(count);
            try {
                rs.absolute(i + 1);
                one_row.add(oid);
                for (int j = 1; j < count; ++j) {
                    type = (String)this.schemaModel.getValueAt(j - 1, SchemaTableModel.TYPE);
                    if (SchemaType.isBlobType(type)) {
                        if (type.equalsIgnoreCase("long varchar") || type.equalsIgnoreCase("clob") || type.equalsIgnoreCase("longvarchar")) {
                            b = rs.getBlob(j);
                            length = !rs.wasNull() ? b.length() : -1L;
                            obj = new BlobCellObject(this.comp, rs, i + 1, j, this.absDataModel.getColumnName(j), type, length, rs.wasNull());
                        } else if (type.equalsIgnoreCase("nclob")) {
                            b = rs.getBlob(j);
                            long tmpLength = b.length();
                            obj = new BlobCellObject(this.comp, rs, i + 1, j, this.absDataModel.getColumnName(j), type, tmpLength, rs.wasNull());
                        } else {
                            b = rs.getBlob(j);
                            length = rs.wasNull() ? -1L : (b != null ? b.length() : -1L);
                            obj = new BlobCellObject(this.comp, rs, i + 1, j, this.absDataModel.getColumnName(j), type, length, rs.wasNull());
                        }
                        one_row.add(obj);
                        JdbcUtil.free(b);
                        continue;
                    }
                    if (type.equals("binary")) {
                        temp = rs.getString(j);
                        one_row.add(rs.wasNull() ? "" : temp.toString());
                        continue;
                    }
                    if (type.equals("oid")) {
                        temp = rs.getString(j);
                        one_row.add(rs.wasNull() ? "" : temp.toString());
                        continue;
                    }
                    if (type.equals("char") || type.equals("varchar") || type.equals("nchar") || type.equals("nvarchar") || type.equals("integer") || type.equals("smallint") || type.equals("bigint")) {
                        temp = rs.getString(j);
                        one_row.add(rs.wasNull() ? "" : temp.toString());
                        continue;
                    }
                    temp = rs.getString(j);
                    one_row.add(rs.wasNull() ? "" : temp);
                }
                this.dataModel.addValue(one_row);
                continue;
            }
            catch (SQLException sqle) {
                GuiUt.showErrorDlg(DbFrame.frame, sqle.getMessage(), null);
                DbaObject.close(rs);
            }
        }
        String s = GuiUt.mapStringForProperty(this.res.getString("records_selected"), Integer.toString(this.dataModel.getRowCount()));
        if (this.dataModel.getRowCount() > 0) {
            s = s + " (" + (this.data_start + 1) + " - " + this.data_end + ")";
        }
        this.infoLabel.setText(s);
        DbFrame.frame.setStatusDisc(s);
        this.absDataModel.fireTableChanged(new TableModelEvent(this.absDataModel));
        if (this.dataModel.getRowCount() > 0) {
            this.Table_Data.setSelectedRow(0);
        }
    }

    private void getTableData() {
        this.data_counter = 0;
        this.data_offset = 0;
        this.data_max = 0;
        this.data_end = 0;
        this.data_start = 0;
        this.dataModel.removeAll();
        ResultSet rs = null;
        try {
            this.stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement(1004, 1007);
            int counts = 0;
            rs = this.stmt.executeQuery(this.qbeStr);
            while (rs.next()) {
                ++counts;
            }
            this.data_max = counts;
            DbaObject.close(rs);
            this.viewRS = this.stmt.executeQuery(this.qbeStr);
            this.viewRS.absolute(0);
            this.data_offset = DbFrame.frame.px.getNumRecord();
            this.data_end = this.data_max < this.data_offset ? this.data_max : this.data_offset;
            if (this.data_max == 0) {
                this.button_status[0] = false;
                this.button_status[1] = this.data_max > this.data_offset;
                this.button_status[2] = false;
                this.button_status[3] = this.data_max > this.data_offset;
                this.setButtonStatus(this.button_status);
                return;
            }
            this.setData(this.viewRS);
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            DbaObject.close(rs);
            DbaObject.close(this.viewRS);
            DbaObject.close(this.stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DbaObject.close(rs);
            DbaObject.close(this.viewRS);
            DbaObject.close(this.stmt);
            GuiUt.showErrorDlg(DbFrame.frame, ex.getClass().toString() + ":" + ex.getMessage(), null);
        }
        if (this.dataModel.getRowCount() > 0) {
            this.Table_Data.setSelectedRow(0);
        }
        this.button_info[0] = this.data_start;
        this.button_info[1] = this.data_end;
        this.button_info[2] = this.data_max;
        this.button_info[3] = this.data_offset;
        this.button_info[4] = this.data_counter;
        this.button_status[0] = false;
        this.button_status[1] = this.data_max > this.data_offset;
        this.button_status[2] = false;
        this.button_status[3] = this.data_max > this.data_offset;
        this.setButtonStatus(this.button_status);
    }

    public void closeResultSet() {
        System.out.println("close view resultset...");
        DbaObject.close(this.viewRS);
        DbaObject.close(this.stmt);
    }

    private void setButtonStatus(boolean[] status) {
        this.Data_Up_Button.setEnabled(status[0]);
        this.Data_Down_Button.setEnabled(status[1]);
        this.Data_First_Button.setEnabled(status[2]);
        this.Data_Last_Button.setEnabled(status[3]);
    }

    private void ButtonAction(int action) {
        int start = this.button_info[0];
        int end = this.button_info[1];
        int max = this.button_info[2];
        int offset = this.button_info[3];
        int tmp = 0;
        switch (action) {
            case 0: {
                this.data_counter -= this.data_offset;
                this.data_start -= this.data_offset;
                if (this.data_start < 0) {
                    return;
                }
                tmp = this.data_end % this.data_offset;
                if (tmp == 0) {
                    this.data_end -= this.data_offset;
                    break;
                }
                this.data_end -= tmp;
                break;
            }
            case 1: {
                this.data_counter += this.data_offset;
                this.data_start = this.data_end;
                if (this.data_start >= this.data_max) {
                    return;
                }
                this.data_end += this.data_offset;
                if (this.data_end <= this.data_max) break;
                this.data_end = this.data_max;
                break;
            }
            case 2: {
                this.data_start = 0;
                this.data_counter = 0;
                this.data_end = this.data_offset;
                break;
            }
            case 3: {
                tmp = this.data_max % this.data_offset;
                this.data_start = tmp == 0 ? this.data_max - this.data_offset : this.data_max - tmp;
                this.data_end = this.data_max;
                this.data_counter = this.data_start;
            }
        }
        this.setData(this.viewRS);
        this.button_info[0] = this.data_start;
        this.button_info[1] = this.data_end;
        this.button_info[2] = this.data_max;
        this.button_info[3] = this.data_offset;
        this.button_info[4] = this.data_counter;
        this.button_status[2] = this.data_start != 0;
        this.button_status[0] = this.button_status[2];
        this.button_status[3] = this.data_end != this.data_max;
        this.button_status[1] = this.button_status[3];
        this.setButtonStatus(this.button_status);
    }

    private void TableRowSelectionChanged(ListSelectionEvent e) {
        int row = this.Table_Data.getSelectedRow();
        if (this.current_row == row && e != null) {
            return;
        }
        this.current_row = row;
        int col = this.Table_Data.getSelectedColumn();
        if (row < 0 || col < 0) {
            return;
        }
        if (row >= this.dataModel.getRowCount() || col >= this.dataModel.getColumnCount()) {
            return;
        }
        if (this.previous_row == row) {
            return;
        }
        if (e != null && (this.previous_row < 0 || this.previous_row == row) || this.dataModel.withNewData(this.previous_row)) {
            // empty if block
        }
        if (row == this.dataModel.getRowCount() - 1 && this.dataModel.withNewData(row)) {
            this.dataModel.addEmptyRow();
            this.absDataModel.fireTableChanged(new TableModelEvent(this.absDataModel));
        }
        this.previous_row = row;
        this.Table_Data.editCellAt(row, col);
    }

    private void TableColumnSelectionChanged(ListSelectionEvent e) {
        int col = this.Table_Data.getSelectedColumn();
        int row = this.Table_Data.getSelectedRow();
        if (col < 0 || col >= this.Table_Data.getColumnCount()) {
            return;
        }
        if (row < 0 || row >= this.Table_Data.getRowCount()) {
            return;
        }
        this.Table_Data.editCellAt(row, col);
    }
}

