/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Monitor;

import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class SysConfigInfo
extends DbaTabbedPane {
    private static final long serialVersionUID = 5751477888177692218L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.MonitorRes", LocaleManager.getLocale());
    private JCheckBox autoRefreshCheckBox = new JCheckBox();
    private DbaTableModel model1 = null;
    private JTable table1 = null;
    private Timer timer = null;

    public SysConfigInfo() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("SysConfigTabbedPane");
        this.autoRefreshCheckBox.setName("AutoRefreshCheckbox");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "sysconfig.info");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        DbaButton refreshButton = new DbaButton(new Dimension(120, 24), this.res.getString("Refresh"), 'R', DBAImageResource.getResource(this.getClass(), "/jdbaimages/refresh.gif"), new ReflectionAction(this, "refreshButtonActionPerformed"));
        refreshButton.setName("RefreshButton");
        JPanel refreshPanel = new JPanel();
        refreshPanel.setName("SysConfigButtonPanel");
        refreshPanel.add(refreshButton);
        if (DbFrame.frame.px.getAutoRefresh()) {
            this.autoRefreshCheckBox.setSelected(true);
        } else {
            this.autoRefreshCheckBox.setSelected(false);
        }
        this.autoRefreshCheckBox.setText(this.res.getString("Auto_Refresh"));
        this.autoRefreshCheckBox.addActionListener(new ReflectionAction(this, "autoRefreshCheckBoxActionPerformed"));
        JPanel autoRefreshPanel = new JPanel();
        autoRefreshPanel.setName("SysConfigCheckboxPanel");
        autoRefreshPanel.add(this.autoRefreshCheckBox);
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)refreshPanel, "West");
        buttonPanel.add((Component)autoRefreshPanel, "East");
        JScrollPane jScrollPane1 = new JScrollPane();
        String[] columnNames = new String[]{this.res.getString("KeyWord"), this.res.getString("Value")};
        this.model1 = new DbaTableModel(columnNames);
        this.table1 = new JTable(this.model1);
        this.table1.setName("SysConfigTable");
        this.getSysConfigInfo();
        this.setPreferredColumnWidth(this.table1);
        jScrollPane1.getViewport().add((Component)this.table1, null);
        jPanel1.setLayout(new BorderLayout());
        jPanel1.add((Component)jScrollPane1, "Center");
        jPanel1.add((Component)buttonPanel, "North");
        this.add((Component)jPanel1, this.res.getTitle("System_Configuration"));
        this.timer = new Timer(DbFrame.frame.px.getAutoRefreshTime() * 1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SysConfigInfo.this.model1.removeAll();
                SysConfigInfo.this.getSysConfigInfo();
                SysConfigInfo.this.model1.fireTableChanged(new TableModelEvent(SysConfigInfo.this.model1));
            }
        });
        this.autoRefreshCheckBoxActionPerformed(null);
    }

    private void setPreferredColumnWidth(JTable table) {
        TableColumn keyWord = table.getColumnModel().getColumn(0);
        keyWord.setMinWidth(120);
        keyWord.setMaxWidth(120);
    }

    private synchronized void getSysConfigInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            DatabaseConnection dcon = DbFrame.conn_DatabaseConnection;
            if (dcon == null) {
                return;
            }
            Connection con = dcon.getDbConnection();
            if (con == null) {
                return;
            }
            stmt = con.createStatement();
            String query = "select KEYWORD, VALUE from SYSTEM.SYSCONFIG order by KEYWORD";
            rs = stmt.executeQuery(query);
            Object[] entry = null;
            while (rs.next()) {
                entry = new Object[]{rs.getString(1).trim(), rs.getString(2).trim()};
                this.model1.addValue(new DBARowInfo(entry));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            this.model1.fireTableDataChanged();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public void refreshButtonActionPerformed(ActionEvent e) {
        this.model1.removeAll();
        this.getSysConfigInfo();
    }

    public void autoRefreshCheckBoxActionPerformed(ActionEvent e) {
        if (this.autoRefreshCheckBox.isSelected()) {
            DbFrame.frame.px.updateVariables(3, "true");
            this.timer.start();
        } else {
            DbFrame.frame.px.updateVariables(3, "false");
            this.timer.stop();
        }
    }
}

