/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Monitor;

import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.Monitor.LockInfo;
import dbatool.Monitor.ResizableBorder;
import dbatool.Monitor.SessionInfo;
import dbatool.Monitor.SessionTableModel;
import dbaut.GuiUt;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class Resizable
extends JComponent
implements MouseListener,
MouseMotionListener {
    public static final int MIDDLE = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    private static final Color waitOval = new Color(Integer.decode("#C8DDF2"));
    private static final Color holdOval = new Color(Integer.decode("#FFFAB3"));
    private ResizableBorder border;
    private ArrayList<Resizable> rect;
    private DBAResourceBundle res = null;
    private ArrayList<Vector> waitset = null;
    private ArrayList<Vector> holdset = null;
    private String connid = null;
    private JPopupMenu popup = null;
    private JPopupMenu sqlcmdpop = new JPopupMenu();
    private JLabel sqlcmdLabel;
    private JMenuItem killConnectionItem = null;
    private Object lkpanel;
    private int rectlocation;
    private int cursor;
    private Point startPos = null;
    private int w = 0;
    private int h = 0;

    public int getRectlocation() {
        return this.rectlocation;
    }

    public void setRectlocation(int rectlocation) {
        this.rectlocation = rectlocation;
    }

    public Resizable(Component comp, ArrayList<Resizable> rect, DBAResourceBundle res, int rectlocation, ArrayList<Vector> waitSet, ArrayList<Vector> holdSet, String cid, Object obj) {
        this.rect = rect;
        this.res = res;
        this.rectlocation = rectlocation;
        this.waitset = waitSet;
        this.holdset = holdSet;
        this.connid = cid;
        this.lkpanel = obj;
        this.border = new ResizableBorder(8, rectlocation);
        this.setLayout(new BorderLayout());
        if (rectlocation == 1) {
            JPanel jp = (JPanel)comp;
            this.add(jp);
            for (Component c : jp.getComponents()) {
                c.addMouseListener(this);
                c.addMouseMotionListener(this);
            }
        } else {
            this.popupLabel();
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBorder(this.border);
    }

    private void popupLabel() {
        this.sqlcmdLabel = new JLabel(""){

            @Override
            public Insets getInsets(Insets insets) {
                return new Insets(10, 10, 10, 10);
            }
        };
        this.sqlcmdpop.add(this.sqlcmdLabel);
        for (int i = 0; i < this.holdset.size(); ++i) {
            final String connectionid = (String)this.holdset.get(i).get(2);
            for (int j = 0; j < this.waitset.size(); ++j) {
                String cidwait = (String)this.waitset.get(j).get(2);
                if (!cidwait.equalsIgnoreCase(this.connid)) continue;
                return;
            }
            if (!connectionid.equalsIgnoreCase(this.connid)) continue;
            this.killConnectionItem = new JMenuItem(this.res.getString("kill_conntion"));
            this.popup = new JPopupMenu();
            this.popup.setBorder(BorderFactory.createLineBorder(new Color(Integer.decode("#6382BF")), 1));
            this.killConnectionItem.setBackground(new Color(Integer.decode("#B8CFE5")));
            this.popup.add(this.killConnectionItem);
            this.killConnectionItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Statement stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
                        ResultSet rs = stmt.executeQuery("select * from syslock where LK_STATUS='CONVERT' or LK_STATUS='WAITING'");
                        if (!rs.next()) {
                            int result = GuiUt.showWarningDlg(DbFrame.frame, Resizable.this.res.getString("kill_conntion"), Resizable.this.res.getString("lock_release"));
                            if (Resizable.this.lkpanel instanceof SessionInfo) {
                                ((SessionInfo)Resizable.this.lkpanel).Refresh_Button_actionPerformed(null);
                            } else if (Resizable.this.lkpanel instanceof LockInfo) {
                                ((LockInfo)Resizable.this.lkpanel).Refresh_Button_actionPerformed(null);
                            }
                            return;
                        }
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    int result = GuiUt.showOptionDlg(DbFrame.frame, Resizable.this.res.getString("kill_conntion"), Resizable.this.res.getString("kill_conntion") + ": " + connectionid);
                    if (result == 0) {
                        boolean b = DatabaseConnection.executeSQL("kill connection " + connectionid);
                        if (Resizable.this.lkpanel instanceof SessionInfo) {
                            ((SessionInfo)Resizable.this.lkpanel).Refresh_Button_actionPerformed(null);
                        } else if (Resizable.this.lkpanel instanceof LockInfo) {
                            ((LockInfo)Resizable.this.lkpanel).Refresh_Button_actionPerformed(null);
                        }
                    }
                }
            });
        }
    }

    private void resize() {
        if (this.getParent() != null) {
            ((JComponent)this.getParent()).revalidate();
        }
        this.repaint();
    }

    public void MousePress() {
        for (int i = 0; i < this.rect.size(); ++i) {
            Resizable r = this.rect.get(i);
            if (!r.equals(this)) continue;
            this.rect.remove(r);
        }
        this.rect.add(this);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        int i;
        super.paint(g);
        if (this.rectlocation != 3) {
            return;
        }
        Color col = null;
        boolean iswait = false;
        boolean ishold = false;
        for (i = 0; i < this.waitset.size(); ++i) {
            if (!this.waitset.get(i).get(2).equals(this.connid)) continue;
            col = waitOval;
            iswait = true;
            break;
        }
        for (i = 0; i < this.holdset.size(); ++i) {
            if (!this.holdset.get(i).get(2).equals(this.connid)) continue;
            col = holdOval;
            ishold = true;
            break;
        }
        if (iswait && ishold) {
            col = waitOval;
        }
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setColor(col);
        g2D.fillOval(7, 7, 83, 83);
        g2D.setColor(Color.BLACK);
        g2D.drawOval(7, 7, 83, 83);
        g2D.drawString("Connection Id", 10, 47);
        g2D.drawString(this.connid, 32, 60);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.sqlcmdpop.setVisible(false);
        if (this.hasFocus()) {
            ResizableBorder border = (ResizableBorder)this.getBorder();
            this.setCursor(Cursor.getPredefinedCursor(border.getCursor(me)));
        }
        Rectangle re = this.getBounds();
        Point p = new Point(me.getX() + (int)re.getX(), me.getY() + (int)re.getY());
        String msg = "";
        if (this.rectlocation == 3 && re.contains(p)) {
            int i;
            for (i = 0; i < this.holdset.size(); ++i) {
                if (!this.connid.equalsIgnoreCase((String)this.holdset.get(i).get(2))) continue;
                msg = this.res.getString("Login_IP") + ": " + (String)this.holdset.get(i).get(6) + "<br>" + this.res.getString("Login_Host") + ": " + this.holdset.get(i).get(7) + "<br>" + this.res.getString("Login_Time") + ": " + this.holdset.get(i).get(8) + "<br>" + this.res.getString("Current_SQL_Command") + ": " + this.holdset.get(i).get(9) + "<br>" + this.res.getString("Time_of_Current_SQL") + ": " + this.holdset.get(i).get(10);
                break;
            }
            for (i = 0; i < this.waitset.size(); ++i) {
                if (!this.connid.equalsIgnoreCase((String)this.waitset.get(i).get(2))) continue;
                msg = this.res.getString("Login_IP") + ": " + (String)this.waitset.get(i).get(6) + "<br>" + this.res.getString("Login_Host") + ": " + this.waitset.get(i).get(7) + "<br>" + this.res.getString("Login_Time") + ": " + this.waitset.get(i).get(8) + "<br>" + this.res.getString("Current_SQL_Command") + ": " + this.waitset.get(i).get(9) + "<br>" + this.res.getString("Time_of_Current_SQL") + ": " + this.waitset.get(i).get(10);
            }
            this.sqlcmdpop.setVisible(true);
            this.sqlcmdLabel.setText("<html><title></title><body>" + msg + "</body></html>");
            this.sqlcmdpop.show(me.getComponent(), me.getX() + 10, me.getY() + 10);
        } else {
            this.sqlcmdpop.hide();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.sqlcmdpop.setVisible(false);
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mousePressed(MouseEvent me) {
        ResizableBorder border = (ResizableBorder)this.getBorder();
        this.cursor = border.getCursor(me);
        this.startPos = me.getPoint();
        this.requestFocus();
        this.MousePress();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.requestFocus();
        if (this.startPos != null) {
            int x = this.getX();
            int y = this.getY();
            int w = this.getWidth();
            int h = this.getHeight();
            int dx = me.getX() - this.startPos.x;
            int dy = me.getY() - this.startPos.y;
            if (this.rectlocation == 1) {
                switch (this.cursor) {
                    case 8: {
                        if (h - dy < 50) break;
                        this.setBounds(x, y + dy, w, h - dy);
                        this.resize();
                        break;
                    }
                    case 9: {
                        if (h + dy < 50) break;
                        this.setBounds(x, y, w, h + dy);
                        this.startPos = me.getPoint();
                        this.resize();
                        break;
                    }
                    case 10: {
                        if (w - dx < 50) break;
                        this.setBounds(x + dx, y, w - dx, h);
                        this.resize();
                        break;
                    }
                    case 11: {
                        if (w + dx < 50) break;
                        this.setBounds(x, y, w + dx, h);
                        this.startPos = me.getPoint();
                        this.resize();
                        break;
                    }
                    case 6: {
                        if (w - dx < 50 || h - dy < 50) break;
                        this.setBounds(x + dx, y + dy, w - dx, h - dy);
                        this.resize();
                        break;
                    }
                    case 7: {
                        if (w + dx < 50 || h - dy < 50) break;
                        this.setBounds(x, y + dy, w + dx, h - dy);
                        this.startPos = new Point(me.getX(), this.startPos.y);
                        this.resize();
                        break;
                    }
                    case 4: {
                        if (w - dx < 50 || h + dy < 50) break;
                        this.setBounds(x + dx, y, w - dx, h + dy);
                        this.startPos = new Point(this.startPos.x, me.getY());
                        this.resize();
                        break;
                    }
                    case 5: {
                        if (w + dx < 50 || h + dy < 50) break;
                        this.setBounds(x, y, w + dx, h + dy);
                        this.startPos = me.getPoint();
                        this.resize();
                        break;
                    }
                    case 13: {
                        Rectangle bounds = this.getBounds();
                        bounds.translate(dx, dy);
                        this.setBounds(bounds);
                        this.resize();
                    }
                }
            } else {
                Rectangle bounds = this.getBounds();
                bounds.translate(dx, dy);
                this.setBounds(bounds);
                this.resize();
            }
            this.setCursor(Cursor.getPredefinedCursor(this.cursor));
        }
        int dw = this.getWidth() - this.w;
        int dh = this.getHeight() - this.h;
        if (this.getX() < 0 && this.getY() < 0) {
            this.w = this.getWidth() - dw;
            this.h = this.getHeight() - dh;
            this.setBounds(2, 10, this.w, this.h);
        } else if (this.getX() < 0) {
            this.w = this.getWidth() - dw;
            this.h = this.getHeight() - dh;
            this.setBounds(2, this.getY(), this.w, this.h);
        } else if (this.getY() < 0) {
            this.w = this.getWidth() - dw;
            this.h = this.getHeight() - dh;
            this.setBounds(this.getX(), 10, this.w, this.h);
        }
        this.w = this.getWidth();
        this.h = this.getHeight();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.startPos = null;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (this.lkpanel instanceof SessionInfo) {
            JTable tb = ((SessionInfo)this.lkpanel).getTable1();
            SessionTableModel sessionModel = ((SessionInfo)this.lkpanel).getModel1();
            for (int i = 0; i < sessionModel.getRowCount(); ++i) {
                String value = (String)sessionModel.getValueAt(i, 0);
                if (!value.equals(this.getName())) continue;
                tb.setRowSelectionInterval(i, i);
            }
            tb.updateUI();
        } else if (this.lkpanel instanceof LockInfo && this.rectlocation == 3) {
            int connid = Integer.valueOf(this.getName());
            LockInfo panel = (LockInfo)this.lkpanel;
            DefaultComboBoxModel connidModel = panel.getConnection_model();
            connidModel.setSelectedItem(connid);
            panel.updateTableModel(true);
            if (panel.getModeltb().getRowCount() <= 0) {
                GuiUt.showWarningDlg(DbFrame.frame, null, this.res.getString("lock_release"));
            }
        }
        if (this.popup != null) {
            if (me.getModifiers() == 4) {
                this.popup.show(me.getComponent(), me.getX(), me.getY());
            }
        }
        ResizableBorder border = (ResizableBorder)this.getBorder();
        this.cursor = border.getCursor(me);
        this.startPos = me.getPoint();
        this.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

