/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Monitor;

import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.Monitor.Bar;
import dbatool.Monitor.JournalStatusUserPanel;
import dbatool.tableModel.BasicInfoTableModel;
import dbaut.GuiUt;
import dbaut.alarm.Alarm2;
import dbaut.alarm.Sleeper;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;

public class JournalStatus
extends DbaTabbedPane
implements Sleeper {
    private static final long serialVersionUID = 1L;
    private static final int Y_AXIS = 0;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.MonitorRes", LocaleManager.getLocale());
    private String[] helpids = new String[]{"status.info.page&IOstatus", "status.info.journalstatus", "status.info.journalstatus"};
    private String[] titles = new String[]{this.res.getTitle("JOURNAL_STATUS"), this.res.getTitle("JOURNAL_USER"), this.res.getTitle("JOURNAL_GRAPH")};
    private String[] names = new String[]{"PageAndIOPanel", "JournalPanel", "JournalPanel2"};
    private static DbaPanel panels = null;
    private static BasicInfoTableModel models = null;
    private Alarm2 clock = null;
    private boolean isRefreshing = false;
    static int block_number = 50;
    ArrayList<JPanel> ArrayListPanel = null;
    static JFrame frame = null;
    static Bar[] bar = null;
    static Bar totalBar = null;
    int callCount = 0;
    private JCheckBox Auto_Refresh_Checkbox = new JCheckBox(this.res.getString("Auto_Refresh"));
    JournalStatusUserPanel userPanel = null;
    DbaButton ButtonReload = new DbaButton(new Dimension(120, 24), this.res.getString("JOURNAL_STATUS_GRAPH_BUTTON_REFRESH"), 'R', DBAImageResource.getResource(this.getClass(), "/jdbaimages/refresh.gif"), new ReflectionAction(this, "buttonReloadData"));
    DbaButton ButtonCheckPoint = new DbaButton(new Dimension(120, 24), this.res.getString("JOURNAL_STATUS_GRAPH_BUTTON_CHECKPOINT"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/checkpoint.gif"), new ReflectionAction(this, "buttonCheckPoint"));
    private int freeJnl = 0;
    private int totalJnl = 0;
    private int position = 0;

    public JournalStatus() {
        this.Auto_Refresh_Checkbox.addActionListener(new ReflectionAction(this, "Auto_Refresh_Checkbox_actionPerformed"));
        try {
            this.Control("init");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (DbFrame.frame.px.getAutoRefresh()) {
            this.Auto_Refresh_Checkbox.setSelected(true);
            this.userPanel.Auto_Refresh_Checkbox2.setSelected(true);
        } else {
            this.Auto_Refresh_Checkbox.setSelected(false);
            this.userPanel.Auto_Refresh_Checkbox2.setSelected(false);
        }
    }

    private void Control(String Ctype) throws Exception {
        if (Ctype == "init") {
            this.View1();
            this.userPanel = new JournalStatusUserPanel(DbFrame.helpres, "updatestatistics.info", this);
            this.add((Component)this.userPanel, this.titles[1]);
            this.View3(JournalStatus.getNUM_JOURNAL_FILE());
            HashMap<Object, Object> data = JournalStatus.Model(1, 1);
            this.append(data);
            ArrayList<ArrayList<String>> data2 = this.userPanel.reload();
            JournalStatus.append3(data, data2);
            this.clock = new Alarm2();
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
        }
    }

    private void append(HashMap data) {
        models.removeAll();
        Object[] b = null;
        Object[] freeJnlObj = null;
        HashMap map = data;
        String key = null;
        int cur = 0;
        for (Map.Entry entry : map.entrySet()) {
            b = new Object[2];
            key = (String)entry.getKey();
            b[0] = this.res.getString(key);
            b[1] = entry.getValue();
            models.addValue(b);
            if (key.compareTo("NUM_JNR_BLOCK_FREE") == 0) {
                this.freeJnl = Integer.parseInt((String)b[1]);
                this.position = cur;
                freeJnlObj = b;
            } else if (key.compareTo("NUM_JOURNAL_BLOCKS") == 0) {
                this.totalJnl = Integer.parseInt((String)b[1]);
            }
            ++cur;
        }
        if (freeJnlObj != null && this.freeJnl != 0 && this.totalJnl != 0) {
            double d = (double)this.freeJnl / (double)this.totalJnl;
            freeJnlObj[1] = d < 0.5 ? (d < 0.2 ? freeJnlObj[1].toString() + " (" + this.res.getString("JNL_LESS_THAN_TWENTY") + ")" : freeJnlObj[1].toString() + " (" + this.res.getString("JNL_LESS_THAN_FIFTY") + ")") : freeJnlObj[1].toString() + " (" + this.res.getString("JNL_MORE_THAN_FIFTY") + ")";
        }
        models.fireTableChanged(new TableModelEvent(models));
    }

    private static void append3(HashMap data, ArrayList<ArrayList<String>> data2) {
        int k;
        int NUM_JNL_BLK_WRITE = 0;
        int NUM_JNR_BLOCK_FREE = 0;
        int NUM_JOURNAL_FILE = 0;
        int CURRENT_JOURNAL_BN = 0;
        int CURRENT_JOURNAL_FN = 0;
        int NUM_JNL_BLK_READ = 0;
        int NUM_JOURNAL_BLOCKS = 0;
        int NUM_JNL_REC_WRITE = 0;
        float JOURNAL_FLUSH_RATE = 0.0f;
        int NUM_JNL_FRC_WRITE = 0;
        HashMap map = data;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey().toString().equals("NUM_JNL_BLK_WRITE")) {
                NUM_JNL_BLK_WRITE = Integer.valueOf(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().toString().equals("NUM_JNR_BLOCK_FREE")) {
                NUM_JNR_BLOCK_FREE = Integer.valueOf(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().toString().equals("NUM_JOURNAL_FILE")) {
                NUM_JOURNAL_FILE = Integer.valueOf(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().toString().equals("CURRENT_JOURNAL_BN")) {
                CURRENT_JOURNAL_BN = Integer.valueOf(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().toString().equals("CURRENT_JOURNAL_FN")) {
                CURRENT_JOURNAL_FN = Integer.valueOf(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().toString().equals("NUM_JNL_BLK_READ")) {
                NUM_JNL_BLK_READ = Integer.valueOf(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().toString().equals("NUM_JOURNAL_BLOCKS")) {
                NUM_JOURNAL_BLOCKS = Integer.valueOf(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().toString().equals("NUM_JNL_REC_WRITE")) {
                NUM_JNL_REC_WRITE = Integer.valueOf(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().toString().equals("JOURNAL_FLUSH_RATE")) {
                JOURNAL_FLUSH_RATE = Float.parseFloat(entry.getValue().toString());
                continue;
            }
            if (!entry.getKey().toString().equals("NUM_JNL_FRC_WRITE")) continue;
            NUM_JNL_FRC_WRITE = Integer.valueOf(entry.getValue().toString());
        }
        int StartOffset = CURRENT_JOURNAL_BN - (NUM_JOURNAL_BLOCKS - NUM_JNR_BLOCK_FREE);
        int UseSize = NUM_JOURNAL_BLOCKS - NUM_JNR_BLOCK_FREE;
        int block_size = NUM_JOURNAL_BLOCKS / NUM_JOURNAL_FILE / block_number;
        int offset = 0;
        int draw = UseSize;
        int[] start = new int[NUM_JOURNAL_FILE];
        int[] end = new int[NUM_JOURNAL_FILE];
        int[] start_add = new int[NUM_JOURNAL_FILE];
        int[] end_add = new int[NUM_JOURNAL_FILE];
        int[] LINE_ARR = new int[NUM_JOURNAL_FILE];
        for (int i = 0; i < NUM_JOURNAL_FILE; ++i) {
            start[offset] = 0;
            end[offset] = 0;
            int FN = CURRENT_JOURNAL_FN - i;
            LINE_ARR[offset++] = FN < 0 ? NUM_JOURNAL_FILE + FN : FN;
        }
        int line_size = 0;
        for (int i = 0; i < NUM_JOURNAL_FILE; ++i) {
            offset = LINE_ARR[i];
            line_size = block_size * block_number;
            if (offset == CURRENT_JOURNAL_FN) {
                start[offset] = StartOffset <= 0 ? 0 : StartOffset;
                end[offset] = CURRENT_JOURNAL_BN;
                draw -= end[offset] - start[offset];
                continue;
            }
            if (draw - line_size > 0) {
                start[offset] = 0;
                end[offset] = line_size;
                draw -= end[offset] - start[offset];
                continue;
            }
            if (draw <= 0) continue;
            start[offset] = line_size - draw;
            end[offset] = line_size;
            draw -= end[offset] - start[offset];
        }
        if (draw > 0) {
            start_add[CURRENT_JOURNAL_FN] = line_size - draw;
            end_add[CURRENT_JOURNAL_FN] = line_size;
        }
        int Block_of_total = NUM_JOURNAL_BLOCKS / block_number;
        boolean isSetUsingColor = false;
        int[] setTotalColor = new int[block_number];
        for (k = 0; k < block_number; ++k) {
            setTotalColor[k] = 0;
        }
        for (int i = 0; i < start.length; ++i) {
            int journalSize = block_size * block_number;
            int journalSize_start = (int)Math.floor((start[i] + i * journalSize) / Block_of_total);
            int journalSize_end = (int)Math.floor((end[i] + i * journalSize) / Block_of_total);
            int journalSize_start_add = (int)Math.floor((start_add[i] + i * journalSize) / Block_of_total);
            int journalSize_end_add = (int)Math.floor((end_add[i] + i * journalSize) / Block_of_total);
            for (int j = 0; j < block_number; ++j) {
                int temp = j * block_size;
                isSetUsingColor = false;
                if (start[i] <= temp && temp <= end[i] && start[i] != end[i] && end[i] != 0) {
                    isSetUsingColor = true;
                }
                if (start_add[i] <= temp && temp <= end_add[i] && start_add[i] != end_add[i] && end_add[i] != 0) {
                    isSetUsingColor = true;
                }
                if (isSetUsingColor) {
                    bar[i].setBlockUsingColor(j);
                    continue;
                }
                bar[i].setBlockFreeColor(j);
            }
            if (start[i] != 0 && start[i] < block_size) {
                bar[i].setBlockUsingColor(0);
            }
            for (int k2 = 0; k2 < setTotalColor.length; ++k2) {
                if (k2 > journalSize_start && k2 <= journalSize_end) {
                    setTotalColor[k2] = 1;
                    continue;
                }
                if (k2 <= journalSize_start_add || k2 > journalSize_end_add) continue;
                setTotalColor[k2] = 1;
            }
        }
        for (k = 0; k < setTotalColor.length; ++k) {
            if (setTotalColor[k] == 1) {
                totalBar.setBlockUsingColor(k);
                continue;
            }
            totalBar.setTotalBlockFreeColor(k);
        }
        for (ArrayList<String> b : data2) {
            int journalNumber = Integer.parseInt(b.get(2));
            int journalOffset = Integer.parseInt(b.get(3)) / block_size;
            bar[journalNumber].createBlockHJPCML(journalOffset, data2, journalNumber, journalOffset, block_size, JournalStatus.getCONNECTION_ID());
            bar[journalNumber].setBlockHoldingColor(journalOffset);
        }
    }

    private void View1() throws Exception {
        this.setName("StatusInfoTabbedPane");
        models = new BasicInfoTableModel();
        panels = new DbaPanel(DbFrame.helpres, this.helpids[0]);
        panels.setLayout(new BorderLayout());
        panels.setName(this.names[0]);
        JTable table = null;
        table = new JTable(models);
        DefaultTableCellRenderer customRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (row == JournalStatus.this.position && column == 1 && (double)JournalStatus.this.freeJnl / (double)JournalStatus.this.totalJnl < 0.5) {
                    component.setForeground(Color.RED);
                    if (component instanceof JComponent) {
                        ((JComponent)component).setToolTipText(JournalStatus.this.res.getString("JNL_FULL_SOLUTION"));
                    }
                } else {
                    component.setForeground(Color.BLACK);
                    if (component instanceof JComponent) {
                        ((JComponent)component).setToolTipText(null);
                    }
                }
                return component;
            }
        };
        table.getColumnModel().getColumn(1).setCellRenderer(customRenderer);
        panels.add(table);
        this.add((Component)panels, this.titles[0]);
    }

    private void View3(int NUM_JOURNAL_FILE) throws Exception {
        int i;
        totalBar = new Bar(this, block_number);
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel panelMain = new JPanel(new GridLayout(11, 1, 5, 5));
        panelMain.setPreferredSize(new Dimension(500, 500));
        JPanel panelButton = new JPanel();
        panelButton.setSize(new Dimension(10, 10));
        panelButton.setLayout(new FlowLayout(0, 2, 2));
        panelButton.add(this.ButtonReload);
        panelButton.add(this.ButtonCheckPoint);
        JPanel panelAutoReload = new JPanel();
        panelAutoReload.setSize(new Dimension(20, 10));
        panelAutoReload.setLayout(new FlowLayout(2, 5, 5));
        panelAutoReload.add((Component)this.Auto_Refresh_Checkbox, "East");
        JPanel panelText = new JPanel();
        JPanel panelT1 = new JPanel();
        JLabel labelT1 = new JLabel(this.res.getTitle("JOURNAL_STATUS_GRAPH_LABEL1"));
        panelT1.setBackground(Bar.tjColor);
        panelT1.add(labelT1);
        JPanel panelT2 = new JPanel();
        JLabel labelT2 = new JLabel(this.res.getTitle("JOURNAL_STATUS_GRAPH_LABEL2"));
        panelT2.setBackground(Bar.ijColor);
        panelT2.add(labelT2);
        JPanel panelT3 = new JPanel();
        JLabel labelT3 = new JLabel(this.res.getTitle("JOURNAL_STATUS_GRAPH_LABEL3"));
        panelT3.setBackground(Bar.juColor);
        panelT3.add(labelT3);
        JPanel panelT4 = new JPanel();
        JLabel labelT4 = new JLabel(this.res.getTitle("JOURNAL_STATUS_GRAPH_LABEL4"));
        panelT4.setBackground(Bar.jhColor);
        panelT4.add(labelT4);
        panelText.add(panelT1);
        panelText.add(panelT2);
        panelText.add(panelT3);
        panelText.add(panelT4);
        JPanel panelTop = new JPanel(new GridLayout(1, 3, 5, 5));
        panelTop.setLayout(new FlowLayout(1, 0, 0));
        panelTop.setLayout(new BoxLayout(panelTop, 0));
        panelTop.add(panelButton);
        panelTop.add(panelText);
        panelTop.add(panelAutoReload);
        JPanel panelTotal = new JPanel();
        panelTotal.setPreferredSize(new Dimension(0, 24));
        JLabel labelTotal = new JLabel(this.res.getTitle("JOURNAL_STATUS_GRAPH_LABEL5") + " :");
        panelTotal.add(labelTotal);
        panelMain.add(panelTop);
        panelMain.add(panelTotal);
        for (int j = 0; j < block_number; ++j) {
            panelTotal.add(totalBar.getBlock(j));
        }
        BoxLayout lo = new BoxLayout(panelTotal, 0);
        panelTotal.setLayout(lo);
        this.ArrayListPanel = new ArrayList();
        for (i = 0; i < NUM_JOURNAL_FILE; ++i) {
            JPanel panelJournal = new JPanel();
            JLabel label = new JLabel(this.res.getTitle("JOURNAL_STATUS_GRAPH_LABEL6") + " " + i + " : ");
            panelJournal.add(label);
            this.ArrayListPanel.add(panelJournal);
            panelMain.add(this.ArrayListPanel.get(i));
        }
        bar = new Bar[NUM_JOURNAL_FILE];
        for (i = 0; i < NUM_JOURNAL_FILE; ++i) {
            JournalStatus.bar[i] = new Bar(this, block_number);
            for (int j = 0; j < block_number; ++j) {
                this.ArrayListPanel.get(i).add(bar[i].getBlock(j));
            }
            BoxLayout lo2 = new BoxLayout(this.ArrayListPanel.get(i), 0);
            this.ArrayListPanel.get(i).setLayout(lo2);
        }
        jScrollPane1.getViewport().add((Component)panelMain, null);
        DbaPanel updStatPanel = new DbaPanel(DbFrame.helpres, "updatestatistics.info");
        updStatPanel.setName("UpdateStatisticsPanel");
        updStatPanel.setLayout(new GridLayout(2, 1, 5, 5));
        updStatPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        updStatPanel.add((Component)jScrollPane1, "Center");
        this.add((Component)updStatPanel, this.titles[2]);
    }

    @Override
    public synchronized void wakeUp() {
        if (this.isRefreshing) {
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
            return;
        }
        if (this.isShowing() && DbFrame.frame.px.getAutoRefresh()) {
            this.isRefreshing = true;
            this.reloadData();
            this.isRefreshing = false;
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
        }
    }

    public void Auto_Refresh_Checkbox_actionPerformed(ActionEvent e) {
        if (this.Auto_Refresh_Checkbox.isSelected()) {
            DbFrame.frame.px.updateVariables(3, "true");
        } else {
            DbFrame.frame.px.updateVariables(3, "false");
        }
        if (DbFrame.frame.px.getAutoRefresh()) {
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
            this.Auto_Refresh_Checkbox.setSelected(true);
            this.userPanel.Auto_Refresh_Checkbox2.setSelected(true);
        } else {
            this.Auto_Refresh_Checkbox.setSelected(false);
            this.userPanel.Auto_Refresh_Checkbox2.setSelected(false);
        }
    }

    public void buttonCheckPoint(ActionEvent e) {
        if (this.isRefreshing) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.isRefreshing = true;
        JournalAction journalAction = new JournalAction(1, 0);
        this.isRefreshing = false;
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void buttonReloadData(ActionEvent e) {
        if (this.isRefreshing) {
            System.out.println("It's refreshing already.");
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.isRefreshing = true;
        this.reloadData();
        this.isRefreshing = false;
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void reloadData() {
        HashMap<Object, Object> data = JournalStatus.Model(1, 1);
        this.append(data);
        ArrayList<ArrayList<String>> data2 = this.userPanel.reload();
        JournalStatus.append3(data, data2);
    }

    private static int getNUM_JOURNAL_FILE() {
        Statement stmt = null;
        ResultSet rs = null;
        String query = "select VALUE from SYSINFO where INFO = 'NUM_JOURNAL_FILE';";
        int NUM_JOURNAL_FILE = 0;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(query);
            rs.next();
            NUM_JOURNAL_FILE = Integer.parseInt(rs.getString(1));
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return NUM_JOURNAL_FILE;
    }

    private static int getCONNECTION_ID() {
        Statement stmt = null;
        ResultSet rs = null;
        String query = "SELECT CONNECTION_ID FROM SYSCONINFO";
        int CONNECTION_ID = 0;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(query);
            rs.next();
            CONNECTION_ID = Integer.parseInt(rs.getString(1));
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return CONNECTION_ID;
    }

    private static HashMap<Object, Object> Model(int SqlType, int arrayType) {
        Statement stmt = null;
        ResultSet rs = null;
        HashMap<Object, Object> dataHashMap = new HashMap<Object, Object>();
        String query = "";
        ArrayList<String> b = null;
        try {
            switch (SqlType) {
                case 1: {
                    query = "select  INFO,VALUE from SYSINFO  where ID like '02%' order by ID";
                    break;
                }
                case 2: {
                    query = "select USER_NAME,cast(CONNECTION_ID as varchar(10)), cast(FIRST_W_JNR_FN as varchar(10)), cast(FIRST_W_JNR_BN as varchar(10)),TIME_OF_SQL_CMD,NUM_J_BLOCK_DURATN, CAST(SQL_CMD as char(100)) from SYSUSER where CONNECTION_ID in (select HOLD_LK_CONNECTION from SYSLOCK) and FIRST_W_JNR_BN <> 0 ;";
                    break;
                }
            }
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(query);
            int columnCounter = rs.getMetaData().getColumnCount();
            int count = 0;
            while (rs.next()) {
                if (arrayType == 1) {
                    dataHashMap.put(rs.getString(1), rs.getString(2));
                } else if (arrayType == 2) {
                    b = new ArrayList<String>();
                    for (int i = 0; i < columnCounter; ++i) {
                        b.add(rs.getString(i + 1));
                    }
                    dataHashMap.put(count, b);
                }
                ++count;
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dataHashMap;
    }

    private void ModelTest(HashMap data) {
        HashMap map = data;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey().toString().equals("NUM_JOURNAL_FILE") && Integer.parseInt(entry.getValue().toString()) < 1) {
                System.out.println(" NUM_JOURNAL_FILE must >  1 \\r\\n");
            }
            if (!entry.getKey().toString().equals("NUM_JOURNAL_BLOCKS") || Integer.parseInt(entry.getValue().toString()) > 0) continue;
            System.out.println(" NUM_JOURNAL_BLOCKS cannot be 0  \\r\\n");
        }
    }

    public class JournalAction {
        int type;
        int arg;

        public JournalAction(int type, int arg) {
            this.type = type;
            this.arg = arg;
            this.query();
        }

        public void query() {
            Statement stmt = null;
            String query = "";
            try {
                switch (this.type) {
                    case 1: {
                        query = "checkpoint";
                        stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
                        stmt.executeQuery(query);
                        stmt.close();
                        GuiUt.showSuccessDlg(DbFrame.frame, JournalStatus.this.res.getString("JOURNAL_STATUS_CHECKPOINT"), null);
                        JournalStatus.this.reloadData();
                        break;
                    }
                    case 2: {
                        query = "kill connection " + this.arg + "";
                        stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
                        stmt.executeQuery(query);
                        stmt.close();
                        GuiUt.showSuccessDlg(DbFrame.frame, JournalStatus.this.res.getString("JOURNAL_STATUS_SUCCESS_DELETE_CONNECTION") + " " + this.arg, null);
                        JournalStatus.this.reloadData();
                        break;
                    }
                }
                stmt = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

