/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Function;

import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.StoredCommand.CommandPermissionTableModel;
import dbatool.Table.UserGroupRenderer;
import dbatool.tableCell.BooleanEditor;
import dbatool.tableCell.BooleanRenderer;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.editorPanel.SQLTextPaneIndentation;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class FunctionInfo
extends DbaTabbedPane {
    DBAResourceBundle res2 = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.wizard.ResWizard", LocaleManager.getLocale());
    private String func_owner = null;
    private String func_name = null;
    private DbaButton Properties_Modify_Button;
    private DbaButton Properties_Confirm_Button;
    private DbaButton Properties_Cancel_Button;
    private SQLTextPaneIndentation Source;
    private String func_def;
    private CommandPermissionTableModel model;
    private DBAToolAbstractTableModel absModel;
    private JTable permission_table;
    private boolean isSQLFUNC;
    private boolean isLUAFUNC;

    public FunctionInfo(String owner, String name) {
        this.Properties_Modify_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Properties_Modify_Button_actionPerformed"));
        this.Properties_Confirm_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Properties_Confirm_Button_actionPerformed"));
        this.Properties_Cancel_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "Properties_Cancel_Button_actionPerformed"));
        this.Source = new SQLTextPaneIndentation();
        this.func_def = "";
        this.model = null;
        this.absModel = null;
        this.permission_table = null;
        this.isSQLFUNC = false;
        this.isLUAFUNC = false;
        this.func_owner = GuiUt.rightTrim(owner);
        this.func_name = GuiUt.rightTrim(name);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("FunctionTabbedPane");
        this.Source.setName("FunctionSourceTextBox");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "Function.info.properties");
        jPanel1.setName("FunctionPropertiesPanel");
        DbaPanel jPanel4 = new DbaPanel(DbFrame.helpres, "Function.info.permission");
        JScrollPane jScrollPane1 = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        JPanel jToolBar1 = new JPanel(new FlowLayout(0));
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        this.model = new CommandPermissionTableModel(this.func_owner);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.permission_table = new JTable(this.absModel);
        this.permission_table.getTableHeader().setReorderingAllowed(false);
        jPanel1.setLayout(new BorderLayout(5, 5));
        jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.setLayout(new BorderLayout(5, 5));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.Source.setEditable(false);
        this.add((Component)jPanel1, DbFrame.frame.res.getTitle("Properties"));
        jPanel1.add((Component)jScrollPane1, "Center");
        jToolBar1.add((Component)this.Properties_Modify_Button, null);
        jToolBar1.add((Component)this.Properties_Confirm_Button, null);
        jToolBar1.add((Component)this.Properties_Cancel_Button, null);
        this.Properties_Confirm_Button.setEnabled(false);
        this.Properties_Cancel_Button.setEnabled(false);
        jScrollPane1.getViewport().add((Component)this.Source, null);
        this.getFunctionInfo();
    }

    public int getComponentType() {
        return 17;
    }

    public void grantOnce(boolean enabled) {
    }

    private void setUpUserGroupRenderer(JTable table, int index) {
        TableColumn column = table.getColumnModel().getColumn(index);
        column.setCellRenderer(new UserGroupRenderer());
    }

    private void setUpBooleanRendererEditor(JTable table) {
        table.setDefaultEditor(Boolean.class, new BooleanEditor(table, table.getModel()));
        table.setDefaultRenderer(Boolean.class, new BooleanRenderer());
    }

    private void getFunctionInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String encode = DbFrame.conn_DatabaseConnection.getDatabaseEncoding();
            String query = "select SOURCE, REMARKS, SQLDEF from SYSTEM.SYSPROCINFO where MODULENAME='FUNCPROC' and PROC_OWNER = '" + this.func_owner + "'" + "and PROC_NAME = '" + this.func_name + "'";
            rs = stmt.executeQuery(query);
            String source = "";
            if (rs.next()) {
                String sqldef = rs.getString(3).trim();
                if (rs.getString(2).trim().equalsIgnoreCase("SQL")) {
                    this.isSQLFUNC = true;
                    source = encode != null ? new String(sqldef.getBytes(), encode) : sqldef;
                } else if (rs.getString(2).trim().equalsIgnoreCase("ESQL")) {
                    this.isLUAFUNC = true;
                    InputStream in = rs.getBinaryStream(1);
                    byte[] buffer = new byte[in.available()];
                    in.read(buffer);
                    source = encode != null ? new String(buffer, encode) : new String(buffer);
                    in.close();
                } else {
                    this.Properties_Modify_Button.setEnabled(false);
                }
            }
            rs.close();
            stmt.close();
            this.Source.setText(source.trim());
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        catch (IOException ioe) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showErrorDlg(DbFrame.frame, ioe.getMessage(), null);
        }
    }

    public void Properties_Cancel_Button_actionPerformed(ActionEvent e) {
        this.getFunctionInfo();
        this.revalidate();
        this.repaint();
        this.releaseTabbedPanel();
        this.Source.setText(this.func_def);
        this.Source.setEditable(false);
        this.Properties_Modify_Button.setEnabled(true);
        this.Properties_Confirm_Button.setEnabled(false);
        this.Properties_Cancel_Button.setEnabled(false);
    }

    public void Properties_Modify_Button_actionPerformed(ActionEvent e) {
        this.fixTabbedPanelAt(this.getSelectedIndex());
        this.Properties_Confirm_Button.setEnabled(true);
        this.Properties_Cancel_Button.setEnabled(true);
        this.Properties_Modify_Button.setEnabled(false);
        if (this.isLUAFUNC) {
            this.modifyESQL();
        }
        if (this.isSQLFUNC) {
            this.modifySQLSP();
        }
    }

    public void Properties_Confirm_Button_actionPerformed(ActionEvent e) {
        File tmpFile = null;
        String fileAbsolutePath = "";
        String str1 = "";
        if (this.isSQLFUNC) {
            try {
                tmpFile = File.createTempFile("proctmp", ".sp");
                fileAbsolutePath = tmpFile.getAbsolutePath();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (this.isLUAFUNC) {
            try {
                tmpFile = File.createTempFile("proctmp", ".ec");
                fileAbsolutePath = tmpFile.getAbsolutePath();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            DataOutputStream outFile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)));
            str1 = this.Source.getText().trim();
            outFile.write(str1.getBytes());
            outFile.close();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        Statement stmt = null;
        JDialog dialog = new JDialog();
        GuiUt.setCenterLocation(DbFrame.frame, dialog);
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            stmt.execute("create procedure from '" + fileAbsolutePath + "'");
            this.Source.setText(str1);
            stmt.close();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(dialog, null, sqle);
            DbaObject.close(stmt);
            dialog.setVisible(false);
            dialog.dispose();
            return;
        }
        dialog.setVisible(false);
        dialog.dispose();
        this.getFunctionInfo();
        this.Source.setEditable(false);
        this.revalidate();
        this.repaint();
        this.releaseTabbedPanel();
        this.Properties_Modify_Button.setEnabled(true);
        this.Properties_Confirm_Button.setEnabled(false);
        this.Properties_Cancel_Button.setEnabled(false);
    }

    private void modifySQLSP() {
        String sql_text;
        this.Source.setEditable(true);
        this.func_def = sql_text = this.Source.getText();
        String new_str = "";
        Pattern p = Pattern.compile("create\\s+procedure\\s", 2);
        Matcher match = p.matcher(sql_text);
        if (match.find()) {
            String out;
            new_str = out = match.replaceAll("CREATE OR REPLACE PROCEDURE ");
        } else {
            p = Pattern.compile("create\\s+or\\s+replace\\s+procedure\\s", 2);
            match = p.matcher(sql_text);
            if (match.find()) {
                String out;
                new_str = out = match.replaceAll("CREATE OR REPLACE PROCEDURE ");
            }
        }
        this.Source.setText(new_str);
    }

    private void modifyESQL() {
        String sql_text;
        this.Source.setEditable(true);
        this.func_def = sql_text = this.Source.getText();
        String new_str = "";
        Pattern p = Pattern.compile("exec\\s+sql\\s+create\\s+procedure", 2);
        Matcher match = p.matcher(sql_text);
        if (match.find()) {
            String out;
            new_str = out = match.replaceAll("EXEC SQL CREATE OR REPLACE PROCEDURE ");
        } else {
            p = Pattern.compile("exec\\s+sql\\s+create\\s+or\\s+replace\\s+procedure", 2);
            match = p.matcher(sql_text);
            if (match.find()) {
                String out;
                new_str = out = match.replaceAll("EXEC SQL CREATE OR REPLACE PROCEDURE ");
            }
        }
        this.Source.setText(new_str);
    }
}

