/*
 * Decompiled with CFR 0.152.
 */
package dbatool;

import com.syscom.dm.dba.sca.DbaAuthority;
import dbatool.DbFrame;
import dbaut.GuiUt;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class DbaToolBar
extends JToolBar
implements LocaleChangeListener {
    private JButton connectButton = new JButton();
    private JButton disconnectButton = new JButton();
    private JButton statisticButton = new JButton();
    private JButton autoIndexButton = new JButton();
    private JButton createObjectButton = new JButton();
    private JButton refreshButton = new JButton();
    private JButton settingButton = new JButton();
    private JButton queryButton = new JButton();
    private JButton tdeButton = new JButton();
    JButton helpButton = new JButton();
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private ActionListener cshListener_menuitem = null;

    public DbaToolBar() {
        this.setName("DbaToolBar");
        this.connectButton.setName("ConnectButton");
        this.disconnectButton.setName("DisconnecButton");
        this.createObjectButton.setName("CreateButton");
        this.statisticButton.setName("StatisticsButton");
        this.autoIndexButton.setName("AutoIndexButton");
        this.refreshButton.setName("RefreshButton");
        this.settingButton.setName("SettingBuuton");
        this.queryButton.setName("QueryButton");
        this.setLayout(new FlowLayout(0, 2, 0));
        this.setFloatable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.connectButton.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/database_connect.gif"));
        this.connectButton.setToolTipText(this.res.getString("Connect_Database"));
        this.disconnectButton.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/disconnection.gif"));
        this.disconnectButton.setToolTipText(this.res.getString("Disconnect_Database"));
        this.statisticButton.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/update_statistics_24.gif"));
        this.statisticButton.setToolTipText(this.res.getString("Update_Statistics"));
        this.autoIndexButton.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/auto_index_24.gif"));
        this.autoIndexButton.setToolTipText(this.res.getString("Sync_Auto_Index"));
        this.createObjectButton.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/create_24.gif"));
        this.createObjectButton.setToolTipText(this.res.getString("Create_"));
        this.refreshButton.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/refresh24.gif"));
        this.refreshButton.setToolTipText(this.res.getString("Refresh"));
        this.settingButton.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/setting.gif"));
        this.settingButton.setToolTipText(this.res.getString("Preferences"));
        this.tdeButton.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/TDE.gif"));
        this.tdeButton.setToolTipText(this.res.getString("Manage_TDE"));
        this.helpButton.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/About24.gif"));
        this.helpButton.setToolTipText(this.res.getString("Help"));
        this.queryButton.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/query.gif"));
        this.queryButton.setToolTipText(this.res.getString("query"));
        this.addSeparator();
        this.add(this.connectButton);
        this.add(this.disconnectButton);
        this.add(this.createObjectButton);
        this.add(this.statisticButton);
        this.add(this.autoIndexButton);
        this.add(this.refreshButton);
        this.add(this.settingButton);
        this.add(this.queryButton);
        this.add(this.tdeButton);
        this.add(this.helpButton);
        this.connectButton.addActionListener(new ReflectionAction(this, "connectButton_actionPerformed"));
        this.disconnectButton.addActionListener(new ReflectionAction(this, "disconnectButton_actionPerformed"));
        this.statisticButton.addActionListener(new ReflectionAction(this, "statisticButton_actionPerformed"));
        this.autoIndexButton.addActionListener(new ReflectionAction(this, "autoIndexButton_actionPerformed"));
        this.refreshButton.addActionListener(new ReflectionAction(this, "refreshButton_actionPerformed"));
        this.settingButton.addActionListener(new ReflectionAction(this, "settingButton_actionPerformed"));
        this.tdeButton.addActionListener(new ReflectionAction(this, "tdeButton_actionPerformed"));
        this.queryButton.addActionListener(new ReflectionAction(this, "queryButton_actionPerformed"));
        this.createObjectButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DbaToolBar.this.createObjectButton_mouseReleased(e);
            }
        });
    }

    public void checkUserPrivilege(DbaAuthority authority) {
        if (authority.isAboveDba()) {
            this.createObjectButton.setEnabled(true);
            this.statisticButton.setEnabled(true);
            this.autoIndexButton.setEnabled(true);
        } else if (authority.isResource()) {
            this.createObjectButton.setEnabled(true);
            this.statisticButton.setEnabled(false);
            this.autoIndexButton.setEnabled(false);
        } else if (authority.isConnect()) {
            this.createObjectButton.setEnabled(false);
            this.statisticButton.setEnabled(false);
            this.autoIndexButton.setEnabled(false);
        }
    }

    public void createObjectButton_mouseReleased(MouseEvent e) {
        if (this.createObjectButton.isSelected()) {
            return;
        }
        if (!this.createObjectButton.isEnabled()) {
            return;
        }
        DbFrame.frame.createObjectButton_mouseReleased(e);
    }

    public void refreshButton_actionPerformed(ActionEvent e) {
        DbFrame.frame.Refresh_menuitem_actionPerformed(e);
    }

    public void statisticButton_actionPerformed(ActionEvent e) {
        DbFrame.frame.Update_Statistics_MenuItem_actionPerformed(e);
    }

    public void autoIndexButton_actionPerformed(ActionEvent e) {
        DbFrame.frame.Sync_Auto_Index_Menuitem_actionPerformed(e);
    }

    public void connectButton_actionPerformed(ActionEvent e) {
        DbFrame.frame.Connect_MenuItem_actionPerformed(e);
    }

    public static void disconnectButton_actionPerformed(ActionEvent e) {
        DBAResourceBundle res2 = DbFrame.frame.getResourceBundle();
        int result = GuiUt.showOptionDlg(DbFrame.frame, res2.getString("Warning"), res2.getString("Do_you_disconnect"));
        if (result != 0) {
            return;
        }
        DbFrame.frame.Disconnect_MenuItem_actionPerformed(null);
        DbFrame.frame.Disconnect_MenuItem_actionPerformed(e);
    }

    public void settingButton_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.Preferences_Menitem_actionPerformed(e);
    }

    public void tdeButton_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.TDE_Setting_Menuitem_actionPerformed(e);
    }

    public void queryButton_actionPerformed(ActionEvent e) {
        DbFrame.frame.createJsqlQuery_actionPerformed(e);
    }

    public void freezeMenuitem(boolean freeze) {
        this.createObjectButton.setEnabled(!freeze);
        this.statisticButton.setEnabled(!freeze);
        this.autoIndexButton.setEnabled(!freeze);
        this.refreshButton.setEnabled(!freeze);
        this.queryButton.setEnabled(!freeze);
        this.tdeButton.setEnabled(!freeze);
    }

    public void setHelpButton(boolean first) {
        if (DbFrame.frame.mainHB != null) {
            this.helpButton.setEnabled(true);
            if (first) {
                this.cshListener_menuitem = new CSH.DisplayHelpFromSource((HelpBroker)DbFrame.frame.mainHB);
                this.helpButton.addActionListener(this.cshListener_menuitem);
            } else {
                this.helpButton.removeActionListener(this.cshListener_menuitem);
                this.cshListener_menuitem = new CSH.DisplayHelpFromSource((HelpBroker)DbFrame.frame.mainHB);
                this.helpButton.addActionListener(this.cshListener_menuitem);
            }
        } else {
            this.helpButton.setEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setToolBarButtonEnable(boolean enable) {
        this.createObjectButton.setEnabled(enable);
        this.statisticButton.setEnabled(enable);
        this.autoIndexButton.setEnabled(enable);
        this.refreshButton.setEnabled(enable);
        this.disconnectButton.setEnabled(enable);
        this.queryButton.setEnabled(enable);
        if (enable) {
            if (DbFrame.conn_DatabaseConnection.isDBTDE()) {
                this.tdeButton.setEnabled(enable);
                return;
            }
        }
        this.tdeButton.setEnabled(false);
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = DbFrame.frame.getResourceBundle();
        this.connectButton.setToolTipText(this.res.getString("Connect_Database"));
        this.disconnectButton.setToolTipText(this.res.getString("Disconnect_Database"));
        this.statisticButton.setToolTipText(this.res.getString("Update_Statistics"));
        this.autoIndexButton.setToolTipText(this.res.getString("Sync_Auto_Index"));
        this.createObjectButton.setToolTipText(this.res.getString("Create_"));
        this.refreshButton.setToolTipText(this.res.getString("Refresh"));
        this.settingButton.setToolTipText(this.res.getString("Preferences"));
        this.helpButton.setToolTipText(this.res.getString("Help"));
        this.queryButton.setToolTipText(this.res.getString("query"));
        this.tdeButton.setToolTipText(this.res.getString("Manage_TDE"));
    }

    public void removeTDEButton() {
        this.remove(this.tdeButton);
    }

    public void addTDEButton() {
        if (!DbaToolBar.containsButton(this, this.tdeButton)) {
            this.add((Component)this.tdeButton, 9);
        }
    }

    private static boolean containsButton(JToolBar toolBar, JButton buttonToFind) {
        for (int i = 0; i < toolBar.getComponentCount(); ++i) {
            Component component = toolBar.getComponent(i);
            if (component != buttonToFind) continue;
            return true;
        }
        return false;
    }
}

