/*
 * Decompiled with CFR 0.152.
 */
package dbatool.DatabaseLink;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class DatabaseLinkList
extends DbaTabbedPane
implements ComponentPrivilege {
    private int OWNER = 0;
    private int DBLINK = 1;
    private int DBSERVER = 2;
    private int USER = 3;
    private DbaButton Create_Button;
    private DbaButton Drop_Button;
    private DbaTableModel model;
    private DBAToolAbstractTableModel absModel;
    private JTable table;

    public DatabaseLinkList() {
        this.Create_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.Drop_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
        this.model = null;
        this.absModel = null;
        this.table = null;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("DatabaseLinksTabbedPane");
        String[] columnNames = new String[]{DbFrame.frame.res.getString("Owner"), DbFrame.frame.res.getString("Link_Name"), DbFrame.frame.res.getString("Database_Server"), DbFrame.frame.res.getString("User_Name")};
        this.model = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.table = new JTable(this.absModel);
        this.table.setName("DatabaseLinksTable");
        this.Create_Button.setName("CreateButton");
        this.Drop_Button.setName("DropButton");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "databaselink.list");
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setName("DatabaseLinksButtonPanel");
        jPanel1.setLayout(new BorderLayout());
        this.add((Component)jPanel1, DbFrame.frame.res.getString("Database_Link"));
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.Create_Button, null);
        jPanel2.add((Component)this.Drop_Button, null);
        jPanel1.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.table, null);
        this.initColumnSizes();
        this.getDatabaseLinkList();
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
        this.absModel.addMouseListenerToHeaderInTable(this.table);
    }

    @Override
    public int getComponentType() {
        return 18;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Drop_Button.setEnabled(enabled);
    }

    public void table_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            int r = this.table.getSelectedRow();
            Object value = this.table.getValueAt(r, 0);
            String owner = (String)value;
            this.authority.authorise(owner);
        }
    }

    private void initColumnSizes() {
        TableColumn column = null;
        int[] sizes = new int[]{100, 100, 100, 100};
        for (int i = 0; i < sizes.length; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(sizes[i]);
        }
    }

    private void getDatabaseLinkList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model.removeAll();
            String query = "select OWNER, DB_LINK, DBSVR, USER_NAME from SYSDBLINK order by OWNER, DB_LINK, DBSVR";
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.model.addValue(new DBARowInfo(this.getRowInfo(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4))));
            }
            rs.close();
            stmt.close();
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(DbFrame.frame.res.getString("The_number_of_database_links_is"), Integer.toString(this.model.getRowCount())));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private Object[] getRowInfo(String owner, String dblink, String dbserver, String user) {
        Object[] data = new Object[4];
        data[this.OWNER] = GuiUt.rightTrim(owner);
        data[this.DBLINK] = GuiUt.rightTrim(dblink);
        data[this.DBSERVER] = dbserver.trim();
        data[this.USER] = GuiUt.rightTrim(user);
        return data;
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(16);
        this.getDatabaseLinkList();
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        String owner = (String)this.model.getValueAt(row, this.OWNER);
        String dblink = (String)this.model.getValueAt(row, this.DBLINK);
        String str1 = DbFrame.frame.res.getString("Do_you_want_to_drop_database_link");
        String str2 = GuiUt.mapStringForProperty(str1, dblink);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, DbFrame.frame.res.getString("Drop_Database_Link"), str2 + "?");
        if (reply != 0) {
            return;
        }
        String query = owner.equals("PUBLIC") ? "DROP PUBLIC DATABASE LINK " : "DROP DATABASE LINK ";
        boolean result = DatabaseConnection.executeSQL(query = query + GuiUt.getIDString(dblink));
        if (!result) {
            return;
        }
        this.getDatabaseLinkList();
        if (row >= this.model.getRowCount()) {
            this.table.clearSelection();
        }
    }
}

