/*
 * Decompiled with CFR 0.152.
 */
package datatransfer;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class DataTransferButton
extends JLabel
implements ActionListener {
    private static final long serialVersionUID = 4837115737308594459L;
    private ImageIcon in;
    private ImageIcon out;
    private String text;
    Vector<ActionListener> listeners = new Vector();

    public DataTransferButton(ImageIcon in, ImageIcon out, String text) {
        try {
            this.in = in;
            this.out = out;
            this.text = text;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Font font = this.getFont();
        this.setFont(new Font(font.getName(), 1, 16));
        this.setText(this.text);
        this.setIcon(this.out);
        this.setBorder(null);
        this.setBackground(Color.white);
        this.setForeground(Color.decode("#6699CC"));
        this.setHorizontalAlignment(2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DataTransferButton.this.setForeground(Color.decode("#99CCFF"));
                DataTransferButton.this.setIcon(DataTransferButton.this.in);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DataTransferButton.this.setForeground(Color.decode("#6699CC"));
                DataTransferButton.this.setIcon(DataTransferButton.this.out);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                DataTransferButton.this.actionPerformed(null);
            }
        });
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Iterator<ActionListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().actionPerformed(e);
        }
    }
}

