/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut.textField;

import dbaut.comp.DbaFileChooser;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class FilePathField
extends JPanel {
    String fileseparator = System.getProperty("file.separator");
    private CharField File_Path = new CharField(255, true);
    private JButton Browse_Button = new JButton();
    private String buttonText = null;
    private Component parent = null;
    private FileFilter[] filter = null;
    private ActionListener listener = null;
    private PropertyChangeListener pclistener = null;
    private int mode = 0;

    public FilePathField(Component comp, String buttonText, FileFilter[] filter) {
        this.parent = comp == null ? this : comp;
        this.buttonText = buttonText;
        this.filter = filter;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.File_Path.setCaretPosition(0);
        this.Browse_Button.setMargin(new Insets(2, 2, 2, 2));
        this.Browse_Button.setText("...");
        this.Browse_Button.setPreferredSize(new Dimension(20, 24));
        this.Browse_Button.addActionListener(new ReflectionAction(this, "Browse_Button_actionPerformed"));
        this.File_Path.setBorder(null);
        this.File_Path.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    FilePathField.this.File_Path_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                FilePathField.this.File_Path_keyReleased(e);
            }
        });
        this.File_Path.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (FilePathField.this.listener != null) {
                    FilePathField.this.listener.actionPerformed(null);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.File_Path, "Center");
        this.add((Component)this.Browse_Button, "East");
    }

    public void setButtonText(String text) {
        this.buttonText = text;
    }

    public void setText(String text) {
        this.File_Path.setText(text);
    }

    public String getText() {
        return this.File_Path.getText();
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.File_Path.setEnabled(enable);
        this.Browse_Button.setEnabled(enable);
    }

    public void setFileSelectionMode(int mode) {
        this.mode = mode;
    }

    public void Browse_Button_actionPerformed(ActionEvent e) {
        DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dbautproperties.dbaut.Res", LocaleManager.getLocale());
        DbaFileChooser chooser = new DbaFileChooser();
        if (this.filter != null) {
            int size = this.filter.length;
            for (int i = 0; i < size; ++i) {
                chooser.addChoosableFileFilter(this.filter[i]);
            }
            chooser.setFileFilter(this.filter[0]);
        }
        chooser.setLocale(LocaleManager.getLocale());
        String path = this.File_Path.getText();
        if (path != null && path.length() > 0 && path.indexOf(this.fileseparator) > 0) {
            chooser.setCurrentDirectory(path);
        }
        chooser.setFileSelectionMode(this.mode);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileHidingEnabled(false);
        if (this.buttonText == null) {
            this.buttonText = res.getString("Open");
        }
        int state = chooser.showDialog(this.parent, this.buttonText);
        if (state != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        if (f == null || f.getPath() == null) {
            return;
        }
        if (f.getPath().length() > 254) {
            System.out.println("File path is longer than 254.");
        } else {
            this.File_Path.setText(f.getPath());
            this.File_Path.setCaretPosition(0);
        }
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void File_Path_keyReleased(KeyEvent e) {
        if (e.getKeyCode() != 10) {
            if (e.getKeyCode() != 9) {
                if (this.pclistener == null) return;
                this.pclistener.propertyChange(null);
                return;
            }
        }
        if (this.listener == null) return;
        this.listener.actionPerformed(null);
    }

    public boolean isEmpty() {
        String txt = this.File_Path.getText();
        return txt == null || txt.trim().length() == 0;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pclistener) {
        this.pclistener = pclistener;
        if (this.File_Path != null) {
            this.File_Path.addPropertyChangeListener(pclistener);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    public void removeActionListener(ActionListener l) {
        if (this.listener == l) {
            this.listener = null;
        }
    }

    @Override
    public void requestFocus() {
        this.File_Path.requestFocus();
    }
}

