/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.dm.dba.sca;

import com.syscom.dm.common.sca.AbstractAuthority;
import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.ComponentRole;
import com.syscom.dm.dba.sca.DbaAuthority;
import com.syscom.dm.dba.sca.InternalUtil;
import com.syscom.dm.dba.sca.role.Role;
import dbaut.privilege.UserPrivilege;

public abstract class AbstractDbaAuthority
extends AbstractAuthority
implements DbaAuthority {
    private ComponentPrivilege privilege = null;
    private ComponentRole componentRole = null;
    private Role role = null;

    public AbstractDbaAuthority(ComponentPrivilege privilege) {
        if (privilege != null) {
            this.setComponentPrivilege(privilege);
            if (privilege instanceof ComponentRole) {
                this.setComponentRole((ComponentRole)((Object)privilege));
            }
        }
    }

    @Override
    public void authoriseOnce() {
        this.authoriseOnce(null, null);
    }

    @Override
    public void authoriseOnce(String owner) {
        this.authoriseOnce(owner, null);
    }

    @Override
    public void authoriseOnce(String owner, String name) {
        if (this.getComponentPrivilege() != null && this.getRole() != null) {
            this.getComponentPrivilege().grantOnce(this.getRole().isAuthorisedOnce(owner, name));
        }
    }

    @Override
    public void authorise() {
        this.authorise(null, null);
    }

    @Override
    public void authorise(String owner) {
        this.authorise(owner, null);
    }

    @Override
    public void authorise(String owner, String name) {
        if (this.getComponentPrivilege() != null && this.getRole() != null) {
            this.getComponentPrivilege().grant(this.getRole().isAuthorised(owner, name));
        }
    }

    @Override
    public boolean isOwner(String owner) {
        return this.getPrivilege().isOwner(owner);
    }

    @Override
    public boolean isSysadm() {
        return false;
    }

    @Override
    public boolean isSysdba() {
        return false;
    }

    @Override
    public boolean isDba() {
        return false;
    }

    @Override
    public boolean isResource() {
        return false;
    }

    @Override
    public boolean isConnect() {
        return false;
    }

    @Override
    protected UserPrivilege getPrivilege() {
        return InternalUtil.getUserPrivilege();
    }

    protected boolean isSystem(String owner) {
        return "SYSTEM".equalsIgnoreCase(owner);
    }

    protected ComponentPrivilege getComponentPrivilege() {
        return this.privilege;
    }

    private void setComponentPrivilege(ComponentPrivilege privilege) {
        this.privilege = privilege;
    }

    protected ComponentRole getComponentRole() {
        return this.componentRole;
    }

    private void setComponentRole(ComponentRole componentRole) {
        this.componentRole = componentRole;
    }

    private Role getRole() {
        return this.role;
    }

    protected void setRole(Role role) {
        this.role = role;
    }
}

