/*
 * Decompiled with CFR 0.152.
 */
package ServerMgr.runtimesetting;

import DmEditor.AllSectionInfo.ConfigItem;
import DmEditor.AllSectionInfo.autoindex.AutoIndexPanel;
import DmEditor.AllSectionInfo.charset.CharSetEncodingPanel;
import DmEditor.AllSectionInfo.logsystem.NewLogSystemPanel;
import DmEditor.AllSectionInfo.scheduledaemon.ScheduleDaemonPanel;
import DmEditor.AllSectionInfo.statistics.StatisticsPanel;
import DmEditor.Preferences.Preferences;
import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import ServerMgr.UserPasswordDlg;
import ServerMgr.runtimesetting.BackupPanel;
import ServerMgr.runtimesetting.DiffIncBackupPanel;
import com.borland.jbcl.control.GroupBox;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.dm.svrmgr.sca.DefaultSvrmgrAuthority;
import dbatool.DbFrame;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.locale.LocaleManager;
import dbaut.panel.PanelWithTitle;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.resource.HelpResourceBundle;
import dbaut.textField.FilePathField;
import dbaut.textField.IntegerRangeField;
import dbaut.util.JavaTypeUtil;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import wizard.WizardPanel;

public class RunTimeSettingDlg
extends JDialog {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.ServerMgrRes", LocaleManager.getLocale());
    private SteppedComboBox DatabaseNames_ComboBox = new SteppedComboBox();
    private JCheckBox writeToConfig_CheckBox = new JCheckBox();
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private DbaButton OK_Button = new DbaButton(this.res.getString("OK"), 'O', new ReflectionAction(this, "OK_Button_actionPerformed"));
    private JLabel foLabel = new JLabel(this.res.getString("File_object_directory"));
    private FilePathField filePath = new FilePathField(this, null, this.res.getString("Select_path"), true);
    private JCheckBox jsyncCheckBox = new JCheckBox(this.res.getString("Enable_the_synchronization_of_journal"), true);
    private JTextArea jsyncTextArea1 = new JTextArea();
    private PanelWithTitle dbSqlstGroupBox = new PanelWithTitle(this.res.getString("Display_sql_command"));
    private JRadioButton dbSqlstRadioButton1 = new JRadioButton(this.res.getString("Disabled"));
    private JRadioButton dbSqlstRadioButton2 = new JRadioButton(this.res.getString("Sow_SQL_command_time"));
    private JRadioButton dbSqlstRadioButton3 = new JRadioButton(this.res.getString("Show_sql_command_exact"));
    private JCheckBox ddDdbmdCheckBox = new JCheckBox(this.res.getString("Enable_distributed_db_mode"));
    private JLabel dbExtnpLabel = new JLabel(this.res.getString("Pages_to_extend_when"));
    private JLabel dbFosubLabel = new JLabel(this.res.getString("Files_per_FO_sub"));
    private JRadioButton dbFosubRadioButton1 = new JRadioButton(this.res.getString("Always_in_same_dir"));
    private JRadioButton dbFosubRadioButton2 = new JRadioButton("100 ~ 10000");
    private IntegerRangeField dbFosubRangeField = new IntegerRangeField(10000, 100, false);
    private JCheckBox dbUsrfoCheckBox = new JCheckBox();
    private IntegerRangeField dbExtnpRangeField = new IntegerRangeField(Short.MAX_VALUE, 1, false);
    private Frame frame = null;
    private PanelWithTitle blockConnectionGroupBox = new PanelWithTitle(this.res.getString("Block_connection"));
    private JRadioButton blockConnectionRadioButton1 = new JRadioButton(this.res.getString("Allow_new_connection"));
    private JRadioButton blockConnectionRadioButton2 = new JRadioButton(this.res.getString("Block_new_connection"));
    private BackupPanel backupPanel = null;
    private Vector backupHt = new Vector();
    private String strBMode = null;
    private DiffIncBackupPanel diffIncBackupPanel = null;
    private Vector diffIncHt = new Vector();
    private NewLogSystemPanel logSystemPanel = null;
    private Vector logSystemHt = new Vector();
    private CharSetEncodingPanel charSetEncodingPanel = null;
    private Vector charSetEncodingHt = new Vector();
    private StatisticsPanel statisticsPanel = null;
    private Vector statisticsHt = new Vector();
    private AutoIndexPanel autoIndexPanel = null;
    private Vector autoIndexHt = new Vector();
    private ScheduleDaemonPanel scheduleDaemonPanel = null;
    private Vector scheduleDeamonHt = new Vector();
    private PanelWithTitle dbExthdGroupBox = new PanelWithTitle();
    private JRadioButton dbExthdRadioButton0 = new JRadioButton();
    private JRadioButton dbExthdRadioButton1 = new JRadioButton();
    private JRadioButton dbExthdRadioButton2 = new JRadioButton();
    private IntegerRangeField dbExthdTextField = new IntegerRangeField(EXTHD_DEFAULT_STRING, this.getMaxExthd(1), -1, 0, false);
    private static final int EXTHD_FIRST = -1;
    private static final int EXTHD_SMALLEST = 0;
    private static final int EXTHD_MIN = -1;
    private static final int EXTHD_DEFAULT_INT = 100;
    private static final String EXTHD_DEFAULT_STRING = String.valueOf(100) + "M";
    private static int dbPageSize = JdmConfig.getDBPageSize(Preferences.selectedSection);
    private HelpResourceBundle helpres = null;
    private Connection db_connection = null;
    private int usrfo = 0;
    private int sqlst = 0;
    private int fosub = 0;
    private int ddbmd = 0;
    private int extnp = 0;
    private int jsync = 0;
    private int block = 0;
    private String fodir = null;
    private String dbname = null;
    private String exthd = null;
    private boolean isLocalHost = true;
    private boolean fromJSvrMgr = true;

    public RunTimeSettingDlg(Frame frame, String title, Boolean modal, Connection db_connection) {
        super(frame, title, (boolean)modal);
        this.frame = frame;
        this.db_connection = db_connection;
        this.fromJSvrMgr = db_connection == null;
        this.jbInit();
    }

    public RunTimeSettingDlg(Frame frame, Connection db_connection) {
        this(frame, null, db_connection);
    }

    public RunTimeSettingDlg(Frame frame, String dbname, Connection db_connection) {
        super(frame);
        this.setModal(true);
        this.frame = frame;
        this.db_connection = db_connection;
        this.dbname = dbname;
        this.fromJSvrMgr = db_connection == null;
        this.jbInit();
    }

    private void jbInit() {
        this.setName("RuntimeSettingDialog");
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RunTimeSettingDlg.this.Cancel_Button_actionPerformed(null);
            }
        });
        SmHelpButton help_Button = new SmHelpButton();
        if (SmFrame.frame != null) {
            this.helpres = SmFrame.helpres;
        } else if (DbFrame.frame != null) {
            this.helpres = DbFrame.helpres;
        }
        DbaButton Cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        Cancel_Button.setName("CancelButton");
        this.OK_Button.setName("OKButton");
        this.OK_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"));
        Cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        JPanel panel1 = new JPanel(new BorderLayout());
        JPanel jPanel1 = new JPanel(new FlowLayout(0));
        JLabel dbNameLabel = new JLabel(this.res.getString("DB_name"));
        this.jsyncTextArea1.setBackground(WizardPanel.sysColor);
        this.jsyncTextArea1.setWrapStyleWord(true);
        this.jsyncTextArea1.setLineWrap(true);
        this.jsyncTextArea1.setBorder(null);
        this.tabbedPane.setName("RuntimeSettingTabbedPane");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = RunTimeSettingDlg.this.tabbedPane.getSelectedIndex();
                if (index < 0 || index >= RunTimeSettingDlg.this.tabbedPane.getComponentCount()) {
                    return;
                }
                DbaPanel p = (DbaPanel)RunTimeSettingDlg.this.tabbedPane.getComponentAt(index);
                if (RunTimeSettingDlg.this.fromJSvrMgr) {
                    if (SmFrame.frame.mainHB != null) {
                        SmFrame.frame.mainHB.enableHelpKey((Component)RunTimeSettingDlg.this.tabbedPane.getRootPane(), p.getHelpIDString(), null);
                    }
                } else if (DbFrame.frame.mainHB != null) {
                    DbFrame.frame.mainHB.enableHelp((Component)RunTimeSettingDlg.this.tabbedPane.getRootPane(), p.getHelpIDString(), null);
                }
            }
        });
        JPanel dbaPanel2 = new JPanel(new BorderLayout());
        JPanel dbaPanel3 = new JPanel(new BorderLayout());
        DbaPanel dbaPanel5 = new DbaPanel(this.helpres, "Runtime_Setting_System_Control");
        dbaPanel5.setLayout((LayoutManager)new VerticalFlowLayout(0, 10, 10, true, false));
        JPanel systemControl = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.dbSqlstGroupBox.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.dbExtnpRangeField.setPreferredSize(new Dimension(50, 24));
        this.dbSqlstGroupBox.add(this.dbSqlstRadioButton1);
        this.dbSqlstGroupBox.add(this.dbSqlstRadioButton2);
        this.dbSqlstGroupBox.add(this.dbSqlstRadioButton3);
        systemControl.add(this.dbSqlstGroupBox);
        JPanel ddDdbmdPanel = new JPanel(new BorderLayout());
        ddDdbmdPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 20));
        ddDdbmdPanel.add((Component)this.ddDdbmdCheckBox, "Center");
        systemControl.add(ddDdbmdPanel);
        JPanel dbExtnpPanel = new JPanel(new BorderLayout());
        this.dbExtnpLabel.setPreferredSize(new Dimension(250, 19));
        dbExtnpPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 20));
        dbExtnpPanel.add((Component)this.dbExtnpLabel, "West");
        dbExtnpPanel.add((Component)this.dbExtnpRangeField, "Center");
        systemControl.add(dbExtnpPanel);
        PanelWithTitle jsyncTmpPane2 = new PanelWithTitle();
        this.filePath.setBorder(BorderFactory.createEtchedBorder());
        this.filePath.setPreferredSize(new Dimension(81, 22));
        this.jsyncTextArea1.setDisabledTextColor(Color.lightGray);
        this.jsyncTextArea1.setEditable(false);
        this.jsyncTextArea1.setText(this.res.getString("Disable_this_setting_will") + " " + this.res.getString("Could_be_dangerous_if_system") + " " + this.res.getString("System_crash_point_in_second"));
        dbaPanel2.setPreferredSize(new Dimension(14, 80));
        GroupBox jPanel7 = new GroupBox();
        JPanel jPanel8 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        ButtonGroup dbSqlstButtonGroup = new ButtonGroup();
        ButtonGroup blockConnectionButtonGroup = new ButtonGroup();
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        this.setTitle(this.res.getString("RunTime_Setting"));
        jPanel3.setPreferredSize(new Dimension(230, 10));
        this.writeToConfig_CheckBox.setSelected(true);
        this.writeToConfig_CheckBox.setText(this.res.getString("write_to_dmconfig"));
        this.writeToConfig_CheckBox.setForeground(Color.red);
        this.writeToConfig_CheckBox.addActionListener(new ReflectionAction(this, "writeToConfig_CheckBox_actionPerformed"));
        jPanel7.setPreferredSize(new Dimension(99, 180));
        jPanel7.setLayout((LayoutManager)new BorderLayout());
        jPanel8.setPreferredSize(new Dimension(18, 150));
        this.DatabaseNames_ComboBox.setName("Runtime_DatabaseNameComboBox");
        this.DatabaseNames_ComboBox.setPreferredSize(new Dimension(200, 24));
        this.DatabaseNames_ComboBox.addActionListener(new ReflectionAction(this, "DatabaseNames_ComboBox_actionPerformed"));
        panel1.setPreferredSize(new Dimension(1020, 600));
        help_Button.setBorder(BorderFactory.createRaisedBevelBorder());
        this.getContentPane().add(panel1);
        panel1.add((Component)jPanel1, "North");
        jPanel1.add(dbNameLabel);
        jPanel1.add(this.DatabaseNames_ComboBox);
        jPanel1.add(this.writeToConfig_CheckBox);
        panel1.add((Component)jPanel2, "South");
        jPanel2.add((Component)jPanel3, "West");
        jPanel2.add((Component)jPanel4, "Center");
        jPanel4.add((Component)this.OK_Button, null);
        jPanel4.add((Component)Cancel_Button, null);
        jPanel4.add((Component)help_Button, null);
        panel1.add((Component)this.tabbedPane, "Center");
        dbSqlstButtonGroup.add(this.dbSqlstRadioButton1);
        dbSqlstButtonGroup.add(this.dbSqlstRadioButton2);
        dbSqlstButtonGroup.add(this.dbSqlstRadioButton3);
        blockConnectionButtonGroup.add(this.blockConnectionRadioButton1);
        blockConnectionButtonGroup.add(this.blockConnectionRadioButton2);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.dbExthdRadioButton0);
        bg2.add(this.dbExthdRadioButton1);
        bg2.add(this.dbExthdRadioButton2);
        this.dbExthdGroupBox.setLabel(this.res.getString("DB_EXTHD"));
        this.dbExthdRadioButton0.setText(this.res.getString("db_exthd_option_0"));
        this.dbExthdRadioButton1.setText(this.res.getString("db_exthd_option_1"));
        this.dbExthdRadioButton2.setText(this.res.getString("db_exthd_option_2"));
        this.dbExthdRadioButton0.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RunTimeSettingDlg.this.dbExthdRadioButton0Changed(e);
            }
        });
        this.dbExthdRadioButton1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RunTimeSettingDlg.this.dbExthdRadioButton1Changed(e);
            }
        });
        this.dbExthdRadioButton2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RunTimeSettingDlg.this.dbExthdRadioButton2Changed(e);
            }
        });
        this.dbExthdTextField.unitComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RunTimeSettingDlg.this.setdbExthdTextField(e);
            }
        });
        this.dbExthdTextField.Value_Field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RunTimeSettingDlg.this.setdbExthdSelected();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RunTimeSettingDlg.this.setdbExthdSelected();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RunTimeSettingDlg.this.setdbExthdSelected();
            }
        });
        this.dbExthdGroupBox.add(this.dbExthdRadioButton0);
        this.dbExthdGroupBox.add(this.dbExthdRadioButton1);
        JPanel panel0 = new JPanel(new FlowLayout(0, 0, 0));
        panel0.add(this.dbExthdRadioButton2);
        panel0.add(this.dbExthdTextField);
        this.dbExthdGroupBox.add(panel0);
        systemControl.add(this.dbExthdGroupBox);
        dbaPanel2.add((Component)jPanel8, "North");
        dbaPanel3.add((Component)jPanel7, "North");
        dbaPanel5.add(jsyncTmpPane2);
        dbaPanel5.add(systemControl);
        jsyncTmpPane2.add(this.jsyncCheckBox);
        jsyncTmpPane2.add(this.jsyncTextArea1);
        DefaultComboBoxModel aComboModel = new DefaultComboBoxModel(this.assignDatabaseName());
        this.DatabaseNames_ComboBox.setModel((ComboBoxModel)aComboModel);
        this.diffIncBackupPanel = new DiffIncBackupPanel(this.helpres, "Runtime_Setting_Differential_Incremental_Backup");
        this.diffIncBackupPanel.addComponents(this.diffIncHt);
        this.backupPanel = new BackupPanel(this, this.helpres, "Runtime_Setting_Backup", this.diffIncBackupPanel);
        this.backupPanel.addComponents(this.backupHt);
        this.tabbedPane.add((Component)this.backupPanel, this.res.getString("Backup"));
        this.tabbedPane.add((Component)this.diffIncBackupPanel, this.res.getString("Differential_Incremental_Backup"));
        DbaPanel dbaPanel4 = new DbaPanel(this.helpres, "Runtime_Setting_File_Object");
        dbaPanel4.setLayout((LayoutManager)new VerticalFlowLayout(0, 5, 5, true, false));
        this.dbUsrfoCheckBox.setText(this.res.getString("Enable_usr_file_obj"));
        dbaPanel4.add(this.dbUsrfoCheckBox);
        GroupBox foPanel3 = new GroupBox();
        foPanel3.setLayout((LayoutManager)new BorderLayout());
        foPanel3.add((Component)this.foLabel, (Object)"West");
        foPanel3.add((Component)this.filePath, (Object)"Center");
        dbaPanel4.add((Component)foPanel3);
        GroupBox foPanel1 = new GroupBox();
        foPanel1.setLayout((LayoutManager)new GridLayout(2, 2, 0, 0));
        foPanel1.add((Component)this.dbFosubLabel);
        foPanel1.add((Component)this.dbFosubRadioButton2);
        foPanel1.add((Component)new JLabel());
        this.dbFosubRadioButton1.addActionListener(new ReflectionAction(this, "dbFosub_actionPerformed"));
        this.dbFosubRadioButton2.addActionListener(new ReflectionAction(this, "dbFosub_actionPerformed"));
        ButtonGroup dbFosubButtonGroup = new ButtonGroup();
        dbFosubButtonGroup.add(this.dbFosubRadioButton1);
        dbFosubButtonGroup.add(this.dbFosubRadioButton2);
        JPanel panel01 = new JPanel(new FlowLayout(0, 0, 0));
        panel01.add(this.dbFosubRadioButton1);
        panel01.add(new JLabel(" "));
        panel01.add(this.dbFosubRangeField);
        foPanel1.add((Component)panel01);
        dbaPanel4.add((Component)foPanel1);
        this.tabbedPane.add((Component)dbaPanel4, this.res.getString("File_object"));
        this.tabbedPane.add((Component)dbaPanel5, this.res.getString("System_control"));
        this.logSystemPanel = new NewLogSystemPanel(this.helpres, "Runtime_Setting_Log_System", true);
        this.logSystemPanel.setBorder(null);
        this.tabbedPane.add((Component)this.logSystemPanel, this.res.getString("Log_System"));
        this.logSystemPanel.addComponents(this.logSystemHt);
        this.charSetEncodingPanel = new CharSetEncodingPanel(this.helpres, "Runtime_Setting_Charset_Encoding", true);
        this.charSetEncodingPanel.setBorder(null);
        this.tabbedPane.add((Component)this.charSetEncodingPanel, this.res.getString("CharSetEncoding"));
        this.charSetEncodingPanel.addComponents(this.charSetEncodingHt);
        this.statisticsPanel = new StatisticsPanel(this.helpres, "Runtime_Setting_Statistics", true);
        this.statisticsPanel.setBorder(null);
        this.tabbedPane.add((Component)this.statisticsPanel, this.res.getString("Statistics"));
        this.statisticsPanel.addComponents(this.statisticsHt);
        this.autoIndexPanel = new AutoIndexPanel(this.helpres, "Runtime_Setting_Auto_Index", true);
        this.autoIndexPanel.setBorder(null);
        this.tabbedPane.add((Component)this.autoIndexPanel, this.res.getString("Auto_Index"));
        this.autoIndexPanel.addComponents(this.autoIndexHt);
        this.scheduleDaemonPanel = new ScheduleDaemonPanel(this.helpres, "Runtime_Setting_Schedule_Deamon", true);
        this.scheduleDaemonPanel.setBorder(null);
        this.tabbedPane.add((Component)this.scheduleDaemonPanel, this.res.getString("Schedule_Daemon"));
        this.scheduleDaemonPanel.addComponents(this.scheduleDeamonHt);
        this.blockConnectionGroupBox.setPreferredSize(new Dimension(131, 100));
        this.blockConnectionGroupBox.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.blockConnectionGroupBox.add(this.blockConnectionRadioButton1);
        this.blockConnectionGroupBox.add(this.blockConnectionRadioButton2);
        this.dbExthdRadioButton0.setName("ExtendThresholdRadioButton0");
        this.dbExthdRadioButton1.setName("ExtendThresholdRadioButton1");
        this.dbExthdRadioButton2.setName("ExtendThresholdRadioButton2");
        this.dbExthdTextField.setName("ExtendThresholdTextField");
        this.setComponentStatus(false);
        if (!this.fromJSvrMgr) {
            DbaPanel connectionPanel = new DbaPanel(this.helpres, "Runtime_Setting_Connection");
            connectionPanel.setLayout(new BorderLayout());
            connectionPanel.add((Component)this.blockConnectionGroupBox, "North");
            this.tabbedPane.add((Component)connectionPanel, this.res.getString("Connection"));
            if (this.dbname != null) {
                this.DatabaseNames_ComboBox.setSelectedItem(this.dbname);
                this.DatabaseNames_ComboBox.setEnabled(false);
                Preferences.selectedSection = this.dbname;
            }
            this.backupPanel.dbBksvrCheckBoxActionPerformed(null);
        }
        this.pack();
    }

    private void dbExthdRadioButton0Changed(ItemEvent e) {
        if (e.getStateChange() == 1 && this.dbExthdRadioButton0.isSelected()) {
            Integer value = this.dbExthdTextField.getValue();
            int unitType = this.dbExthdTextField.getUnit();
            if (value != null && value != -1) {
                this.dbExthdTextField.setValue(-1);
            }
            if (unitType != 0) {
                this.dbExthdTextField.setUnit(0);
            }
            this.dbExthdRadioButton0.requestFocus();
        }
    }

    private void dbExthdRadioButton1Changed(ItemEvent e) {
        if (e.getStateChange() == 1 && this.dbExthdRadioButton1.isSelected()) {
            Integer value = this.dbExthdTextField.getValue();
            int unitType = this.dbExthdTextField.getUnit();
            if (value != null && value != 0) {
                this.dbExthdTextField.setValue(0);
            }
            if (unitType != 0) {
                this.dbExthdTextField.setUnit(0);
            }
            this.dbExthdRadioButton1.requestFocus();
        }
    }

    private void dbExthdRadioButton2Changed(ItemEvent e) {
        boolean enabled = this.dbExthdRadioButton2.isSelected() && this.dbExthdRadioButton2.isEnabled();
        this.dbExthdTextField.setEnabled(enabled);
        if (e.getStateChange() == 1 && this.dbExthdRadioButton2.isSelected()) {
            Integer value = this.dbExthdTextField.getValue();
            int unitType = this.dbExthdTextField.getUnit();
            int maxExthd = this.getMaxExthd(unitType);
            if (value != null && (value > maxExthd || value < 1)) {
                int defaultExthd = this.getDefaultExthd(unitType);
                this.dbExthdTextField.setValue(defaultExthd);
            }
            this.dbExthdTextField.requestFocus();
        }
    }

    private void setdbExthdTextField(ItemEvent e) {
        if (e.getStateChange() == 1) {
            int unitType = this.dbExthdTextField.getUnit();
            int maxExthd = this.getMaxExthd(unitType);
            this.dbExthdTextField.setMax(maxExthd);
            if (this.dbExthdRadioButton2.isSelected()) {
                int defaultExthd = this.getDefaultExthd(unitType);
                this.dbExthdTextField.setValue(defaultExthd);
            }
        }
    }

    private void dbExthdFocusLost() {
        Integer value = this.dbExthdTextField.getValue();
        int unitType = this.dbExthdTextField.getUnit();
        int maxExthd = this.getMaxExthd(unitType);
        if (value == null) {
            int defaultExthd = this.getDefaultExthd(unitType);
            this.dbExthdTextField.setValue(defaultExthd);
        } else if (value > maxExthd) {
            this.dbExthdTextField.setValue(maxExthd);
        } else if (value < -1) {
            this.dbExthdTextField.setValue(-1);
        }
    }

    private void setdbExthdSelected() {
        Integer value = this.dbExthdTextField.getValue();
        if (value != null) {
            if (value == -1) {
                if (!this.dbExthdRadioButton0.isSelected()) {
                    this.dbExthdRadioButton0.setSelected(true);
                }
            } else if (value == 0) {
                if (!this.dbExthdRadioButton1.isSelected()) {
                    this.dbExthdRadioButton1.setSelected(true);
                }
            } else if (!this.dbExthdRadioButton2.isSelected()) {
                this.dbExthdRadioButton2.setSelected(true);
            }
        }
    }

    private int getMaxExthd(int unitType) {
        int result = 0x100000 / dbPageSize * 4;
        if (unitType == 1) {
            result = 4096;
        } else if (unitType == 2) {
            result = 4;
        }
        return result;
    }

    private int getDefaultExthd(int unitType) {
        int result = 100;
        if (unitType == 0) {
            result = 102400 / dbPageSize;
        } else if (unitType == 2) {
            result = 1;
        }
        return result;
    }

    public void setDiffIncPanelEnable(boolean flag) {
        this.tabbedPane.setEnabledAt(1, flag);
    }

    public String getBMode() {
        return this.strBMode;
    }

    public Vector assignDatabaseName() {
        Vector<String> v = JdmConfig.getDatabaseNames("dmconfig.ini", false, true);
        v.insertElementAt(" ", 0);
        return v;
    }

    public void dbFosub_actionPerformed(ActionEvent e) {
        if (this.dbFosubRadioButton1.isSelected()) {
            this.dbFosubRangeField.setValue("");
            this.dbFosubRangeField.setEnabled(false);
        } else {
            this.dbFosubRangeField.setEnabled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void DatabaseNames_ComboBox_actionPerformed(ActionEvent e) {
        String dbname;
        if (this.DatabaseNames_ComboBox.getSelectedIndex() == 0) {
            this.setComponentStatus(false);
            if (this.fromJSvrMgr && this.db_connection != null) {
                DbaObject.close(this.db_connection);
                this.db_connection = null;
            }
            this.writeToConfig_CheckBox.setSelected(true);
            this.writeToConfig_CheckBox.setEnabled(true);
            return;
        }
        Preferences.selectedSection = dbname = this.DatabaseNames_ComboBox.getSelectedItem().toString().trim();
        dbPageSize = JdmConfig.getDBPageSize(Preferences.selectedSection);
        JdmConfig config = new JdmConfig();
        this.isLocalHost = config.isLocalHost(dbname);
        if (this.fromJSvrMgr) {
            DatabaseConnection connection;
            UserPasswordDlg dlg = null;
            dlg = SmFrame.isWindows() ? new UserPasswordDlg((Dialog)this, dbname, "RunTimeSettingDlgHelpIDInformation") : new UserPasswordDlg(this, "", true, dbname, "RunTimeSettingDlgHelpIDInformation");
            GuiUt.setCenterLocation(this, dlg);
            dlg.show();
            if (!dlg.getResult()) {
                this.setComponentStatus(false);
                return;
            }
            if (this.db_connection != null) {
                DbaObject.close(this.db_connection);
            }
            if ((connection = new DatabaseConnection(dbname, dlg.getUserName(), dlg.getPassword(), this)) == null || !connection.result) {
                connection = null;
                this.setComponentStatus(false);
                return;
            }
            DefaultSvrmgrAuthority authority = new DefaultSvrmgrAuthority(connection);
            if (!authority.isAboveDba()) {
                authority.errorIsNotDBA(this);
                this.setComponentStatus(false);
                connection.disconnect();
                return;
            }
            this.setComponentStatus(true);
            this.db_connection = connection.dbconn;
            this.getConnectOption();
        } else {
            this.setComponentStatus(true);
            this.getConnectOption();
        }
        if (this.isLocalHost) {
            this.writeToConfig_CheckBox.setSelected(true);
            this.writeToConfig_CheckBox.setEnabled(true);
            return;
        }
        this.writeToConfig_CheckBox.setSelected(false);
        this.writeToConfig_CheckBox.setEnabled(false);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        if (this.fromJSvrMgr) {
            if (this.db_connection != null) {
                DbaObject.close(this.db_connection);
            }
            this.db_connection = null;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void setComponentStatus(boolean flag) {
        this.OK_Button.setEnabled(flag);
        this.filePath.setEnabled(flag);
        this.foLabel.setEnabled(flag);
        this.jsyncCheckBox.setEnabled(flag);
        this.jsyncTextArea1.setEnabled(flag);
        if (flag) {
            this.jsyncTextArea1.setForeground(Color.black);
            this.dbSqlstGroupBox.setForeground(Color.black);
            this.blockConnectionGroupBox.setForeground(Color.black);
            this.dbExthdGroupBox.setForeground(Color.black);
        } else {
            this.jsyncTextArea1.setForeground(Color.gray);
            this.dbSqlstGroupBox.setForeground(Color.gray);
            this.blockConnectionGroupBox.setForeground(Color.gray);
            this.dbExthdGroupBox.setForeground(Color.gray);
        }
        this.dbSqlstGroupBox.setEnabled(flag);
        this.dbSqlstRadioButton1.setEnabled(flag);
        this.dbSqlstRadioButton2.setEnabled(flag);
        this.dbSqlstRadioButton3.setEnabled(flag);
        this.ddDdbmdCheckBox.setEnabled(flag);
        this.dbExtnpLabel.setEnabled(flag);
        this.dbUsrfoCheckBox.setEnabled(flag);
        this.dbFosubLabel.setEnabled(flag);
        this.dbFosubRadioButton1.setEnabled(flag);
        this.dbFosubRadioButton2.setEnabled(flag);
        this.dbFosubRangeField.setEnabled(flag);
        this.dbExtnpRangeField.setEnabled(flag);
        this.blockConnectionGroupBox.setEnabled(flag);
        this.blockConnectionRadioButton1.setEnabled(flag);
        this.blockConnectionRadioButton2.setEnabled(flag);
        this.dbExthdRadioButton0.setEnabled(flag);
        this.dbExthdRadioButton1.setEnabled(flag);
        this.dbExthdRadioButton2.setEnabled(flag);
        this.dbExthdTextField.setEnabled(flag);
        this.backupPanel.setEnabled(flag);
        this.diffIncBackupPanel.setEnabled(flag);
        this.logSystemPanel.setEnabled(flag);
        this.charSetEncodingPanel.setEnabled(flag);
        this.statisticsPanel.setAllEnabled(flag);
        this.autoIndexPanel.setAllEnabled(flag);
        this.scheduleDaemonPanel.setAllEnabled(flag);
    }

    public void writeToConfig_CheckBox_actionPerformed(ActionEvent e) {
        if (this.writeToConfig_CheckBox.isSelected()) {
            this.writeToConfig_CheckBox.setForeground(Color.red);
        } else {
            this.writeToConfig_CheckBox.setForeground(Color.blue);
        }
    }

    private void getConnectOption() {
        try {
            CallableStatement cstmt = null;
            cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('fodir', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.executeQuery();
            this.fodir = cstmt.getString(1);
            if (this.fodir.length() != 0 && (this.fodir.endsWith("/") || this.fodir.endsWith("\\"))) {
                this.fodir = this.fodir.substring(0, this.fodir.length() - 1);
            }
            this.filePath.setText(this.fodir);
            cstmt.close();
            cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('usrfo', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.executeQuery();
            this.usrfo = JavaTypeUtil.parseInt(cstmt.getString(1), this);
            this.dbUsrfoCheckBox.setSelected(this.usrfo == 1);
            cstmt.close();
            cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('jsync', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.executeQuery();
            this.jsync = JavaTypeUtil.parseInt(cstmt.getString(1), this);
            cstmt.close();
            this.jsyncCheckBox.setSelected(this.jsync == 1);
            cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('sqlst', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.executeQuery();
            this.sqlst = JavaTypeUtil.parseInt(cstmt.getString(1), this);
            switch (this.sqlst) {
                case 0: {
                    this.dbSqlstRadioButton1.setSelected(true);
                    break;
                }
                case 1: {
                    this.dbSqlstRadioButton2.setSelected(true);
                    break;
                }
                case 2: {
                    this.dbSqlstRadioButton3.setSelected(true);
                }
            }
            cstmt.close();
            cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('fosub', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.executeQuery();
            this.fosub = JavaTypeUtil.parseInt(cstmt.getString(1), this);
            if (this.fosub == 0) {
                this.dbFosubRadioButton1.setSelected(true);
                this.dbFosubRangeField.setEnabled(false);
                this.dbFosubRangeField.setInitValue(100);
            } else {
                this.dbFosubRadioButton2.setSelected(true);
                this.dbFosubRangeField.setEnabled(true);
                this.dbFosubRangeField.setInitValue(this.fosub);
            }
            cstmt.close();
            cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('ddbmd', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.executeQuery();
            this.ddbmd = JavaTypeUtil.parseInt(cstmt.getString(1), this);
            this.ddDdbmdCheckBox.setSelected(this.ddbmd == 1);
            cstmt.close();
            cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('extnp', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.executeQuery();
            this.extnp = JavaTypeUtil.parseInt(cstmt.getString(1), this);
            this.dbExtnpRangeField.setValue(this.extnp);
            cstmt.close();
            cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('exthd', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.executeQuery();
            this.exthd = cstmt.getString(1).trim();
            this.dbExthdTextField.setInitValue(this.exthd);
            cstmt.close();
            if (!this.fromJSvrMgr) {
                cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('blockcon', ?)}");
                cstmt.registerOutParameter(1, 12);
                cstmt.executeQuery();
                this.block = JavaTypeUtil.parseInt(cstmt.getString(1), this);
                switch (this.block) {
                    case 0: {
                        this.blockConnectionRadioButton1.setSelected(true);
                        break;
                    }
                    case 1: {
                        this.blockConnectionRadioButton2.setSelected(true);
                    }
                }
                cstmt.close();
            }
            Enumeration e1 = this.backupHt.elements();
            ConfigItem item1 = null;
            while (e1.hasMoreElements()) {
                item1 = (ConfigItem)e1.nextElement();
                String keyword = item1.getKeyword();
                String value = "";
                if (keyword.equalsIgnoreCase("bmode")) {
                    Statement stmt = this.db_connection.createStatement();
                    ResultSet rs = stmt.executeQuery("select ID, INFO, VALUE from SYSINFO where ID='0705'");
                    rs.next();
                    this.strBMode = rs.getString(3);
                    rs.close();
                    stmt.close();
                    if (this.strBMode.equalsIgnoreCase("NON-BACKUP")) {
                        value = "0";
                    } else if (this.strBMode.equalsIgnoreCase("BACKUP-DATA")) {
                        value = "1";
                    } else if (this.strBMode.equalsIgnoreCase("BACKUP-DATA-AND-BLOB")) {
                        value = "2";
                    } else {
                        System.out.println("illegal backup mode" + this.strBMode + ".");
                    }
                } else {
                    cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('" + keyword + "', ?)}");
                    cstmt.registerOutParameter(1, 12);
                    cstmt.execute();
                    value = cstmt.getString(1);
                    cstmt.close();
                }
                item1.setValue(value);
                item1.initComponent();
            }
            Enumeration e2 = this.diffIncHt.elements();
            ConfigItem item2 = null;
            while (e2.hasMoreElements()) {
                item2 = (ConfigItem)e2.nextElement();
                cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('" + item2.getKeyword() + "', ?)}");
                cstmt.registerOutParameter(1, 12);
                cstmt.execute();
                item2.setValue(cstmt.getString(1));
                item2.initComponent();
                cstmt.close();
            }
            this.backupPanel.dbBksvrCheckBoxActionPerformed(null);
            Enumeration e = this.logSystemHt.elements();
            ConfigItem item = null;
            while (e.hasMoreElements()) {
                item = (ConfigItem)e.nextElement();
                cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('" + item.getKeyword() + "', ?)}");
                cstmt.registerOutParameter(1, 12);
                cstmt.execute();
                item.setValue(cstmt.getString(1));
                item.initComponent();
                cstmt.close();
            }
            Enumeration charSetEncodingEnum = this.charSetEncodingHt.elements();
            ConfigItem charSetEncodingItem = null;
            while (charSetEncodingEnum.hasMoreElements()) {
                charSetEncodingItem = (ConfigItem)charSetEncodingEnum.nextElement();
                Statement stmt = this.db_connection.createStatement();
                ResultSet rs = stmt.executeQuery("select GETSYSINFO('" + charSetEncodingItem.getKeyword() + "')");
                String code = null;
                while (rs.next()) {
                    code = rs.getString(1).trim();
                }
                charSetEncodingItem.setValue(code);
                charSetEncodingItem.initComponent();
                rs.close();
                stmt.close();
            }
            Enumeration e3 = this.statisticsHt.elements();
            ConfigItem item3 = null;
            while (e3.hasMoreElements()) {
                item3 = (ConfigItem)e3.nextElement();
                cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('" + item3.getKeyword() + "', ?)}");
                cstmt.registerOutParameter(1, 12);
                cstmt.execute();
                item3.setValue(cstmt.getString(1));
                item3.initComponent();
                cstmt.close();
            }
            this.statisticsPanel.stsvrCheckBoxActionPerformed(null);
            Enumeration e4 = this.autoIndexHt.elements();
            ConfigItem item4 = null;
            while (e4.hasMoreElements()) {
                item4 = (ConfigItem)e4.nextElement();
                cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('" + item4.getKeyword() + "', ?)}");
                cstmt.registerOutParameter(1, 12);
                cstmt.execute();
                item4.setValue(cstmt.getString(1));
                item4.initComponent();
                cstmt.close();
            }
            this.autoIndexPanel.idxsvrCheckBoxActionPerformed(null);
            Enumeration e5 = this.scheduleDeamonHt.elements();
            ConfigItem item5 = null;
            while (e5.hasMoreElements()) {
                item5 = (ConfigItem)e5.nextElement();
                cstmt = this.db_connection.prepareCall("{call GETSYSTEMOPTION('" + item5.getKeyword() + "', ?)}");
                cstmt.registerOutParameter(1, 12);
                cstmt.execute();
                item5.setValue(cstmt.getString(1));
                item5.initComponent();
                cstmt.close();
            }
            this.scheduleDaemonPanel.schsvCheckBoxActionPerformed(null);
        }
        catch (SQLException sqle) {
            this.backupPanel.dbBksvrCheckBoxActionPerformed(null);
            sqle.printStackTrace();
            GuiUt.showErrorDlg(this, sqle.getMessage(), "");
        }
    }

    public void OK_Button_actionPerformed(ActionEvent e) {
        int set_usrfo = 0;
        int set_sqlst = 1;
        int set_fosub = 0;
        int set_extnp = 20;
        int set_ddbmd = 0;
        int set_jsync = 1;
        int set_block = 0;
        String set_fodir = "";
        String set_exthd = EXTHD_DEFAULT_STRING;
        Statement stmt = null;
        try {
            String key;
            stmt = this.db_connection.createStatement();
            set_fodir = this.filePath.getText();
            if (!this.fodir.equals(set_fodir)) {
                stmt.execute("Call SETSYSTEMOPTION('fodir', '" + set_fodir + "')");
            }
            int n = set_jsync = this.jsyncCheckBox.isSelected() ? 1 : 0;
            if (this.jsync != set_jsync) {
                stmt.execute("Call SETSYSTEMOPTION('JSYNC','" + set_jsync + "')");
            }
            int n2 = set_usrfo = this.dbUsrfoCheckBox.isSelected() ? 1 : 0;
            if (this.usrfo != set_usrfo) {
                stmt.execute("Call SETSYSTEMOPTION('usrfo','" + set_usrfo + "')");
            }
            if (this.sqlst != (set_sqlst = this.dbSqlstRadioButton1.isSelected() ? 0 : (this.dbSqlstRadioButton2.isSelected() ? 1 : 2))) {
                stmt.execute("Call SETSYSTEMOPTION('sqlst', '" + set_sqlst + "')");
            }
            if (this.fosub != (set_fosub = this.dbFosubRadioButton1.isSelected() ? 0 : (this.dbFosubRangeField.getValue() == null ? 100 : this.dbFosubRangeField.getValue()))) {
                stmt.execute("Call SETSYSTEMOPTION('fosub','" + set_fosub + "')");
            }
            int n3 = set_ddbmd = this.ddDdbmdCheckBox.isSelected() ? 1 : 0;
            if (this.ddbmd != set_ddbmd) {
                stmt.execute("Call SETSYSTEMOPTION('ddbmd','" + set_ddbmd + "')");
            }
            if (this.extnp != (set_extnp = this.dbExtnpRangeField.getValue().intValue())) {
                stmt.execute("Call SETSYSTEMOPTION('extnp','" + set_extnp + "')");
            }
            if (!this.exthd.equalsIgnoreCase(set_exthd = this.dbExthdTextField.getStringValue())) {
                stmt.execute("Call SETSYSTEMOPTION('exthd', '" + set_exthd + "')");
            }
            if (!this.fromJSvrMgr) {
                int n4 = set_block = this.blockConnectionRadioButton1.isSelected() ? 0 : 1;
                if (this.block != set_block) {
                    stmt.execute("Call SETSYSTEMOPTION('blockcon','" + set_block + "')");
                }
            }
            Enumeration diEnum = this.diffIncHt.elements();
            ConfigItem diConfigItem = null;
            while (diEnum.hasMoreElements()) {
                diConfigItem = (ConfigItem)diEnum.nextElement();
                if (!diConfigItem.isChanged()) continue;
                stmt.execute("call SETSYSTEMOPTION('" + diConfigItem.getKeyword() + "', '" + diConfigItem.getStringValue() + "')");
            }
            Enumeration backupEnum = this.backupHt.elements();
            ConfigItem backupConfigItem = null;
            while (backupEnum.hasMoreElements()) {
                backupConfigItem = (ConfigItem)backupEnum.nextElement();
                if (!backupConfigItem.isChanged()) continue;
                key = backupConfigItem.getKeyword();
                if (key.trim().equalsIgnoreCase("bmode")) {
                    ((JdbcOdbcConnection)this.db_connection).setOption(1120, this.backupPanel.getBMode());
                    continue;
                }
                String sql = "call SETSYSTEMOPTION('" + backupConfigItem.getKeyword() + "', '" + backupConfigItem.getStringValue() + "')";
                stmt.execute(sql);
            }
            Enumeration e1 = this.logSystemHt.elements();
            ConfigItem item = null;
            while (e1.hasMoreElements()) {
                item = (ConfigItem)e1.nextElement();
                if (!item.isChanged()) continue;
                stmt.execute("call SETSYSTEMOPTION('" + item.getKeyword() + "', '" + item.getStringValue() + "')");
            }
            Enumeration e2 = this.charSetEncodingHt.elements();
            ConfigItem item2 = null;
            while (e2.hasMoreElements()) {
                item2 = (ConfigItem)e2.nextElement();
                key = item2.getKeyword();
                String value = item2.getStringValue();
                if (!item2.isChanged()) continue;
                if (key.equalsIgnoreCase("clilcode") && !value.equalsIgnoreCase((String)CharSetEncodingPanel.charSetArrayList.get(0))) {
                    stmt.execute("set client_char_set '" + value + "'");
                }
                if (!key.equalsIgnoreCase("errlcode") || value.equalsIgnoreCase((String)CharSetEncodingPanel.errCharSetArrayList.get(0))) continue;
                stmt.execute("set errmsg_char_set '" + value + "'");
            }
            Enumeration e3 = this.statisticsHt.elements();
            ConfigItem item3 = null;
            while (e3.hasMoreElements()) {
                item3 = (ConfigItem)e3.nextElement();
                if (!item3.isChanged()) continue;
                stmt.execute("call SETSYSTEMOPTION('" + item3.getKeyword() + "', '" + item3.getStringValue() + "')");
            }
            Enumeration e4 = this.autoIndexHt.elements();
            ConfigItem item4 = null;
            while (e4.hasMoreElements()) {
                item4 = (ConfigItem)e4.nextElement();
                if (!item4.isChanged()) continue;
                stmt.execute("call SETSYSTEMOPTION('" + item4.getKeyword() + "', '" + item4.getStringValue() + "')");
            }
            Enumeration e5 = this.scheduleDeamonHt.elements();
            ConfigItem item5 = null;
            while (e5.hasMoreElements()) {
                item5 = (ConfigItem)e5.nextElement();
                if (!item5.isChanged()) continue;
                stmt.execute("call SETSYSTEMOPTION('" + item5.getKeyword() + "', '" + item5.getStringValue() + "')");
            }
            DbaObject.close(stmt);
        }
        catch (SQLException setex) {
            GuiUt.showErrorDlg(this, setex.getMessage(), null);
            DbaObject.close(stmt);
            return;
        }
        catch (Exception ex) {
            GuiUt.showErrorDlg(this, ex.getMessage(), null);
            return;
        }
        if (this.writeToConfig_CheckBox.isSelected()) {
            JdmConfig dmconfig = new JdmConfig();
            dmconfig.fileOpen("dmconfig.ini", this.DatabaseNames_ComboBox.getSelectedItem().toString().trim(), "r+");
            if (set_fodir.length() == 0) {
                dmconfig.procDelete("DB_FODIR", 0);
            } else {
                dmconfig.insertPara("DB_FODIR", set_fodir, 4096);
            }
            if (this.usrfo != set_usrfo) {
                dmconfig.insertPara("DB_USRFO", new Integer(set_usrfo), 8192);
            }
            if (this.sqlst != set_sqlst) {
                dmconfig.insertPara("DB_SQLST", new Integer(set_sqlst), 8192);
            }
            if (this.fosub != set_fosub) {
                dmconfig.insertPara("DB_FOSUB", new Integer(set_fosub), 8192);
            }
            if (this.ddbmd != set_ddbmd) {
                dmconfig.insertPara("DD_DDBMD", new Integer(set_ddbmd), 8192);
            }
            if (this.extnp != set_extnp) {
                dmconfig.insertPara("DB_EXTNP", new Integer(set_extnp), 8192);
            }
            if (!this.exthd.equalsIgnoreCase(set_exthd)) {
                dmconfig.insertPara("DB_EXTHD", set_exthd, 4096);
            }
            Enumeration backupEnum = this.backupHt.elements();
            ConfigItem backupConfigItem = null;
            while (backupEnum.hasMoreElements()) {
                backupConfigItem = (ConfigItem)backupEnum.nextElement();
                if (!backupConfigItem.isChanged()) continue;
                backupConfigItem.saveChange(dmconfig, "db_");
            }
            Enumeration diEnum = this.diffIncHt.elements();
            ConfigItem diConfigItem = null;
            while (diEnum.hasMoreElements()) {
                diConfigItem = (ConfigItem)diEnum.nextElement();
                if (!diConfigItem.isChanged()) continue;
                diConfigItem.saveChange(dmconfig, "db_");
            }
            Enumeration e1 = this.logSystemHt.elements();
            ConfigItem item = null;
            while (e1.hasMoreElements()) {
                item = (ConfigItem)e1.nextElement();
                if (!item.isChanged()) continue;
                item.saveChange(dmconfig, "db_");
            }
            Enumeration e2 = this.charSetEncodingHt.elements();
            ConfigItem item2 = null;
            while (e2.hasMoreElements()) {
                item2 = (ConfigItem)e2.nextElement();
                if (!item2.isChanged()) continue;
                item2.saveChange(dmconfig, "db_");
            }
            Enumeration e3 = this.statisticsHt.elements();
            ConfigItem item3 = null;
            while (e3.hasMoreElements()) {
                item3 = (ConfigItem)e3.nextElement();
                if (!item3.isChanged()) continue;
                item3.saveChange(dmconfig, "db_");
            }
            Enumeration e4 = this.autoIndexHt.elements();
            ConfigItem item4 = null;
            while (e4.hasMoreElements()) {
                item4 = (ConfigItem)e4.nextElement();
                if (!item4.isChanged()) continue;
                item4.saveChange(dmconfig, "db_");
            }
            Enumeration e5 = this.scheduleDeamonHt.elements();
            ConfigItem item5 = null;
            while (e5.hasMoreElements()) {
                item5 = (ConfigItem)e5.nextElement();
                if (!item5.isChanged()) continue;
                item5.saveChange(dmconfig, "db_");
            }
            dmconfig.fileClose();
        }
        GuiUt.showInformationDlg(this, this.res.getString("Runtime_setting_is_successfully"));
        this.Cancel_Button_actionPerformed(null);
    }
}

