/*
 * Decompiled with CFR 0.152.
 */
package DmEditor.AllSectionInfo.userfiles;

import DmEditor.AllSectionInfo.userfiles.UDFNRowInfo;
import dbaut.GuiUt;
import dbaut.Logical_file;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class UDFNTableCols
extends AbstractTableModel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale());
    private String[] columnNames = new String[]{this.res.getString("Logical_File_Name"), this.res.getString("Physical_File_Name"), this.res.getString("Raw_Device_Offset"), this.res.getString("Page_Size")};
    private Vector data = new Vector();

    public void setTableHeader(String colNameONE, String colNameTWO, String colNameTHREE, String colNameFOUR) {
        this.columnNames[0] = colNameONE;
        this.columnNames[1] = colNameTWO;
        this.columnNames[2] = colNameTHREE;
        this.columnNames[3] = colNameFOUR;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col].toString().trim();
    }

    @Override
    public Object getValueAt(int row, int col) {
        UDFNRowInfo rowData = (UDFNRowInfo)this.data.elementAt(row);
        String s = rowData.getValueAt(col).toString().trim();
        if (col == 2 && s.equals("-1")) {
            s = "";
        }
        return s;
    }

    public Class getColumnClass(int c) {
        UDFNRowInfo rowData = (UDFNRowInfo)this.data.elementAt(0);
        return rowData.getValueAt(c).getClass();
    }

    public void addValue(UDFNRowInfo newData) {
        this.data.addElement(newData);
    }

    public void removeValue(int x) {
        this.data.remove(x);
    }

    public void removeAll() {
        this.data.removeAllElements();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 2) {
            if (GuiUt.isWindows()) {
                return false;
            }
            String ss = this.getValueAt(row, 1).toString();
            return (ss = ss.toLowerCase()).startsWith("/dev/");
        }
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            return;
        }
        Object orig_value = this.getValueAt(row, col);
        if (value.toString().trim().length() <= 0) {
            return;
        }
        UDFNRowInfo rowData = (UDFNRowInfo)this.data.elementAt(row);
        rowData.setValueAt(value, col);
    }

    public UDFNRowInfo getRow(int row) {
        return (UDFNRowInfo)this.data.elementAt(row);
    }

    public UDFNRowInfo getRowByLogicalName(String logname) {
        Enumeration e = this.data.elements();
        UDFNRowInfo rowData = null;
        while (e.hasMoreElements()) {
            rowData = (UDFNRowInfo)e.nextElement();
            if (((String)rowData.getValueAt(0)).compareTo(logname) != 0) continue;
            return rowData;
        }
        return null;
    }

    public Logical_file newLogicalFileFromRow(int row) {
        UDFNRowInfo rowData = (UDFNRowInfo)this.data.elementAt(row);
        return rowData.newLogicalFile();
    }
}

