/*
 * Decompiled with CFR 0.152.
 */
package DmEditor.AllSectionInfo;

import DmEditor.AllSectionInfo.DetailInfo;
import DmEditor.MainDlg;
import DmEditor.MainFrame;
import DmEditor.Preferences.Preferences;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.JPanel;

public class DetailParent
extends JPanel
implements LocaleChangeListener {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale());
    public DbaButton saveButton = new DbaButton(new Dimension(100, 22), false);
    private DbaButton resetButton = new DbaButton(new Dimension(100, 22), false);
    private DetailInfo myDetailInfo = null;
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 22), false);
    private Component comp = null;
    private DbaButton helpButton = new DbaButton(new Dimension(100, 22), false);
    static boolean userFilePaneChange = false;
    ActionListener cshListener = null;

    public DetailParent(Component paraComp, DetailInfo paraDetailInfo) {
        try {
            this.comp = paraComp;
            this.myDetailInfo = paraDetailInfo;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
        JPanel jPanel1 = new JPanel();
        this.setPreferredSize(new Dimension(600, 550));
        this.setLayout(new BorderLayout());
        jPanel1.setPreferredSize(new Dimension(10, 30));
        jPanel1.setLayout(new FlowLayout(2, 3, 3));
        this.saveButton.setMargin(new Insets(0, 0, 0, 0));
        this.saveButton.setMnemonic('S');
        this.saveButton.setText(this.res.getString("Save"));
        this.saveButton.addActionListener(new ReflectionAction(this, "saveButton_actionPerformed"));
        this.resetButton.setMargin(new Insets(0, 0, 0, 0));
        this.resetButton.setMnemonic('T');
        this.resetButton.setText(this.res.getString("Reset"));
        this.resetButton.addActionListener(new ReflectionAction(this, "resetButton_actionPerformed"));
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText(this.res.getString("Cancel"));
        this.cancelButton.addActionListener(new ReflectionAction(this, "cancelButton_actionPerformed"));
        this.helpButton.setText(this.res.getString("Help"));
        this.helpButton.setMnemonic('E');
        this.saveButton.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/save.gif"));
        this.resetButton.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/done.gif"));
        this.cancelButton.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        this.helpButton.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/help.gif"));
        this.helpButton.setMargin(new Insets(0, 0, 0, 0));
        if (Preferences.mainHB == null) {
            this.helpButton.setEnabled(false);
        } else {
            this.cshListener = new CSH.DisplayHelpFromSource((HelpBroker)Preferences.mainHB);
            this.helpButton.addActionListener(this.cshListener);
        }
        this.add((Component)jPanel1, "South");
        jPanel1.add((Component)this.saveButton, null);
        jPanel1.add((Component)this.resetButton, null);
        if (this.comp instanceof MainDlg) {
            jPanel1.add((Component)this.cancelButton, null);
        }
        jPanel1.add((Component)this.helpButton, null);
        this.setName("DetailParentPanel");
        this.saveButton.setName("SaveButton");
        this.resetButton.setName("ResetButton");
        this.cancelButton.setName("CancelButton");
        this.helpButton.setName("HelpButton");
    }

    public void saveChange() {
        this.myDetailInfo.saveChange();
    }

    public void saveButton_actionPerformed(ActionEvent e) {
        String behavior = Preferences.behavior;
        boolean isChange = false;
        ArrayList side = null;
        this.myDetailInfo.editingStopped();
        if (behavior.equals("normal")) {
            isChange = this.myDetailInfo.isChanged();
            side = this.myDetailInfo.isChangedSide();
        }
        this.saveChange();
        this.myDetailInfo.initConfigDetailInfo();
        if (behavior.equals("normal")) {
            if (userFilePaneChange) {
                GuiUt.showInformationDlg(this.comp, this.res.getString("Config_key_word_setting_saved_successfully") + "\n" + this.res.getString("You_need_to_restart"));
            } else if (isChange && side.size() > 0) {
                GuiUt.showInformationDlg(this.comp, this.res.getString("Config_key_word_setting_saved_successfully") + "\n" + this.res.getString("You_need_to_restart") + "\n" + side.toString());
            } else {
                GuiUt.showInformationDlg(this.comp, this.res.getString("Config_key_word_setting_saved_successfully"));
            }
        } else {
            GuiUt.showInformationDlg(this.comp, this.res.getString("Config_key_word_setting_saved_successfully"));
        }
        if (this.comp instanceof MainDlg) {
            MainDlg dlg = (MainDlg)this.comp;
            dlg.setVisible(false);
            dlg.dispose();
        }
        userFilePaneChange = false;
    }

    public void resetButton_actionPerformed(ActionEvent e) {
        this.myDetailInfo.editingStopped();
        Preferences.stateValue = this.myDetailInfo.getSelectedIndex();
        this.myDetailInfo.initExistDetailInfo();
        if (this.myDetailInfo.isError) {
            this.saveButton.setEnabled(false);
        } else {
            this.saveButton.setEnabled(true);
        }
        this.revalidate();
        this.repaint();
        GuiUt.showInformationDlg(this.comp, this.res.getString("Config_key_word_setting_reset_successfully"));
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        if (this.comp instanceof MainDlg) {
            MainDlg dlg = (MainDlg)this.comp;
            dlg.setVisible(false);
            dlg.dispose();
        }
        if (this.comp instanceof MainFrame) {
            MainFrame frame = (MainFrame)this.comp;
            frame.exitApplication();
        }
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = e == null ? DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale()) : DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", e.getLocale());
        this.saveButton.setText(this.res.getString("Save"));
        this.resetButton.setText(this.res.getString("Reset"));
        this.cancelButton.setText(this.res.getString("Cancel"));
        this.helpButton.setText(this.res.getString("Help"));
        if (Preferences.mainHB == null) {
            this.helpButton.setEnabled(false);
        } else {
            this.helpButton.removeActionListener(this.cshListener);
            this.cshListener = new CSH.DisplayHelpFromSource((HelpBroker)Preferences.mainHB);
            this.helpButton.addActionListener(this.cshListener);
        }
    }
}

