/*
 * Decompiled with CFR 0.152.
 */
package DmEditor.AllSectionInfo;

import DmEditor.AllSectionInfo.AllKeywordInfo;
import DmEditor.AllSectionInfo.ConfigItem;
import dbaut.JdmConfig;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class AllSectionInfo {
    private Hashtable ht = new Hashtable();

    public ConfigItem getItem(String keyword) {
        return (ConfigItem)this.ht.get(keyword);
    }

    public short getStyle(String keyword) {
        short style = -1;
        ConfigItem item = (ConfigItem)this.ht.get(keyword);
        if (item != null) {
            style = item.getStyle();
        }
        return style;
    }

    public boolean booleanValue(String keyword) {
        boolean b = false;
        ConfigItem item = (ConfigItem)this.ht.get(keyword);
        if (item != null) {
            b = (Boolean)item.getOrigValue(2);
        } else {
            System.err.println("can't find the setting for " + keyword + ".");
        }
        return b;
    }

    public void setValue(String keyword, Object value) {
        ConfigItem item = (ConfigItem)this.ht.get(keyword);
        if (item != null) {
            item.setValue(value);
        }
    }

    public void add(String keyword, Object obj, Object defaultValue, short style) {
        this.ht.put(keyword, new ConfigItem(keyword, obj, defaultValue, style));
    }

    public void saveChange(JdmConfig config) {
        Enumeration e = this.ht.elements();
        ConfigItem item = null;
        while (e.hasMoreElements()) {
            item = (ConfigItem)e.nextElement();
            if (!item.isChanged()) continue;
            item.saveChange(config);
        }
    }

    public boolean isChanged(String keyword) {
        ConfigItem item = (ConfigItem)this.ht.get(keyword);
        return item != null && item.isChanged();
    }

    public boolean isChanged() {
        Enumeration e = this.ht.elements();
        ConfigItem item = null;
        while (e.hasMoreElements()) {
            item = (ConfigItem)e.nextElement();
            if (!item.isChanged()) continue;
            System.out.println(item.getKeyword() + " has been changed.");
            return true;
        }
        return false;
    }

    public void resetValues() {
        Enumeration e = this.ht.elements();
        ConfigItem item = null;
        while (e.hasMoreElements()) {
            item = (ConfigItem)e.nextElement();
            item.resetValue();
        }
    }

    public void initComponents() {
        Enumeration e = this.ht.elements();
        ConfigItem item = null;
        while (e.hasMoreElements()) {
            item = (ConfigItem)e.nextElement();
            item.initComponent();
        }
    }

    public ArrayList isChangedSide() {
        ArrayList<String> keyList = new ArrayList<String>();
        Enumeration e = this.ht.elements();
        ConfigItem item = null;
        while (e.hasMoreElements()) {
            String key;
            int side;
            item = (ConfigItem)e.nextElement();
            if (!item.isChanged() || (side = AllKeywordInfo.keywordInfo(key = item.getKeyword())) != 0) continue;
            keyList.add(key);
        }
        return keyList;
    }
}

