/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.sql;

import dbmaster.sql.JdbcOdbc;
import dbmaster.sql.JdbcOdbcAPI;
import dbmaster.sql.JdbcOdbcBindCol;
import dbmaster.sql.JdbcOdbcBlob;
import dbmaster.sql.JdbcOdbcClob;
import dbmaster.sql.JdbcOdbcConnection;
import dbmaster.sql.JdbcOdbcNClob;
import dbmaster.sql.JdbcOdbcResultSetMetaData;
import dbmaster.sql.JdbcOdbcStatement;
import dbmaster.sql.LargeObjectInterface;
import dbmaster.sql.ODBCDef;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class JdbcOdbcResultSet
extends JdbcOdbc
implements ResultSet {
    private JdbcOdbcAPI ODBCOBJ;
    private boolean isClose;
    private JdbcOdbcStatement myStatement;
    protected JdbcOdbcBindCol[] bindCol;
    protected SQLWarning lastWarning;
    protected int numResultCols;
    protected static int INPUT_STREAM_BUF_LEN = 2048;
    private boolean lastColumnNull;
    private boolean dropFlag;
    private short rsStatus;
    private int cursorPos;
    private int myCursorType;
    protected JdbcOdbcBindCol[] updateCol;
    protected JdbcOdbcBindCol[] insertCol;
    protected ColumnInfo[] selectCol;
    protected boolean needRemap = false;
    private boolean insertFlag;
    private short orgStatus;
    protected int fetchSize;
    private HashSet lobs = new HashSet();

    public JdbcOdbcResultSet(JdbcOdbcAPI jdbcOdbcAPI, JdbcOdbcStatement jdbcOdbcStatement, boolean bl) throws SQLException {
        int n;
        if (this.needTrace) {
            this.trace("new ResultSet");
        }
        this.ODBCOBJ = jdbcOdbcAPI;
        this.myStatement = jdbcOdbcStatement;
        this.lastWarning = null;
        this.rsStatus = (short)3;
        this.orgStatus = (short)3;
        this.lastColumnNull = false;
        this.isClose = false;
        this.dropFlag = bl;
        this.numResultCols = this.getColCount();
        JdbcOdbcResultSetMetaData jdbcOdbcResultSetMetaData = (JdbcOdbcResultSetMetaData)this.getMetaData();
        this.selectCol = new ColumnInfo[this.numResultCols];
        for (n = 0; n < this.numResultCols; ++n) {
            this.selectCol[n] = new ColumnInfo();
            this.selectCol[n].sqltype = jdbcOdbcResultSetMetaData.getColumnSQLType(n + 1);
        }
        this.insertCol = new JdbcOdbcBindCol[this.numResultCols];
        for (n = 0; n < this.numResultCols; ++n) {
            this.insertCol[n] = new JdbcOdbcBindCol();
        }
        this.updateCol = new JdbcOdbcBindCol[this.numResultCols];
        for (n = 0; n < this.numResultCols; ++n) {
            this.updateCol[n] = new JdbcOdbcBindCol();
        }
        this.bindCol = this.updateCol;
        this.cursorPos = 0;
        this.myCursorType = -1;
        this.insertFlag = false;
        this.fetchSize = jdbcOdbcStatement.getFetchSize();
        this.needRemap = jdbcOdbcStatement.colMapLength() > 0;
    }

    public JdbcOdbcResultSet(JdbcOdbcAPI jdbcOdbcAPI, JdbcOdbcStatement jdbcOdbcStatement) throws SQLException {
        int n;
        if (this.needTrace) {
            this.trace("new ResultSet");
        }
        this.ODBCOBJ = jdbcOdbcAPI;
        this.myStatement = jdbcOdbcStatement;
        this.lastWarning = null;
        this.rsStatus = 0;
        this.orgStatus = 0;
        this.lastColumnNull = false;
        this.isClose = false;
        this.dropFlag = false;
        this.numResultCols = this.getColCount();
        JdbcOdbcResultSetMetaData jdbcOdbcResultSetMetaData = (JdbcOdbcResultSetMetaData)this.getMetaData();
        this.selectCol = new ColumnInfo[this.numResultCols];
        for (n = 0; n < this.numResultCols; ++n) {
            this.selectCol[n] = new ColumnInfo();
            this.selectCol[n].sqltype = jdbcOdbcResultSetMetaData.getColumnSQLType(n + 1);
        }
        this.updateCol = new JdbcOdbcBindCol[this.numResultCols];
        for (n = 0; n < this.numResultCols; ++n) {
            this.updateCol[n] = new JdbcOdbcBindCol();
        }
        this.insertCol = new JdbcOdbcBindCol[this.numResultCols];
        for (n = 0; n < this.numResultCols; ++n) {
            this.insertCol[n] = new JdbcOdbcBindCol();
        }
        this.bindCol = this.updateCol;
        this.cursorPos = 0;
        this.myCursorType = -1;
        this.insertFlag = false;
        this.fetchSize = jdbcOdbcStatement.getFetchSize();
        this.needRemap = jdbcOdbcStatement.colMapLength() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.absolute(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        int n2 = this.getCursorType();
        if (n2 == 1003) {
            this.JDBCError("JERR_CURSOR_FORWARD_ONLY", "ResultSet.absolute(" + n2 + ")");
        }
        this.clearLargeObject();
        this.resetBindCol();
        try {
            boolean bl = false;
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                bl = this.ODBCOBJ.jdbcFetchScroll(this.myStatement.getHSTMT(), 5, n);
            }
            if (!bl) {
                this.cursorPos = -1;
                this.rsStatus = (short)3;
                return false;
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
            this.rsStatus = (short)6;
        }
        catch (SQLException sQLException) {
            this.rsStatus = (short)5;
            this.cursorPos = -1;
            throw sQLException;
        }
        this.cursorPos = 1;
        if (this.rsStatus != 6) {
            this.rsStatus = 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.afterLast()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        int n = this.getCursorType();
        if (n == 1003) {
            this.JDBCError("JERR_CURSOR_FORWARD_ONLY", "ResultSet.afterLast(" + n + ")");
        }
        this.clearLargeObject();
        this.resetBindCol();
        boolean bl = false;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            bl = this.ODBCOBJ.jdbcFetchScroll(this.myStatement.getHSTMT(), 3, 0L);
        }
        if (!bl) {
            this.cursorPos = -1;
            this.rsStatus = (short)3;
        } else {
            try {
                jdbcOdbcConnection = this.myStatement.myConnection;
                synchronized (jdbcOdbcConnection) {
                    bl = this.ODBCOBJ.jdbcFetchScroll(this.myStatement.getHSTMT(), 1, 1L);
                }
                if (!bl) {
                    this.cursorPos = -1;
                    this.rsStatus = (short)3;
                }
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
                this.rsStatus = (short)6;
            }
            catch (SQLException sQLException) {
                this.rsStatus = (short)5;
                throw sQLException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.beforeFirst()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        int n = this.getCursorType();
        if (n == 1003) {
            this.JDBCError("JERR_CURSOR_FORWARD_ONLY", "ResultSet.beforeFirst(" + n + ")");
        }
        this.clearLargeObject();
        this.resetBindCol();
        boolean bl = false;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            bl = this.ODBCOBJ.jdbcFetchScroll(this.myStatement.getHSTMT(), 2, 0L);
        }
        if (!bl) {
            this.cursorPos = 0;
            this.rsStatus = (short)3;
        } else {
            try {
                bl = false;
                jdbcOdbcConnection = this.myStatement.myConnection;
                synchronized (jdbcOdbcConnection) {
                    bl = this.ODBCOBJ.jdbcFetchScroll(this.myStatement.getHSTMT(), 6, -1L);
                }
                if (!bl) {
                    this.cursorPos = 0;
                    this.rsStatus = (short)3;
                }
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
                this.rsStatus = (short)6;
            }
            catch (SQLException sQLException) {
                this.rsStatus = (short)5;
                throw sQLException;
            }
        }
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.cancelRowUpdates()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        this.resetBindCol();
    }

    public void clearWarnings() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.clearWarnings()");
        }
        this.lastWarning = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.close()");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            if (this.isClose) {
                return;
            }
            this.lastWarning = null;
            this.lastColumnNull = false;
            this.clearLargeObject();
            if (this.ODBCOBJ != null && this.myStatement.getHSTMT() != 0L && !this.ODBCOBJ.fgDBrollback) {
                if (this.dropFlag) {
                    this.myStatement.close();
                } else {
                    this.ODBCOBJ.jdbcCloseCursor(this.myStatement.getHSTMT());
                }
            }
            this.isClose = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.deleteRow()");
        }
        this.checkClosed(this.isClosed());
        if (this.cursorPos <= 0) {
            this.JDBCError("JERR_CURSOR_POS_INCORRECT", "ResultSet.deleteRow()");
        }
        if (this.rsStatus == 1) {
            this.JDBCError("JERR_ROW_HAS_DELETED", "ResultSet.deleteRow()");
        }
        this.clearLargeObject();
        this.lastWarning = null;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcSetPos(this.myStatement.getHSTMT(), 1, 3);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        catch (SQLException sQLException) {
            this.rsStatus = (short)5;
            throw sQLException;
        }
        this.rsStatus = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.first()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        int n = this.getCursorType();
        if (n == 1003) {
            this.JDBCError("JERR_CURSOR_FORWARD_ONLY", "ResultSet.first(" + n + ")");
        }
        this.clearLargeObject();
        this.resetBindCol();
        try {
            boolean bl = false;
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                bl = this.ODBCOBJ.jdbcFetchScroll(this.myStatement.getHSTMT(), 2, 0L);
            }
            if (!bl) {
                this.cursorPos = -1;
                this.rsStatus = (short)3;
                return false;
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
            this.rsStatus = (short)6;
        }
        catch (SQLException sQLException) {
            this.rsStatus = (short)5;
            throw sQLException;
        }
        this.cursorPos = 1;
        if (this.rsStatus != 6) {
            this.rsStatus = 0;
        }
        return true;
    }

    public Array getArray(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getArray(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.getArray(" + n + ")", null);
    }

    public Array getArray(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getArray(" + string + ")");
        }
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.getArray(" + string + ")", null);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getAsciiStream(" + n + ")");
        }
        JdbcOdbcClob jdbcOdbcClob = (JdbcOdbcClob)this.getClob(n);
        if (this.lastColumnNull || jdbcOdbcClob == null) {
            return null;
        }
        InputStream inputStream = jdbcOdbcClob.getAsciiStream(true);
        return inputStream;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getAsciiStream(" + string + ")");
        }
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getBigDecimal(" + n + ")");
        }
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getBigDecimal(" + n + ")");
        }
        int n2 = n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        if (this.selectCol[n - 1].type != -8 || this.selectCol[n - 1].maxlen < 84) {
            this.selectCol[n - 1].maxlen = 84;
            this.selectCol[n - 1].buffer = new byte[this.selectCol[n - 1].maxlen];
        }
        this.lastWarning = null;
        String string = this.getDataInString(n);
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.getDefault());
        if (string != null && numberFormat instanceof DecimalFormat) {
            char c = ((DecimalFormat)numberFormat).getDecimalFormatSymbols().getDecimalSeparator();
            string = string.replace(c, '.');
        }
        if (string != null) {
            return new BigDecimal(string);
        }
        return new BigDecimal("0");
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getBigDecimal(" + n + "," + n2 + ")");
        }
        return this.getBigDecimal(n).setScale(n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getBigDecimal(" + string + ")");
        }
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getBigDecimal(" + string + "," + n + ")");
        }
        return this.getBigDecimal(this.findColumn(string)).setScale(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getBinaryStream(" + n + ")");
        }
        JdbcOdbcBlob jdbcOdbcBlob = (JdbcOdbcBlob)this.getBlob(n);
        if (this.lastColumnNull || jdbcOdbcBlob == null) {
            return null;
        }
        return jdbcOdbcBlob.getBinaryStream(true);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getBinaryStream(" + string + ")");
        }
        return this.getBinaryStream(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getBlob(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getBlob(" + n + ")");
        }
        int n2 = n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        if (!this.isBlobType(n)) {
            this.JDBCError("JERR_CANNOT_GET_BLOB", "ResultSet.getBlob(int)");
        }
        JdbcOdbcBlob jdbcOdbcBlob = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            JdbcOdbcConnection jdbcOdbcConnection2 = (JdbcOdbcConnection)this.myStatement.getConnection();
            jdbcOdbcBlob = new JdbcOdbcBlob(this.ODBCOBJ, jdbcOdbcConnection2, this.myStatement, n);
            if (jdbcOdbcConnection2.getAutoCommit()) {
                this.registerLargeObject(jdbcOdbcBlob);
            } else {
                jdbcOdbcConnection2.registerLargeObject(jdbcOdbcBlob);
            }
        }
        this.lastColumnNull = jdbcOdbcBlob.isNull();
        return jdbcOdbcBlob;
    }

    public Blob getBlob(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getBlob(" + string + ")");
        }
        return this.getBlob(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getBoolean(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getBoolean(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.lastColumnNull = false;
        int n2 = this.getInt(n);
        return n2 != 0;
    }

    public boolean getBoolean(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getBoolean(" + string + ")");
        }
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getByte(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getByte(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.lastColumnNull = false;
        byte[] byArray = this.getBytes(n, 1);
        if (this.lastColumnNull) {
            return 0;
        }
        return byArray[0];
    }

    public byte getByte(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getByte(" + string + ")");
        }
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getBytes(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getBytes(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        int n2 = (int)this.getMaxByteLen(n);
        return this.getBytes(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes(int n, int n2) throws SQLException {
        this.selectCol[n - 1].maxlen = n2;
        this.selectCol[n - 1].buffer = new byte[this.selectCol[n - 1].maxlen];
        this.selectCol[n - 1].type = -2;
        byte[] byArray = null;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                byArray = this.ODBCOBJ.jdbcGetDataBinary(this.myStatement.getHSTMT(), n, this.selectCol[n - 1].maxlen, this.selectCol[n - 1].buffer, this.selectCol[n - 1].len);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        this.lastColumnNull = byArray == null;
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getBytes(" + string + ")");
        }
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getCharacterStream(" + n + ")");
        }
        JdbcOdbcClob jdbcOdbcClob = (JdbcOdbcClob)this.getClob(n);
        if (this.lastColumnNull || jdbcOdbcClob == null) {
            return null;
        }
        return jdbcOdbcClob.getCharacterStream(true);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getCharacterStream(" + string + ")");
        }
        return this.getCharacterStream(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n) throws SQLException {
        boolean bl;
        if (this.needTrace) {
            this.trace("ResultSet.getClob(" + n + ")");
        }
        if (this.selectCol[n - 1].sqltype == -10) {
            return this.getNClob(n);
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getClob(" + n + ")");
        }
        if (!(bl = this.isBlobType(n = this.needRemap ? this.myStatement.mapColumn(n) : n))) {
            this.JDBCError("JERR_CANNOT_GET_BLOB", "ResultSet.getClob()");
        }
        JdbcOdbcClob jdbcOdbcClob = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            JdbcOdbcConnection jdbcOdbcConnection2 = (JdbcOdbcConnection)this.myStatement.getConnection();
            jdbcOdbcClob = new JdbcOdbcClob(this.ODBCOBJ, jdbcOdbcConnection2, this.myStatement, n, this.selectCol[n - 1].sqltype);
            if (jdbcOdbcConnection2.getAutoCommit()) {
                this.registerLargeObject(jdbcOdbcClob);
            } else {
                jdbcOdbcConnection2.registerLargeObject(jdbcOdbcClob);
            }
        }
        this.lastColumnNull = jdbcOdbcClob.isNull();
        return jdbcOdbcClob;
    }

    public Clob getClob(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getClob(" + string + ")");
        }
        return this.getClob(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrency() throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("ResultSet.getConcurrency()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                n = this.ODBCOBJ.jdbcGetStmtAttrInt(this.myStatement.getHSTMT(), 7);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        switch (n) {
            case 1: {
                n = 1007;
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                n = 1008;
                break;
            }
            default: {
                this.JDBCError("JERR_INTERNAL_ERROR", "ResultSet.getConcurrency()");
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        String string = "";
        if (this.needTrace) {
            this.trace("ResultSet.getCursorName()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                string = this.ODBCOBJ.jdbcGetCursorName(this.myStatement.getHSTMT());
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        return string.trim();
    }

    public Date getDate(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getDate(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getDate(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.lastColumnNull = false;
        String string = this.getDateTimeInString(n);
        if (string == null) {
            this.lastColumnNull = true;
            return null;
        }
        if (this.selectCol[n - 1].sqltype == 93) {
            return new Date(Timestamp.valueOf(string).getTime());
        }
        try {
            return ((JdbcOdbcConnection)this.myStatement.getConnection()).getDate(string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public Date getDate(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getDate(" + string + ")");
        }
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getDate(" + string + "," + calendar + ")");
        }
        return this.getDate(this.findColumn(string), calendar);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getDate(" + n + "," + calendar + ")");
        }
        this.checkClosed(this.isClosed());
        Date date = this.getDate(n);
        long l = calendar.getTimeZone().getRawOffset();
        long l2 = TimeZone.getDefault().getRawOffset();
        return new Date(date.getTime() + (l2 - l));
    }

    public double getDouble(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getDouble(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getDouble(" + n + ")");
        }
        int n2 = n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        if (this.selectCol[n - 1].type != -8 || this.selectCol[n - 1].maxlen < 84) {
            this.selectCol[n - 1].maxlen = 84;
            this.selectCol[n - 1].buffer = new byte[this.selectCol[n - 1].maxlen];
        }
        this.lastWarning = null;
        String string = this.getDataInString(n);
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.getDefault());
        if (string != null && numberFormat instanceof DecimalFormat) {
            char c = ((DecimalFormat)numberFormat).getDecimalFormatSymbols().getDecimalSeparator();
            string = string.replace(c, '.');
        }
        if (string != null) {
            return new Double(string);
        }
        return new Double("0");
    }

    public double getDouble(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getDouble(" + string + ")");
        }
        return this.getDouble(this.findColumn(string));
    }

    public int getFetchDirection() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getFetchDirection()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getFetchSize()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        return this.fetchSize;
    }

    public float getFloat(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getFloat(" + n + ")");
        }
        return (float)this.getDouble(n);
    }

    public float getFloat(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getFloat(" + string + ")");
        }
        return this.getFloat(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getInt(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getInt(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        int n2 = 0;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                n2 = this.ODBCOBJ.jdbcGetDataInt(this.myStatement.getHSTMT(), n, this.selectCol[n - 1].ivalue, this.selectCol[n - 1].len);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
            n2 = this.selectCol[n - 1].ivalue[0];
        }
        this.lastColumnNull = this.selectCol[n - 1].len[0] == 0L;
        return n2;
    }

    public int getInt(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getInt(" + string + ")");
        }
        return this.getInt(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getLong(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.lastColumnNull = false;
        long l = 0L;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                l = this.ODBCOBJ.jdbcGetDataLong(this.myStatement.getHSTMT(), n, this.selectCol[n - 1].lvalue, this.selectCol[n - 1].len);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
            l = this.selectCol[n - 1].lvalue[0];
        }
        if (this.selectCol[n - 1].len[0] == 0L) {
            this.lastColumnNull = true;
        }
        return l;
    }

    public long getLong(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getLong(" + string + ")");
        }
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getMetaData()");
        }
        this.checkClosed(this.isClosed());
        return new JdbcOdbcResultSetMetaData(this.ODBCOBJ, this.myStatement);
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        if (this.needTrace) {
            this.trace("ResultSet.getObject(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getObject(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.lastColumnNull = false;
        int n2 = this.selectCol[n - 1].sqltype;
        switch (n2) {
            case -7: {
                object = new Boolean(this.getBoolean(n));
                break;
            }
            case 4: 
            case 5: {
                object = new Integer(this.getInt(n));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n));
                break;
            }
            case 6: 
            case 7: {
                object = new Float(this.getFloat(n));
                break;
            }
            case 8: {
                object = new Double(this.getDouble(n));
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 301: {
                object = this.getBytes(n);
                break;
            }
            case 91: {
                object = this.getDate(n);
                break;
            }
            case 92: {
                object = this.getTime(n);
                break;
            }
            case 93: {
                object = this.getTimestamp(n);
                break;
            }
            case 2: 
            case 3: {
                object = this.getBigDecimal(n);
                break;
            }
            default: {
                object = this.getString(n);
            }
        }
        if (this.wasNull()) {
            object = null;
        }
        return object;
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.trace("ResultSet.getObject(" + n + "," + map + ")");
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.getObject(int, Map)", null);
    }

    public Object getObject(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getObject(" + string + ")");
        }
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.trace("ResultSet.getObject(" + string + "," + map + ")");
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.getObject(String, Map)", null);
    }

    public Ref getRef(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getRef(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.getRef(int)", null);
    }

    public Ref getRef(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getRef(" + string + ")");
        }
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.getRef(String)", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRecord() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getRecord()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                return this.ODBCOBJ.jdbcGetRecord(this.myStatement.getHSTMT());
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("ResultSet.getRow()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                n = this.ODBCOBJ.jdbcGetStmtAttrInt(this.myStatement.getHSTMT(), 1119);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        return n;
    }

    public short getShort(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getShort(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getShort(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.lastColumnNull = false;
        return (short)this.getInt(n);
    }

    public short getShort(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getShort(" + string + ")");
        }
        return this.getShort(this.findColumn(string));
    }

    public Statement getStatement() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getStatement()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        return this.myStatement;
    }

    public String getString(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getString(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getString(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        int n2 = (int)this.getMaxU16Len(n) + 2;
        if (this.selectCol[n - 1].type != -8 || this.selectCol[n - 1].maxlen < n2) {
            this.selectCol[n - 1].maxlen = n2;
            this.selectCol[n - 1].buffer = new byte[this.selectCol[n - 1].maxlen];
            this.selectCol[n - 1].type = -8;
        }
        return this.getDataInString(n);
    }

    public String getString(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getString(" + string + ")");
        }
        return this.getString(this.findColumn(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDateTimeInString(int n) throws SQLException {
        String string = null;
        if (this.selectCol[n - 1].type != 92) {
            this.selectCol[n - 1].buffer = new byte[512];
            this.selectCol[n - 1].maxlen = 512;
            this.selectCol[n - 1].type = 92;
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                string = this.ODBCOBJ.jdbcGetDataStringDateTime(this.myStatement.getHSTMT(), n, this.selectCol[n - 1].buffer, this.selectCol[n - 1].len);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        return string;
    }

    public Time getTime(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getTime(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getTime(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.lastColumnNull = false;
        String string = this.getDateTimeInString(n);
        if (string == null) {
            this.lastColumnNull = true;
            return null;
        }
        if (this.selectCol[n - 1].sqltype == 93) {
            Timestamp timestamp = Timestamp.valueOf(string);
            return new Time(timestamp.getTime());
        }
        try {
            return ((JdbcOdbcConnection)this.myStatement.getConnection()).getTime(string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public Time getTime(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("getTime(" + string + ")");
        }
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getTime(" + n + "," + calendar + ")");
        }
        Time time = this.getTime(n);
        long l = calendar.getTimeZone().getRawOffset();
        long l2 = TimeZone.getDefault().getRawOffset();
        return new Time(time.getTime() + (l2 - l));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getTime(" + string + "," + calendar + ")");
        }
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getTimestamp(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getTimestamp(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.lastColumnNull = false;
        String string = this.getDateTimeInString(n);
        if (string == null) {
            this.lastColumnNull = true;
            return null;
        }
        try {
            return ((JdbcOdbcConnection)this.myStatement.getConnection()).getTimestamp(this.selectCol[n - 1].sqltype, string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("getTimestamp(" + string + ")");
        }
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getTimestamp(" + n + "," + calendar + ")");
        }
        Timestamp timestamp = this.getTimestamp(n);
        long l = calendar.getTimeZone().getRawOffset();
        long l2 = TimeZone.getDefault().getRawOffset();
        return new Timestamp(timestamp.getTime() + (l2 - l));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getTimestamp(" + string + "," + calendar + ")");
        }
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("ResultSet.getType()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                n = this.ODBCOBJ.jdbcGetStmtAttrInt(this.myStatement.getHSTMT(), 6);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        switch (n) {
            case 0: {
                n = 1003;
                break;
            }
            case 2: {
                n = 1005;
                break;
            }
            case 1: 
            case 3: {
                n = 1004;
                break;
            }
            default: {
                this.JDBCError("JERR_INTERNAL_ERROR", "ResultSet.getType(" + n + ")");
            }
        }
        return n;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getUnicodeStream(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.getUnicodeStream(int)", null);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getUnicodeStream(" + string + ")");
        }
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.getUnicodeStream(String)", null);
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.getWarnings()");
        }
        return this.lastWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        JdbcOdbcConnection jdbcOdbcConnection;
        int n;
        if (this.needTrace) {
            this.trace("ResultSet.insertRow()");
        }
        this.checkClosed(this.isClosed());
        int n2 = this.getCursorType();
        if (n2 == 1003) {
            this.JDBCError("JERR_CURSOR_FORWARD_ONLY", "ResultSet.insertRow(" + n2 + ")");
        }
        if ((n = this.myStatement.getResultSetConcurrency()) == 1007) {
            this.JDBCError("JERR_CONCUR_READ_ONLY", "ResultSet.insertRow(" + n + ")");
        }
        if (!this.insertFlag) {
            this.JDBCError("JERR_INV_INSERT_POS", "ResultSet.insertRow()");
        }
        this.lastWarning = null;
        this.bindColumn();
        boolean bl = false;
        try {
            jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                bl = this.ODBCOBJ.jdbcBulkOperations(this.myStatement.getHSTMT(), 4);
            }
            if (bl) {
                this.putData();
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        catch (SQLException sQLException) {
            this.freeBindColumns();
            this.rsStatus = (short)5;
            throw sQLException;
        }
        this.rsStatus = (short)4;
        this.freeBindColumns();
        try {
            jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcFreeStmt(this.myStatement.getHSTMT(), 2);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = null;
        }
    }

    public boolean isAfterLast() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.isAfterLast()");
        }
        this.checkClosed(this.isClosed());
        if (this.getCursorType() != 1003) {
            return this.cursorPos == -1;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.isBeforeFirst()");
        }
        this.checkClosed(this.isClosed());
        if (this.getCursorType() != 1003) {
            if (this.cursorPos == 0) {
                if (this.next()) {
                    this.previous();
                    return true;
                }
                return false;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    public boolean isFirst() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.isFirst()");
        }
        this.checkClosed(this.isClosed());
        return this.getRow() == 1;
    }

    public boolean isLast() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.isLast()");
        }
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.isLast()", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.last()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        int n = this.getCursorType();
        if (n == 1003) {
            this.JDBCError("JERR_CURSOR_FORWARD_ONLY", "ResultSet.last(" + n + ")");
        }
        this.clearLargeObject();
        this.resetBindCol();
        boolean bl = false;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                bl = this.ODBCOBJ.jdbcFetchScroll(this.myStatement.getHSTMT(), 3, 0L);
            }
            if (!bl) {
                this.cursorPos = -1;
                this.rsStatus = (short)3;
                return false;
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
            this.rsStatus = (short)6;
        }
        this.cursorPos = 1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.moveToCurrentRow()");
        }
        this.checkClosed(this.isClosed());
        this.clearLargeObject();
        this.lastWarning = null;
        if (this.insertFlag) {
            this.rsStatus = this.orgStatus;
            this.bindCol = this.updateCol;
            try {
                JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
                synchronized (jdbcOdbcConnection) {
                    this.ODBCOBJ.jdbcSetPos(this.myStatement.getHSTMT(), 0, 1);
                }
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
            this.insertFlag = false;
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.moveToInsertRow()");
        }
        this.checkClosed(this.isClosed());
        this.clearLargeObject();
        this.lastWarning = null;
        if (!this.insertFlag) {
            this.bindCol = this.insertCol;
            this.orgStatus = this.rsStatus;
            this.rsStatus = (short)3;
            this.insertFlag = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        boolean bl = false;
        if (this.needTrace) {
            this.trace("ResultSet.next()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        this.lastColumnNull = false;
        this.clearLargeObject();
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                bl = this.ODBCOBJ.jdbcFetch(this.myStatement.getHSTMT());
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
            this.resetBindCol();
        }
        if (bl) {
            this.resetBindCol();
            this.cursorPos = 1;
            return true;
        }
        this.cursorPos = -1;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.previous()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        int n = this.getCursorType();
        if (n == 1003) {
            this.JDBCError("JERR_CURSOR_FORWARD_ONLY", "ResultSet.previous(" + n + ")");
        }
        this.clearLargeObject();
        this.resetBindCol();
        boolean bl = false;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                bl = this.ODBCOBJ.jdbcFetchScroll(this.myStatement.getHSTMT(), 4, 0L);
            }
            if (!bl) {
                this.cursorPos = -1;
                this.rsStatus = (short)3;
                return false;
            }
        }
        catch (SQLWarning sQLWarning) {
            this.rsStatus = (short)6;
            this.lastWarning = sQLWarning;
        }
        catch (SQLException sQLException) {
            this.rsStatus = (short)5;
            throw sQLException;
        }
        this.cursorPos = 1;
        if (this.rsStatus != 6) {
            this.rsStatus = 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.refreshRow()");
        }
        this.checkClosed(this.isClosed());
        if (this.cursorPos <= 0) {
            this.JDBCError("JERR_CURSOR_POS_INCORRECT", "ResultSet.refreshRow()");
        }
        this.clearLargeObject();
        this.lastWarning = null;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcSetPos(this.myStatement.getHSTMT(), 0, 1);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
            this.rsStatus = (short)6;
        }
        catch (SQLException sQLException) {
            this.rsStatus = (short)5;
            throw sQLException;
        }
        if (this.rsStatus != 6) {
            this.rsStatus = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.relative(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        int n2 = this.getCursorType();
        if (n2 == 1003) {
            this.JDBCError("JERR_CURSOR_FORWARD_ONLY", "ResultSet.relative(" + n2 + ")");
        }
        this.clearLargeObject();
        this.resetBindCol();
        boolean bl = false;
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                bl = this.ODBCOBJ.jdbcFetchScroll(this.myStatement.getHSTMT(), 6, n);
            }
            if (!bl) {
                this.cursorPos = -1;
                this.rsStatus = (short)3;
                return false;
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
            this.rsStatus = (short)6;
        }
        catch (SQLException sQLException) {
            this.rsStatus = (short)5;
            throw sQLException;
        }
        this.cursorPos = 1;
        if (this.rsStatus != 6) {
            this.rsStatus = 0;
        }
        return true;
    }

    public boolean rowDeleted() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.rowDeleted()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        return this.rsStatus == 1;
    }

    public boolean rowInserted() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.rowInserted()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        if (!this.insertFlag) {
            return false;
        }
        return this.rsStatus == 4;
    }

    public boolean rowUpdated() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.rowUpdated()");
        }
        this.checkClosed(this.isClosed());
        this.lastWarning = null;
        if (this.insertFlag) {
            return false;
        }
        return this.rsStatus == 2;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.setFetchDirection(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n == 1001) {
            this.JDBCError("JERR_UNSUPPORT_FETCH_DIRECTION_VAL", "ResultSet.setFetchDirection(" + n + ")");
        } else if (n != 1000 && n != 1002) {
            this.JDBCError("JERR_INV_FETCH_DIRECTION_VAL", "ResultSet.setFetchDirection(FETCH_FORWARD)");
        }
        this.lastWarning = null;
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.setFetchSize(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n < 0) {
            this.JDBCError("JERR_INV_FETCH_SIZE", "ResultSet.setFetchSize(" + n + ")");
        }
        this.lastWarning = null;
        this.fetchSize = n;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(n, inputStream, (long)n2);
    }

    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateAsciiStream(" + n + "," + inputStream + "," + l + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateAsciiStream(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setInputStream(inputStream, l, (short)1);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateAsciiStream(" + string + "," + inputStream + "," + n + ")");
        }
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateBigDecimal(" + n + "," + bigDecimal + ")");
        }
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.updateBigDecimal(int, BigDecimal)", null);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateBigDecimal(" + string + "," + bigDecimal + ")");
        }
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.updateBigDecimal(String, BigDecimal)", null);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(n, inputStream, (long)n2);
    }

    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateBinaryStream(" + n + "," + inputStream + "," + l + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateBinaryStream(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setInputStream(inputStream, l, (short)-2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateBinaryStream(" + string + "," + inputStream + "," + n + ")");
        }
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateBoolean(" + n + "," + bl + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateBoolean(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData(bl ? 1 : 0);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateBoolean(" + string + "," + bl + ")");
        }
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateByte(" + n + "," + by + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateByte(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData((int)by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateByte(" + string + "," + by + ")");
        }
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateBytes(" + n + "," + byArray + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateBytes(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData(byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateBytes(" + string + "," + byArray + ")");
        }
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(n, reader, (long)n2);
    }

    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateCharacterStream(" + n + "," + reader + "," + l + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateCharacterStream(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setReader(reader, l);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateCharacterStream(" + string + "," + reader + "," + n + ")");
        }
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateDate(" + n + "," + date + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateDate(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData(date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateDate(" + string + "," + date + ")");
        }
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateDouble(" + n + "," + d + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateDouble(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData(d);
    }

    public void updateDouble(String string, double d) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateDouble(" + string + "," + d + ")");
        }
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateFloat(" + n + "," + f + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateFloat(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData(f);
    }

    public void updateFloat(String string, float f) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateFloat(" + string + "," + f + ")");
        }
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateInt(" + n + "," + n2 + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateInt(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData(n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateInt(" + string + "," + n + ")");
        }
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateLong(" + n + "," + l + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateLong(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData(l);
    }

    public void updateLong(String string, long l) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateLong(" + string + "," + l + ")");
        }
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateNull(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateNull(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData((String)null);
    }

    public void updateNull(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateNull(" + string + ")");
        }
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateObject(" + n + "," + object + "," + n2 + ")");
        }
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.updateObject(int, Object, int)", null);
    }

    public void updateObject(int n, Object object) throws SQLException {
        String string;
        if (this.needTrace) {
            this.trace("ResultSet.updateObject(" + n + "," + object + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateObject(" + n + ")");
        }
        if ((string = object.getClass().getName()).compareTo("java.lang.Boolean") == 0) {
            this.updateBoolean(n, (boolean)((Boolean)object));
        }
        if (string.compareTo("java.lang.Byte") == 0) {
            this.updateBytes(n, object.toString().getBytes());
        }
        if (string.compareTo("java.lang.Integer") == 0) {
            this.updateInt(n, (int)((Integer)object));
        }
        if (string.compareTo("java.lang.Long") == 0) {
            this.updateLong(n, (long)((Long)object));
        }
        if (string.compareTo("java.lang.Character") == 0 || string.compareTo("java.lang.String") == 0 || string.compareTo("java.sql.StringBuffer") == 0) {
            this.updateString(n, (String)object);
        }
        if (string.compareTo("java.lang.Double") == 0) {
            this.updateDouble(n, (double)((Double)object));
        }
        if (string.compareTo("java.lang.Float") == 0) {
            this.updateFloat(n, ((Float)object).floatValue());
        }
        if (string.compareTo("java.lang.Short") == 0) {
            this.updateFloat(n, (float)((Short)object).shortValue());
        }
        if (string.compareTo("java.sql.Date") == 0) {
            this.updateDate(n, (Date)object);
        }
        if (string.compareTo("java.sql.Time") == 0) {
            this.updateTime(n, (Time)object);
        }
        if (string.compareTo("java.sql.Timestamp") == 0) {
            this.updateTimestamp(n, (Timestamp)object);
        }
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateObject(" + string + "," + object + "," + n + ")");
        }
        this.checkClosed(this.isClosed());
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.updateObject(String, Object, int)", null);
    }

    public void updateObject(String string, Object object) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateObject(" + string + "," + object + ")");
        }
        this.updateObject(this.findColumn(string), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        int n;
        int n2;
        if (this.needTrace) {
            this.trace("ResultSet.updateRow()");
        }
        this.checkClosed(this.isClosed());
        if (this.cursorPos <= 0) {
            this.JDBCError("JERR_CURSOR_POS_INCORRECT", "ResultSet.updateRow()");
        }
        if (this.rsStatus == 1 || this.rsStatus == 3) {
            this.JDBCError("JERR_CANNOT_UPDATE_ROW", "ResultSet.updateRow()");
        }
        if ((n2 = this.getCursorType()) == 1003) {
            this.JDBCError("JERR_CURSOR_FORWARD_ONLY", "ResultSet.updateRow(" + n2 + ")");
        }
        if ((n = this.myStatement.getResultSetConcurrency()) == 1007) {
            this.JDBCError("JERR_CONCUR_READ_ONLY", "ResultSet.updateRow(" + n + ")");
        }
        this.lastWarning = null;
        this.clearLargeObject();
        this.bindColumn();
        try {
            boolean bl = false;
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                bl = this.ODBCOBJ.jdbcSetPos(this.myStatement.getHSTMT(), this.cursorPos, 2);
            }
            if (bl) {
                this.putData();
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        catch (SQLException sQLException) {
            this.rsStatus = (short)5;
            this.freeBindColumns();
            throw sQLException;
        }
        this.rsStatus = (short)2;
        this.freeBindColumns();
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcFreeStmt(this.myStatement.getHSTMT(), 2);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = null;
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateShort(" + n + "," + s + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateShort(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData(s);
    }

    public void updateShort(String string, short s) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateShort(" + string + "," + s + ")");
        }
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateString(" + n + "," + string + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateString(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData(string);
    }

    public void updateString(String string, String string2) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateString(" + string + "," + string2 + ")");
        }
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateTime(" + n + "," + time + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateTime(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData(time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateTime(" + string + "," + time + ")");
        }
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateTimestamp(" + n + "," + timestamp + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateTimestamp(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setData(timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateTimestamp(" + string + "," + timestamp + ")");
        }
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public boolean wasNull() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.wasNull()");
        }
        this.checkClosed(this.isClosed());
        return this.lastColumnNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getColCount() throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("ResultSet.getColCount");
        }
        if ((n = this.myStatement.colMapLength()) == -1) {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                n = this.ODBCOBJ.jdbcNumResultCols(this.myStatement.getHSTMT());
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDataInString(int n) throws SQLException {
        String string = null;
        if (this.needTrace) {
            this.trace("getDataInString" + n + "," + this.selectCol[n - 1].maxlen + ")");
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                string = this.ODBCOBJ.jdbcGetDataStr(this.myStatement.getHSTMT(), n, this.selectCol[n - 1].maxlen, this.selectCol[n - 1].buffer, this.selectCol[n - 1].len);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        this.lastColumnNull = string == null;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnType(int n) throws SQLException {
        int[] nArray;
        block6: {
            nArray = new int[1];
            if (this.needTrace) {
                this.trace("getColumnType" + n + ")");
            }
            try {
                nArray[0] = this.bindCol[n - 1].getDescType();
                if (nArray[0] != 99) break block6;
                JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
                synchronized (jdbcOdbcConnection) {
                    this.ODBCOBJ.jdbcDescribeCol(this.myStatement.getHSTMT(), n, null, 0, null, nArray, null, null, null);
                }
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        this.bindCol[n - 1].setDescType(nArray[0]);
        return this.odbc2JavaType(nArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMaxByteLen(int n) throws SQLException {
        long l;
        block12: {
            l = -1L;
            if (this.needTrace) {
                this.trace("getMaxByteLen" + n + ")");
            }
            int n2 = this.selectCol[n - 1].sqltype;
            if (this.needTrace) {
                this.trace("after getMaxByteLen, type is" + n2 + ")");
            }
            try {
                if (n2 == -1 || n2 == -10 || n2 == 12 || n2 == 1 || n2 == 301 || n2 == -4 || n2 == -3 || n2 == -2) {
                    byte[] byArray = new byte[1];
                    JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
                    synchronized (jdbcOdbcConnection) {
                        l = this.ODBCOBJ.jdbcGetDataStream(this.myStatement.getHSTMT(), n, -2, byArray, 0);
                        break block12;
                    }
                }
                JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
                synchronized (jdbcOdbcConnection) {
                    l = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n, 1003);
                }
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        if (l < 1L) {
            l = 1L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMaxU16Len(int n) throws SQLException {
        long l;
        block11: {
            l = -1L;
            if (this.needTrace) {
                this.trace("getMaxU16Len" + n + ")");
            }
            int n2 = this.selectCol[n - 1].sqltype;
            if (this.needTrace) {
                this.trace("after getMaxU16Len, type is" + n2 + ")");
            }
            try {
                if (n2 == -1 || n2 == -10 || n2 == 12 || n2 == 1 || n2 == 301 || n2 == -4 || n2 == -3 || n2 == -2) {
                    byte[] byArray = new byte[1];
                    JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
                    synchronized (jdbcOdbcConnection) {
                        l = this.ODBCOBJ.jdbcGetDataStream(this.myStatement.getHSTMT(), n, -8, byArray, 0);
                        break block11;
                    }
                }
                JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
                synchronized (jdbcOdbcConnection) {
                    l = this.ODBCOBJ.jdbcColAttributeInt(this.myStatement.getHSTMT(), n, 6);
                }
                l *= 2L;
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return l;
    }

    private void freeBindColumns() throws NullPointerException {
        if (this.needTrace) {
            this.trace("ResultSet.freeBindColumns()");
        }
        for (int i = 0; i < this.numResultCols; ++i) {
            if (this.bindCol[i].pgDataBuf != 0L) {
                this.ODBCOBJ.releaseStoredBytes(this.bindCol[i].pgDataBuf, this.bindCol[i].pgDataValBuf);
            }
            if (this.bindCol[i].pgLenBuf == 0L) continue;
            this.ODBCOBJ.releaseStoredBytes(this.bindCol[i].pgLenBuf, this.bindCol[i].pgLenValBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void bindColumn() throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.bindColumn()");
        }
        try {
            int n = 0;
            while (n < this.numResultCols) {
                int n2 = this.bindCol[n].getType();
                switch (n2) {
                    case 4: {
                        Object[] objectArray = this.bindCol[n].allocBindDataBuf(4);
                        int n3 = (Integer)this.bindCol[n].getData();
                        long[] lArray = new long[2];
                        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
                        Object object3 = jdbcOdbcConnection;
                        // MONITORENTER : jdbcOdbcConnection
                        this.ODBCOBJ.jdbcBindColInt(this.myStatement.getHSTMT(), n + 1, n2, n3, (byte[])objectArray, lArray);
                        // MONITOREXIT : object3
                        this.bindCol[n].pgDataBuf = lArray[0];
                        this.bindCol[n].pgDataValBuf = lArray[1];
                        this.bindCol[n].pgLenBuf = 0L;
                        this.bindCol[n].pgLenValBuf = 0L;
                        break;
                    }
                    case -25: {
                        Object[] objectArray = this.bindCol[n].allocBindDataBuf(8);
                        long l = (Long)this.bindCol[n].getData();
                        Object object3 = new long[2];
                        Object object2 = this.myStatement.myConnection;
                        // MONITORENTER : object2
                        this.ODBCOBJ.jdbcBindColLong(this.myStatement.getHSTMT(), n + 1, n2, l, (byte[])objectArray, (long[])object3);
                        // MONITOREXIT : object2
                        this.bindCol[n].pgDataBuf = (long)object3[0];
                        this.bindCol[n].pgDataValBuf = (long)object3[1];
                        this.bindCol[n].pgLenBuf = 0L;
                        this.bindCol[n].pgLenValBuf = 0L;
                        break;
                    }
                    case 5: {
                        Object[] objectArray = this.bindCol[n].allocBindDataBuf(2);
                        short s = (Short)this.bindCol[n].getData();
                        long[] lArray = new long[2];
                        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
                        Object object3 = jdbcOdbcConnection;
                        // MONITORENTER : jdbcOdbcConnection
                        this.ODBCOBJ.jdbcBindColShort(this.myStatement.getHSTMT(), n + 1, n2, s, (byte[])objectArray, lArray);
                        // MONITOREXIT : object3
                        this.bindCol[n].pgDataBuf = lArray[0];
                        this.bindCol[n].pgDataValBuf = lArray[1];
                        this.bindCol[n].pgLenBuf = 0L;
                        this.bindCol[n].pgLenValBuf = 0L;
                        break;
                    }
                    case 8: {
                        Object[] objectArray = this.bindCol[n].allocBindDataBuf(8);
                        double d = (Double)this.bindCol[n].getData();
                        Object object3 = new long[2];
                        Object object2 = this.myStatement.myConnection;
                        // MONITORENTER : object2
                        this.ODBCOBJ.jdbcBindColDouble(this.myStatement.getHSTMT(), n + 1, d, (byte[])objectArray, (long[])object3);
                        // MONITOREXIT : object2
                        this.bindCol[n].pgDataBuf = (long)object3[0];
                        this.bindCol[n].pgDataValBuf = (long)object3[1];
                        this.bindCol[n].pgLenBuf = 0L;
                        this.bindCol[n].pgLenValBuf = 0L;
                        break;
                    }
                    case 6: {
                        Object[] objectArray = this.bindCol[n].allocBindDataBuf(8);
                        float f = ((Float)this.bindCol[n].getData()).floatValue();
                        long[] lArray = new long[2];
                        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
                        Object object3 = jdbcOdbcConnection;
                        // MONITORENTER : jdbcOdbcConnection
                        this.ODBCOBJ.jdbcBindColFloat(this.myStatement.getHSTMT(), n + 1, f, (byte[])objectArray, lArray);
                        // MONITOREXIT : object3
                        this.bindCol[n].pgDataBuf = lArray[0];
                        this.bindCol[n].pgDataValBuf = lArray[1];
                        this.bindCol[n].pgLenBuf = 0L;
                        this.bindCol[n].pgLenValBuf = 0L;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        Object object;
                        Object object2;
                        Object object3;
                        Object[] objectArray = this.bindCol[n].getBinaryLen();
                        long[] lArray = new long[4];
                        int n4 = this.bindCol[n].getStreamType();
                        if (n4 == 0) {
                            object3 = (byte[])this.bindCol[n].getData();
                            object2 = this.bindCol[n].allocBindDataBuf(((long[])object3).length);
                            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
                            object = jdbcOdbcConnection;
                            // MONITORENTER : jdbcOdbcConnection
                            this.ODBCOBJ.jdbcBindColBinary(this.myStatement.getHSTMT(), n + 1, n2, (byte[])object3, (byte[])object2, (long[])objectArray, lArray);
                            // MONITOREXIT : object
                        } else {
                            object3 = this.bindCol[n].allocBindDataBuf(4);
                            object2 = this.myStatement.myConnection;
                            // MONITORENTER : object2
                            this.ODBCOBJ.jdbcBindColAtExec(this.myStatement.getHSTMT(), n + 1, n2, (byte[])object3, (long[])objectArray, lArray);
                            // MONITOREXIT : object2
                        }
                        this.bindCol[n].pgDataBuf = lArray[0];
                        this.bindCol[n].pgDataValBuf = lArray[1];
                        this.bindCol[n].pgLenBuf = lArray[2];
                        this.bindCol[n].pgLenValBuf = lArray[3];
                        break;
                    }
                    case -8: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        JdbcOdbcConnection jdbcOdbcConnection;
                        Object object;
                        Object object2;
                        Object object3;
                        Object[] objectArray = this.bindCol[n].getBinaryLen();
                        int n5 = this.bindCol[n].getStreamType();
                        if (n5 != 0) {
                            long[] lArray = new long[4];
                            object3 = this.bindCol[n].allocBindDataBuf(4);
                            object2 = this.myStatement.myConnection;
                            // MONITORENTER : object2
                            this.ODBCOBJ.jdbcBindColAtExec(this.myStatement.getHSTMT(), n + 1, n2, (byte[])object3, (long[])objectArray, lArray);
                            // MONITOREXIT : object2
                            this.bindCol[n].pgDataBuf = lArray[0];
                            this.bindCol[n].pgDataValBuf = lArray[1];
                            this.bindCol[n].pgLenBuf = lArray[2];
                            this.bindCol[n].pgLenValBuf = lArray[3];
                            break;
                        }
                        Object object4 = this.bindCol[n].getData();
                        object3 = null;
                        if (object4 != null) {
                            object3 = object4.toString();
                        }
                        if (object3 == null) {
                            object2 = new long[4];
                            object = this.bindCol[n].allocBindDataBuf(1);
                            jdbcOdbcConnection = this.myStatement.myConnection;
                            // MONITORENTER : jdbcOdbcConnection
                            this.ODBCOBJ.jdbcBindColNull(this.myStatement.getHSTMT(), n + 1, (byte[])object, (long[])objectArray, (long[])object2);
                            // MONITOREXIT : jdbcOdbcConnection
                            this.bindCol[n].pgDataBuf = (long)object2[0];
                            this.bindCol[n].pgDataValBuf = (long)object2[1];
                            this.bindCol[n].pgLenBuf = (long)object2[2];
                            this.bindCol[n].pgLenValBuf = (long)object2[3];
                            break;
                        }
                        object2 = new long[4];
                        try {
                            object = this.bindCol[n].allocBindDataBuf(((String)object3).getBytes(ODBCDef.DM_UNICODE).length + 2);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new SQLException("encoding unsupported");
                        }
                        jdbcOdbcConnection = this.myStatement.myConnection;
                        // MONITORENTER : jdbcOdbcConnection
                        this.ODBCOBJ.jdbcBindColStr(this.myStatement.getHSTMT(), n + 1, (String)object3, (byte[])object, (long[])objectArray, (long[])object2);
                        // MONITOREXIT : jdbcOdbcConnection
                        this.bindCol[n].pgDataBuf = (long)object2[0];
                        this.bindCol[n].pgDataValBuf = (long)object2[1];
                        this.bindCol[n].pgLenBuf = (long)object2[2];
                        this.bindCol[n].pgLenValBuf = (long)object2[3];
                        break;
                    }
                    case 99: {
                        Object[] objectArray = this.bindCol[n].getBinaryLen();
                        long[] lArray = new long[4];
                        byte[] byArray = this.bindCol[n].allocBindDataBuf(1);
                        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
                        Object object3 = jdbcOdbcConnection;
                        // MONITORENTER : jdbcOdbcConnection
                        this.ODBCOBJ.jdbcBindColIgnore(this.myStatement.getHSTMT(), n + 1, byArray, (long[])objectArray, lArray);
                        // MONITOREXIT : object3
                        this.bindCol[n].pgDataBuf = lArray[0];
                        this.bindCol[n].pgDataValBuf = lArray[1];
                        this.bindCol[n].pgLenBuf = lArray[2];
                        this.bindCol[n].pgLenValBuf = lArray[3];
                        break;
                    }
                    default: {
                        this.JDBCError("JERR_INTERNAL_ERROR", "ResultSet.bindColumn(" + n2 + ")");
                    }
                }
                ++n;
            }
            return;
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    private void resetBindCol() throws SQLException {
        for (int i = 0; i < this.numResultCols; ++i) {
            this.bindCol[i].clear();
        }
    }

    private boolean isBlobType(int n) throws SQLException {
        int n2 = this.selectCol[n - 1].sqltype;
        return n2 == -4 || n2 == -1 || n2 == -10 || n2 == 301;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void putData() throws SQLException {
        var2_1 = true;
        var3_2 = false;
lbl3:
        // 3 sources

        try {
            block22: while (var2_1) {
                block36: {
                    block37: {
                        var18_15 = this.myStatement.myConnection;
                        synchronized (var18_15) {
                            var1_3 = this.ODBCOBJ.jdbcParamData(this.myStatement.getHSTMT());
                        }
                        if (var1_3 <= 0) break block36;
                        var13_10 = this.bindCol[var1_3 - 1].getStreamType();
                        var11_9 = this.bindCol[var1_3 - 1].getStreamLen();
                        var6_6 = (int)(var11_9 / (long)JdbcOdbcResultSet.INPUT_STREAM_BUF_LEN + 1L);
                        if (var13_10 != 2) break block37;
                        var14_11 = this.bindCol[var1_3 - 1].getReader();
                        var15_12 = new char[JdbcOdbcResultSet.INPUT_STREAM_BUF_LEN];
                        var18_16 = 0;
                        while (var18_16 < var6_6) {
                            try {
                                var9_8 = var14_11.read(var15_12);
                            }
                            catch (IOException var19_22) {
                                throw new SQLException(var19_22.getMessage());
                            }
                            if (var9_8 != -1L) {
                                try {
                                    var19_20 = new String(var15_12, 0, (int)var9_8);
                                    var5_5 = var19_20.getBytes(ODBCDef.DM_UNICODE);
                                }
                                catch (UnsupportedEncodingException var19_23) {
                                    throw new SQLException("encoding unsupported");
                                }
                                var19_20 = this.myStatement.myConnection;
                                synchronized (var19_20) {
                                    this.ODBCOBJ.jdbcPutData(this.myStatement.getHSTMT(), var5_5, var5_5.length);
                                }
                                var3_2 = true;
                            } else {
                                if (var3_2) continue block22;
                                this.JDBCError("JERR_CANNOT_GET_ENOUGH_STREAM", "ResultSet.putData()");
                            }
                            ++var18_16;
                            var11_9 -= (long)JdbcOdbcResultSet.INPUT_STREAM_BUF_LEN;
                        }
                        ** GOTO lbl3
                    }
                    if (var13_10 == 4) {
                        var16_13 = this.bindCol[var1_3 - 1].getBlob();
                        var4_4 = var16_13.getBinaryStream();
                    } else if (var13_10 == 3) {
                        var17_14 = this.bindCol[var1_3 - 1].getClob();
                        var4_4 = var17_14.getAsciiStream();
                    } else {
                        var4_4 = this.bindCol[var1_3 - 1].getInputStream();
                    }
                    var5_5 = new byte[JdbcOdbcResultSet.INPUT_STREAM_BUF_LEN];
                    if (var11_9 == 0x7FFFFFFFL) {
                        do {
                            try {
                                var9_8 = var4_4.read(var5_5);
                            }
                            catch (IOException var18_17) {
                                throw new SQLException(var18_17.getMessage());
                            }
                            if (var9_8 != -1L) {
                                var18_15 = this.myStatement.myConnection;
                                synchronized (var18_15) {
                                    this.ODBCOBJ.jdbcPutData(this.myStatement.getHSTMT(), var5_5, var9_8);
                                }
                                var3_2 = true;
                                continue;
                            }
                            if (var3_2) continue block22;
                            this.JDBCError("JERR_CANNOT_GET_ENOUGH_STREAM", "ResultSet.putData()");
                        } while (var9_8 == (long)JdbcOdbcResultSet.INPUT_STREAM_BUF_LEN);
                        continue;
                    }
                    var18_18 = 0;
                    while (var18_18 < var6_6) {
                        try {
                            var9_8 = var4_4.read(var5_5);
                        }
                        catch (IOException var19_24) {
                            throw new SQLException(var19_24.getMessage());
                        }
                        if (var9_8 != -1L) {
                            var7_7 = var11_9 > (long)JdbcOdbcResultSet.INPUT_STREAM_BUF_LEN ? (long)JdbcOdbcResultSet.INPUT_STREAM_BUF_LEN : var11_9;
                            var19_20 = this.myStatement.myConnection;
                            synchronized (var19_20) {
                                this.ODBCOBJ.jdbcPutData(this.myStatement.getHSTMT(), var5_5, var7_7);
                            }
                            var3_2 = true;
                        } else {
                            if (var3_2) continue block22;
                            this.JDBCError("JERR_CANNOT_GET_ENOUGH_STREAM", "ResultSet.putData()");
                        }
                        ++var18_18;
                        var11_9 -= (long)JdbcOdbcResultSet.INPUT_STREAM_BUF_LEN;
                    }
                    ** GOTO lbl3
                }
                var2_1 = false;
            }
        }
        catch (SQLWarning var18_19) {
            this.lastWarning = var18_19;
        }
    }

    private int getCursorType() throws SQLException {
        if (this.myCursorType == -1) {
            this.myCursorType = this.myStatement.getResultSetType();
        }
        return this.myCursorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSvrstmt() throws SQLException {
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            return this.ODBCOBJ.jdbcGetStmtAttrLong(this.myStatement.getHSTMT(), 1117);
        }
    }

    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    public boolean isClosed() throws SQLException {
        if (this.isClose) {
            return true;
        }
        return this.myStatement.isClosed();
    }

    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        try {
            this.updateAsciiStream(n, inputStream, inputStream.available());
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        try {
            this.updateBinaryStream(n, inputStream, inputStream.available());
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream);
    }

    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n, inputStream);
    }

    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream);
    }

    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(n, inputStream, l);
    }

    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader, Integer.MAX_VALUE);
    }

    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    public void updateClob(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader);
    }

    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(string), reader);
    }

    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(this.findColumn(string), reader, l);
    }

    protected ResourceBundle getResourceBundle() {
        return this.myStatement.getResourceBundle();
    }

    public void t3UpdateStream(int n, long l, short s) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.t3UpdateStream(" + n + "," + l + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.t3UpdateBinaryStream(" + n + ")");
        }
        n = this.needRemap ? this.myStatement.mapColumn(n) : n;
        this.lastWarning = null;
        this.bindCol[n - 1].setInputStream(null, l, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int t3UpdateRow() throws SQLException {
        int n;
        int n2;
        int n3 = 0;
        if (this.needTrace) {
            this.trace("ResultSet.t3UpdateRow()");
        }
        this.checkClosed(this.isClosed());
        if (this.cursorPos <= 0) {
            this.JDBCError("JERR_CURSOR_POS_INCORRECT", "ResultSet.updateRow()");
        }
        if (this.rsStatus == 1 || this.rsStatus == 3) {
            this.JDBCError("JERR_CANNOT_UPDATE_ROW", "ResultSet.updateRow()");
        }
        if ((n2 = this.getCursorType()) == 1003) {
            this.JDBCError("JERR_CURSOR_FORWARD_ONLY", "ResultSet.updateRow(" + n2 + ")");
        }
        if ((n = this.myStatement.getResultSetConcurrency()) == 1007) {
            this.JDBCError("JERR_CONCUR_READ_ONLY", "ResultSet.updateRow(" + n + ")");
        }
        this.lastWarning = null;
        this.clearLargeObject();
        this.bindColumn();
        try {
            boolean bl = false;
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                bl = this.ODBCOBJ.jdbcSetPos(this.myStatement.getHSTMT(), this.cursorPos, 2);
            }
            if (bl) {
                n3 = 99;
                return n3;
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        catch (SQLException sQLException) {
            this.rsStatus = (short)5;
            this.freeBindColumns();
            throw sQLException;
        }
        this.rsStatus = (short)2;
        this.freeBindColumns();
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcFreeStmt(this.myStatement.getHSTMT(), 2);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = null;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int t3InsertRow() throws SQLException {
        int n;
        int n2 = 0;
        if (this.needTrace) {
            this.trace("ResultSet.t3InsertRow()");
        }
        this.checkClosed(this.isClosed());
        int n3 = this.getCursorType();
        if (n3 == 1003) {
            this.JDBCError("JERR_CURSOR_FORWARD_ONLY", "ResultSet.insertRow(" + n3 + ")");
        }
        if ((n = this.myStatement.getResultSetConcurrency()) == 1007) {
            this.JDBCError("JERR_CONCUR_READ_ONLY", "ResultSet.insertRow(" + n + ")");
        }
        if (!this.insertFlag) {
            this.JDBCError("JERR_INV_INSERT_POS", "ResultSet.insertRow()");
        }
        this.lastWarning = null;
        this.bindColumn();
        try {
            boolean bl = false;
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                bl = this.ODBCOBJ.jdbcBulkOperations(this.myStatement.getHSTMT(), 4);
            }
            if (bl) {
                n2 = 99;
                return n2;
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        catch (SQLException sQLException) {
            this.freeBindColumns();
            this.rsStatus = (short)5;
            throw sQLException;
        }
        this.rsStatus = (short)4;
        this.freeBindColumns();
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcFreeStmt(this.myStatement.getHSTMT(), 2);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = null;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int t3ParamData() throws SQLException {
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            return this.ODBCOBJ.jdbcParamData(this.myStatement.getHSTMT());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int t3PutData(byte[] byArray, long l) throws SQLException {
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.ODBCOBJ.jdbcPutData(this.myStatement.getHSTMT(), byArray, l);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t3UpdateRowFinal() throws SQLException {
        this.rsStatus = (short)2;
        this.freeBindColumns();
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcFreeStmt(this.myStatement.getHSTMT(), 2);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t3InsertRowFinal() throws SQLException {
        this.rsStatus = (short)4;
        this.freeBindColumns();
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcFreeStmt(this.myStatement.getHSTMT(), 2);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcOdbcNClob getNClob(int n) throws SQLException {
        boolean bl;
        if (this.needTrace) {
            this.trace("ResultSet.getNClob(" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.getClob(" + n + ")");
        }
        if (!(bl = this.isBlobType(n = this.needRemap ? this.myStatement.mapColumn(n) : n))) {
            this.JDBCError("JERR_CANNOT_GET_BLOB", "ResultSet.getClob()");
        }
        JdbcOdbcNClob jdbcOdbcNClob = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
        synchronized (jdbcOdbcConnection) {
            JdbcOdbcConnection jdbcOdbcConnection2 = (JdbcOdbcConnection)this.myStatement.getConnection();
            jdbcOdbcNClob = new JdbcOdbcNClob(this.ODBCOBJ, jdbcOdbcConnection2, this.myStatement, n, this.selectCol[n - 1].sqltype);
            if (jdbcOdbcConnection2.getAutoCommit()) {
                this.registerLargeObject(jdbcOdbcNClob);
            } else {
                jdbcOdbcConnection2.registerLargeObject(jdbcOdbcNClob);
            }
        }
        this.lastColumnNull = jdbcOdbcNClob.isNull();
        return jdbcOdbcNClob;
    }

    private void registerLargeObject(LargeObjectInterface largeObjectInterface) {
        this.lobs.add(largeObjectInterface);
    }

    private void clearLargeObject() throws SQLException {
        Iterator iterator = this.lobs.iterator();
        while (iterator.hasNext()) {
            ((LargeObjectInterface)iterator.next()).close();
        }
        this.lobs.clear();
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateBlob(" + n + "," + blob + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateBlob(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        this.lastWarning = null;
        this.bindCol[n2 - 1].setBlob(blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateBlob(" + string + "," + blob + ")");
        }
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateClob(" + n + "," + clob + ")");
        }
        this.checkClosed(this.isClosed());
        if (n <= 0 || n > this.numResultCols) {
            this.JDBCError("JERR_INV_COLUMN_NUM", "ResultSet.updateClob(" + n + ")");
        }
        int n2 = this.myStatement.mapColumn(n);
        this.lastWarning = null;
        this.bindCol[n2 - 1].setClob(clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.updateClob(" + string + "," + clob + ")");
        }
        this.updateClob(this.findColumn(string), clob);
    }

    public URL getURL(int n) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.getURL(int columnIndex)", null);
    }

    public URL getURL(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.getURL(String columnName)", null);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.updateRef(int columnIndex, Ref x)", null);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.updateRef(String columnName, Ref x)", null);
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.updateArray(int columnIndex, Array x)", null);
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "ResultSet.updateArray(String columnName, Array x)", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("ResultSet.findColumn(" + string + ")");
        }
        this.checkClosed(this.isClosed());
        if (string == null) {
            this.JDBCError("JERR_CANNOT_NULL_STRING", "ResultSet.findColumn(String)");
        }
        if (string.compareTo("") == 0) {
            this.JDBCError("JERR_CANNOT_EMPTY_STRING", "ResultSet.findColumn(String)");
        }
        this.lastWarning = null;
        try {
            for (int i = 1; i <= this.numResultCols; ++i) {
                String string2;
                JdbcOdbcConnection jdbcOdbcConnection = this.myStatement.myConnection;
                synchronized (jdbcOdbcConnection) {
                    string2 = this.ODBCOBJ.jdbcColAttributeStr(this.myStatement.getHSTMT(), i, 1011);
                }
                if (!(this.gbDbCase == 1 ? string.equalsIgnoreCase(string2) : string.compareTo(string2) == 0)) continue;
                return i;
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        throw this.JDBCError("JERR_CANNOT_FIND_COLUMN", "ResultSet.findColumn(" + string + ")", null);
    }

    class ColumnInfo {
        int type;
        int sqltype;
        int maxlen;
        byte[] buffer;
        double[] dvalue = new double[1];
        float[] fvalue = new float[1];
        int[] ivalue = new int[1];
        long[] lvalue = new long[1];
        long[] len = new long[1];

        ColumnInfo() {
        }
    }
}

