/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.sql;

import dbmaster.sql.JdbcOdbc;
import dbmaster.sql.JdbcOdbcAPI;
import dbmaster.sql.JdbcOdbcConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class JdbcOdbcDriver
extends JdbcOdbc
implements java.sql.Driver {
    public static final int majorVersion = 1;
    public static final int minorVersion = 0;
    private final boolean jdbcCompliant = false;
    private static HashMap drivers = new HashMap();
    static Lock myLock = new Lock();
    private ResourceBundle rb = null;

    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        JdbcOdbcConnection jdbcOdbcConnection = null;
        ConnInfo connInfo = new ConnInfo();
        if (!this.acceptsURL(string, connInfo)) {
            return null;
        }
        Driver driver = this.getDriver(connInfo);
        if (connInfo.fgJavaSP) {
            jdbcOdbcConnection = new JdbcOdbcConnection(connInfo.javaHDBC, driver);
        } else {
            String string2 = connInfo.ConnStr;
            String string3 = JdbcOdbcDriver.getErrlcode(string);
            if (string3 != null) {
                this.rb = driver.ODBCOBJ.getResourceBundle(string3);
            }
            jdbcOdbcConnection = new JdbcOdbcConnection(string2, properties, driver);
        }
        jdbcOdbcConnection.setURL(string);
        return jdbcOdbcConnection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        ConnInfo connInfo = new ConnInfo();
        return this.acceptsURL(string, connInfo);
    }

    private boolean acceptsURL(String string, ConnInfo connInfo) throws SQLException {
        int n = 0;
        int n2 = 0;
        if (this.trusted()) {
            n = string.indexOf(":");
            if (n > 0) {
                String string2 = string.substring(0, n);
                if (string2.equalsIgnoreCase("jdbc") && (n2 = string.indexOf(":", n + 1)) > 0) {
                    String string3 = string.substring(n + 1, n2);
                    if (string3.equalsIgnoreCase("dbmaster")) {
                        String string4 = string.substring(n2 + 1);
                        return this.acceptsubName(string4, connInfo);
                    }
                    if (string3.equalsIgnoreCase("default")) {
                        String string5 = string.substring(n2 + 1);
                        if (string5.equalsIgnoreCase("connection")) {
                            connInfo.fgJavaSP = true;
                            return true;
                        }
                        return false;
                    }
                    if (string3.equalsIgnoreCase("dbmaster-odbc")) {
                        String string6;
                        connInfo.ConnStr = string6 = string.substring(n2 + 1);
                        connInfo.fgODBC = true;
                        return true;
                    }
                }
            } else if (this.needTrace) {
                this.trace("invalid URL - " + string + " (index1 = " + n + ", index2 = " + n2 + ")");
            }
        }
        return false;
    }

    private boolean acceptsubName(String string, ConnInfo connInfo) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = string.indexOf("//");
        if (n >= 0) {
            String string2 = string.substring(0, n + 2);
            if (string2.compareTo("//") == 0 && (n2 = string.indexOf(":", n + 2)) > 0) {
                String string3 = string.substring(n + 2, n2);
                n3 = string.indexOf("/", n2 + 1);
                if (n3 > 0) {
                    String string4 = string.substring(n2 + 1, n3);
                    String string5 = string.substring(n3 + 1);
                    connInfo.ConnStr = "DSN=" + string5 + ";SVADR=" + string3 + ";PTNUM=" + string4 + ";";
                    bl = true;
                }
            }
        } else {
            connInfo.ConnStr = "DSN=" + string;
            bl = true;
        }
        return bl;
    }

    boolean trusted() {
        return true;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "PreparedStatement.Driver.getPropertyInfo(String, java.util.Properties)", null);
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    protected Driver getDriver() throws SQLException {
        return this.getDriver(new ConnInfo());
    }

    protected synchronized Driver getDriver(ConnInfo connInfo) throws SQLException {
        String string = System.getProperty("DM_DRIVER_MODE");
        int n = 1;
        if (string != null) {
            if (string.compareTo("SERVER_ODBC") == 0) {
                n = 3;
            } else if (string.compareTo("SINGLE_USER") == 0) {
                n = 2;
            }
        }
        if (connInfo.fgJavaSP) {
            n = 3;
        }
        if (connInfo.fgODBC) {
            n = 4;
        }
        long[] lArray = new long[1];
        Driver driver = (Driver)drivers.get(new Integer(n));
        if (driver != null) {
            if (connInfo.fgJavaSP) {
                connInfo.javaHDBC = driver.ODBCOBJ.jdbcGetEnvAttrLong(driver.hENV, 1001);
            }
            return driver;
        }
        if (driver == null) {
            driver = new Driver();
            drivers.put(new Integer(n), driver);
        }
        if (connInfo.fgODBC) {
            driver.fgODBC = true;
        }
        if (driver.dllVersion == null) {
            lArray[0] = 0L;
        } else {
            lArray[0] = driver.dllHandler;
            if (driver.dllVersion.compareTo(string) == 0) {
                n = 0;
            }
        }
        driver.hENV = driver.ODBCOBJ.jdbcAllocEnv(null, n, lArray, connInfo.fgJavaSP);
        driver.dllVersion = string;
        driver.dllHandler = lArray[0];
        if (connInfo.fgJavaSP) {
            connInfo.javaHDBC = driver.ODBCOBJ.jdbcGetEnvAttrLong(driver.hENV, 1001);
        }
        return driver;
    }

    private static String getErrlcode(String string) {
        String string2 = string.toLowerCase();
        int n = string2.indexOf("errlcode");
        if (n < 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n), "= ;");
        stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        return stringTokenizer.nextToken();
    }

    public static String getDMVersion() {
        return "5.4.7 (#32018, 20250731)";
    }

    protected ResourceBundle getResourceBundle() {
        if (this.rb != null) {
            return this.rb;
        }
        this.rb = ResourceBundle.getBundle("dbmaster.sql.dmJdbc");
        return this.rb;
    }

    static {
        JdbcOdbcDriver.trace2("JdbcOdbcDriver static method - register driver");
        JdbcOdbcDriver jdbcOdbcDriver = new JdbcOdbcDriver();
        try {
            DriverManager.registerDriver(jdbcOdbcDriver);
        }
        catch (SQLException sQLException) {
            JdbcOdbcDriver.trace2("register driver fail (" + sQLException.getMessage() + ")");
        }
    }

    private static class Lock
    extends Thread {
        private boolean locked = false;
        private Thread thisThread = null;

        private Lock() {
        }

        private final synchronized void lock() throws SQLException {
            this.thisThread = Thread.currentThread();
            while (this.locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.locked = true;
            this.thisThread = null;
        }

        private final synchronized void unlock() throws SQLException {
            this.locked = false;
            this.notifyAll();
        }
    }

    static class ConnInfo {
        String ConnStr;
        boolean fgJavaSP = false;
        boolean fgODBC = false;
        long javaHDBC = 0L;

        ConnInfo() {
        }
    }

    class Driver {
        protected long hENV = 0L;
        int hDBC_getProInfo;
        int nConn = 0;
        String dllVersion;
        long dllHandler;
        boolean fgODBC = false;
        protected JdbcOdbcAPI ODBCOBJ = new JdbcOdbcAPI();

        Driver() {
        }

        long allocConn() throws SQLException {
            long l = 0L;
            myLock.lock();
            ++this.nConn;
            myLock.unlock();
            try {
                l = this.ODBCOBJ.jdbcAllocConnect(this.hENV);
            }
            catch (SQLException sQLException) {
                myLock.lock();
                --this.nConn;
                myLock.unlock();
                throw JdbcOdbcDriver.this.JDBCError("JERR_INTERNAL_ERROR", null, sQLException);
            }
            return l;
        }

        void disConn(long l) throws SQLException {
            if (JdbcOdbcDriver.this.needTrace) {
                JdbcOdbcDriver.this.trace("Connection.disConn");
            }
            try {
                this.ODBCOBJ.jdbcDisconnect(l);
            }
            catch (SQLException sQLException) {
                throw JdbcOdbcDriver.this.JDBCError("JERR_DISCONN_FAIL", null, sQLException);
            }
        }

        void freeConn(long l) throws SQLException {
            if (JdbcOdbcDriver.this.needTrace) {
                JdbcOdbcDriver.this.trace("Connection.freeConn");
            }
            try {
                this.ODBCOBJ.jdbcFreeConnect(l);
            }
            catch (SQLException sQLException) {
                throw JdbcOdbcDriver.this.JDBCError("JERR_INTERNAL_ERROR", null, sQLException);
            }
            myLock.lock();
            --this.nConn;
            myLock.unlock();
        }
    }
}

