/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.sql;

import dbmaster.sql.JdbcOdbcAPI;
import dbmaster.sql.JdbcOdbcConnection;
import dbmaster.sql.JdbcOdbcStatement;
import dbmaster.sql.LargeObjectAbstract;
import dbmaster.sql.ODBCDef;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ResourceBundle;

public class JdbcOdbcClob
extends LargeObjectAbstract
implements Clob {
    protected long available;
    protected long total_length;
    private String clilcode = null;
    private int _sqltype = -1;
    static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected static final short BINARY_STREAM = 0;
    protected static final short ASCII_STREAM = 1;
    protected static final short B2HEX_STREAM = 2;
    protected static final short U16_ASCII_STREAM = 3;
    protected static final short U8_ASCII_STREAM = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcOdbcClob(JdbcOdbcAPI jdbcOdbcAPI, JdbcOdbcConnection jdbcOdbcConnection, JdbcOdbcStatement jdbcOdbcStatement, int n, int n2) throws SQLException {
        this.ODBCOBJ = jdbcOdbcAPI;
        this.myConnection = jdbcOdbcConnection;
        this.myStatement = jdbcOdbcStatement;
        byte[] byArray = new byte[1];
        this._sqltype = n2;
        JdbcOdbcConnection jdbcOdbcConnection2 = this.myConnection;
        synchronized (jdbcOdbcConnection2) {
            this.available = this.total_length = this.ODBCOBJ.jdbcGetDataStream(jdbcOdbcStatement.getHSTMT(), n, 1, byArray, 0);
            this.hBLOB = this.ODBCOBJ.jdbcGetBlobHandle(jdbcOdbcStatement.getHSTMT(), n);
        }
        if (this.hBLOB == 0L) {
            this.wasNull = true;
        }
        this.isClose = false;
        this.clilcode = this.myConnection.getClilcode();
    }

    public long length() throws SQLException {
        this.trace("JdbcOdbcClob.length");
        this.checkClosed(this.isClose);
        return this.total_length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long l, int n) throws SQLException {
        this.trace("JdbcOdbcClob.getSubString");
        if (l < 1L) {
            this.JDBCError("JERR_INV_START_POS", null);
        }
        if (n < 0) {
            this.JDBCError("JERR_INV_GET_LENGTH", null);
        }
        this.checkClosed(this.isClose);
        byte[] byArray = null;
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            byArray = this.ODBCOBJ.jdbcGetBlob(this.hBLOB, l - 1L, n);
        }
        try {
            if (this.clilcode == null) {
                return new String(byArray);
            }
            return new String(byArray, this.clilcode);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes(long l, int n, byte[] byArray, int[] nArray) throws SQLException {
        this.trace("JdbcOdbcClob.getBytes");
        if (l < 1L) {
            this.JDBCError("JERR_INV_START_POS", null);
        }
        if (n < 0) {
            this.JDBCError("JERR_INV_GET_LENGTH", null);
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            return this.ODBCOBJ.jdbcGetBlob(this.hBLOB, l - 1L, n, byArray, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        this.trace("JdbcOdbcClob.getBytes");
        if (l < 1L) {
            this.JDBCError("JERR_INV_START_POS", null);
        }
        if (n < 0) {
            this.JDBCError("JERR_INV_GET_LENGTH", null);
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            return this.ODBCOBJ.jdbcGetBlob(this.hBLOB, l - 1L, n);
        }
    }

    public static byte[] getHex(byte[] byArray, int n) {
        byte[] byArray2 = new byte[2 * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = byArray[i] & 0xFF;
            byArray2[n2++] = HEX_CHAR_TABLE[n3 >>> 4];
            byArray2[n2++] = HEX_CHAR_TABLE[n3 & 0xF];
        }
        return byArray2;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.trace("JdbcOdbcClob.getAsciiStream");
        this.checkClosed(this.isClose);
        return this.getAsciiStream(false);
    }

    protected InputStream getAsciiStream(boolean bl) throws SQLException {
        if (this._sqltype == -4) {
            return new Stream(this, bl, 2, 1L, this.total_length);
        }
        if (this._sqltype == -10) {
            return new Stream(this, bl, 3, 1L, this.total_length);
        }
        if (this.myConnection.isU8()) {
            return new Stream(this, bl, 4, 1L, this.total_length);
        }
        return new Stream(this, bl, 1, 1L, this.total_length);
    }

    public java.io.Reader getCharacterStream() throws SQLException {
        return this.getCharacterStream(1L, this.total_length);
    }

    public long position(String string, long l) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Clob.position(String, long)", null);
    }

    public long position(Clob clob, long l) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Clob.position(Clob, long)", null);
    }

    public boolean isNull() throws SQLException {
        this.checkClosed(this.isClose);
        return this.wasNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (!this.isClose) {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.myConnection.unregisterLargeObject(this);
                if (this.hBLOB != 0L) {
                    this.ODBCOBJ.jdbcDropBlobHandle(this.hBLOB);
                }
            }
            this.isClose = true;
        }
    }

    public void free() throws SQLException {
        this.close();
    }

    public java.io.Reader getCharacterStream(long l, long l2) throws SQLException {
        this.trace("JdbcOdbcClobg.getCharacterStream");
        this.checkClosed(this.isClose);
        try {
            String string = this.myConnection.getClilcode();
            if (this._sqltype == -10) {
                string = ODBCDef.DM_UNICODE;
            } else if (this._sqltype == -1 && this.myConnection.isU8()) {
                string = "UTF-8";
            }
            Stream stream = new Stream(this, false, 0, l, l2);
            if (string == null) {
                return new InputStreamReader(stream);
            }
            return new InputStreamReader((InputStream)stream, string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    protected java.io.Reader getCharacterStream(boolean bl) throws SQLException {
        this.trace("JdbcOdbcClob.getCharacterStream");
        this.checkClosed(this.isClose);
        try {
            String string = this.myConnection.getClilcode();
            if (this._sqltype == -10) {
                string = ODBCDef.DM_UNICODE;
            } else if (this._sqltype == -1 && this.myConnection.isU8()) {
                string = "UTF-8";
            }
            Stream stream = new Stream(this, bl, 0, 1L, this.total_length);
            if (string == null) {
                return new InputStreamReader(stream);
            }
            return new InputStreamReader((InputStream)stream, string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    protected ResourceBundle getResourceBundle() {
        return this.myConnection.getResourceBundle();
    }

    public int setString(long l, String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Clob.setString(long pos, String str)", null);
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Clob.setString(long pos, String str, int offset, int len)", null);
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Clob.setAsciiStream(long pos)", null);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Clob.setCharacterStream(long pos)", null);
    }

    public void truncate(long l) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Clob.truncate(long len)", null);
    }

    public class Reader
    extends InputStreamReader {
        private InputStream _in = null;

        public Reader(InputStream inputStream) {
            super(inputStream);
            this._in = inputStream;
        }

        public Reader(InputStream inputStream, String string) throws UnsupportedEncodingException {
            super(inputStream, string);
            this._in = inputStream;
        }

        public void mark(int n) throws IOException {
            this._in.mark(n);
        }

        public void reset() throws IOException {
            this._in.reset();
        }

        public boolean markSupported() {
            return true;
        }
    }

    public class Stream
    extends InputStream {
        private JdbcOdbcClob _clob = null;
        private long _clobPos = 0L;
        private long _clobLen = 0L;
        private boolean _freeClobWhenClose = false;
        private byte[] buffer = new byte[1024];
        private byte[] ba = null;
        private int pos = 0;
        private int[] relen = new int[1];
        private int end = 0;
        private int _readlimit = 0;
        private short _type = 0;
        private boolean isClose = false;

        Stream(JdbcOdbcClob jdbcOdbcClob2, boolean bl, short s, long l, long l2) {
            this._clob = jdbcOdbcClob2;
            this._type = s;
            this._clobLen = l2;
            this._clobPos = l;
            this._freeClobWhenClose = bl;
        }

        public void close() {
            if (this._clob.isClose || this.isClose) {
                return;
            }
            this.isClose = true;
            if (!this._freeClobWhenClose) {
                return;
            }
            try {
                this._clob.free();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }

        public int available() throws IOException {
            try {
                JdbcOdbcClob.this.checkClosed(this._clob.isClose || this.isClose);
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            return (int)JdbcOdbcClob.this.available;
        }

        public int read() throws IOException {
            try {
                JdbcOdbcClob.this.checkClosed(this._clob.isClose || this.isClose);
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            try {
                if (this.ba == null || this.pos > this.end) {
                    if (this._clobPos > this._clobLen) {
                        return -1;
                    }
                    int n = (int)(this._clobLen - this._clobPos + 1L > 1024L ? 1024L : this._clobLen - this._clobPos + 1L);
                    this.buffer = this._clob.getBytes(this._clobPos, n, this.buffer, this.relen);
                    if (this.relen[0] <= 0) {
                        return -1;
                    }
                    this._clobPos += (long)this.relen[0];
                    this.pos = 0;
                    if (this._type == 1) {
                        String string = null;
                        if (JdbcOdbcClob.this.clilcode != null) {
                            string = new String(this.buffer, 0, this.relen[0], JdbcOdbcClob.this.clilcode);
                            this.ba = string.getBytes();
                        } else {
                            this.ba = new byte[this.relen[0]];
                            System.arraycopy(this.buffer, 0, this.ba, 0, this.relen[0]);
                        }
                        this.end = this.ba.length - 1;
                    } else if (this._type == 3) {
                        if (this._freeClobWhenClose) {
                            String string = new String(this.buffer, 0, this.relen[0], "UTF-16LE");
                            this.ba = string.getBytes();
                        } else {
                            this.ba = new byte[this.relen[0]];
                            System.arraycopy(this.buffer, 0, this.ba, 0, this.relen[0]);
                        }
                        this.end = this.ba.length - 1;
                    } else if (this._type == 2) {
                        this.ba = JdbcOdbcClob.getHex(this.buffer, this.relen[0]);
                        this.end = this.ba.length - 1;
                        this._clobPos += (long)this.relen[0];
                    } else if (this._type == 4) {
                        String string = new String(this.buffer, 0, this.relen[0], "UTF-8");
                        this.ba = string.getBytes();
                        this.end = this.ba.length - 1;
                    } else {
                        this.ba = this.buffer;
                        this.end = this.relen[0] - 1;
                    }
                }
                --JdbcOdbcClob.this.available;
                return this.ba[this.pos++] & 0xFF;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                return -1;
            }
        }

        public void mark(int n) {
            this._readlimit = n;
        }

        public void reset() throws IOException {
            this._clobPos = this._readlimit + 1;
            JdbcOdbcClob.this.available = JdbcOdbcClob.this.total_length - (long)this._readlimit;
            this.pos = 0;
            this.ba = null;
        }
    }
}

