/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;

class JPEGImage
extends SimpleRenderedImage {
    private BufferedImage image = null;

    public JPEGImage(InputStream inputStream) {
        JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream);
        try {
            this.image = jPEGImageDecoder.decodeAsBufferedImage();
        }
        catch (ImageFormatException imageFormatException) {
            throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder1"));
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder2"));
        }
        this.minX = 0;
        this.minY = 0;
        this.tileWidth = this.width = this.image.getWidth();
        this.tileHeight = this.height = this.image.getHeight();
        if (!(this.image.getSampleModel() instanceof ComponentSampleModel)) {
            int n = -1;
            int n2 = this.image.getSampleModel().getNumBands();
            if (n2 == 1) {
                n = 10;
            } else if (n2 == 3) {
                n = 5;
            } else if (n2 == 4) {
                n = 6;
            } else {
                throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder3"));
            }
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, n);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawRenderedImage(this.image, new AffineTransform());
            this.image = bufferedImage;
        }
        this.sampleModel = this.image.getSampleModel();
        this.colorModel = this.image.getColorModel();
    }

    public synchronized Raster getTile(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("JPEGImageDecoder4"));
        }
        return this.image.getTile(0, 0);
    }
}

