/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.RemoteImage;
import javax.media.jai.TileCache;
import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoder;
import javax.media.jai.tilecodec.TileDecoderFactory;
import javax.media.jai.tilecodec.TileEncoder;
import javax.media.jai.tilecodec.TileEncoderFactory;

public final class SerializableRenderedImage
implements RenderedImage,
Serializable {
    private static final int SERVER_TIMEOUT = 60000;
    private static final String CLOSE_MESSAGE = "CLOSE";
    private transient boolean isServer;
    private boolean isSourceRemote;
    private transient RenderedImage source;
    private int minX;
    private int minY;
    private int width;
    private int height;
    private int minTileX;
    private int minTileY;
    private int numXTiles;
    private int numYTiles;
    private int tileWidth;
    private int tileHeight;
    private int tileGridXOffset;
    private int tileGridYOffset;
    private transient SampleModel sampleModel = null;
    private transient ColorModel colorModel = null;
    private transient Vector sources = null;
    private transient Hashtable properties = null;
    private boolean useDeepCopy;
    private Rectangle imageBounds;
    private transient Raster imageRaster;
    private InetAddress host;
    private int port;
    private transient boolean serverOpen = false;
    private transient ServerSocket serverSocket = null;
    private transient Thread serverThread;
    private static transient Hashtable remoteReferenceCount;
    private boolean useTileCodec = false;
    private transient TileDecoderFactory tileDecoderFactory = null;
    private transient TileEncoderFactory tileEncoderFactory = null;
    private TileCodecParameterList encodingParam = null;
    private TileCodecParameterList decodingParam = null;
    static /* synthetic */ Class class$java$awt$image$Raster;

    private static synchronized void incrementRemoteReferenceCount(Object object) {
        if (remoteReferenceCount == null) {
            remoteReferenceCount = new Hashtable();
            remoteReferenceCount.put(object, new Integer(1));
        } else {
            Integer n = (Integer)remoteReferenceCount.get(object);
            if (n == null) {
                remoteReferenceCount.put(object, new Integer(1));
            } else {
                remoteReferenceCount.put(object, new Integer(n + 1));
            }
        }
    }

    private static synchronized void decrementRemoteReferenceCount(Object object) {
        Integer n;
        if (remoteReferenceCount != null && (n = (Integer)remoteReferenceCount.get(object)) != null) {
            if (n == 1) {
                remoteReferenceCount.remove(object);
            } else {
                remoteReferenceCount.put(object, new Integer(n - 1));
            }
        }
    }

    SerializableRenderedImage() {
    }

    public SerializableRenderedImage(RenderedImage renderedImage, boolean bl, OperationRegistry operationRegistry, String string, TileCodecParameterList tileCodecParameterList, TileCodecParameterList tileCodecParameterList2) throws NotSerializableException {
        this(renderedImage, bl, false);
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableRenderedImage1"));
        }
        if (!string.equals(tileCodecParameterList.getFormatName())) {
            throw new IllegalArgumentException(JaiI18N.getString("UseTileCodec0"));
        }
        if (!string.equals(tileCodecParameterList2.getFormatName())) {
            throw new IllegalArgumentException(JaiI18N.getString("UseTileCodec1"));
        }
        this.tileEncoderFactory = (TileEncoderFactory)operationRegistry.getFactory("tileEncoder", string);
        this.tileDecoderFactory = (TileDecoderFactory)operationRegistry.getFactory("tileDecoder", string);
        if (this.tileEncoderFactory == null || this.tileDecoderFactory == null) {
            throw new RuntimeException(JaiI18N.getString("UseTileCodec2"));
        }
        this.encodingParam = tileCodecParameterList;
        this.decodingParam = tileCodecParameterList2;
        this.useTileCodec = true;
    }

    public SerializableRenderedImage(RenderedImage renderedImage, boolean bl) {
        this(renderedImage, bl, true);
    }

    public SerializableRenderedImage(RenderedImage renderedImage) {
        this(renderedImage, false, true);
    }

    private SerializableRenderedImage(RenderedImage renderedImage, boolean bl, boolean bl2) {
        DataBuffer dataBuffer;
        String[] stringArray;
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableRenderedImage0"));
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel != null && SerializerFactory.getSerializer(sampleModel.getClass()) == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableRenderedImage2"));
        }
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null && SerializerFactory.getSerializer(colorModel.getClass()) == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableRenderedImage3"));
        }
        if (bl2 && (stringArray = renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY())) != null && (dataBuffer = stringArray.getDataBuffer()) != null && SerializerFactory.getSerializer(dataBuffer.getClass()) == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableRenderedImage4"));
        }
        this.isServer = true;
        this.useDeepCopy = bl;
        this.source = renderedImage;
        this.isSourceRemote = renderedImage instanceof RemoteImage;
        this.minX = renderedImage.getMinX();
        this.minY = renderedImage.getMinY();
        this.width = renderedImage.getWidth();
        this.height = renderedImage.getHeight();
        this.minTileX = renderedImage.getMinTileX();
        this.minTileY = renderedImage.getMinTileY();
        this.numXTiles = renderedImage.getNumXTiles();
        this.numYTiles = renderedImage.getNumYTiles();
        this.tileWidth = renderedImage.getTileWidth();
        this.tileHeight = renderedImage.getTileHeight();
        this.tileGridXOffset = renderedImage.getTileGridXOffset();
        this.tileGridYOffset = renderedImage.getTileGridYOffset();
        this.sampleModel = renderedImage.getSampleModel();
        this.colorModel = renderedImage.getColorModel();
        this.sources = new Vector();
        this.sources.add(renderedImage);
        this.properties = new Hashtable();
        stringArray = renderedImage.getPropertyNames();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.properties.put(stringArray[n], renderedImage.getProperty(stringArray[n]));
                ++n;
            }
        }
        this.imageBounds = new Rectangle(this.minX, this.minY, this.width, this.height);
        try {
            this.host = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException.getMessage());
        }
        this.serverOpen = false;
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        if (this.isServer || this.isSourceRemote) {
            return this.source.copyData(writableRaster);
        }
        Raster raster = null;
        if (writableRaster == null) {
            raster = this.getData(this.imageBounds);
            writableRaster = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), new Point(raster.getMinX(), raster.getMinY()));
        } else {
            raster = this.getData(writableRaster.getBounds());
            writableRaster.setDataElements(raster.getMinX(), raster.getMinY(), raster);
        }
        return writableRaster;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public Raster getData() {
        if (this.isServer || this.isSourceRemote) {
            return this.source.getData();
        }
        return this.getData(this.imageBounds);
    }

    public Raster getData(Rectangle rectangle) {
        Raster raster = null;
        if (this.isServer || this.isSourceRemote) {
            raster = this.source.getData(rectangle);
        } else if (this.useDeepCopy) {
            raster = this.imageRaster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        } else {
            Object object;
            Socket socket = this.connectToServer();
            OutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            InputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                inputStream = socket.getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            try {
                objectOutputStream.writeObject(rectangle);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            Object object2 = null;
            try {
                object2 = objectInputStream.readObject();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            if (this.useTileCodec) {
                object = (byte[])object2;
                raster = this.decodeRasterFromByteArray((byte[])object);
            } else {
                if (!(object2 instanceof SerializableState)) {
                    raster = null;
                }
                object = (SerializableState)object2;
                Class clazz = object.getObjectClass();
                raster = (class$java$awt$image$Raster == null ? (class$java$awt$image$Raster = SerializableRenderedImage.class$("java.awt.image.Raster")) : class$java$awt$image$Raster).isAssignableFrom(clazz) ? (Raster)object.getObject() : null;
            }
            try {
                outputStream.close();
                objectOutputStream.close();
                inputStream.close();
                objectInputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            if (this.imageBounds.equals(rectangle)) {
                this.closeClient();
                this.imageRaster = raster;
                this.useDeepCopy = true;
            }
        }
        return raster;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMinTileX() {
        return this.minTileX;
    }

    public int getMinTileY() {
        return this.minTileY;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getNumXTiles() {
        return this.numXTiles;
    }

    public int getNumYTiles() {
        return this.numYTiles;
    }

    public Object getProperty(String string) {
        Object v = this.properties.get(string);
        return v == null ? Image.UndefinedProperty : v;
    }

    public String[] getPropertyNames() {
        String[] stringArray = null;
        if (!this.properties.isEmpty()) {
            stringArray = new String[this.properties.size()];
            Enumeration enumeration = this.properties.keys();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n++] = (String)enumeration.nextElement();
            }
        }
        return stringArray;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public Vector getSources() {
        return this.sources;
    }

    public Raster getTile(int n, int n2) {
        Object object;
        if (this.isServer || this.isSourceRemote) {
            return this.source.getTile(n, n2);
        }
        TileCache tileCache = JAI.getDefaultInstance().getTileCache();
        if (tileCache != null && (object = tileCache.getTile(this, n, n2)) != null) {
            return object;
        }
        object = new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
        Rectangle rectangle = ((Rectangle)object).intersection(new Rectangle(this.tileXToX(n), this.tileYToY(n2), this.getTileWidth(), this.getTileHeight()));
        Raster raster = this.getData(rectangle);
        if (tileCache != null) {
            tileCache.add(this, n, n2, raster);
        }
        return raster;
    }

    private int tileXToX(int n) {
        return PlanarImage.tileXToX(n, this.getTileGridXOffset(), this.getTileWidth());
    }

    private int tileYToY(int n) {
        return PlanarImage.tileYToY(n, this.getTileGridYOffset(), this.getTileHeight());
    }

    public int getTileGridXOffset() {
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset() {
        return this.tileGridYOffset;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getWidth() {
        return this.width;
    }

    private synchronized void openServer() throws IOException, SocketException {
        if (!this.serverOpen) {
            this.serverSocket = new ServerSocket(0);
            this.serverSocket.setSoTimeout(60000);
            this.port = this.serverSocket.getLocalPort();
            this.serverOpen = true;
            this.serverThread = new Thread(new TileServer());
            this.serverThread.start();
            SerializableRenderedImage.incrementRemoteReferenceCount(this);
        }
    }

    private void closeClient() {
        Socket socket = this.connectToServer();
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        try {
            objectOutputStream.writeObject(CLOSE_MESSAGE);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        try {
            outputStream.close();
            objectOutputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    private Socket connectToServer() {
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.port);
            socket.setSoLinger(true, 1);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return socket;
    }

    private byte[] encodeRasterToByteArray(Raster raster) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TileEncoder tileEncoder = this.tileEncoderFactory.createEncoder(byteArrayOutputStream, this.decodingParam, raster.getSampleModel());
        try {
            tileEncoder.encode(raster);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    private Raster decodeRasterFromByteArray(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        TileDecoder tileDecoder = this.tileDecoderFactory.createDecoder(byteArrayInputStream, this.decodingParam);
        try {
            return tileDecoder.decode();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.isServer) {
            if (this.serverOpen) {
                this.serverOpen = false;
                try {
                    this.serverThread.join(120000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.serverSocket.close();
                }
                catch (Exception exception) {}
            }
        } else {
            this.closeClient();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        if (!this.useDeepCopy) {
            try {
                this.openServer();
            }
            catch (Exception exception) {
                if (exception instanceof SocketException && this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.serverOpen = false;
                this.useDeepCopy = true;
            }
        }
        objectOutputStream.defaultWriteObject();
        if (this.isSourceRemote) {
            object = this.source.getClass().getName();
            objectOutputStream.writeObject(this.source.getProperty((String)object + ".serverName"));
            objectOutputStream.writeObject(this.source.getProperty((String)object + ".id"));
        }
        object = this.properties;
        boolean bl = false;
        Enumeration enumeration = ((Hashtable)object).keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (this.properties.get(k) instanceof Serializable) continue;
            if (!bl) {
                object = (Hashtable)this.properties.clone();
                bl = true;
            }
            ((Hashtable)object).remove(k);
        }
        objectOutputStream.writeObject(SerializerFactory.getState(this.sampleModel, null));
        objectOutputStream.writeObject(SerializerFactory.getState(this.colorModel, null));
        objectOutputStream.writeObject(object);
        if (this.useDeepCopy) {
            if (this.useTileCodec) {
                objectOutputStream.writeObject(this.encodeRasterToByteArray(this.source.getData()));
            } else {
                objectOutputStream.writeObject(SerializerFactory.getState(this.source.getData(), null));
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Serializable serializable;
        Object object;
        this.isServer = false;
        this.source = null;
        this.serverOpen = false;
        this.serverSocket = null;
        this.serverThread = null;
        this.colorModel = null;
        objectInputStream.defaultReadObject();
        if (this.isSourceRemote) {
            object = (String)objectInputStream.readObject();
            serializable = (Long)objectInputStream.readObject();
            this.source = new RemoteImage((String)object + "::" + (Long)serializable, (RenderedImage)null);
        }
        object = (SerializableState)objectInputStream.readObject();
        this.sampleModel = (SampleModel)object.getObject();
        serializable = (SerializableState)objectInputStream.readObject();
        this.colorModel = (ColorModel)serializable.getObject();
        this.properties = (Hashtable)objectInputStream.readObject();
        if (this.useDeepCopy) {
            if (this.useTileCodec) {
                this.imageRaster = this.decodeRasterFromByteArray((byte[])objectInputStream.readObject());
            } else {
                SerializableState serializableState = (SerializableState)objectInputStream.readObject();
                this.imageRaster = (Raster)serializableState.getObject();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TileServer
    implements Runnable {
        private TileServer() {
        }

        public void run() {
            while (SerializableRenderedImage.this.serverOpen) {
                Socket socket = null;
                try {
                    socket = SerializableRenderedImage.this.serverSocket.accept();
                    socket.setSoLinger(true, 1);
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
                InputStream inputStream = null;
                OutputStream outputStream = null;
                ObjectInputStream objectInputStream = null;
                ObjectOutputStream objectOutputStream = null;
                try {
                    inputStream = socket.getInputStream();
                    outputStream = socket.getOutputStream();
                    objectInputStream = new ObjectInputStream(inputStream);
                    objectOutputStream = new ObjectOutputStream(outputStream);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
                Object object = null;
                try {
                    object = objectInputStream.readObject();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
                if (object instanceof String && ((String)object).equals(SerializableRenderedImage.CLOSE_MESSAGE)) {
                    SerializableRenderedImage.decrementRemoteReferenceCount(this);
                } else if (object instanceof Rectangle) {
                    Raster raster = SerializableRenderedImage.this.source.getData((Rectangle)object);
                    if (SerializableRenderedImage.this.useTileCodec) {
                        byte[] byArray = SerializableRenderedImage.this.encodeRasterToByteArray(raster);
                        try {
                            objectOutputStream.writeObject(byArray);
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception.getMessage());
                        }
                    }
                    try {
                        objectOutputStream.writeObject(SerializerFactory.getState(raster, null));
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.getMessage());
                    }
                }
                try {
                    objectOutputStream.close();
                    objectInputStream.close();
                    outputStream.close();
                    inputStream.close();
                    socket.close();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            }
        }
    }
}

