/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.Warp;

public abstract class WarpOpImage
extends GeometricOpImage {
    protected Warp warp;

    public WarpOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl, BorderExtender borderExtender, Interpolation interpolation, Warp warp) {
        super(OpImage.vectorize(renderedImage), imageLayout, map, bl, borderExtender, interpolation);
        if (warp == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.warp = warp;
        if (bl && borderExtender == null) {
            int n = interpolation == null ? 0 : interpolation.getLeftPadding();
            int n2 = interpolation == null ? 0 : interpolation.getRightPadding();
            int n3 = interpolation == null ? 0 : interpolation.getTopPadding();
            int n4 = interpolation == null ? 0 : interpolation.getBottomPadding();
            int n5 = this.getMinX() + n;
            int n6 = this.getMinY() + n3;
            int n7 = Math.max(this.getWidth() - n - n2, 0);
            int n8 = Math.max(this.getHeight() - n3 - n4, 0);
            this.computableBounds = new Rectangle(n5, n6, n7, n8);
        } else {
            this.computableBounds = this.getBounds();
        }
    }

    public int getLeftPadding() {
        return this.interp == null ? 0 : this.interp.getLeftPadding();
    }

    public int getRightPadding() {
        return this.interp == null ? 0 : this.interp.getRightPadding();
    }

    public int getTopPadding() {
        return this.interp == null ? 0 : this.interp.getTopPadding();
    }

    public int getBottomPadding() {
        return this.interp == null ? 0 : this.interp.getBottomPadding();
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return this.warp.mapSourceRect(rectangle);
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle2 = this.warp.mapDestRect(rectangle);
        return rectangle2 == null ? this.getSource(0).getBounds() : rectangle2;
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight).intersection(this.computableBounds);
        if (rectangle.isEmpty()) {
            return writableRaster;
        }
        PlanarImage planarImage = this.getSource(0);
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        if (!rectangle2.intersects(planarImage.getBounds())) {
            return writableRaster;
        }
        if (this.cobbleSources) {
            Raster[] rasterArray = new Raster[]{this.extender != null ? planarImage.getExtendedData(rectangle2, this.extender) : planarImage.getData(rectangle2)};
            this.computeRect(rasterArray, writableRaster, rectangle);
        } else {
            PlanarImage[] planarImageArray = new PlanarImage[]{planarImage};
            this.computeRect(planarImageArray, writableRaster, rectangle);
        }
        return writableRaster;
    }
}

