/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

public abstract class SourcelessOpImage
extends OpImage {
    private static ImageLayout layoutHelper(int n, int n2, int n3, int n4, SampleModel sampleModel, ImageLayout imageLayout) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(n);
        imageLayout2.setMinY(n2);
        imageLayout2.setWidth(n3);
        imageLayout2.setHeight(n4);
        imageLayout2.setSampleModel(sampleModel);
        if (!imageLayout2.isValid(16)) {
            imageLayout2.setTileGridXOffset(imageLayout2.getMinX(null));
        }
        if (!imageLayout2.isValid(32)) {
            imageLayout2.setTileGridYOffset(imageLayout2.getMinY(null));
        }
        return imageLayout2;
    }

    public SourcelessOpImage(ImageLayout imageLayout, Map map, SampleModel sampleModel, int n, int n2, int n3, int n4) {
        super(null, SourcelessOpImage.layoutHelper(n, n2, n3, n4, sampleModel, imageLayout), map, false);
    }

    public boolean computesUniqueTiles() {
        return false;
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        this.computeRect((PlanarImage[])null, writableRaster, rectangle2);
        return writableRaster;
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        throw new IllegalArgumentException(JaiI18N.getString("SourcelessOpImage0"));
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        throw new IllegalArgumentException(JaiI18N.getString("SourcelessOpImage0"));
    }
}

