/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.media.jai.registry.CollectionRegistryMode;
import javax.media.jai.registry.RemoteRenderableRegistryMode;
import javax.media.jai.registry.RemoteRenderedRegistryMode;
import javax.media.jai.registry.RenderableCollectionRegistryMode;
import javax.media.jai.registry.RenderableRegistryMode;
import javax.media.jai.registry.RenderedRegistryMode;
import javax.media.jai.registry.TileDecoderRegistryMode;
import javax.media.jai.registry.TileEncoderRegistryMode;
import javax.media.jai.util.CaselessStringKey;

public class RegistryMode {
    private static Hashtable registryModes = new Hashtable(4);
    private static HashSet immutableNames = new HashSet();
    private CaselessStringKey name;
    private Class descriptorClass;
    private Class productClass;
    private Method factoryMethod;
    private boolean arePreferencesSupported;
    private boolean arePropertiesSupported;

    private static boolean addMode(RegistryMode registryMode, boolean bl) {
        if (registryModes.containsKey(registryMode.name)) {
            return false;
        }
        registryModes.put(registryMode.name, registryMode);
        if (bl) {
            immutableNames.add(registryMode.name);
        }
        return true;
    }

    public static synchronized boolean addMode(RegistryMode registryMode) {
        return RegistryMode.addMode(registryMode, false);
    }

    public static synchronized boolean removeMode(String string) {
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (immutableNames.contains(caselessStringKey)) {
            return false;
        }
        return registryModes.remove(caselessStringKey) != null;
    }

    public static synchronized String[] getModeNames() {
        String[] stringArray = new String[registryModes.size()];
        int n = 0;
        Enumeration enumeration = registryModes.keys();
        while (enumeration.hasMoreElements()) {
            CaselessStringKey caselessStringKey = (CaselessStringKey)enumeration.nextElement();
            stringArray[n++] = caselessStringKey.getName();
        }
        if (n <= 0) {
            return null;
        }
        return stringArray;
    }

    public static synchronized String[] getModeNames(Class clazz) {
        String[] stringArray;
        String[] stringArray2 = new String[registryModes.size()];
        int n = 0;
        Enumeration enumeration = registryModes.elements();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (stringArray.getDescriptorClass() != clazz) continue;
            stringArray2[n++] = stringArray.getName();
        }
        if (n <= 0) {
            return null;
        }
        stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringArray2[n2];
            ++n2;
        }
        return stringArray;
    }

    public static RegistryMode getMode(String string) {
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        return (RegistryMode)registryModes.get(caselessStringKey);
    }

    public static synchronized Set getDescriptorClasses() {
        HashSet<Class> hashSet = new HashSet<Class>();
        Enumeration enumeration = registryModes.elements();
        while (enumeration.hasMoreElements()) {
            RegistryMode registryMode = (RegistryMode)enumeration.nextElement();
            hashSet.add(registryMode.descriptorClass);
        }
        return hashSet;
    }

    protected RegistryMode(String string, Class clazz, Class clazz2, Method method, boolean bl, boolean bl2) {
        this.name = new CaselessStringKey(string);
        this.descriptorClass = clazz;
        this.productClass = clazz2;
        this.factoryMethod = method;
        this.arePreferencesSupported = bl;
        this.arePropertiesSupported = bl2;
    }

    public final String getName() {
        return this.name.getName();
    }

    public final Method getFactoryMethod() {
        return this.factoryMethod;
    }

    public final boolean arePreferencesSupported() {
        return this.arePreferencesSupported;
    }

    public final boolean arePropertiesSupported() {
        return this.arePropertiesSupported;
    }

    public final Class getDescriptorClass() {
        return this.descriptorClass;
    }

    public final Class getProductClass() {
        return this.productClass;
    }

    public final Class getFactoryClass() {
        return this.factoryMethod.getDeclaringClass();
    }

    static {
        RegistryMode.addMode(new RenderedRegistryMode(), true);
        RegistryMode.addMode(new RenderableRegistryMode(), true);
        RegistryMode.addMode(new CollectionRegistryMode(), true);
        RegistryMode.addMode(new RenderableCollectionRegistryMode(), true);
        RegistryMode.addMode(new RemoteRenderedRegistryMode(), true);
        RegistryMode.addMode(new RemoteRenderableRegistryMode(), true);
        RegistryMode.addMode(new TileEncoderRegistryMode(), true);
        RegistryMode.addMode(new TileDecoderRegistryMode(), true);
    }
}

