/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.FCT;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.media.jai.util.MathJAI;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.UntiledOpImage;

public class DCTOpImage
extends UntiledOpImage {
    private FCT fct;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        SampleModel sampleModel;
        int n;
        int n2;
        int n3;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        boolean bl = false;
        int n4 = imageLayout2.getWidth(renderedImage);
        if (n4 > 1 && (n3 = MathJAI.nextPositivePowerOf2(n4)) != n4) {
            n4 = n3;
            imageLayout2.setWidth(n4);
            bl = true;
        }
        if ((n3 = imageLayout2.getHeight(renderedImage)) > 1 && (n2 = MathJAI.nextPositivePowerOf2(n3)) != n3) {
            n3 = n2;
            imageLayout2.setHeight(n3);
            bl = true;
        }
        if ((n = (sampleModel = imageLayout2.getSampleModel(renderedImage)).getTransferType()) != 4 && n != 5) {
            n = 4;
            bl = true;
        }
        if (bl) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, n, n4, n3, sampleModel.getNumBands());
            imageLayout2.setSampleModel(sampleModel);
            ColorModel colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public DCTOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, FCT fCT) {
        super(renderedImage, map, DCTOpImage.layoutHelper(imageLayout, renderedImage));
        this.fct = fCT;
    }

    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        if (rectangle.width == 1 && rectangle.height == 1) {
            double[] dArray = raster.getPixel(rectangle.x, rectangle.y, (double[])null);
            writableRaster.setPixel(rectangle.x, rectangle.y, dArray);
            return;
        }
        this.fct.setLength(rectangle.width > 1 ? this.getWidth() : this.getHeight());
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        int n3 = raster.getMinX();
        int n4 = raster.getMinY();
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, new Rectangle(n3, n4, n, n2), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n5 = rasterAccessor.getDataType();
        int n6 = rasterAccessor2.getDataType();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getPixelStride();
        int n10 = rasterAccessor2.getScanlineStride();
        int n11 = this.sampleModel.getNumBands();
        int n12 = 0;
        while (n12 < n11) {
            int n13;
            int n14;
            Object object = rasterAccessor.getDataArray(n12);
            Object object2 = rasterAccessor2.getDataArray(n12);
            if (rectangle.width > 1) {
                this.fct.setLength(this.getWidth());
                n14 = rasterAccessor.getBandOffset(n12);
                n13 = rasterAccessor2.getBandOffset(n12);
                int n15 = 0;
                while (n15 < n2) {
                    this.fct.setData(n5, object, n14, n7, n);
                    this.fct.transform();
                    this.fct.getData(n6, object2, n13, n9);
                    n14 += n8;
                    n13 += n10;
                    ++n15;
                }
            }
            if (rectangle.width == 1) {
                n14 = rasterAccessor.getBandOffset(n12);
                n13 = rasterAccessor2.getBandOffset(n12);
                this.fct.setData(n5, object, n14, n8, n2);
                this.fct.transform();
                this.fct.getData(n6, object2, n13, n10);
            } else if (rectangle.height > 1) {
                this.fct.setLength(this.getHeight());
                n14 = rasterAccessor2.getBandOffset(n12);
                n13 = 0;
                while (n13 < rectangle.width) {
                    this.fct.setData(n6, object2, n14, n10, rectangle.height);
                    this.fct.transform();
                    this.fct.getData(n6, object2, n14, n10);
                    n14 += n9;
                    ++n13;
                }
            }
            ++n12;
        }
        if (rasterAccessor2.needsClamping()) {
            rasterAccessor2.clampDataArrays();
        }
        rasterAccessor2.copyDataToRaster();
    }
}

