/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PointOpImage;

final class BandSelectOpImage
extends PointOpImage {
    private int[] bandIndices;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, int[] nArray) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = renderedImage.getSampleModel().createSubsetSampleModel(nArray);
        imageLayout2.setSampleModel(sampleModel);
        ColorModel colorModel = imageLayout2.getColorModel(null);
        if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
            imageLayout2.unsetValid(512);
        }
        imageLayout2.setTileGridXOffset(renderedImage.getTileGridXOffset());
        imageLayout2.setTileGridYOffset(renderedImage.getTileGridYOffset());
        imageLayout2.setTileWidth(renderedImage.getTileWidth());
        imageLayout2.setTileHeight(renderedImage.getTileHeight());
        return imageLayout2;
    }

    public BandSelectOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int[] nArray) {
        super(OpImage.vectorize(renderedImage), BandSelectOpImage.layoutHelper(imageLayout, renderedImage, nArray), map, true);
        this.bandIndices = nArray;
    }

    public boolean computesUniqueTiles() {
        return false;
    }

    public Raster computeTile(int n, int n2) {
        Raster raster = this.getSourceImage(0).getTile(n, n2);
        return raster.createChild(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), raster.getMinX(), raster.getMinY(), this.bandIndices);
    }

    public Raster getTile(int n, int n2) {
        return this.computeTile(n, n2);
    }
}

