/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterFactory;
import javax.media.jai.WarpOpImage;
import javax.media.jai.WarpPolynomial;

final class MlibWarpPolynomialOpImage
extends WarpOpImage {
    private double[] xCoeffs;
    private double[] yCoeffs;
    private int filter;
    private double preScaleX;
    private double preScaleY;
    private double postScaleX;
    private double postScaleY;

    public MlibWarpPolynomialOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, WarpPolynomial warpPolynomial, Interpolation interpolation, int n) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, warpPolynomial);
        float[] fArray = warpPolynomial.getXCoeffs();
        float[] fArray2 = warpPolynomial.getYCoeffs();
        int n2 = fArray.length;
        this.xCoeffs = new double[n2];
        this.yCoeffs = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.xCoeffs[n3] = fArray[n3];
            this.yCoeffs[n3] = fArray2[n3];
            ++n3;
        }
        this.filter = n;
        this.preScaleX = warpPolynomial.getPreScaleX();
        this.preScaleY = warpPolynomial.getPreScaleY();
        this.postScaleX = warpPolynomial.getPostScaleX();
        this.postScaleY = warpPolynomial.getPostScaleY();
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight).intersection(this.computableBounds);
        if (rectangle.isEmpty()) {
            return writableRaster;
        }
        Rectangle rectangle2 = this.warp.mapDestRect(rectangle).intersection(this.getSourceImage(0).getBounds());
        if (rectangle2.isEmpty()) {
            return writableRaster;
        }
        int n3 = this.interp == null ? 0 : this.interp.getLeftPadding();
        int n4 = this.interp == null ? 0 : this.interp.getRightPadding();
        int n5 = this.interp == null ? 0 : this.interp.getTopPadding();
        int n6 = this.interp == null ? 0 : this.interp.getBottomPadding();
        rectangle2 = new Rectangle(rectangle2.x - n3, rectangle2.y - n5, rectangle2.width + n3 + n4, rectangle2.height + n5 + n6);
        Raster[] rasterArray = new Raster[]{this.getBorderExtender() != null ? this.getSourceImage(0).getExtendedData(rectangle2, this.extender) : this.getSourceImage(0).getData(rectangle2)};
        this.computeRect(rasterArray, writableRaster, rectangle);
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, raster.getBounds(), n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 2: 
            case 3: {
                int n2 = 0;
                while (n2 < mediaLibImageArray2.length) {
                    Image.PolynomialWarp((mediaLibImage)mediaLibImageArray2[n2], (mediaLibImage)mediaLibImageArray[n2], (double[])this.xCoeffs, (double[])this.yCoeffs, (double)rectangle.x, (double)rectangle.y, (double)raster.getMinX(), (double)raster.getMinY(), (double)this.preScaleX, (double)this.preScaleY, (double)this.postScaleX, (double)this.postScaleY, (int)this.filter, (int)0);
                    ++n2;
                }
                break;
            }
            case 4: 
            case 5: {
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    Image.PolynomialWarp_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])this.xCoeffs, (double[])this.yCoeffs, (double)rectangle.x, (double)rectangle.y, (double)raster.getMinX(), (double)raster.getMinY(), (double)this.preScaleX, (double)this.preScaleY, (double)this.postScaleX, (double)this.postScaleY, (int)this.filter, (int)0);
                    ++n3;
                }
                break;
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

