/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

final class MlibSeparableConvolveOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    float[] hValues;
    float[] vValues;
    double[] hDoubleData;
    double[] vDoubleData;
    int[] hIntData;
    int[] vIntData;
    int shift = -1;

    public MlibSeparableConvolveOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.hValues = kernelJAI.getHorizontalKernelData();
        this.vValues = kernelJAI.getVerticalKernelData();
        this.hDoubleData = new double[this.hValues.length];
        int n = 0;
        while (n < this.hValues.length) {
            this.hDoubleData[n] = this.hValues[n];
            ++n;
        }
        this.vDoubleData = new double[this.vValues.length];
        int n2 = 0;
        while (n2 < this.vValues.length) {
            this.vDoubleData[n2] = this.vValues[n2];
            ++n2;
        }
        this.hIntData = new int[this.hValues.length];
        this.vIntData = new int[this.vValues.length];
    }

    private synchronized void setShift(int n) {
        if (this.shift == -1) {
            int n2 = MediaLibAccessor.getMediaLibDataType(n);
            this.shift = Image.SConvKernelConvert((int[])this.hIntData, (int[])this.vIntData, (double[])this.hDoubleData, (double[])this.vDoubleData, (int)this.kw, (int)this.kh, (int)n2);
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        int n2 = this.getSampleModel().getNumBands();
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        int n3 = 0;
        while (n3 < mediaLibImageArray2.length) {
            switch (mediaLibAccessor2.getDataType()) {
                case 0: 
                case 2: 
                case 3: {
                    if (this.shift == -1) {
                        this.setShift(n);
                    }
                    switch (this.kw) {
                        case 3: {
                            Image.SConv3x3((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (int[])this.hIntData, (int[])this.vIntData, (int)this.shift, (int)((1 << n2) - 1), (int)0);
                            break;
                        }
                        case 5: {
                            Image.SConv5x5((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (int[])this.hIntData, (int[])this.vIntData, (int)this.shift, (int)((1 << n2) - 1), (int)0);
                            break;
                        }
                        case 7: {
                            Image.SConv7x7((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (int[])this.hIntData, (int[])this.vIntData, (int)this.shift, (int)((1 << n2) - 1), (int)0);
                        }
                    }
                    break;
                }
                case 4: 
                case 5: {
                    switch (this.kw) {
                        case 3: {
                            Image.SConv3x3_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])this.hDoubleData, (double[])this.vDoubleData, (int)((1 << n2) - 1), (int)0);
                            break;
                        }
                        case 5: {
                            Image.SConv5x5_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])this.hDoubleData, (double[])this.vDoubleData, (int)((1 << n2) - 1), (int)0);
                            break;
                        }
                        case 7: {
                            Image.SConv7x7_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])this.hDoubleData, (double[])this.vDoubleData, (int)((1 << n2) - 1), (int)0);
                        }
                    }
                    break;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("MlibUshort"));
                }
            }
            ++n3;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

