/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtt.tree;

import com.syscom.misc.XMLImageResource;
import com.syscom.misc.XMLTreeCellRenderer;
import com.syscom.ut.GuiUt;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.schema.node.Column;
import com.syscom.xml.schema.node.Database;
import com.syscom.xml.schema.node.Table;
import com.syscom.xml.schema.node.View;
import com.syscom.xml.xtt.console.XTTFrame;
import com.syscom.xml.xtt.tree.CheckNode;
import com.syscom.xml.xtt.tree.eDragSource;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseAdapter;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class TableSchemaViewerTree
extends JTree
implements DragGestureListener,
DragSourceListener {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.treetable.resource.Res", LocaleManager.getLocale());
    private CheckNode rootNode = null;
    private DefaultTreeModel treeModel = null;
    private MouseAdapter treeMouseAdapter = null;
    private TreeWillExpandListener twelistener = null;
    private TreePath selectedTreePath = null;
    private DragSource dragSource = new eDragSource();

    public TableSchemaViewerTree() {
        this.rootNode = this.getTree();
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.setModel(this.treeModel);
        this.setToolTipText("");
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        TreeUI treeUI = this.getUI();
        if (treeUI instanceof MetalTreeUI) {
            MetalTreeUI mTreeUI = (MetalTreeUI)treeUI;
            ImageIcon icon = XMLImageResource.getResource(this.getClass(), "/xmlimages/minus.gif");
            mTreeUI.setExpandedIcon(icon);
            icon = XMLImageResource.getResource(this.getClass(), "/xmlimages/plus.gif");
            mTreeUI.setCollapsedIcon(icon);
        }
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setShowsRootHandles(true);
        this.setCellRenderer(new XMLTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
        this.twelistener = new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                XTTFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
                TableSchemaViewerTree.this.tree_treeWillExpand(e);
                XTTFrame.frame.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.addTreeWillExpandListener(this.twelistener);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TableSchemaViewerTree.this.tree_valueChanged(e);
            }
        });
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point ptDragOrigin = e.getDragOrigin();
        TreePath dragPath = this.getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
        if (dragPath == null) {
            GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("Please_select_a_tree"), null);
            return;
        }
        CheckNode cnode = (CheckNode)dragPath.getLastPathComponent();
        if (cnode.getLevel() == 0) {
            return;
        }
        this.setSelectionPath(dragPath);
        String[] sa = new String[]{"/xmlimages/add_child_cursor.gif", "/xmlimages/add_sibling_cursor.gif", "/xmlimages/link_cursor.gif"};
        int choice = 0;
        choice = XTTFrame.frame.px.getAddModeSettingForBoolean() ? (XTTFrame.frame.px.getNodeAsChildSettingForBoolean() ? 0 : 1) : 2;
        Image image = XMLImageResource.getResource(this.getClass(), sa[choice]).getImage();
        Point offset = new Point(0, 0);
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, offset, "");
        int action = e.getDragAction();
        Transferable transferable = null;
        Object obj = null;
        if (this.selectedTreePath != null) {
            obj = ((CheckNode)this.selectedTreePath.getLastPathComponent()).getUserObject();
            if (obj instanceof Table || obj instanceof View || obj instanceof Column) {
                transferable = (Transferable)obj;
            }
            if (obj instanceof Transferable) {
                View view;
                Vector v;
                TreePath path = this.getSelectionPath();
                CheckNode node = (CheckNode)path.getLastPathComponent();
                if (node == null) {
                    return;
                }
                node.removeAllChildren();
                Object node_obj = node.getUserObject();
                if (node_obj instanceof Table) {
                    Table table = (Table)obj;
                    Vector v2 = table.initColumns(XTTFrame.frame.conn.dbconn);
                    if (v2 != null && v2.size() > 0) {
                        int size = v2.size();
                        for (int i = 0; i < size; ++i) {
                            node.add(new CheckNode((Column)v2.elementAt(i)));
                        }
                    }
                } else if (node_obj instanceof View && (v = (view = (View)obj).initColumns(XTTFrame.frame.conn.dbconn)) != null && v.size() > 0) {
                    int size = v.size();
                    for (int i = 0; i < size; ++i) {
                        node.add(new CheckNode((Column)v.elementAt(i)));
                    }
                }
                this.treeModel.reload(node);
                this.dragSource.startDrag(e, cursor, transferable, this);
            }
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dsde) {
    }

    void tree_treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        try {
            TreePath path = e.getPath();
            CheckNode node = (CheckNode)path.getLastPathComponent();
            if (node == null) {
                return;
            }
            Object obj = node.getUserObject();
            if (obj instanceof Table) {
                node.removeAllChildren();
                Table table = (Table)obj;
                Vector v = table.initColumns(XTTFrame.frame.conn.dbconn);
                if (v != null && v.size() > 0) {
                    int size = v.size();
                    for (int i = 0; i < size; ++i) {
                        node.add(new CheckNode((Column)v.elementAt(i)));
                    }
                }
            } else if (obj instanceof View) {
                node.removeAllChildren();
                View view = (View)obj;
                Vector v = view.initColumns(XTTFrame.frame.conn.dbconn);
                if (v != null && v.size() > 0) {
                    int size = v.size();
                    for (int i = 0; i < size; ++i) {
                        node.add(new CheckNode((Column)v.elementAt(i)));
                    }
                }
            }
            this.treeModel.reload(node);
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void closeConnection() {
        if (XTTFrame.frame.conn == null) {
            return;
        }
        try {
            XTTFrame.frame.conn.dbconn.close();
            XTTFrame.frame.conn.dbconn = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckNode getTree() {
        ResultSet dbmdrs = null;
        DatabaseMetaData dbmd = null;
        XTTFrame xTTFrame = XTTFrame.frame;
        Database database = new Database(xTTFrame.px.getLoginDbName());
        CheckNode rootNode = new CheckNode(database);
        try {
            Table table = null;
            View view = null;
            CheckNode node1 = null;
            String owner = "";
            String tableName = "";
            String type = "";
            dbmd = XTTFrame.frame.conn.dbconn.getMetaData();
            dbmdrs = dbmd.getTables(null, null, null, null);
            while (dbmdrs.next()) {
                owner = dbmdrs.getString(2);
                tableName = dbmdrs.getString(3);
                type = dbmdrs.getString(4);
                if (type.equals("TABLE")) {
                    table = new Table(owner, tableName);
                    database.addChild(table);
                    node1 = new CheckNode(table);
                    rootNode.add(node1);
                    node1.add(new CheckNode());
                    continue;
                }
                if (!type.equals("VIEW")) continue;
                view = new View(owner, tableName);
                database.addChild(view);
                node1 = new CheckNode(view);
                rootNode.add(node1);
                node1.add(new CheckNode());
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        finally {
            try {
                if (dbmd != null) {
                    dbmd = null;
                }
                if (dbmdrs != null) {
                    dbmdrs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rootNode;
    }

    void tree_valueChanged(TreeSelectionEvent e) {
        this.selectedTreePath = this.getSelectionPath();
    }
}

