/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtt.dlg;

import com.syscom.misc.XMLImageResource;
import com.syscom.table.DataTableModel;
import com.syscom.table.DataTableModelRowInfo;
import com.syscom.table.TableFocusListener;
import com.syscom.ut.comp.DbaButton;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.node.Template;
import com.syscom.xml.xtt.console.HelpButton;
import com.syscom.xml.xtt.console.XTTFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;

public class ParameterDlg
extends JDialog {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtt.dlg.resource.Res", LocaleManager.getLocale());
    Template template = null;
    String result = "";
    JTable table = null;
    public DataTableModel dtm = null;

    public ParameterDlg(Frame frame, String title, boolean modal, Template t) {
        super(frame, title, true);
        try {
            this.template = t;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ParameterDlg(Frame frame, Template t) {
        super(frame);
        this.setModal(true);
        try {
            this.template = t;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() {
        this.setTitle(this.res.getString("Parameter_setting"));
        JScrollPane scroll = new JScrollPane();
        this.getContentPane().setLayout(new BorderLayout());
        JLabel parameterNameLabel = new JLabel(this.res.getString("Name_"));
        JLabel parameterDefaultLabel = new JLabel(this.res.getString("Default_"));
        DbaButton okButton = new DbaButton(this.res.getString("Ok"), 'O');
        HelpButton helpButton = new HelpButton();
        XTTFrame.frame.enableDialogHelp(this.getRootPane(), helpButton, "parameterdlg");
        okButton.setIcon(XMLImageResource.getResource(this.getClass(), "/xmlimages/ut/ok.gif"));
        helpButton.setIcon(XMLImageResource.getResource(this.getClass(), "/xmlimages/ut/help.gif"));
        JPanel panel1 = new JPanel(new GridLayout(2, 2));
        JPanel panel2 = new JPanel();
        panel1.add(parameterNameLabel);
        panel1.add(new JTextField());
        panel1.add(parameterDefaultLabel);
        panel1.add(new JTextField());
        panel2.add(okButton);
        panel2.add(helpButton);
        this.getContentPane().add((Component)panel2, "South");
        this.dtm = this.template.get_dtmValue();
        this.dtm.removeAll();
        int size = this.template.get_dtmDefault().getRowCount();
        for (int i = 0; i < size - 1; ++i) {
            this.dtm.addValue(new DataTableModelRowInfo(this.template.get_dtmDefault().getValueAt(i, 0).toString().trim(), this.template.get_dtmDefault().getValueAt(i, 1).toString().trim()));
        }
        this.dtm.setTableColumnNames(this.res.getString("Name"), this.res.getString("Value"));
        this.dtm.setCellEditable(false);
        this.table = new JTable(this.dtm);
        this.table.getTableHeader().setReorderingAllowed(false);
        scroll.getViewport().add(this.table);
        this.table.addFocusListener(new TableFocusListener(this.table));
        this.getContentPane().add((Component)scroll, "Center");
        okButton.addActionListener(new ReflectionAction(this, "okButton_actionPerformed"));
    }

    public void okButton_actionPerformed(ActionEvent e) {
        this.table.editingStopped(null);
        this.dtm.fireTableChanged(new TableModelEvent(this.dtm));
        int rowCount = this.table.getRowCount();
        String tmpStr = "";
        for (int i = 0; i < rowCount; ++i) {
            tmpStr = this.table.getValueAt(i, 1).toString().trim();
            if (tmpStr.length() <= 0) continue;
            if (i == rowCount - 1) {
                if (this.table.getValueAt(i, 0).toString().trim().length() <= 0) continue;
                this.result = this.result + this.table.getValueAt(i, 0).toString().trim() + "=\"" + tmpStr + "\"";
                continue;
            }
            if (this.table.getValueAt(i, 0).toString().trim().length() <= 0) continue;
            this.result = this.result + this.table.getValueAt(i, 0).toString().trim() + "=\"" + tmpStr + "\",";
        }
        this.result = this.result.trim();
        if (this.result.endsWith(",")) {
            this.result = this.result.substring(0, this.result.length() - 1);
        }
        this.setVisible(false);
    }

    public String getResult() {
        return this.result;
    }
}

