/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.schema.node;

import com.syscom.datatransfer.XTTDatatransfer;
import com.syscom.misc.XMLImageResource;
import com.syscom.xml.schema.SchemaTreeNodeInterface;
import com.syscom.xml.schema.node.Column;
import com.syscom.xml.xtt.tree.CheckNode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.ImageIcon;

public class Table
extends XTTDatatransfer
implements SchemaTreeNodeInterface {
    private static ImageIcon icon = null;
    private static String imagefilename = "/xmlimages/schema/table.gif";
    private String owner = null;
    private String name = null;
    private Vector columns = null;
    private CheckNode checkNode = null;
    private SchemaTreeNodeInterface parent = null;

    public Table(String owner, String name) {
        this.owner = owner;
        this.name = name;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = XMLImageResource.getResource(this.getClass(), imagefilename);
        }
        return icon;
    }

    @Override
    public String toString() {
        return this.owner.trim() + "." + this.name.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector initColumns(Connection conn) {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = new Vector();
        ResultSet dbmdrs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            String columnName = "";
            String typeName = "";
            String tableName = "";
            String ownerName = "";
            Column column = null;
            dbmdrs = dbmd.getColumns(null, this.owner, this.name, null);
            while (dbmdrs.next()) {
                ownerName = dbmdrs.getString(2);
                tableName = dbmdrs.getString(3);
                columnName = dbmdrs.getString(4);
                int type = dbmdrs.getInt(5);
                int precision = dbmdrs.getInt(7);
                int scale = dbmdrs.getInt(9);
                int ordinal_position = dbmdrs.getInt(17);
                typeName = this.getDBMakerDataType(type);
                column = new Column(ownerName, tableName, columnName, typeName, precision, precision, scale, ordinal_position);
                this.addChild(column);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        finally {
            try {
                if (dbmdrs != null) {
                    dbmdrs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.columns;
    }

    public String getOwnerName() {
        return this.owner;
    }

    public String getTableName() {
        return this.name;
    }

    public String getDBMakerDataType(int i) {
        String typeStr = "char";
        switch (i) {
            case -5: {
                typeStr = "bigint";
                break;
            }
            case -2: {
                typeStr = "binary";
                break;
            }
            case -7: {
                typeStr = "smallint";
                break;
            }
            case 2004: {
                typeStr = "long varbinary";
                break;
            }
            case 1: {
                typeStr = "char";
                break;
            }
            case 2005: {
                typeStr = "long varchar";
                break;
            }
            case 91: {
                typeStr = "date";
                break;
            }
            case 3: {
                typeStr = "decimal";
                break;
            }
            case 8: {
                typeStr = "double";
                break;
            }
            case 6: {
                typeStr = "real";
                break;
            }
            case 4: {
                typeStr = "integer";
                break;
            }
            case -4: {
                typeStr = "long varbinary";
                break;
            }
            case -1: {
                typeStr = "long varchar";
                break;
            }
            case 2: {
                typeStr = "decimal";
                break;
            }
            case 7: {
                typeStr = "real";
                break;
            }
            case 5: {
                typeStr = "smallint";
                break;
            }
            case 92: {
                typeStr = "time";
                break;
            }
            case 93: {
                typeStr = "timestamp";
                break;
            }
            case -6: {
                typeStr = "smallint";
                break;
            }
            case -3: {
                typeStr = "binary";
                break;
            }
            case 12: {
                typeStr = "varchar";
                break;
            }
            default: {
                typeStr = "char";
            }
        }
        return typeStr;
    }

    @Override
    public void setCheckNode(CheckNode current_node) {
        this.checkNode = current_node;
    }

    public CheckNode getCheckNode() {
        return this.checkNode;
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getToolTipText() {
        return "";
    }

    @Override
    public SchemaTreeNodeInterface getParent() {
        return this.parent;
    }

    @Override
    public void setParent(SchemaTreeNodeInterface node) {
        this.parent = node;
    }

    @Override
    public void setChildren(Vector v) {
        this.columns = v;
    }

    @Override
    public boolean isFreeze() {
        return false;
    }

    @Override
    public Vector getChildren() {
        return this.columns;
    }

    public void addChild(SchemaTreeNodeInterface child) {
        if (this.columns == null) {
            this.columns = new Vector();
        }
        child.setParent(this);
        this.columns.addElement(child);
    }
}

