/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.node.display;

import com.syscom.table.DataTableModel;
import com.syscom.table.DataTableModelRowInfo;
import com.syscom.table.TableFocusListener;
import com.syscom.undo.TableRowRemoveUndoEdit;
import com.syscom.ut.PlatformUtil;
import com.syscom.ut.locale.LocaleChangeEvent;
import com.syscom.ut.locale.LocaleChangeListener;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.node.Template;
import com.syscom.xml.node.display.AbstractDisplayPanel;
import com.syscom.xml.xtt.console.XTTFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TemplatePanel
extends AbstractDisplayPanel
implements LocaleChangeListener {
    private ResourceBundle res1 = ResourceBundle.getBundle("com.syscom.xml.node.display.resource.Res", LocaleManager.getLocale());
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.table.resource.Res", LocaleManager.getLocale());
    private Template template = null;
    private JScrollPane scrollPane = new JScrollPane();
    public DataTableModel dtm = null;
    public JTable table = null;

    public TemplatePanel(Template template) {
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
        this.template = template;
        this.setLayout(new BorderLayout());
        this.dtm = template.get_dtmDefault();
        this.table = new JTable(this.dtm);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setBorder(null);
        this.scrollPane.getViewport().add(this.table);
        this.table.setRowHeight(20);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    TemplatePanel.this.table_keyReleased(e);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                TemplatePanel.this.table_keyReleased(e);
            }
        });
        this.table.addFocusListener(new TableFocusListener(this.table));
    }

    void table_keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127 && this.table.getSelectedRowCount() > 0 && this.table.getRowCount() >= 2) {
            TableRowRemoveUndoEdit edit = new TableRowRemoveUndoEdit(this.template, "addValueAt", this.dtm, (DataTableModelRowInfo)this.dtm.data.elementAt(this.table.getSelectedRow()), this.table.getSelectedRow());
            XTTFrame.frame.undoSupport.postEdit(edit);
            XTTFrame.frame.menubar.setUndoEnabled(true);
            XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
            this.dtm.removeSelectedRow(this.table.getSelectedRow());
            XTTFrame.setXTTModified(true);
            XTTFrame.frame.refresh_XTTCombo();
        }
        this.table.editingStopped(null);
        this.dtm.fireTableChanged(new TableModelEvent(this.dtm));
    }

    public boolean isParameters() {
        return this.dtm.getRowCount() > 1;
    }

    @Override
    public void grabComponentFocus(String property) {
        int index = property.indexOf("*");
        String row = null;
        if (index >= 0) {
            row = property.substring(0, index);
            String string = property.substring(index + 1, property.length());
        } else {
            row = property;
        }
        this.table.grabFocus();
        this.table.setRowSelectionInterval(Integer.parseInt(row), Integer.parseInt(row));
    }

    public Vector getParameterObjects() {
        Vector<String> v = new Vector<String>();
        if (this.dtm.getRowCount() > 1) {
            int rowCount = this.dtm.getRowCount();
            for (int i = 0; i < rowCount - 1; ++i) {
                v.add("$" + this.dtm.getValueAt(i, 0).toString().trim());
            }
        }
        return v;
    }

    @Override
    public String getTitle() {
        return this.res1.getString("Parameters");
    }

    @Override
    public void stopEditing() {
        this.table.editingStopped(null);
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = ResourceBundle.getBundle("com.syscom.table.resource.Res", LocaleManager.getLocale());
        this.res1 = ResourceBundle.getBundle("com.syscom.xml.node.display.resource.Res", LocaleManager.getLocale());
        this.dtm.localeChanged(e);
        TableColumnModel tcm = this.table.getColumnModel();
        TableColumn tc = tcm.getColumn(0);
        tc.setHeaderValue(this.res.getString("Name"));
        tc = tcm.getColumn(1);
        tc.setHeaderValue(this.res.getString("Default"));
    }
}

