/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut.comp;

import com.syscom.ut.comp.DbaRadioMenuItem;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleChangeEvent;
import com.syscom.ut.locale.LocaleChangeListener;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.preference.CorePreferences;
import com.syscom.ut.resource.DBAResourceBundle;
import java.awt.event.ActionEvent;
import java.util.Locale;

public class LocaleRadioMenuItem
extends DbaRadioMenuItem
implements LocaleChangeListener {
    private DBAResourceBundle res = new DBAResourceBundle("utproperties.Res", LocaleManager.getLocale());
    private short language_choice;

    public LocaleRadioMenuItem(short language_choice) {
        this.language_choice = language_choice;
        switch (language_choice) {
            case 1: {
                this.setText(this.res.getString("Chinese"));
                this.setMnemonic('C');
                break;
            }
            case 2: {
                this.setText(this.res.getString("Japanese"));
                this.setMnemonic('J');
                break;
            }
            case 3: {
                this.setText(this.res.getString("China"));
                this.setMnemonic('S');
                break;
            }
            default: {
                this.setText(this.res.getString("English"));
                this.setMnemonic('E');
            }
        }
        this.addActionListener(new ReflectionAction(this, "language_actionPerformed"));
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    public void language_actionPerformed(ActionEvent e) {
        CorePreferences cp = null;
        switch (this.language_choice) {
            case 1: {
                LocaleManager.getLocaleManager().localeChanged(new LocaleChangeEvent(this, Locale.TAIWAN));
                System.out.println("CHINESE = " + this.getLanguageChoice());
                CorePreferences.setLanguageChoice(this.getLanguageChoice());
                cp = CorePreferences.getCorePreferences();
                try {
                    cp.save();
                }
                catch (Exception ec) {
                    ec.printStackTrace();
                }
                break;
            }
            case 2: {
                LocaleManager.getLocaleManager().localeChanged(new LocaleChangeEvent(this, Locale.JAPAN));
                System.out.println("JAPANESE = " + this.getLanguageChoice());
                CorePreferences.setLanguageChoice(this.getLanguageChoice());
                cp = CorePreferences.getCorePreferences();
                try {
                    cp.save();
                }
                catch (Exception ej) {
                    ej.printStackTrace();
                }
                break;
            }
            case 3: {
                LocaleManager.getLocaleManager().localeChanged(new LocaleChangeEvent(this, Locale.CHINA));
                System.out.println("china = " + this.getLanguageChoice());
                CorePreferences.setLanguageChoice(this.getLanguageChoice());
                cp = CorePreferences.getCorePreferences();
                try {
                    cp.save();
                }
                catch (Exception ec) {
                    ec.printStackTrace();
                }
                break;
            }
            default: {
                LocaleManager.getLocaleManager().localeChanged(new LocaleChangeEvent(this, Locale.US));
                System.out.println("ENGLISH = " + this.getLanguageChoice());
                CorePreferences.setLanguageChoice(this.getLanguageChoice());
                cp = CorePreferences.getCorePreferences();
                try {
                    cp.save();
                    break;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    public short getLanguageChoice() {
        return this.language_choice;
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = e != null ? new DBAResourceBundle("utproperties.Res", e.getLocale()) : new DBAResourceBundle("utproperties.Res", LocaleManager.getLocale());
        switch (this.language_choice) {
            case 1: {
                this.setText(this.res.getString("Chinese"));
                break;
            }
            case 2: {
                this.setText(this.res.getString("Japanese"));
                break;
            }
            case 3: {
                this.setText(this.res.getString("China"));
                break;
            }
            default: {
                this.setText(this.res.getString("English"));
            }
        }
    }
}

