/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.undo;

import com.syscom.table.DataTableModel;
import com.syscom.xml.node.display.AbstractDisplayPanel;
import com.syscom.xml.xtt.console.XTTFrame;
import com.syscom.xml.xttinterface.XTTTreeNodeInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class TableUndoEdit
extends AbstractUndoableEdit {
    private Object data = null;
    private XTTTreeNodeInterface xtt = null;
    private String method = null;
    private Vector undoQueueVector = new Vector();
    private DataTableModel dtm = null;
    private int row = 0;
    private int col = 0;

    public TableUndoEdit(XTTTreeNodeInterface xtt2, String method, Object old, DataTableModel dtm, int row, int col) {
        this.xtt = xtt2;
        this.data = old;
        this.method = method;
        this.dtm = dtm;
        this.row = row;
        this.col = col;
    }

    public String getMethod() {
        return "setValueAt";
    }

    @Override
    public void undo() throws CannotUndoException {
        try {
            Class<?> cls = this.dtm.getClass();
            Class[] classes = new Class[]{new Object().getClass(), Integer.TYPE, Integer.TYPE};
            Method m = cls.getMethod(this.getMethod(), classes);
            Object[] objs = new Object[]{this.data, new Integer(this.row), new Integer(this.col)};
            m.invoke((Object)this.dtm, objs);
            if (this.dtm.getValueAt(this.row, 0).toString().trim().length() == 0 && this.dtm.getValueAt(this.row, 1).toString().trim().length() == 0 && this.dtm.getRowCount() > this.row) {
                this.dtm.removeSelectedRow(this.dtm.getRowCount() - 1);
            }
            DefaultMutableTreeNode dmtn = this.xtt.getDefaultMutableTreeNode();
            XTTFrame.frame.setSelectedNode(dmtn);
            ((JTabbedPane)XTTFrame.frame.getBottomPanel()).setSelectedIndex(this.xtt.getTabbedIndex(this.method));
            String property = this.row + "*" + this.col;
            ((AbstractDisplayPanel)((JTabbedPane)XTTFrame.frame.getBottomPanel()).getSelectedComponent()).grabComponentFocus(property);
            XTTFrame.frame.refreshXTT();
            if (XTTFrame.frame.from >= 0) {
                XTTFrame.frame.undoManager.trimEdits(XTTFrame.frame.from - 1, XTTFrame.frame.undoManager.getUndoQueueSize() - 1);
            } else {
                XTTFrame.frame.undoManager.trimEdits(0, XTTFrame.frame.undoManager.getUndoQueueSize() - 1);
            }
            XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
        }
        catch (InvocationTargetException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void redo() throws CannotRedoException {
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return false;
    }
}

