/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.misc;

import com.syscom.misc.QueryParser;
import com.syscom.undo.DnDDocumentUndoEdit;
import com.syscom.ut.DbaObject;
import com.syscom.ut.GuiUt;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.node.Attribute;
import com.syscom.xml.node.QueryElement;
import com.syscom.xml.schema.node.Column;
import com.syscom.xml.xtt.console.XTTFrame;
import com.syscom.xml.xttinterface.XTTTreeNodeInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class XTTUt {
    public static boolean isLegalElementName(String s, XTTTreeNodeInterface xttTreeNodeInterface) {
        ResourceBundle res = ResourceBundle.getBundle("com.syscom.misc.resource.Res", LocaleManager.getLocale());
        boolean b = true;
        if (s.length() <= 0) {
            if (xttTreeNodeInterface instanceof QueryElement) {
                GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Element_name_can_not"), null);
            } else {
                GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Attribute_name_can_not"), null);
            }
            b = false;
            return b;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i == 0 && (Character.isLetter(c) || c == '_')) {
                b = true;
                continue;
            }
            if (i == 0) {
                if (xttTreeNodeInterface instanceof QueryElement) {
                    GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Element_name_cannot") + c, null);
                } else {
                    GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Attribute_name_cannot") + c, null);
                }
                b = false;
                return b;
            }
            if (Character.isSpaceChar(c)) {
                if (xttTreeNodeInterface instanceof QueryElement) {
                    GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Element_name_cannot1"), null);
                } else {
                    GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Attribute_name_cannot1"), null);
                }
                b = false;
                return b;
            }
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.') {
                b = true;
                continue;
            }
            if (xttTreeNodeInterface instanceof QueryElement) {
                GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Element_name_cannot2") + c, null);
            } else {
                GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Attribute_name_cannot2") + c, null);
            }
            b = false;
            return b;
        }
        if (b && xttTreeNodeInterface instanceof Attribute && XTTUt.isDuplicateAttributeName(s, xttTreeNodeInterface)) {
            GuiUt.showErrorDlg(XTTFrame.frame, res.getString("This_attribute_name"), null);
            b = false;
            return b;
        }
        return b;
    }

    public static boolean isLegalQueryObjectName(String s) {
        ResourceBundle res = ResourceBundle.getBundle("com.syscom.misc.resource.Res", LocaleManager.getLocale());
        boolean b = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i == 0 && (Character.isLetter(c) || c == '_')) {
                b = true;
                continue;
            }
            if (i == 0) {
                GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Query_name_cannot") + c, null);
                b = false;
                return b;
            }
            if (Character.isSpaceChar(c)) {
                GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Query_name_cannot_has"), null);
                b = false;
                return b;
            }
            if (Character.isLetterOrDigit(c) || c == '_') {
                b = true;
                continue;
            }
            GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Query_name_cannot_has1") + c, null);
            b = false;
            return b;
        }
        return b;
    }

    public static boolean isLegalQueryObjectName(String s, XTTTreeNodeInterface xttTreeNodeInterface, XTTTreeNodeInterface root) {
        ResourceBundle res = ResourceBundle.getBundle("com.syscom.misc.resource.Res", LocaleManager.getLocale());
        boolean b = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i == 0 && (Character.isLetter(c) || c == '_')) {
                b = true;
                continue;
            }
            if (i == 0) {
                GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Query_name_cannot") + c, null);
                b = false;
                return b;
            }
            if (Character.isSpaceChar(c)) {
                GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Query_name_cannot_has"), null);
                b = false;
                return b;
            }
            if (Character.isLetterOrDigit(c) || c == '_') {
                b = true;
                continue;
            }
            GuiUt.showErrorDlg(XTTFrame.frame, res.getString("Query_name_cannot_has1") + c, null);
            b = false;
            return b;
        }
        if (b && xttTreeNodeInterface instanceof QueryElement && XTTUt.isDuplicateQueryObjectName(s, root, xttTreeNodeInterface)) {
            GuiUt.showErrorDlg(XTTFrame.frame, res.getString("This_query_name_is"), null);
            b = true;
            return b;
        }
        return b;
    }

    public static boolean isDuplicateQueryObjectName(String s, XTTTreeNodeInterface xttTreeNodeInterface, XTTTreeNodeInterface selfXTT) {
        Vector children;
        XTTTreeNodeInterface childXTT = null;
        if (xttTreeNodeInterface instanceof QueryElement) {
            QueryElement qe = (QueryElement)xttTreeNodeInterface;
            if (qe.getQueryName().trim().length() == 0) {
                return false;
            }
            if (qe.getQueryName().equals(s)) {
                return true;
            }
        }
        if ((children = xttTreeNodeInterface.getChildren()) == null) {
            return false;
        }
        int size = children.size();
        int pos = children.indexOf(selfXTT);
        for (int i = 0; i < size; ++i) {
            if (i == pos || !XTTUt.isDuplicateQueryObjectName(s, childXTT = (XTTTreeNodeInterface)children.elementAt(i), selfXTT)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDuplicateAttributeNameInDropAction(String s, XTTTreeNodeInterface xttTreeNodeInterface) {
        boolean b = false;
        Vector children = xttTreeNodeInterface.getChildren();
        XTTTreeNodeInterface child = null;
        int pos = children.indexOf(xttTreeNodeInterface);
        for (int i = 0; i < children.size(); ++i) {
            if (i == pos) continue;
            child = (XTTTreeNodeInterface)children.elementAt(i);
            if (child instanceof Attribute) {
                Attribute childAtt = (Attribute)child;
                if (s.equals(childAtt.getName())) {
                    b = true;
                    return b;
                }
                b = false;
                continue;
            }
            b = false;
        }
        return b;
    }

    public static boolean isDuplicateAttributeName(String s, XTTTreeNodeInterface xttTreeNodeInterface) {
        XTTTreeNodeInterface parent = null;
        boolean b = false;
        parent = xttTreeNodeInterface.getParent();
        if (parent == null) {
            return false;
        }
        Vector children = parent.getChildren();
        XTTTreeNodeInterface child = null;
        int pos = children.indexOf(xttTreeNodeInterface);
        for (int i = 0; i < children.size(); ++i) {
            if (i == pos) continue;
            child = (XTTTreeNodeInterface)children.elementAt(i);
            if (child instanceof Attribute) {
                Attribute childAtt = (Attribute)child;
                if (s.equals(childAtt.getName())) {
                    b = true;
                    return b;
                }
                b = false;
                continue;
            }
            b = false;
        }
        return b;
    }

    public static DefaultMutableTreeNode searchSuitableElement(DefaultMutableTreeNode node, Column column, DnDDocumentUndoEdit edit) {
        ResourceBundle res = ResourceBundle.getBundle("com.syscom.misc.resource.Res", LocaleManager.getLocale());
        XTTTreeNodeInterface sourceXTT = (XTTTreeNodeInterface)node.getUserObject();
        XTTTreeNodeInterface parentXTT = null;
        DefaultMutableTreeNode parentNode = null;
        if (sourceXTT instanceof Attribute) {
            parentNode = (DefaultMutableTreeNode)node.getParent();
            parentXTT = sourceXTT.getParent();
            if (parentXTT == null) {
                GuiUt.showErrorDlg(XTTFrame.frame, res.getString("No_any_suitable"), null);
                return null;
            }
            return XTTUt.searchSuitableElement(parentNode, column, edit);
        }
        if (sourceXTT instanceof QueryElement) {
            QueryElement qe = (QueryElement)sourceXTT;
            if (qe.getQueryName() == null || qe.getQueryName().length() <= 0 || qe.getCommand() == null || qe.getCommand().length() <= 0) {
                parentXTT = qe.getParent();
                parentNode = (DefaultMutableTreeNode)node.getParent();
                int queryElementParentNodeLevel = parentNode.getLevel();
                if (parentXTT == null) {
                    GuiUt.showErrorDlg(XTTFrame.frame, res.getString("No_any_suitable"), null);
                    return null;
                }
                return XTTUt.searchSuitableElement(parentNode, column, edit);
            }
            String command = qe.getCommand();
            PreparedStatement p_stmt = null;
            ResultSetMetaData rsmd = null;
            Vector<XTTTableInfoObject> v = new Vector<XTTTableInfoObject>();
            try {
                String sqlStr = QueryParser.getPreparedStmt(command).trim();
                XTTFrame.frame.conn.dbconn.setAutoCommit(false);
                p_stmt = XTTFrame.frame.conn.dbconn.prepareStatement(sqlStr);
                rsmd = p_stmt.getMetaData();
                int column_count = rsmd.getColumnCount();
                XTTTableInfoObject tio = null;
                for (int i = 1; i < column_count; ++i) {
                    tio = new XTTTableInfoObject(rsmd.getSchemaName(i), rsmd.getTableName(i), rsmd.getColumnName(i));
                    v.add(tio);
                }
                DbaObject.close(p_stmt);
                XTTFrame.frame.conn.dbconn.rollback();
                XTTFrame.frame.conn.dbconn.setAutoCommit(true);
            }
            catch (SQLException sqle) {
                System.out.println("sqle.getMessage() = " + sqle.getMessage());
                DbaObject.close(p_stmt);
                DbaObject.rollback(XTTFrame.frame.conn.dbconn);
                DbaObject.setAutoCommit(XTTFrame.frame.conn.dbconn, true);
            }
            if (!XTTUt.columnNameCheck(v, column)) {
                String upper_command = command.toUpperCase();
                int from_pos = 0;
                int previous_pos = 0;
                while ((from_pos = upper_command.indexOf("FROM")) >= 0) {
                    upper_command = upper_command.substring(from_pos + 1, upper_command.length());
                    previous_pos = from_pos;
                }
                String modified_sql = "";
                if (previous_pos > 0) {
                    modified_sql = column.getColumnAliasName() != null ? command.substring(0, previous_pos) + ",\"" + column.getTableName() + "\".\"" + column.getColumnName() + "\" as " + column.getColumnAliasName() + " " + command.substring(previous_pos, command.length()) : command.substring(0, previous_pos) + ",\"" + column.getTableName() + "\".\"" + column.getColumnName() + "\" " + command.substring(previous_pos, command.length());
                } else {
                    return null;
                }
                PreparedStatement pstmt = null;
                try {
                    XTTFrame.frame.conn.dbconn.setAutoCommit(false);
                    String sqlStr = QueryParser.getPreparedStmt(modified_sql).trim();
                    pstmt = XTTFrame.frame.conn.dbconn.prepareStatement(sqlStr);
                    DbaObject.close(pstmt);
                    qe.setCommand(modified_sql);
                    edit.setXTT(qe);
                    edit.setOldData(command);
                    XTTFrame.frame.conn.dbconn.rollback();
                    XTTFrame.frame.conn.dbconn.setAutoCommit(true);
                    XTTFrame.frame.refreshXTT();
                    return node;
                }
                catch (SQLException sqle) {
                    DbaObject.close(pstmt);
                    DbaObject.rollback(XTTFrame.frame.conn.dbconn);
                    DbaObject.setAutoCommit(XTTFrame.frame.conn.dbconn, true);
                    parentXTT = qe.getParent();
                    parentNode = (DefaultMutableTreeNode)node.getParent();
                    int queryElementCatchParentNodeLevel = parentNode.getLevel();
                    if (parentXTT == null) {
                        GuiUt.showErrorDlg(XTTFrame.frame, res.getString("No_any_suitable"), null);
                        return null;
                    }
                    return XTTUt.searchSuitableElement(parentNode, column, edit);
                }
            }
            return node;
        }
        GuiUt.showErrorDlg(XTTFrame.frame, res.getString("No_any_suitable"), null);
        return null;
    }

    public static boolean columnNameCheck(Vector v, Column column) {
        int size = v.size();
        XTTTableInfoObject xtt_tio = null;
        boolean b = true;
        String column_name = column.getColumnAliasName() != null ? column.getColumnAliasName() : column.getColumnName();
        for (int i = 0; i < size; ++i) {
            xtt_tio = (XTTTableInfoObject)v.elementAt(i);
            if (column.getTableName().equals(xtt_tio.getTable()) && column_name.equals(xtt_tio.getColumn())) {
                b = true;
                break;
            }
            b = false;
        }
        return b;
    }

    public static String buildSpaceString(int space_count) {
        String space = "";
        for (int i = 0; i < space_count; ++i) {
            space = space + " ";
        }
        return space;
    }

    public static short writeXTTFileContent(File writedFile, String encoding, String content) {
        try {
            OutputStreamWriter writer = null;
            if (encoding.trim().length() == 0) {
                writer = new OutputStreamWriter(new FileOutputStream(writedFile));
            } else if (encoding.equals("UTF-16LE")) {
                content = new String("\ufeff") + content;
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(writedFile), "UnicodeLittleUnmarked");
            } else if (encoding.equals("UTF-16BE")) {
                content = new String("\ufeff") + content;
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(writedFile), "UnicodeBigUnmarked");
            } else {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(writedFile), encoding);
            }
            writer.write(content);
            writer.close();
            return 0;
        }
        catch (IOException ioe) {
            GuiUt.showErrorDlg(XTTFrame.frame, ioe.getMessage(), null);
            return -1;
        }
    }

    public static String mapXMLData(String sourceStr, boolean isAttribute) {
        int sourceStr_len = sourceStr.length();
        String destStr = "";
        String tmpStr = "";
        for (int i = 0; i < sourceStr_len; ++i) {
            char c = sourceStr.charAt(i);
            if (c == '<') {
                tmpStr = "&lt;";
            } else if (c == '>') {
                tmpStr = "&gt;";
            } else if (c == '&') {
                tmpStr = "&amp;";
            } else if (c == '\'') {
                tmpStr = "&apos;";
            } else if (c == '\"') {
                tmpStr = "&quot;";
            } else if (isAttribute) {
                if (c == '\n') {
                    tmpStr = "&#xA;";
                } else if (Character.isSpaceChar(c)) {
                    tmpStr = "&#x20;";
                } else if (c == '\r') {
                    tmpStr = "&#xD;";
                } else {
                    tmpStr = "";
                    tmpStr = tmpStr + c;
                }
            } else {
                tmpStr = "";
                tmpStr = tmpStr + c;
            }
            destStr = destStr + tmpStr;
        }
        return destStr;
    }

    public static boolean isDbObjectNameAsAscii(String objName) {
        char[] cA = objName.toCharArray();
        int len = cA.length;
        boolean b = true;
        for (int i = 0; i < len; ++i) {
            if (cA[i] >= 'a' && cA[i] <= 'z' || cA[i] >= 'A' && cA[i] <= 'Z' || cA[i] >= '0' && cA[i] <= '9' || cA[i] == '_') continue;
            b = false;
            break;
        }
        return b;
    }

    private static class XTTTableInfoObject {
        private String owner_name = null;
        private String table_name = null;
        private String column_name = null;

        public XTTTableInfoObject(String owner, String table, String column) {
            this.owner_name = owner;
            this.table_name = table;
            this.column_name = column;
        }

        public String getOwner() {
            return this.owner_name;
        }

        public String getTable() {
            return this.table_name;
        }

        public String getColumn() {
            return this.column_name;
        }
    }
}

