/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.misc;

import com.syscom.importxsddtd.XSDDTDDisabledTreeNode;
import com.syscom.importxsddtd.dtd.AttListDecl;
import com.syscom.importxsddtd.dtd.DTDParser;
import com.syscom.importxsddtd.dtd.ParseException;
import com.syscom.ut.GuiUt;
import com.syscom.xml.node.Attribute;
import com.syscom.xml.node.QueryElement;
import com.syscom.xml.xtt.console.XTTFrame;
import com.syscom.xml.xttinterface.XTTTreeNodeInterface;
import java.awt.Cursor;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class DTDHandler {
    private Vector elements = new Vector();
    private Vector attrlists = new Vector();
    private QueryElement rootQE = null;

    public void attListDecl(AttListDecl list) {
        this.attrlists.add(list);
    }

    public void elementDecl(QueryElement e) {
        this.elements.add(e);
    }

    private boolean isRecursive(Stack s, String str1) {
        return s.indexOf(str1) >= 0;
    }

    private void copyElement(QueryElement dest, QueryElement src, Stack stack) {
        Vector v = src.getChildren();
        if (v == null || v.size() == 0) {
            return;
        }
        stack.push(dest.getLocalName());
        XTTTreeNodeInterface child = null;
        QueryElement e = null;
        Attribute a = null;
        Enumeration enum1 = v.elements();
        while (enum1.hasMoreElements()) {
            child = (XTTTreeNodeInterface)enum1.nextElement();
            if (child instanceof QueryElement) {
                e = (QueryElement)child;
                if (this.isRecursive(stack, e.getLocalName())) continue;
                dest.addChild(new QueryElement(e.getLocalName()));
                continue;
            }
            if (!(child instanceof Attribute)) continue;
            a = (Attribute)child;
            dest.addChild(new Attribute(a.getName(), a.getValue()));
        }
        stack.pop();
    }

    public XSDDTDDisabledTreeNode getTreeNode(String filename) {
        System.out.println("start parse " + new Date());
        try {
            FileInputStream in = new FileInputStream(filename);
            int size = in.available();
            byte[] ba = new byte[size];
            in.read(ba);
            DTDParser parser = new DTDParser(new ByteArrayInputStream(ba));
            parser.setHandle(this);
            parser.parse();
            parser = null;
            in.close();
        }
        catch (IOException ioe) {
            XTTFrame.frame.setCursor(Cursor.getPredefinedCursor(0));
            GuiUt.showErrorDlg(XTTFrame.frame, ioe.getMessage(), null);
            return null;
        }
        catch (ParseException pe) {
            XTTFrame.frame.setCursor(Cursor.getPredefinedCursor(0));
            GuiUt.showErrorDlg(XTTFrame.frame, pe.getMessage(), null);
            return null;
        }
        System.out.println("start organize " + new Date());
        this.organize();
        XSDDTDDisabledTreeNode root = new XSDDTDDisabledTreeNode(this.rootQE);
        XSDDTDDisabledTreeNode node = null;
        QueryElement e = null;
        int size = this.elements.size();
        for (int i = 0; i < size && (node = this.getTreeNode(e = (QueryElement)this.elements.elementAt(i), 0, new Stack())) != null; ++i) {
            root.add(node);
        }
        return root;
    }

    private XSDDTDDisabledTreeNode getTreeNode(QueryElement current, int scope, Stack stack) {
        try {
            XSDDTDDisabledTreeNode treenode0 = new XSDDTDDisabledTreeNode(current);
            current.setDefaultMutableTreeNode(treenode0);
            stack.push(current.getLocalName());
            Vector v = current.getChildren();
            if (v != null) {
                XTTTreeNodeInterface child = null;
                QueryElement e = null;
                QueryElement e2 = null;
                Enumeration enum1 = v.elements();
                while (enum1.hasMoreElements()) {
                    child = (XTTTreeNodeInterface)enum1.nextElement();
                    if (child instanceof Attribute) {
                        treenode0.add(new XSDDTDDisabledTreeNode(child));
                        continue;
                    }
                    if (!(child instanceof QueryElement) || this.isRecursive(stack, (e = (QueryElement)child).getLocalName())) continue;
                    e2 = this.searchElement(e.getLocalName());
                    if (e2 != null) {
                        this.copyElement(e, e2, stack);
                    }
                    treenode0.add(this.getTreeNode(e, scope + 1, stack));
                }
            }
            stack.pop();
            return treenode0;
        }
        catch (OutOfMemoryError e) {
            XTTFrame.frame.setCursor(Cursor.getPredefinedCursor(0));
            GuiUt.showErrorDlg(XTTFrame.frame, e.getMessage(), null);
            return null;
        }
    }

    public void setRoot(QueryElement qe) {
        this.rootQE = qe;
    }

    private QueryElement searchElement(String str) {
        if (this.elements == null || this.elements.size() == 0) {
            return null;
        }
        QueryElement e = null;
        String name = null;
        int size = this.elements.size();
        Enumeration enum1 = this.elements.elements();
        while (enum1.hasMoreElements()) {
            e = (QueryElement)enum1.nextElement();
            name = e.getLocalName();
            if (name.compareTo(str) != 0) continue;
            return e;
        }
        return null;
    }

    private void organize() {
        Object children = null;
        boolean size = false;
        Enumeration enum1 = null;
        int k = 0;
        String name = null;
        QueryElement e = null;
        Object e2 = null;
        Object e3 = null;
        AttListDecl a = null;
        int e_size = this.elements.size();
        int a_size = this.attrlists.size();
        for (int j = 0; j < e_size; ++j) {
            e = (QueryElement)this.elements.elementAt(j);
            name = e.getLocalName();
            for (int i = 0; i < a_size; ++i) {
                a = (AttListDecl)this.attrlists.elementAt(i);
                if (!a.isEqual(name)) continue;
                k = 0;
                enum1 = a.getAttributes();
                while (enum1.hasMoreElements()) {
                    e.addChildAt((XTTTreeNodeInterface)enum1.nextElement(), k++);
                }
            }
        }
    }
}

