/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaFileChooser;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JToolBar;
import queryAnalyzer.AsQueryPane;
import queryAnalyzer.DbaFileFilter;
import queryAnalyzer.QueryFrame;

public class TableToolBar
extends JToolBar
implements LocaleChangeListener {
    private DBAResourceBundle res = new DBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    public DbaButton pageUpDbaButton = new DbaButton(new Dimension(20, 20));
    public DbaButton pageDownDbaButton = new DbaButton(new Dimension(20, 20));
    public DbaButton firstPageDbaButton = new DbaButton(new Dimension(20, 20));
    public DbaButton lastPageDbaButton = new DbaButton(new Dimension(20, 20));
    public DbaButton saveTableDbaButton = new DbaButton(new Dimension(20, 20));

    public TableToolBar() {
        this.setOrientation(1);
        this.setFloatable(false);
        this.pageUpDbaButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/previous.gif"));
        this.pageUpDbaButton.addActionListener(new ReflectionAction(this, "pageUp_actionPerformed"));
        this.pageUpDbaButton.setToolTipText(this.res.getString("Page_Up"));
        this.pageDownDbaButton.setToolTipText(this.res.getString("Page_Down"));
        this.pageDownDbaButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/next.gif"));
        this.pageDownDbaButton.addActionListener(new ReflectionAction(this, "pageDown_actionPerformed"));
        this.firstPageDbaButton.setToolTipText(this.res.getString("First_Page"));
        this.firstPageDbaButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/first.gif"));
        this.firstPageDbaButton.addActionListener(new ReflectionAction(this, "firstPage_actionPerformed"));
        this.lastPageDbaButton.setToolTipText(this.res.getString("Last_Page"));
        this.lastPageDbaButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/last.gif"));
        this.lastPageDbaButton.addActionListener(new ReflectionAction(this, "lastPage_actionPerformed"));
        this.saveTableDbaButton.setToolTipText(this.res.getString("Save_Table"));
        this.saveTableDbaButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/save.gif"));
        this.saveTableDbaButton.addActionListener(new ReflectionAction(this, "saveTable_actionPerformed"));
        this.pageDownDbaButton.setEnabled(false);
        this.pageUpDbaButton.setEnabled(false);
        this.lastPageDbaButton.setEnabled(false);
        this.firstPageDbaButton.setEnabled(false);
        this.saveTableDbaButton.setEnabled(false);
        this.add((Component)this.firstPageDbaButton, null);
        this.add((Component)this.pageUpDbaButton, null);
        this.add((Component)this.pageDownDbaButton, null);
        this.add((Component)this.lastPageDbaButton, null);
        this.add((Component)this.saveTableDbaButton, null);
    }

    public void pageUp_actionPerformed(ActionEvent e) {
        AsQueryPane myPane = QueryFrame.frame.getSelectedQueryPanel();
        myPane.ButtonAction(new Integer(myPane.pageUP));
    }

    public void pageDown_actionPerformed(ActionEvent e) {
        AsQueryPane myPane = QueryFrame.frame.getSelectedQueryPanel();
        myPane.ButtonAction(new Integer(myPane.pageDOWN));
    }

    public void firstPage_actionPerformed(ActionEvent e) {
        AsQueryPane myPane = QueryFrame.frame.getSelectedQueryPanel();
        myPane.ButtonAction(new Integer(myPane.pageFIRST));
    }

    public void lastPage_actionPerformed(ActionEvent e) {
        AsQueryPane myPane = QueryFrame.frame.getSelectedQueryPanel();
        myPane.ButtonAction(new Integer(myPane.pageLAST));
    }

    public void saveTable_actionPerformed(ActionEvent e) {
        DbaFileChooser outputFileChooser = new DbaFileChooser(QueryFrame.frame.px.getBlobFilePath());
        outputFileChooser.setFileFilter(new DbaFileFilter("txt"));
        int saveResponse = outputFileChooser.showDialog(QueryFrame.frame, this.res.getString("save_as"));
        if (saveResponse == 0) {
            File file = outputFileChooser.getSelectedFile();
            String filterName = outputFileChooser.getFileFilter().getDescription();
            if (filterName != null && filterName.equalsIgnoreCase("*.txt") && !file.getPath().endsWith(".txt")) {
                String s = file.getPath() + ".txt";
                file = new File(s);
            }
            if (file.exists()) {
                String s1;
                if (!file.canWrite()) {
                    s1 = this.res.getString("file_cannot_be_written");
                    String s2 = GuiUt.mapStringForProperty(s1, file.toString());
                    GuiUt.showWarningDlg(QueryFrame.frame, this.res.getString("Warning"), s2);
                    return;
                }
                s1 = this.res.getString("file_cannot_is_existed");
                String s2 = GuiUt.mapStringForProperty(s1, file.toString());
                int answer = GuiUt.showOptionDlg(QueryFrame.frame, this.res.getString("Warning"), s2);
                if (answer == 0) {
                    file.delete();
                } else {
                    return;
                }
            }
            AsQueryPane myPane = QueryFrame.frame.getSelectedQueryPanel();
            myPane.SaveTableAction(file);
        }
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = e == null ? new DBAResourceBundle("resource.jsqltool", LocaleManager.getLocale()) : new DBAResourceBundle("resource.jsqltool", e.getLocale());
        this.pageUpDbaButton.setToolTipText(this.res.getString("Page_Up"));
        this.pageDownDbaButton.setToolTipText(this.res.getString("Page_Down"));
        this.firstPageDbaButton.setToolTipText(this.res.getString("First_Page"));
        this.lastPageDbaButton.setToolTipText(this.res.getString("Last_Page"));
        this.saveTableDbaButton.setToolTipText(this.res.getString("Save_Table"));
    }
}

