/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbaut.util.JdbcUtil;
import dbaut.util.PlatformUtil;
import dbmaker.sql.JdbcOdbcBlob;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import queryAnalyzer.AsQueryPaneInterface;
import queryAnalyzer.AsTableModel;
import queryAnalyzer.DatabaseConnection;
import queryAnalyzer.QueryFrame;
import tableCell.BlobCellObject;

public class AsQueryPane
extends JScrollPane
implements AsQueryPaneInterface {
    private DBAResourceBundle res = new DBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    public int[] info = new int[5];
    public boolean[] enable = new boolean[5];
    public String query = null;
    public AsTableModel tableModel = null;
    public JTable resultTable = null;
    public ArrayList nameRecord = null;
    public ArrayList dataTypeRecord = null;
    public Vector columnWidth = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private DatabaseConnection conn = null;
    public final int pageUP = 0;
    public final int pageDOWN = 1;
    public final int pageFIRST = 2;
    public final int pageLAST = 3;

    public AsQueryPane(DatabaseConnection conn, int[] info, boolean[] enable, String query, AsTableModel tableModel, JTable resultTable, ArrayList nameRecord, ArrayList dataTypeRecord) {
        this.conn = conn;
        this.info = info;
        this.enable = enable;
        this.query = query;
        this.tableModel = tableModel;
        this.resultTable = resultTable;
        this.nameRecord = nameRecord;
        this.dataTypeRecord = dataTypeRecord;
        this.getViewport().add(resultTable);
        this.ButtonStatus(enable);
        resultTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AsQueryPane.this.table_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent ee) {
                AsQueryPane.this.table_focusLosted(ee);
            }
        });
        resultTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    AsQueryPane.this.table_keyHandle(e);
                }
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                AsQueryPane.this.table_keyHandle(ke);
            }

            @Override
            public void keyReleased(KeyEvent kee) {
                AsQueryPane.this.table_keyHandle(kee);
            }
        });
        resultTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                AsQueryPane.this.table_mouseHandle(me);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                AsQueryPane.this.saveColumnWidth();
            }
        });
    }

    @Override
    public void ButtonStatus(boolean[] enable) {
        QueryFrame.frame.setToolbarStatus(enable);
    }

    @Override
    public void ButtonAction(Integer act) {
        int col;
        int start = this.info[0];
        int end = this.info[1];
        int max = this.info[2];
        int jump = this.info[3];
        int counter = this.info[4];
        if (act != null) {
            int action = act;
            switch (action) {
                case 0: {
                    counter -= jump;
                    if ((start -= jump) < 0) {
                        return;
                    }
                    int moduleEnd = end % jump;
                    if (moduleEnd == 0) {
                        end -= jump;
                        break;
                    }
                    end -= moduleEnd;
                    break;
                }
                case 1: {
                    counter += jump;
                    start = end;
                    if (start >= max) {
                        return;
                    }
                    if ((end += jump) <= max) break;
                    end = max;
                    break;
                }
                case 2: {
                    counter = 0;
                    start = 0;
                    end = jump;
                    break;
                }
                case 3: {
                    int moduleMax = max % jump;
                    start = moduleMax == 0 ? max - jump : max - moduleMax;
                    end = max;
                    counter = start;
                }
            }
            this.info[0] = start;
            this.info[1] = end;
            this.info[2] = max;
            this.info[3] = jump;
            this.info[4] = counter;
        }
        this.enable[1] = start != 0;
        this.enable[0] = this.enable[1];
        this.enable[3] = end != max;
        this.enable[2] = this.enable[3];
        this.enable[4] = true;
        this.executeSql(this.query, this.nameRecord, this.dataTypeRecord, this.tableModel, start, end);
        int temp = 0;
        if (max > 0) {
            temp = start + 1;
        }
        QueryFrame.frame.setRowField("", temp, end, max);
        for (col = 0; col < this.nameRecord.size(); ++col) {
            if (!QueryFrame.frame.isBlobType(this.dataTypeRecord.get(col).toString())) continue;
            QueryFrame.frame.setUpBlobEditor(this.resultTable, this.tableModel, col);
        }
        if (this.columnWidth != null) {
            for (col = 0; col < this.nameRecord.size(); ++col) {
                Integer width = new Integer(this.columnWidth.get(col).toString());
                this.resultTable.getColumnModel().getColumn(col).setPreferredWidth(width);
            }
        }
        this.ButtonStatus(this.enable);
    }

    private void executeSql(String sqlStatement, ArrayList nameRecord, ArrayList dataTypeRecord, AsTableModel tableModel, int start, int end) {
        try {
            this.stmt = this.conn.getDbConnection().createStatement(1004, 1007);
            String sql = sqlStatement + "limit " + start + ", " + (end - start);
            this.rs = this.stmt.executeQuery(sql);
            if (this.rs == null) {
                System.out.println("error,rs is null,this is happend in jsql QueryFrame.java->ExecuteSql.");
                return;
            }
            tableModel.removeAll();
            Blob blob = null;
            int size = nameRecord.size();
            String colType = null;
            Object[] rowData = null;
            int rowNum = 0;
            while (this.rs.next()) {
                ++rowNum;
                rowData = new Object[size];
                for (int col = 0; col < size; ++col) {
                    colType = dataTypeRecord.get(col).toString().trim();
                    if (colType.equalsIgnoreCase("long varchar") || colType.equalsIgnoreCase("clob") || colType.equalsIgnoreCase("nclob") || colType.equalsIgnoreCase("long varbinary") || colType.equalsIgnoreCase("blob") || colType.equalsIgnoreCase("file")) {
                        blob = this.rs.getBlob(col + 1);
                        long length = blob.length();
                        if (length != -1L && !this.rs.wasNull()) {
                            rowData[col] = new BlobCellObject(this.rs, rowNum, col + 1, nameRecord.get(col).toString(), dataTypeRecord.get(col).toString(), length, this.rs.wasNull());
                            ((JdbcOdbcBlob)blob).close();
                        }
                        JdbcUtil.free(blob);
                        continue;
                    }
                    rowData[col] = this.rs.getString(col + 1);
                }
                tableModel.addValue(rowData);
            }
            tableModel.fireTableChanged(new TableModelEvent(tableModel));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void closeResultSet() {
        DbaObject.close(this.rs);
        DbaObject.close(this.stmt);
    }

    @Override
    public void SaveTableAction(File file) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            int rowCount = this.tableModel.getRowCount();
            int colCount = this.tableModel.getColumnCount();
            StringBuffer strColName = new StringBuffer();
            String value = null;
            for (int i = 0; i < colCount; ++i) {
                value = this.tableModel.getColumnName(i);
                strColName.append(value);
                strColName.append("\t");
            }
            out.write(strColName.toString());
            out.newLine();
            String lineSeparator = System.getProperty("line.separator");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    value = this.tableModel.getValueAt(i, j).toString();
                    sb.append(value);
                    sb.append("\t");
                }
                sb.append(lineSeparator);
            }
            out.write(sb.toString());
            out.newLine();
            out.flush();
            out.close();
            GuiUt.showInformationDlg(QueryFrame.frame, this.res.getString("Save_table_successful"));
        }
        catch (Exception e) {
            GuiUt.showErrorDlg(QueryFrame.frame, this.res.getString("Save_table_fail"), "");
            e.printStackTrace();
        }
    }

    public void table_focusGained(FocusEvent e) {
        Integer rowPosition = new Integer(this.resultTable.getSelectedRow() + 1 + this.info[4]);
        int temp = 0;
        if (this.info[2] > 0) {
            temp = this.info[0] + 1;
        }
        QueryFrame.frame.setRowField(rowPosition.toString(), temp, this.info[1], this.info[2]);
    }

    public void table_focusLosted(FocusEvent ee) {
        QueryFrame.frame.setRowField("", 0, 0, this.info[2]);
    }

    public void table_keyHandle(KeyEvent e) {
        Integer rowPosition = new Integer(this.resultTable.getSelectedRow() + 1 + this.info[4]);
        int temp = 0;
        if (this.info[2] > 0) {
            temp = this.info[0] + 1;
        }
        QueryFrame.frame.setRowField(rowPosition.toString(), temp, this.info[1], this.info[2]);
    }

    public void table_mouseHandle(MouseEvent e) {
        Integer rowPosition = new Integer(this.resultTable.getSelectedRow() + 1 + this.info[4]);
        int temp = 0;
        if (this.info[2] > 0) {
            temp = this.info[0] + 1;
        }
        QueryFrame.frame.setRowField(rowPosition.toString(), temp, this.info[1], this.info[2]);
    }

    public void saveColumnWidth() {
        this.columnWidth = new Vector();
        for (int col = 0; col < this.nameRecord.size(); ++col) {
            this.columnWidth.add(new Integer(this.resultTable.getColumnModel().getColumn(col).getWidth()));
        }
    }
}

