/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.DirectoryChooser;
import dbaut.GuiUt;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class DirPathField
extends JPanel {
    private String fileseparator = System.getProperty("file.separator");
    public CharField File_Path = new CharField(255, true);
    public JButton Browse_Button = new JButton("...");
    private Component parent_comp = null;
    private String button_text = null;
    private String default_dir = null;
    private boolean isDirectorlyOnly = false;
    private boolean islocked = false;
    private FileFilter[] filter = null;
    private ActionListener listener = null;

    public DirPathField(Component comp, String default_dir, String buttonText, boolean isDirectoryOnly, boolean islocked, FileFilter[] filter) {
        this.parent_comp = comp;
        this.default_dir = default_dir;
        this.button_text = buttonText;
        this.isDirectorlyOnly = isDirectoryOnly;
        this.islocked = islocked;
        this.filter = filter;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    private void jbInit() throws Exception {
        this.File_Path.setCaretPosition(0);
        this.setLayout(new BorderLayout());
        this.Browse_Button.setMargin(new Insets(2, 2, 2, 2));
        this.Browse_Button.setPreferredSize(new Dimension(22, 22));
        this.Browse_Button.setBorder(BorderFactory.createRaisedBevelBorder());
        this.Browse_Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirPathField.this.Browse_Button_actionPerformed(e);
            }
        });
        this.File_Path.setBorder(null);
        this.File_Path.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    DirPathField.this.File_Path_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DirPathField.this.File_Path_keyReleased(e);
            }
        });
        this.add((Component)this.File_Path, "Center");
        this.add((Component)this.Browse_Button, "East");
        if (this.islocked && this.default_dir == null) {
            this.Browse_Button.setEnabled(false);
        }
    }

    public void setTextBackground(Color color) {
        this.File_Path.setBackground(color);
    }

    public void setButtonText(String text) {
        this.button_text = text;
    }

    public void setText(String text) {
        this.File_Path.setText(text);
    }

    public String getText() {
        return this.File_Path.getText();
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.File_Path.setEnabled(enable);
        this.Browse_Button.setEnabled(enable);
    }

    void Browse_Button_actionPerformed(ActionEvent e) {
        DBAResourceBundle res = new DBAResourceBundle("dbaut.dbautproperties.dbaut.Res", LocaleManager.getLocale());
        DirectoryChooser chooser = new DirectoryChooser(this.default_dir);
        chooser.setLocale(LocaleManager.getLocale());
        String path = this.File_Path.getText();
        if (path != null && path.length() > 0 && path.indexOf(this.fileseparator) > 0) {
            chooser.setCurrentDirectory(new File(path));
        } else if (this.default_dir != null) {
            chooser.setCurrentDirectory(new File(this.default_dir));
        } else {
            chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        if (this.isDirectorlyOnly) {
            chooser.setFileSelectionMode(1);
        }
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileHidingEnabled(false);
        if (this.button_text == null) {
            this.button_text = res.getString("Open");
        }
        int state = chooser.showDialog(this.parent_comp, this.button_text);
        if (state != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        if (f.getPath() == null) {
            return;
        }
        if (f.getPath().length() > 254) {
            GuiUt.showErrorDlg(this.parent_comp, res.getString("File_path_is_longer_than"), null);
        } else {
            if (this.isDirectorlyOnly) {
                this.File_Path.setText(f.getPath());
                this.File_Path.setCaretPosition(0);
            } else {
                String pathname = f.getParent();
                if (pathname.equals(this.default_dir)) {
                    this.File_Path.setText(f.getName());
                    this.File_Path.setCaretPosition(0);
                } else {
                    this.File_Path.setText(f.getPath());
                    this.File_Path.setCaretPosition(0);
                }
            }
            if (this.listener != null) {
                this.listener.actionPerformed(null);
            }
        }
    }

    void File_Path_keyReleased(KeyEvent e) {
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }
}

