/*
 * Decompiled with CFR 0.152.
 */
package dbaut.editorPanel;

import dbaut.editorPanel.SQLTextPane;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.WrappedPlainView;

public class ColorView
extends WrappedPlainView {
    private Segment line = new Segment();
    public static Hashtable keywords = null;

    public ColorView(Element e) {
        super(e);
    }

    public ColorView(Element e, boolean wordWrap) {
        super(e, wordWrap);
    }

    @Override
    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        this.getDocument().getText(p0, p1 - p0, this.line);
        StringTokenizer str = new StringTokenizer(this.line.toString(), " ;=><()',", true);
        int offset = 0;
        boolean in_quote = false;
        Color c = null;
        String t = null;
        while (str.hasMoreTokens()) {
            t = str.nextToken();
            if (t.equals("'")) {
                boolean bl = in_quote = !in_quote;
            }
            if (in_quote) {
                c = SQLTextPane.STRING_LITERAL_COLOR;
            } else {
                c = (Color)keywords.get(t.toUpperCase());
                if (c == null) {
                    c = Color.black;
                }
            }
            g.setColor(c);
            this.line.count = t.length();
            x = Utilities.drawTabbedText(this.line, x, y, g, (TabExpander)this, offset);
            this.line.offset += t.length();
            offset += t.length();
        }
        return x;
    }

    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        try {
            Element lineElement = this.getElement().getElement(lineIndex);
            int start = lineElement.getStartOffset();
            int end = lineElement.getEndOffset();
            this.getDocument().getText(start, end - (start + 1), this.line);
            StringTokenizer str = new StringTokenizer(this.line.toString(), " ;=><()',", true);
            int offset = 0;
            boolean in_quote = false;
            Color c = null;
            String t = null;
            while (str.hasMoreTokens()) {
                t = str.nextToken();
                if (t.equals("'")) {
                    boolean bl = in_quote = !in_quote;
                }
                if (in_quote) {
                    c = SQLTextPane.STRING_LITERAL_COLOR;
                } else {
                    c = (Color)keywords.get(t.toUpperCase());
                    if (c == null) {
                        c = Color.black;
                    }
                }
                g.setColor(c);
                this.line.count = t.length();
                x = Utilities.drawTabbedText(this.line, x, y, g, (TabExpander)this, offset);
                this.line.offset += t.length();
                offset += t.length();
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }
}

