/*
 * Decompiled with CFR 0.152.
 */
package dbaut.comp;

import dbaut.GuiUt;
import dbaut.textField.BinaryField;
import dbaut.textField.CharField;
import dbaut.textField.DecimalField;
import dbaut.textField.DoubleField;
import dbaut.textField.FloatField;
import dbaut.textField.IntegerField;
import dbaut.textField.SmallintField;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class DbaTable
extends JTable {
    private DefaultListSelectionModel rlmodel = null;
    private DefaultListSelectionModel clmodel = null;
    private TableColumnModel tcmodel = null;
    private ListSelectionListener rowlistener = null;
    private int lasthashcode = 0;
    private int current_row = -1;
    private int current_col = -1;

    public DbaTable(TableModel model) {
        super(model);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DbaTable() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.rlmodel = (DefaultListSelectionModel)this.getSelectionModel();
        this.tcmodel = this.getColumnModel();
        this.clmodel = (DefaultListSelectionModel)this.tcmodel.getSelectionModel();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DbaTable.this.this_focusGained(e);
            }
        });
        this.setUpCharEditor();
        this.setUpIntegerEditor();
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        super.editingCanceled(e);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        super.editingStopped(e);
    }

    @Override
    public boolean editCellAt(int row, int col) {
        if (this.current_col == col && this.current_row == row && this.getEditingColumn() == col && this.getEditingRow() == row) {
            return true;
        }
        this.current_col = col;
        this.current_row = row;
        boolean result = super.editCellAt(row, col);
        Component c = this.getEditorComponent();
        if (c == null) {
            return result;
        }
        c.requestFocus();
        if (c instanceof JTextComponent) {
            ((JTextComponent)c).selectAll();
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setNextFocusableComponent(this);
        }
        return result;
    }

    public void addRowSelectionListener(ListSelectionListener listener) {
        this.rlmodel.addListSelectionListener(listener);
        this.rowlistener = listener;
    }

    public void addColumnSelectionListener(ListSelectionListener listener) {
        this.clmodel.addListSelectionListener(listener);
    }

    public void addColumnSelectionListener(TableColumnModelListener listener) {
        this.tcmodel.addColumnModelListener(listener);
    }

    public void setSelectedRow(int row) {
        this.setRowSelectionInterval(row, row);
    }

    public void setSelectedColumn(int col) {
        this.setColumnSelectionInterval(col, col);
    }

    public void setselectedCell(int row, int col) {
        this.setRowSelectionInterval(row, row);
        this.setColumnSelectionInterval(col, col);
    }

    public void setUpIntegerEditorStr() {
        IntegerField field = new IntegerField();
        this.setUpIntegerEditorStr(-1, field);
    }

    public void setUpIntegerEditorStr(int index) {
        IntegerField field = new IntegerField();
        this.setUpIntegerEditorStr(index, field);
    }

    public void setUpIntegerEditorStr(int index, IntegerField f) {
        final IntegerField field = f;
        field.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public Object getCellEditorValue() {
                Integer temp = (Integer)field.getValue();
                return new String(temp == null ? "" : temp.toString());
            }
        };
        TableCellRenderer renderer = null;
        TableColumn column = null;
        if (index < 0) {
            this.setDefaultEditor(Integer.class, editor);
            renderer = this.getDefaultRenderer(Integer.class);
        } else {
            column = this.getColumnModel().getColumn(index);
            column.setCellEditor(editor);
            renderer = column.getCellRenderer();
        }
        if (renderer instanceof DefaultTableCellRenderer) {
            return;
        }
        DefaultTableCellRenderer d_renderer = new DefaultTableCellRenderer();
        d_renderer.setHorizontalAlignment(4);
        if (index < 0) {
            this.setDefaultRenderer(Integer.class, d_renderer);
        } else if (column != null) {
            column.setCellRenderer(d_renderer);
        }
    }

    public void setUpIntegerEditor() {
        final IntegerField field = new IntegerField(0, 5);
        field.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public Object getCellEditorValue() {
                return field.getValue();
            }
        };
        this.setDefaultEditor(Integer.class, editor);
        TableCellRenderer renderer = this.getDefaultRenderer(Integer.class);
        if (renderer instanceof DefaultTableCellRenderer) {
            return;
        }
        DefaultTableCellRenderer d_renderer = new DefaultTableCellRenderer();
        d_renderer.setHorizontalAlignment(4);
        this.setDefaultRenderer(Integer.class, d_renderer);
    }

    public void setUpIntegerEditor(int index) {
        this.setUpIntegerEditor(index, new IntegerField(5));
    }

    public void setUpIntegerEditor(int index, IntegerField f) {
        final IntegerField field = f;
        field.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public Object getCellEditorValue() {
                return field.getValue();
            }
        };
        TableColumn column = this.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
        TableCellRenderer renderer = column.getCellRenderer();
        if (renderer instanceof DefaultTableCellRenderer) {
            return;
        }
        DefaultTableCellRenderer d_renderer = new DefaultTableCellRenderer();
        d_renderer.setHorizontalAlignment(4);
        column.setCellRenderer(d_renderer);
    }

    public void setUpShortEditor(int index) {
        SmallintField field = new SmallintField();
        this.setUpShortEditor(index, field);
    }

    public void setUpShortEditor(int index, SmallintField f) {
        final SmallintField field = f;
        field.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public Object getCellEditorValue() {
                return field.getValue();
            }
        };
        TableColumn column = this.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
        TableCellRenderer renderer = column.getCellRenderer();
        if (renderer instanceof DefaultTableCellRenderer) {
            return;
        }
        DefaultTableCellRenderer d_renderer = new DefaultTableCellRenderer();
        d_renderer.setHorizontalAlignment(4);
        column.setCellRenderer(d_renderer);
    }

    public void setUpShortEditorStr(int index) {
        SmallintField field = new SmallintField();
        this.setUpShortEditor(index, field);
    }

    public void setUpShortEditorStr(int index, SmallintField f) {
        final SmallintField field = f;
        field.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public Object getCellEditorValue() {
                return field.getText();
            }
        };
        TableColumn column = this.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
        TableCellRenderer renderer = column.getCellRenderer();
        if (renderer instanceof DefaultTableCellRenderer) {
            return;
        }
        DefaultTableCellRenderer d_renderer = new DefaultTableCellRenderer();
        d_renderer.setHorizontalAlignment(4);
        column.setCellRenderer(d_renderer);
    }

    public void setUpDecimalEditorStr(int index, DecimalField f) {
        final DecimalField field = f;
        field.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public Object getCellEditorValue() {
                String temp = (String)field.getValue();
                return new String(temp == null ? "" : temp);
            }
        };
        TableColumn column = this.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
        TableCellRenderer renderer = column.getCellRenderer();
        if (renderer instanceof DefaultTableCellRenderer) {
            return;
        }
        DefaultTableCellRenderer d_renderer = new DefaultTableCellRenderer();
        d_renderer.setHorizontalAlignment(4);
        column.setCellRenderer(d_renderer);
    }

    public void setUpDoubleEditor(int index) {
        final DoubleField field = new DoubleField(5);
        field.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public Object getCellEditorValue() {
                return field.getValue();
            }
        };
        TableColumn column = this.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
        TableCellRenderer renderer = column.getCellRenderer();
        if (renderer instanceof DefaultTableCellRenderer) {
            return;
        }
        DefaultTableCellRenderer d_renderer = new DefaultTableCellRenderer();
        d_renderer.setHorizontalAlignment(4);
        column.setCellRenderer(d_renderer);
    }

    public void setUpFloatEditor(int index) {
        final FloatField field = new FloatField(5);
        field.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public Object getCellEditorValue() {
                return field.getValue();
            }
        };
        TableColumn column = this.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
        TableCellRenderer renderer = column.getCellRenderer();
        if (renderer instanceof DefaultTableCellRenderer) {
            return;
        }
        DefaultTableCellRenderer d_renderer = new DefaultTableCellRenderer();
        d_renderer.setHorizontalAlignment(4);
        column.setCellRenderer(d_renderer);
    }

    public void setUpBinaryEditor(int index) {
        final BinaryField field = new BinaryField(5);
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public Object getCellEditorValue() {
                return field.getValue();
            }
        };
        TableColumn column = this.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
    }

    public void setUpCharEditor(int index, CharField f) {
        final CharField field = f;
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public Object getCellEditorValue() {
                return field.getValue();
            }
        };
        TableColumn column = this.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
    }

    public void setUpCharEditor(int index) {
        this.setUpCharEditor(index, new CharField());
    }

    public void setUpCharEditor() {
        final CharField field = new CharField();
        DefaultCellEditor editor = new DefaultCellEditor(field){

            @Override
            public Object getCellEditorValue() {
                return field.getValue();
            }
        };
        this.setDefaultEditor(String.class, editor);
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    private void advanceEdit() {
        int rowIndex = this.rlmodel.getLeadSelectionIndex();
        int columnIndex = this.clmodel.getLeadSelectionIndex();
        if (this.isEditing() && this.getEditingRow() == rowIndex && this.getEditingColumn() == columnIndex) {
            this.advanceEdit(rowIndex, columnIndex);
        }
    }

    private void advanceEdit(int rowIndex, int columnIndex) {
        int i;
        this.editingStopped(null);
        int columnCount = this.getModel().getColumnCount();
        int rowCount = this.getModel().getRowCount();
        for (i = columnIndex + 1; i < columnCount; ++i) {
            if (!this.isCellEditable(rowIndex, i)) continue;
            this.setselectedCell(rowIndex, i);
            return;
        }
        if (rowIndex + 1 >= rowCount) {
            return;
        }
        for (i = 0; i < columnCount; ++i) {
            if (!this.isCellEditable(rowIndex + 1, i)) continue;
            this.setselectedCell(rowIndex + 1, i);
            break;
        }
        if (GuiUt.getJavaVersion().indexOf(GuiUt.JDK13) >= 0 && this.rowlistener != null) {
            this.rowlistener.valueChanged(null);
        }
    }

    void this_focusGained(FocusEvent e) {
        KeyEvent keyEvent;
        EventQueue eq = this.getToolkit().getSystemEventQueue();
        AWTEvent lastEvent = eq.peekEvent();
        if (lastEvent == null) {
            return;
        }
        if (this.lasthashcode == lastEvent.hashCode()) {
            return;
        }
        this.lasthashcode = lastEvent.hashCode();
        if (lastEvent.getID() == 400 && ((keyEvent = (KeyEvent)lastEvent).getKeyCode() == 9 || keyEvent.getKeyChar() == '\t')) {
            this.advanceEdit();
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            boolean i = false;
        }
    }
}

