/*
 * Decompiled with CFR 0.152.
 */
package dbaut.comp;

import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class DbaButton
extends JButton {
    private String text = null;

    public DbaButton(Dimension d, String t, char c, ImageIcon i, ReflectionAction a) {
        this(d, true);
        this.setText(t);
        this.setMnemonic(c);
        this.setToolTipText(t);
        if (i != null) {
            this.setIcon(i);
        }
        if (a != null) {
            this.addActionListener(a);
        }
    }

    public DbaButton(Dimension d, String t, char c, ReflectionAction a) {
        this(d, t, c, null, a);
    }

    public DbaButton(String t, char c, ReflectionAction a) {
        this(new Dimension(80, 20), t, c, a);
    }

    public DbaButton(Dimension d, boolean b, String t, char c, ImageIcon i, ReflectionAction a) {
        this(d, b);
        this.setText(t);
        this.setMnemonic(c);
        this.setToolTipText(t);
        if (i != null) {
            this.setIcon(i);
        }
        if (a != null) {
            this.addActionListener(a);
        }
    }

    public DbaButton(String t, char c) {
        this(new Dimension(80, 20), t, c, null);
    }

    public DbaButton(Dimension d, boolean b) {
        this.setPreferredSize(d);
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setMargin(new Insets(0, 0, 0, 0));
        if (b) {
            this.setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }

    public DbaButton(Dimension d) {
        this(d, true);
    }

    public DbaButton() {
        this(new Dimension(80, 20));
    }

    @Override
    public void setMnemonic(char c) {
        super.setMnemonic(c);
        if (LocaleManager.getLanguageChoice() != 0) {
            String t = this.getText();
            if (t.indexOf(Character.toLowerCase(c)) >= 0) {
                return;
            }
            if (t.indexOf(Character.toUpperCase(c)) >= 0) {
                return;
            }
            if (t.length() > 0) {
                if (t.indexOf(40) > 0 && t.indexOf(41) > 0) {
                    t = String.copyValueOf(t.toCharArray(), 0, t.indexOf(40));
                }
                super.setText(t + "(" + c + ")");
            }
        }
    }

    public String getRealText() {
        if (this.text != null) {
            return this.text;
        }
        return super.getText();
    }

    @Override
    public void setText(String t) {
        this.text = t;
        if (this.getMnemonic() == 0 || LocaleManager.getLanguageChoice() == 0) {
            super.setText(t);
        } else if (LocaleManager.getLanguageChoice() != 0) {
            char c = (char)this.getMnemonic();
            if (t.indexOf(Character.toLowerCase(c)) >= 0 || t.indexOf(Character.toUpperCase(c)) >= 0) {
                super.setText(t);
                return;
            }
            if (t.indexOf(40) >= 0 && t.indexOf(41) >= 0) {
                String s = String.copyValueOf(t.toCharArray(), 0, t.indexOf(40));
                super.setText(s + "(" + c + ")");
            } else {
                super.setText(t + "(" + c + ")");
            }
        }
    }
}

